<?php  
class ControllerBlogFooter extends Controller {
	protected function index() {
		$this->language->load('blog/footer');
		
		$this->load->model('catalog/product');
		$this->load->model('tool/image');
		
		$this->data['products'] = array();

		$products = explode(',', $this->config->get('bp_fpp_product'));		
		
		foreach ($products as $product_id) {
			$product_info = $this->model_catalog_product->getProduct($product_id);
			
			if ($product_info) {
				if ($product_info['image']) {
					$image = $this->model_tool_image->resize($product_info['image'], $this->config->get('bp_fpp_image_width'), $this->config->get('bp_fpp_image_height'));
				} else {
					$image = $this->model_tool_image->resize('blog_no_image.jpg', $this->config->get('bp_fpp_image_width'), $this->config->get('bp_fpp_image_height'));
				}

				if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$price = false;
				}
						
				if ((float)$product_info['special']) {
					$special = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$special = false;
				}
					
				$this->data['products'][] = array(
					'product_id' => $product_info['product_id'],
					'thumb'   	 => $image,
					'name'    	 => (utf8_strlen($product_info['name']) > 14)? utf8_substr($product_info['name'], 0,14) . '..' : $product_info['name'] ,
					'price'   	 => $price,
					'special' 	 => $special,
					'href'    	 => $this->url->link('product/product', 'product_id=' . $product_info['product_id']),
				);
			}
		}

		$this->data['text_we_recommend'] = $this->language->get('text_we_recommend');
		$this->data['social_facebook'] = $this->config->get('blog_facebook_link'); 
		$this->data['social_twitter']  = $this->config->get('blog_twitter_link'); 
		$this->data['social_google']   = $this->config->get('blog_google_link'); 
		$this->data['social_hi5']      = $this->config->get('blog_hi5_link'); 
		$this->data['social_youtube']  = $this->config->get('blog_youtube_link'); 
		$this->data['social_vimeo']    = $this->config->get('blog_vimeo_link'); 
		
		$this->data['copyright'] = sprintf($this->language->get('text_copyright'), date('Y', time()), $this->config->get('blog_name'));
		$this->data['powered'] = sprintf($this->language->get('text_powered'), $this->config->get('blog_name'), date('Y', time()));
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/blog/footer.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/blog/footer.tpl';
		} else {
			$this->template = 'default/template/blog/footer.tpl';
		}
		
		$this->render();
	}
}
?>