<?php 
class ControllerProductCategory extends Controller {  
	public function index() { 
		$this->language->load('product/category'); 
		
		$this->load->model('catalog/category');
		
		$this->load->model('catalog/product');
		
		$this->load->model('tool/image'); 
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'p.sort_order';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else { 
			$page = 1;
		}	
							
		if (isset($this->request->get['limit'])) {
			$limit = $this->request->get['limit'];
		} else {
			$limit = $this->config->get('config_catalog_limit');
		}
			
		if(isset($this->request->get['metal'])){
			$this->data['gemmetalSelected'] = $this->request->get['metal'];
		}			
		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),
       		'separator' => false
   		);	
			
		if (isset($this->request->get['path'])) {
			$path = '';
		
			$parts = explode('_', (string)$this->request->get['path']);
		
			foreach ($parts as $path_id) {
				if (!$path) {
					$path = $path_id;
				} else {
					$path .= '_' . $path_id;
				}
									
				$category_info = $this->model_catalog_category->getCategory($path_id);
				
				if ($category_info) {
	       			$this->data['breadcrumbs'][] = array(
   	    				'text'      => $category_info['name'],
						'href'      => $this->url->link('product/category', 'path=' . $path),
        				'separator' => $this->language->get('text_separator')
        			);
				}
			}		
		
			$category_id = array_pop($parts);
		} else {
			$category_id = 0;
		}
		
		$category_info = $this->model_catalog_category->getCategory($category_id);
	
		if ($category_info) {
	  		$this->document->setTitle($category_info['name'] . $path);
			$this->document->setDescription($category_info['meta_description']);
			$this->document->setKeywords($category_info['meta_keyword']);
			
			$this->data['heading_title'] = $category_info['name'];
			
			$this->data['text_refine'] = $this->language->get('text_refine');
			$this->data['text_empty'] = $this->language->get('text_empty');			
			$this->data['text_quantity'] = $this->language->get('text_quantity');
			$this->data['text_manufacturer'] = $this->language->get('text_manufacturer');
			$this->data['text_model'] = $this->language->get('text_model');
			$this->data['text_price'] = $this->language->get('text_price');
			$this->data['text_tax'] = $this->language->get('text_tax');
			$this->data['text_points'] = $this->language->get('text_points');
			$this->data['text_compare'] = sprintf($this->language->get('text_compare'), (isset($this->session->data['compare']) ? count($this->session->data['compare']) : 0));
			$this->data['text_display'] = $this->language->get('text_display');
			$this->data['text_list'] = $this->language->get('text_list');
			$this->data['text_grid'] = $this->language->get('text_grid');
			$this->data['text_sort'] = $this->language->get('text_sort');
			$this->data['text_limit'] = $this->language->get('text_limit');
					
			$this->data['button_cart'] = $this->language->get('button_cart');
			$this->data['button_wishlist'] = $this->language->get('button_wishlist');
			$this->data['button_compare'] = $this->language->get('button_compare');
			$this->data['button_continue'] = $this->language->get('button_continue');
					
			if ($category_info['image']) {
				$this->data['thumb'] = $this->model_tool_image->resize($category_info['image'], $this->config->get('config_image_category_width'), $this->config->get('config_image_category_height'));
			} else {
				$this->data['thumb'] = '';
			}
									
			$this->data['description'] = html_entity_decode($category_info['description'], ENT_QUOTES, 'UTF-8');
			$this->data['compare'] = $this->url->link('product/compare');
			
			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}	

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}	
			
			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}
								
			$this->data['categories'] = array();
			
			$results = $this->model_catalog_category->getCategories($category_id);
			
			foreach ($results as $result) {
				$data = array(
					'filter_category_id'  => $result['category_id'],
					'filter_sub_category' => true	
				);
							
				$product_total = $this->model_catalog_product->getTotalProducts($data);
				
				$this->data['categories'][] = array(
					'name'  => $result['name'] . ' (' . $product_total . ')',
					'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '_' . $result['category_id'] . $url)
				);
			}
			
			$this->data['products'] = array();
			
			$data = array(
				'filter_category_id' => $category_id, 
				'sort'               => $sort,
				'order'              => $order,
				'start'              => ($page - 1) * $limit,
				'limit'              => $limit
			);
					
			$product_total = $this->model_catalog_product->getTotalProducts($data); 
			
			$results = $this->model_catalog_product->getProducts($data);
			
			$gemstone_id = $this->model_catalog_product->getGemstoneIdImage($category_info['name']);
			$this->log->write("Testing - gemstone_id " . $gemstone_id );

			$metal_id = $this->model_catalog_product->getMetalIdImage($category_info['name']);
			if($metal_id == 0){
				if(isset($this->request->get['metal'])){
					$metal_id = $this->request->get['metal'];
				}
			}
			$this->log->write("Testing - metal_id " . $metal_id );
			
			
			foreach ($results as $result) {
			    $image1="";
				if($gemstone_id || $metal_id){
				
					if($gemstone_id && $metal_id==0){	
						$GemImage = $this->model_catalog_product->getProductGemstoneImage($gemstone_id,$result['product_id']);

				      if (!file_exists(DIR_IMAGE . 'gemstones/' . str_replace('.png.jpg', '_CG'.$gemstone_id .'.png.jpg', $result['image']) )) {
						$this->session->data['cat_gemstone_id'] =  $gemstone_id;				
				
						$new_image_im  = $this->resize( substr( $result['image'] , 0, strlen($result['image'] ) - 4 ), $this->config->get('config_image_category_width'), $this->config->get('config_image_category_height') );
						$im=imagecreatefrompng(  'image/'  . $new_image_im  );
						$this->log->write("Testing5 - ".  'image/'  . $new_image_im  );

						$new_image  = $this->resize( $GemImage['image'], $this->config->get('config_image_category_width'), $this->config->get('config_image_category_height') );
						$stamp = imagecreatefrompng( 'image/'  . $new_image );
						$this->log->write("Testing6 - ". $new_image );

						$marge_right = 0;
						$marge_bottom = 0;
						$sx = imagesx($stamp);
						$sy = imagesy($stamp);
						imagecopy($im, $stamp, imagesx($im) - $sx - $marge_right, imagesy($im) - $sy - $marge_bottom, 0, 0, imagesx($stamp), imagesy($stamp));

/*
						imagepng($im , DIR_IMAGE. 'gemstones/' . $result['image'] );  
						if ($result['image']) {
							$image = HTTPS_IMAGE.'gemstones/' . $result['image'];
						} else {
							$image = false;
						}
*/
						imagepng($im , DIR_IMAGE. 'gemstones/' . str_replace('.png.jpg', '_CG'.$gemstone_id .'.png.jpg', $result['image']) );  
						if ($result['image']) {
							$image = HTTPS_IMAGE. 'gemstones/' . str_replace('.png.jpg', '_CG'.$gemstone_id .'.png.jpg', $result['image']);
						} else {
							$image = false;
						}
					  }else{
						if ($result['image']) {
							$image = HTTPS_IMAGE. 'gemstones/' . str_replace('.png.jpg', '_CG'.$gemstone_id .'.png.jpg', $result['image']);
						} else {
							$image = false;
						}
					  }
				/*	  
					  $image1 = str_replace('TEMP/', '',$result['image']);
					  $part1 = substr($image1,0,strpos($image1, '_G1-'));
					  $part2 = strstr($image1, 'G1-');
					  $part3 = substr($part2,strpos($part2, '_'));
					  $image1 = $part1 . '_G1-' . $GemImage['product_gemavail_id'] . $part3;  
				*/	  
					}
					
					if($metal_id && $gemstone_id==0){
						$MetalImage = $this->model_catalog_product->getProductMetalImage($metal_id,$result['product_id']);

						if (!file_exists(DIR_IMAGE . 'gemstones/' . str_replace('.png.jpg', '_CM'.$metal_id .'.png.jpg', $result['image']) )) {			
						$this->session->data['metal_id'] =  $metal_id;
				/*	
					$this->log->write("Testing1 - ".$GemImage);
					$this->log->write("Testing2 - ".DIR_IMAGE . substr( $result['image'] , 0, strlen($result['image'] ) - 4 ));
					$this->log->write("Testing3 - ".DIR_IMAGE . $GemImage);
					$this->log->write("Testing4 - ".HTTPS_IMAGE.'gemstones/' . $result['image']);
				*/
						$new_image_im  = $this->resize( substr( $result['image'] , 0, strlen($result['image'] ) - 4 ), $this->config->get('config_image_category_width'), $this->config->get('config_image_category_height') );
						$im=imagecreatefrompng(  'image/'  . $new_image_im  );
						$this->log->write("Testing5 - ".  'image/'  . $new_image_im  );

						$new_image  = $this->resize( $MetalImage, $this->config->get('config_image_category_width'), $this->config->get('config_image_category_height') );
						$stamp = imagecreatefrompng( 'image/'  . $new_image );
						$this->log->write("Testing6 - ". $new_image );

						$marge_right = 0;
						$marge_bottom = 0;
						$sx = imagesx($stamp);
						$sy = imagesy($stamp);
						imagecopy($im, $stamp, imagesx($im) - $sx - $marge_right, imagesy($im) - $sy - $marge_bottom, 0, 0, imagesx($stamp), imagesy($stamp));
/*
						imagepng($im , DIR_IMAGE. 'gemstones/' . $result['image']); 
						if ($result['image']) {
							$image = HTTPS_IMAGE.'gemstones/' . $result['image'];
						} else {
							$image = false;
						}
*/
						imagepng($im , DIR_IMAGE. 'gemstones/' . str_replace('.png.jpg', '_CM'.$metal_id .'.png.jpg', $result['image']) );  
						if ($result['image']) {
							$image = HTTPS_IMAGE. 'gemstones/' . str_replace('.png.jpg', '_CM'.$metal_id .'.png.jpg', $result['image']);
						} else {
							$image = false;
						}
					  }else{
						if ($result['image']) {
							$image = HTTPS_IMAGE. 'gemstones/' . str_replace('.png.jpg', '_CM'.$metal_id .'.png.jpg', $result['image']);
						} else {
							$image = false;
						}
					  }
				/*
					  $image1 = str_replace('TEMP/', '',$result['image']);
					  $part1 = substr($image1,0,strpos($image1, '_M1-'));
					  $part2 = strstr($image1, 'M1-');
					  $part3 = substr($part2,strpos($part2, '_'));
					  $image1 = $part1 . '_M1-' . $MetalImage['product_metalavail_id'] . $part3;
				*/
					}
					
					if($gemstone_id && $metal_id){
				      if (!file_exists(DIR_IMAGE . 'gemstones/' . str_replace('.png.jpg', '_CG' . $gemstone_id . '_CM'.$metal_id .'.png.jpg', $result['image']) )) {			
						$MetalImage = $this->model_catalog_product->getProductMetalImage($metal_id,$result['product_id']);
						$GemImage = $this->model_catalog_product->getProductGemstoneImage($gemstone_id,$result['product_id']);
					
						$new_image_im  = $this->resize( substr( $result['image'] , 0, strlen($result['image'] ) - 4 ), $this->config->get('config_image_category_width'), $this->config->get('config_image_category_height') );
						$im=imagecreatefrompng(  'image/'  . $new_image_im  );

						$new_image  = $this->resize( $MetalImage, $this->config->get('config_image_category_width'), $this->config->get('config_image_category_height') );
						$stamp = imagecreatefrompng( 'image/'  . $new_image );

						$new_image1  = $this->resize( $GemImage, $this->config->get('config_image_category_width'), $this->config->get('config_image_category_height') );
						$stamp1 = imagecreatefrompng( 'image/'  . $new_image1 );

						$marge_right = 0;
						$marge_bottom = 0;
						$sx = imagesx($stamp);
						$sy = imagesy($stamp);
						imagecopy($im, $stamp, imagesx($im) - $sx - $marge_right, imagesy($im) - $sy - $marge_bottom, 0, 0, imagesx($stamp), imagesy($stamp));

						$sx1 = imagesx($stamp1);
						$sy1 = imagesy($stamp1);
						imagecopy($im, $stamp1, imagesx($im) - $sx1 - $marge_right, imagesy($im) - $sy1 - $marge_bottom, 0, 0, imagesx($stamp1), imagesy($stamp1));

/*						imagepng($im , DIR_IMAGE. 'gemstones/' . $result['image']); 
						if ($result['image']) {
							$image = HTTPS_IMAGE.'gemstones/' . $result['image'];
						} else {
							$image = false;
						}
*/
						imagepng($im , DIR_IMAGE. 'gemstones/' . str_replace('.png.jpg', '_CG' . $gemstone_id . '_CM'.$metal_id .'.png.jpg', $result['image']) );  
						if ($result['image']) {
							$image = HTTPS_IMAGE. 'gemstones/' . str_replace('.png.jpg', '_CG' . $gemstone_id . '_CM'.$metal_id .'.png.jpg', $result['image']);
						} else {
							$image = false;
						}
					  }else{
						if ($result['image']) {
							$image = HTTPS_IMAGE. 'gemstones/' . str_replace('.png.jpg', '_CG' . $gemstone_id . '_CM'.$metal_id .'.png.jpg', $result['image']);
						} else {
							$image = false;
						}
					  }

					}
					
				}else{
					if ($result['image']) {
						$image = HTTPS_IMAGE.'gemstones/' . $result['image'];
					} else {
						$image = false;
					}
				}
				
				
				if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$price = false;
				}
				
				if ((float)$result['special']) {
					$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$special = false;
				}	
				
				if ($this->config->get('config_tax')) {
					$tax = $this->currency->format((float)$result['special'] ? $result['special'] : $result['price']);
				} else {
					$tax = false;
				}				
				
				if ($this->config->get('config_review_status')) {
					$rating = (int)$result['rating'];
				} else {
					$rating = false;
				}
					
				
				$this->data['products'][] = array(
					'product_id'  => $result['product_id'],
					'thumb'       => $image,
					'imageurl'       => $image1,
					'name'        => $result['name'],
					'description' => mb_substr(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8')), 0, 225) . '...',
					'price'       => $price,
					'special'     => $special,
					'tax'         => $tax,
					'rating'      => $result['rating'],
					'reviews'     => sprintf($this->language->get('text_reviews'), (int)$result['reviews']),
//					'href'        => $this->url->link('product/product', 'path=' . $this->request->get['path'] . '&product_id=' . $result['product_id']) . '&image=' . $image1
					'href'        => $this->url->link('product/product', 'path=' . $this->request->get['path'] . '&product_id=' . $result['product_id'])
				);
			}
			
//			$this->data['heading_title'] = $this->data['heading_title'] . " - " . $gemstone_id . " - " . $metal_id ; 

			$url = '';
	
			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}
							
			$this->data['sorts'] = array();
			
			$this->data['sorts'][] = array(
				'text'  => $this->language->get('text_default'),
				'value' => 'p.sort_order-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.sort_order&order=ASC' . $url)
			);
			
			$this->data['sorts'][] = array(
				'text'  => $this->language->get('text_name_asc'),
				'value' => 'pd.name-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=pd.name&order=ASC' . $url)
			);

			$this->data['sorts'][] = array(
				'text'  => $this->language->get('text_name_desc'),
				'value' => 'pd.name-DESC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=pd.name&order=DESC' . $url)
			);

			$this->data['sorts'][] = array(
				'text'  => $this->language->get('text_price_asc'),
				'value' => 'p.price-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.price&order=ASC' . $url)
			); 

			$this->data['sorts'][] = array(
				'text'  => $this->language->get('text_price_desc'),
				'value' => 'p.price-DESC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.price&order=DESC' . $url)
			); 
			
			$this->data['sorts'][] = array(
				'text'  => $this->language->get('text_rating_desc'),
				'value' => 'rating-DESC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=rating&order=DESC' . $url)
			); 
			
			$this->data['sorts'][] = array(
				'text'  => $this->language->get('text_rating_asc'),
				'value' => 'rating-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=rating&order=ASC' . $url)
			);
			
			$this->data['sorts'][] = array(
				'text'  => $this->language->get('text_model_asc'),
				'value' => 'p.model-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.model&order=ASC' . $url)
			);

			$this->data['sorts'][] = array(
				'text'  => $this->language->get('text_model_desc'),
				'value' => 'p.model-DESC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.model&order=DESC' . $url)
			);
			
			$url = '';
	
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}	

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
			
			
			$this->data['gemmetals'] = array();
			
			$this->data['gemmetals'][] = array(
				'text'  => 'White Gold',
				'value' => '19',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&metal=19')
			);
						
			$this->data['gemmetals'][] = array(
				'text'  => 'Yellow Gold',
				'value' => '20',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&metal=20')
			);
			
			$this->data['gemmetals'][] = array(
				'text'  => 'Rose Gold',
				'value' => '21',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&metal=21')
			);

			
			$this->data['limits'] = array();
			
			$this->data['limits'][] = array(
				'text'  => $this->config->get('config_catalog_limit'),
				'value' => $this->config->get('config_catalog_limit'),
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&limit=' . $this->config->get('config_catalog_limit'))
			);
						
			$this->data['limits'][] = array(
				'text'  => 25,
				'value' => 25,
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&limit=25')
			);
			
			$this->data['limits'][] = array(
				'text'  => 50,
				'value' => 50,
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&limit=50')
			);

			$this->data['limits'][] = array(
				'text'  => 75,
				'value' => 75,
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&limit=75')
			);
			
			$this->data['limits'][] = array(
				'text'  => 100,
				'value' => 100,
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&limit=100')
			);
						
			$url = '';
	
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}	

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
	
			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}
					
			$pagination = new Pagination();
			$pagination->total = $product_total;
			$pagination->page = $page;
			$pagination->limit = $limit;
			$pagination->text = $this->language->get('text_pagination');
			$pagination->url = $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&page={page}');
		
			$this->data['pagination'] = $pagination->render();
		
			$this->data['sort'] = $sort;
			$this->data['order'] = $order;
			$this->data['limit'] = $limit;
		
			$this->data['continue'] = $this->url->link('common/home');

			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/product/category.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/product/category.tpl';
			} else {
				$this->template = 'default/template/product/category.tpl';
			}
			
			$this->children = array(
				'common/column_left',
				'common/column_right',
				'common/content_top',
				'common/content_bottom',
				'common/footer',
				'common/header'
			);
				
			$this->response->setOutput($this->render());										
    	} else {
			$url = '';
			
			if (isset($this->request->get['path'])) {
				$url .= '&path=' . $this->request->get['path'];
			}
									
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}	

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
				
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
						
			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}
						
			$this->data['breadcrumbs'][] = array(
				'text'      => $this->language->get('text_error'),
				'href'      => $this->url->link('product/category', $url),
				'separator' => $this->language->get('text_separator')
			);
				
			$this->document->setTitle($this->language->get('text_error'));

      		$this->data['heading_title'] = $this->language->get('text_error');

      		$this->data['text_error'] = $this->language->get('text_error');

      		$this->data['button_continue'] = $this->language->get('button_continue');

      		$this->data['continue'] = $this->url->link('common/home');

			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/error/not_found.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/error/not_found.tpl';
			} else {
				$this->template = 'default/template/error/not_found.tpl';
			}
			
			$this->children = array(
				'common/column_left',
				'common/column_right',
				'common/content_top',
				'common/content_bottom',
				'common/footer',
				'common/header'
			);
					
			$this->response->setOutput($this->render());
		}
		
  	}
	
		public function resize($filename, $width, $height) {
//		$this->log->write( DIR_IMAGE . $filename );

		if (!file_exists(DIR_IMAGE . $filename) || !is_file(DIR_IMAGE . $filename)) {
			$this->log->write(' Image Not found : ' . DIR_IMAGE . $filename );

			return;
		} 
//		 $this->log->write( DIR_IMAGE . $filename );
		$info = pathinfo($filename);
		$extension = $info['extension'];
		
		$old_image = $filename;
		$new_image = 'cache/' . utf8_substr($filename, 0, strrpos($filename, '.')) . '-' . $width . 'x' . $height . '.' . $extension;
		
		if (!file_exists(DIR_IMAGE . $new_image) || (filemtime(DIR_IMAGE . $old_image) > filemtime(DIR_IMAGE . $new_image))) {
			$path = '';
			
			$directories = explode('/', dirname(str_replace('../', '', $new_image)));
			
			foreach ($directories as $directory) {
				$path = $path . '/' . $directory;
				
				if (!file_exists(DIR_IMAGE . $path)) {
					@mkdir(DIR_IMAGE . $path, 0777);
				}		
			}
			
			$image = new Image(DIR_IMAGE . $old_image);
			$image->resize($width, $height);
			$image->save(DIR_IMAGE . $new_image);
		}
	
		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			return   $new_image;
		} else {
			return   $new_image;
		}	
	}
	
	
		
	public	function png2jpg($originalFile, $outputFile, $quality) {
    	$image = imagecreatefrompng($originalFile);
    	imagejpeg($image, $outputFile, $quality);
    	imagedestroy($image);
	}
	 
}
?>