<?php
class ModelSaleWeightbasedcosts extends Model {
	public function addCustomerGroup($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "labour_weight_based_costs SET low_weight = '" . $this->db->escape($data['low_weight']) . "',high_weight = '" . $this->db->escape($data['high_weight']) . "',cost = '" . $this->db->escape($data['cost']) . "',ccurrency = '" . $this->db->escape($data['ccurrency']) . "',supplier_group_id = '" . (int)$data['supplier_group_id'] . "'");
	}
	 
	public function editCustomerGroup($weightcost_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "labour_weight_based_costs SET low_weight = '" . $this->db->escape($data['low_weight']) . "',high_weight = '" . $this->db->escape($data['high_weight']) . "',cost = '" . $this->db->escape($data['cost']) . "',ccurrency = '" . $this->db->escape($data['ccurrency']) . "',supplier_group_id = '" . (int)$data['supplier_group_id'] . "' WHERE weightcost_id = '" . (int)$weightcost_id . "'");
	}
	
	public function deleteCustomerGroup($weightcost_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "labour_weight_based_costs WHERE weightcost_id = '" . (int)$weightcost_id . "'");
	//	$this->db->query("DELETE FROM " . DB_PREFIX . "product_discount WHERE weightcost_id = '" . (int)$weightcost_id . "'");
	}
	
	public function getCustomerGroup($weightcost_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "labour_weight_based_costs WHERE weightcost_id = '" . (int)$weightcost_id . "'");
		
		return $query->row;
	}
	
	public function getCustomerGroups($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "labour_weight_based_costs";
		
		$sql .= " ORDER BY low_weight";	
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
			
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getTotalCustomerGroups() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "labour_weight_based_costs");
		
		return $query->row['total'];
	}
}
?>