<?php 
class ModelSaledesigner extends Model {
	public function adddesigner($data) {
      	$this->db->query("INSERT INTO " . DB_PREFIX . "designer SET firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', email = '" . $this->db->escape($data['email']) . "',  telephone = '" . $this->db->escape($data['telephone']) . "', image = '" . $this->db->escape($data['image']) . "',fax = '" . $this->db->escape($data['fax']) . "',   newsletter = '" . (int)$data['newsletter'] . "', designer_group_id = '" . (int)$data['designer_group_id'] . "', password = '" . $this->db->escape(md5($data['password'])) . "', status = '" . (int)$data['status'] . "', date_added = NOW()");
      	
      	$designer_id = $this->db->getLastId();
      	
      	if (isset($data['address'])) {		
      		foreach ($data['address'] as $address) {	
      			$this->db->query("INSERT INTO " . DB_PREFIX . "des_address SET designer_id = '" . (int)$designer_id . "', firstname = '" . $this->db->escape($address['firstname']) . "', lastname = '" . $this->db->escape($address['lastname']) . "', company = '" . $this->db->escape($address['company']) . "', address_1 = '" . $this->db->escape($address['address_1']) . "', address_2 = '" . $this->db->escape($address['address_2']) . "', city = '" . $this->db->escape($address['city']) . "', postcode = '" . $this->db->escape($address['postcode']) . "', country_id = '" . (int)$address['country_id'] . "', zone_id = '" . (int)$address['zone_id'] . "'");
				if (isset($address['default'])) {
					$address_id = $this->db->getLastId();
					
					$this->db->query("UPDATE " . DB_PREFIX . "designer SET address_id = '" . $address_id . "' WHERE designer_id = '" . (int)$designer_id . "'");
				}
			} 
		}
	}
	
	public function editdesigner($designer_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "designer SET firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', email = '" . $this->db->escape($data['email']) . "', telephone = '" . $this->db->escape($data['telephone']) . "',  image = '" . $this->db->escape($data['image']) . "', fax = '" . $this->db->escape($data['fax']) . "',  newsletter = '" . (int)$data['newsletter'] . "', designer_group_id = '" . (int)$data['designer_group_id'] . "', status = '" . (int)$data['status'] . "' WHERE designer_id = '" . (int)$designer_id . "'");
	
      	if ($data['password']) {
        	$this->db->query("UPDATE " . DB_PREFIX . "designer SET password = '" . $this->db->escape(md5($data['password'])) . "' WHERE designer_id = '" . (int)$designer_id . "'");
      	}
      	
      	$this->db->query("DELETE FROM " . DB_PREFIX . "des_address WHERE designer_id = '" . (int)$designer_id . "'");
      	
      	if (isset($data['address'])) {
      		foreach ($data['address'] as $address) {
				if ($address['address_id']) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "des_address SET address_id = '" . $this->db->escape($address['address_id']) . "', designer_id = '" . (int)$designer_id . "', firstname = '" . $this->db->escape($address['firstname']) . "', lastname = '" . $this->db->escape($address['lastname']) . "', company = '" . $this->db->escape($address['company']) . "', address_1 = '" . $this->db->escape($address['address_1']) . "', address_2 = '" . $this->db->escape($address['address_2']) . "', city = '" . $this->db->escape($address['city']) . "', postcode = '" . $this->db->escape($address['postcode']) . "', country_id = '" . (int)$address['country_id'] . "', zone_id = '" . (int)$address['zone_id'] . "'");
					
					if (isset($address['default'])) {
						$this->db->query("UPDATE " . DB_PREFIX . "designer SET address_id = '" . (int)$address['address_id'] . "' WHERE designer_id = '" . (int)$designer_id . "'");
					}
				} else {
					$this->db->query("INSERT INTO " . DB_PREFIX . "des_address SET designer_id = '" . (int)$designer_id . "', firstname = '" . $this->db->escape($address['firstname']) . "', lastname = '" . $this->db->escape($address['lastname']) . "', company = '" . $this->db->escape($address['company']) . "', address_1 = '" . $this->db->escape($address['address_1']) . "', address_2 = '" . $this->db->escape($address['address_2']) . "', city = '" . $this->db->escape($address['city']) . "', postcode = '" . $this->db->escape($address['postcode']) . "', country_id = '" . (int)$address['country_id'] . "', zone_id = '" . (int)$address['zone_id'] . "'");
					
					if (isset($address['default'])) {
						$address_id = $this->db->getLastId();
						
						$this->db->query("UPDATE " . DB_PREFIX . "designer SET address_id = '" . (int)$address_id . "' WHERE designer_id = '" . (int)$designer_id . "'");
					}
				}
			}
		}
	}

	public function editToken($designer_id, $token) {
		$this->db->query("UPDATE " . DB_PREFIX . "designer SET token = '" . $this->db->escape($token) . "' WHERE designer_id = '" . (int)$designer_id . "'");
	}
	
	public function deletedesigner($designer_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "designer WHERE designer_id = '" . (int)$designer_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "designer_reward WHERE designer_id = '" . (int)$designer_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "designer_transaction WHERE designer_id = '" . (int)$designer_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "designer_ip WHERE designer_id = '" . (int)$designer_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "des_address WHERE designer_id = '" . (int)$designer_id . "'");
	}
	
	public function getdesigner($designer_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "designer WHERE designer_id = '" . (int)$designer_id . "'");
	
		return $query->row;
	}
	
	public function getdesignerByEmail($email) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "designer WHERE email = '" . $this->db->escape($email) . "'");
	
		return $query->row;
	}
			
	public function getdesigners($data = array()) {
		$sql = "SELECT *, CONCAT(c.firstname, ' ', c.lastname) AS name, cg.name AS designer_group FROM " . DB_PREFIX . "designer c LEFT JOIN " . DB_PREFIX . "designer_group cg ON (c.designer_group_id = cg.designer_group_id)";

		$implode = array();
		
		if (!empty($data['filter_name'])) {
			$implode[] = "LCASE(CONCAT(c.firstname, ' ', c.lastname)) LIKE '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "%'";
		}
		
		if (!empty($data['filter_email'])) {
			$implode[] = "LCASE(c.email) LIKE '" . $this->db->escape(utf8_strtolower($data['filter_email'])) . "%'";
		}
		
		if (!empty($data['filter_designer_group_id'])) {
			$implode[] = "cg.designer_group_id = '" . $this->db->escape($data['filter_designer_group_id']) . "'";
		}	
		
		if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
			$implode[] = "c.status = '" . (int)$data['filter_status'] . "'";
		}	
		
		if (isset($data['filter_approved']) && !is_null($data['filter_approved'])) {
			$implode[] = "c.approved = '" . (int)$data['filter_approved'] . "'";
		}	
			
		if (!empty($data['filter_ip'])) {
			$implode[] = "c.designer_id IN (SELECT designer_id FROM " . DB_PREFIX . "designer_ip WHERE ip = '" . $this->db->escape($data['filter_ip']) . "')";
		}	
				
		if (!empty($data['filter_date_added'])) {
			$implode[] = "DATE(c.date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
		}
		
		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}
		
		$sort_data = array(
			'name',
			'c.email',
			'designer_group',
			'c.status',
			'c.ip',
			'c.date_added'
		);	
			
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY name";	
		}
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}		
		
		$query = $this->db->query($sql);
		
		return $query->rows;	
	}
	
	public function approve($designer_id) {
		$designer_info = $this->getdesigner($designer_id);

		if ($designer_info) {
			$this->db->query("UPDATE " . DB_PREFIX . "designer SET approved = '1' WHERE designer_id = '" . (int)$designer_id . "'");

//			$this->load->language('mail/designer');
			
			$this->load->model('setting/store');
						
			$store_info = $this->model_setting_store->getStore($designer_info['store_id']);
			
			if ($store_info) {
				$store_name = $store_info['name'];
				$store_url = $store_info['url'] . 'index.php?route=account/login';
			} else {
				$store_name = $this->config->get('config_name');
				$store_url = HTTP_CATALOG . 'index.php?route=account/login';
			}
/*	
			$message  = sprintf($this->language->get('text_approve_welcome'), $store_name) . "\n\n";
			$message .= $this->language->get('text_approve_login') . "\n";
			$message .= $store_url . "\n\n";
			$message .= $this->language->get('text_approve_services') . "\n\n";
			$message .= $this->language->get('text_approve_thanks') . "\n";
			$message .= $store_name;
	
			$mail = new Mail();
			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->hostname = $this->config->get('config_smtp_host');
			$mail->username = $this->config->get('config_smtp_username');
			$mail->password = $this->config->get('config_smtp_password');
			$mail->port = $this->config->get('config_smtp_port');
			$mail->timeout = $this->config->get('config_smtp_timeout');							
			$mail->setTo($designer_info['email']);
			$mail->setFrom($this->config->get('config_email'));
			$mail->setSender($store_name);
			$mail->setSubject(sprintf($this->language->get('text_approve_subject'), $store_name));
			$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
			$mail->send();
*/
		}		
	}

	public function unapprove($designer_id) {
		$designer_info = $this->getdesigner($designer_id);
		if ($designer_info) {
			$this->db->query("UPDATE " . DB_PREFIX . "designer SET approved = '0' WHERE designer_id = '" . (int)$designer_id . "'");

//			$this->load->language('mail/designer');
			
			$this->load->model('setting/store');
						
			$store_info = $this->model_setting_store->getStore($designer_info['store_id']);
			
			if ($store_info) {
				$store_name = $store_info['name'];
				$store_url = $store_info['url'] . 'index.php?route=account/login';
			} else {
				$store_name = $this->config->get('config_name');
				$store_url = HTTP_CATALOG . 'index.php?route=account/login';
			}
/*	
			$message  = sprintf($this->language->get('text_approve_welcome'), $store_name) . "\n\n";
			$message .= $this->language->get('text_approve_login') . "\n";
			$message .= $store_url . "\n\n";
			$message .= $this->language->get('text_approve_services') . "\n\n";
			$message .= $this->language->get('text_approve_thanks') . "\n";
			$message .= $store_name;
	
			$mail = new Mail();
			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->hostname = $this->config->get('config_smtp_host');
			$mail->username = $this->config->get('config_smtp_username');
			$mail->password = $this->config->get('config_smtp_password');
			$mail->port = $this->config->get('config_smtp_port');
			$mail->timeout = $this->config->get('config_smtp_timeout');							
			$mail->setTo($designer_info['email']);
			$mail->setFrom($this->config->get('config_email'));
			$mail->setSender($store_name);
			$mail->setSubject(sprintf($this->language->get('text_approve_subject'), $store_name));
			$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
			$mail->send();
*/			
		}		
	}		
	public function getdesignersByNewsletter() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "designer WHERE newsletter = '1' ORDER BY firstname, lastname, email");
	
		return $query->rows;
	}
	
	public function getdesignersBydesignerGroupId($designer_group_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "designer WHERE designer_group_id = '" . (int)$designer_group_id . "' ORDER BY firstname, lastname, email");
	
		return $query->rows;
	}
		
	public function getdesignersByProduct($product_id) {
		if ($product_id) {
			$query = $this->db->query("SELECT DISTINCT `email` FROM `" . DB_PREFIX . "order` o LEFT JOIN " . DB_PREFIX . "order_product op ON (o.order_id = op.order_id) WHERE op.product_id = '" . (int)$product_id . "' AND o.order_status_id <> '0'");
	
			return $query->rows;
		} else {
			return array();	
		}
	}
	
	public function getAddress($address_id) {
		$address_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "des_address WHERE address_id = '" . (int)$address_id . "'");

		$default_query = $this->db->query("SELECT address_id FROM " . DB_PREFIX . "designer WHERE designer_id = '" . (int)$address_query->row['designer_id'] . "'");
				
		if ($address_query->num_rows) {
			$country_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "country` WHERE country_id = '" . (int)$address_query->row['country_id'] . "'");
			
			if ($country_query->num_rows) {
				$country = $country_query->row['name'];
				$iso_code_2 = $country_query->row['iso_code_2'];
				$iso_code_3 = $country_query->row['iso_code_3'];
				$address_format = $country_query->row['address_format'];
			} else {
				$country = '';
				$iso_code_2 = '';
				$iso_code_3 = '';	
				$address_format = '';
			}
			
			$zone_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "zone` WHERE zone_id = '" . (int)$address_query->row['zone_id'] . "'");
			
			if ($zone_query->num_rows) {
				$zone = $zone_query->row['name'];
				$code = $zone_query->row['code'];
			} else {
				$zone = '';
				$code = '';
			}		
		
			return array(
				'address_id'     => $address_query->row['address_id'],
				'designer_id'    => $address_query->row['designer_id'],
				'firstname'      => $address_query->row['firstname'],
				'lastname'       => $address_query->row['lastname'],
				'company'        => $address_query->row['company'],
				'address_1'      => $address_query->row['address_1'],
				'address_2'      => $address_query->row['address_2'],
				'postcode'       => $address_query->row['postcode'],
				'city'           => $address_query->row['city'],
				'zone_id'        => $address_query->row['zone_id'],
				'zone'           => $zone,
				'zone_code'      => $code,
				'country_id'     => $address_query->row['country_id'],
				'country'        => $country,	
				'iso_code_2'     => $iso_code_2,
				'iso_code_3'     => $iso_code_3,
				'address_format' => $address_format,
				'default'		 => ($default_query->row['address_id'] == $address_query->row['address_id']) ? true : false
			);
		}
	}
		
	public function getAddresses($designer_id) {
		$address_data = array();
		
		$query = $this->db->query("SELECT address_id FROM " . DB_PREFIX . "des_address WHERE designer_id = '" . (int)$designer_id . "'");
	
		foreach ($query->rows as $result) {
			$address_info = $this->getAddress($result['address_id']);
		
			if ($address_info) {
				$address_data[] = $address_info;
			}
		}		
		
		return $address_data;
	}	
				
	public function getTotaldesigners($data = array()) {
      	$sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "designer";
		
		$implode = array();
		
		if (!empty($data['filter_name'])) {
			$implode[] = "LCASE(CONCAT(firstname, ' ', lastname)) LIKE '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "%'";
		}
		
		if (!empty($data['filter_email'])) {
			$implode[] = "LCASE(email) LIKE '" . $this->db->escape(utf8_strtolower($data['filter_email'])) . "%'";
		}
		
		if (!empty($data['filter_designer_group_id'])) {
			$implode[] = "designer_group_id = '" . $this->db->escape($data['filter_designer_group_id']) . "'";
		}	
				
		if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
			$implode[] = "status = '" . (int)$data['filter_status'] . "'";
		}			
		
		if (isset($data['filter_approved']) && !is_null($data['filter_approved'])) {
			$implode[] = "approved = '" . (int)$data['filter_approved'] . "'";
		}		
				
		if (!empty($data['filter_date_added'])) {
			$implode[] = "DATE(date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
		}
		
		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}
				
		$query = $this->db->query($sql);
				
		return $query->row['total'];
	}
		
	public function getTotaldesignersAwaitingApproval() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "designer WHERE status = '0' OR approved = '0'");

		return $query->row['total'];
	}
	
	public function getTotalAddressesBydesignerId($designer_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "des_address WHERE designer_id = '" . (int)$designer_id . "'");
		
		return $query->row['total'];
	}
	
	public function getTotalAddressesByCountryId($country_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "des_address WHERE country_id = '" . (int)$country_id . "'");
		
		return $query->row['total'];
	}	
	
	public function getTotalAddressesByZoneId($zone_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "des_address WHERE zone_id = '" . (int)$zone_id . "'");
		
		return $query->row['total'];
	}
	
	public function getTotaldesignersBydesignerGroupId($designer_group_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "designer WHERE designer_group_id = '" . (int)$designer_group_id . "'");
		
		return $query->row['total'];
	}
	public function getTotaldesignersBySizeId($size_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "size WHERE size_id = '" . (int)$size_id . "'");
		
		return $query->row['total'];
	}
			
	public function addTransaction($designer_id, $description = '', $amount = '', $order_id = 0) {
		$designer_info = $this->getdesigner($designer_id);
		
		if ($designer_info) { 
			$this->db->query("INSERT INTO " . DB_PREFIX . "designer_transaction SET designer_id = '" . (int)$designer_id . "', order_id = '" . (int)$order_id . "', description = '" . $this->db->escape($description) . "', amount = '" . (float)$amount . "', date_added = NOW()");

			$this->language->load('mail/designer');
			
			if ($designer_info['store_id']) {
				$this->load->model('setting/store');
		
				$store_info = $this->model_setting_store->getStore($designer_info['store_id']);
				
				if ($store_info) {
					$store_name = $store_info['store_name'];
				} else {
					$store_name = $this->config->get('config_name');
				}	
			} else {
				$store_name = $this->config->get('config_name');
			}	
						
			$message  = sprintf($this->language->get('text_transaction_received'), $this->currency->format($amount, $this->config->get('config_currency'))) . "\n\n";
			$message .= sprintf($this->language->get('text_transaction_total'), $this->currency->format($this->getTransactionTotal($designer_id)));
								
			$mail = new Mail();
			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->hostname = $this->config->get('config_smtp_host');
			$mail->username = $this->config->get('config_smtp_username');
			$mail->password = $this->config->get('config_smtp_password');
			$mail->port = $this->config->get('config_smtp_port');
			$mail->timeout = $this->config->get('config_smtp_timeout');
			$mail->setTo($designer_info['email']);
			$mail->setFrom($this->config->get('config_email'));
			$mail->setSender($store_name);
			$mail->setSubject(sprintf($this->language->get('text_transaction_subject'), $this->config->get('config_name')));
			$mail->setText($message);
			$mail->send();
		}
	}
	
	public function deleteTransaction($order_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "designer_transaction WHERE order_id = '" . (int)$order_id . "'");
	}
	
	public function getTransactions($designer_id, $start = 0, $limit = 10) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "designer_transaction WHERE designer_id = '" . (int)$designer_id . "' ORDER BY date_added DESC LIMIT " . (int)$start . "," . (int)$limit);
	
		return $query->rows;
	}

	public function getTotalTransactions($designer_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total  FROM " . DB_PREFIX . "designer_transaction WHERE designer_id = '" . (int)$designer_id . "'");
	
		return $query->row['total'];
	}
			
	public function getTransactionTotal($designer_id) {
		$query = $this->db->query("SELECT SUM(amount) AS total FROM " . DB_PREFIX . "designer_transaction WHERE designer_id = '" . (int)$designer_id . "'");
	
		return $query->row['total'];
	}
	
	public function getTotalTransactionsByOrderId($order_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "designer_transaction WHERE order_id = '" . (int)$order_id . "'");
	
		return $query->row['total'];
	}	
				
	public function addReward($designer_id, $description = '', $points = '', $order_id = 0) {
		$designer_info = $this->getdesigner($designer_id);
			
		if ($designer_info) { 
			$this->db->query("INSERT INTO " . DB_PREFIX . "designer_reward SET designer_id = '" . (int)$designer_id . "', order_id = '" . (int)$order_id . "', points = '" . (int)$points . "', description = '" . $this->db->escape($description) . "', date_added = NOW()");

			$this->language->load('mail/designer');
			
			if ($order_id) {
				$this->load->model('sale/order');
		
				$order_info = $this->model_sale_order->getOrder($order_id);
				
				if ($order_info) {
					$store_name = $order_info['store_name'];
				} else {
					$store_name = $this->config->get('config_name');
				}	
			} else {
				$store_name = $this->config->get('config_name');
			}		
				
			$message  = sprintf($this->language->get('text_reward_received'), $points) . "\n\n";
			$message .= sprintf($this->language->get('text_reward_total'), $this->getRewardTotal($designer_id));
				
			$mail = new Mail();
			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->hostname = $this->config->get('config_smtp_host');
			$mail->username = $this->config->get('config_smtp_username');
			$mail->password = $this->config->get('config_smtp_password');
			$mail->port = $this->config->get('config_smtp_port');
			$mail->timeout = $this->config->get('config_smtp_timeout');
			$mail->setTo($designer_info['email']);
			$mail->setFrom($this->config->get('config_email'));
			$mail->setSender($store_name);
			$mail->setSubject(sprintf($this->language->get('text_reward_subject'), $store_name));
			$mail->setText($message);
			$mail->send();
		}
	}

	public function deleteReward($order_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "designer_reward WHERE order_id = '" . (int)$order_id . "'");
	}
	
	public function getRewards($designer_id, $start = 0, $limit = 10) {
		$query = $this->db->query("SELECT o.date_added as date_added,r.order_id,r.product_id,r.sale_amount,r.currency,drd.reward_amount as points FROM " . DB_PREFIX . "designer_rewards_distribution drd," . DB_PREFIX . "rewards r,`" . DB_PREFIX . "order` o WHERE  drd.reward_id=r.reward_id AND  r.order_id=o.order_id AND drd.customer_designer_id = '" . (int)$designer_id . "' ORDER BY o.date_added DESC LIMIT " . (int)$start . "," . (int)$limit);
	
		return $query->rows;
	}
	
	public function getTotalRewards($designer_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "designer_reward WHERE designer_id = '" . (int)$designer_id . "'");
	
		return $query->row['total'];
	}
			
	public function getRewardTotal($designer_id) {
		$query = $this->db->query("SELECT SUM(points) AS total FROM " . DB_PREFIX . "designer_reward WHERE designer_id = '" . (int)$designer_id . "'");
	
		return $query->row['total'];
	}		
	
	public function getTotaldesignerRewardsByOrderId($order_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "designer_reward WHERE order_id = '" . (int)$order_id . "'");
	
		return $query->row['total'];
	}
	
	public function getIpsBydesignerId($designer_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "designer_ip WHERE designer_id = '" . (int)$designer_id . "'");

		return $query->rows;
	}	
	
	public function getTotaldesignersByIp($ip) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "designer_ip WHERE ip = '" . $this->db->escape($ip) . "'");

		return $query->row['total'];
	}				
}
?>