<?php
class ModelCatalogLoyal extends Model {
	public function addloyal($data) {
		$this->db->query("INSERT INTO `" . DB_PREFIX . "loyal` SET type = '" . $this->db->escape($data['type']) . "', sort_order = '" . (int)$data['sort_order'] . "'");
		
		$loyal_id = $this->db->getLastId();
		
		foreach ($data['loyal_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "loyal_description SET loyal_id = '" . (int)$loyal_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
		}

		if (isset($data['loyal_value'])) {
			foreach ($data['loyal_value'] as $loyal_value) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "loyal_value SET loyal_id = '" . (int)$loyal_id . "', image = '" . $this->db->escape($loyal_value['image']) . "', sort_order = '" . (int)$loyal_value['sort_order'] . "'");
				
				$loyal_value_id = $this->db->getLastId();
				
				foreach ($loyal_value['loyal_value_description'] as $language_id => $loyal_value_description) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "loyal_value_description SET loyal_value_id = '" . (int)$loyal_value_id . "', language_id = '" . (int)$language_id . "', loyal_id = '" . (int)$loyal_id . "', name = '" . $this->db->escape($loyal_value_description['name']) . "'");
				}
			}
		}
	}
	
	public function editloyal($loyal_id, $data) {
		$this->db->query("UPDATE `" . DB_PREFIX . "loyal` SET type = '" . $this->db->escape($data['type']) . "', sort_order = '" . (int)$data['sort_order'] . "' WHERE loyal_id = '" . (int)$loyal_id . "'");

		$this->db->query("DELETE FROM " . DB_PREFIX . "loyal_description WHERE loyal_id = '" . (int)$loyal_id . "'");

		foreach ($data['loyal_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "loyal_description SET loyal_id = '" . (int)$loyal_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
		}
				
		$this->db->query("DELETE FROM " . DB_PREFIX . "loyal_value WHERE loyal_id = '" . (int)$loyal_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "loyal_value_description WHERE loyal_id = '" . (int)$loyal_id . "'");
		
		if (isset($data['loyal_value'])) {
			foreach ($data['loyal_value'] as $loyal_value) {
				if ($loyal_value['loyal_value_id']) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "loyal_value SET loyal_value_id = '" . (int)$loyal_value['loyal_value_id'] . "', loyal_id = '" . (int)$loyal_id . "', image = '" . $this->db->escape($loyal_value['image']) . "', sort_order = '" . (int)$loyal_value['sort_order'] . "'");
				} else {
					$this->db->query("INSERT INTO " . DB_PREFIX . "loyal_value SET loyal_id = '" . (int)$loyal_id . "', image = '" . $this->db->escape($loyal_value['image']) . "', sort_order = '" . (int)$loyal_value['sort_order'] . "'");
				}
				
				$loyal_value_id = $this->db->getLastId();
				
				foreach ($loyal_value['loyal_value_description'] as $language_id => $loyal_value_description) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "loyal_value_description SET loyal_value_id = '" . (int)$loyal_value_id . "', language_id = '" . (int)$language_id . "', loyal_id = '" . (int)$loyal_id . "', name = '" . $this->db->escape($loyal_value_description['name']) . "'");
				}
			}
		}
	}
	
	public function deleteloyal($loyal_id) {
		$this->db->query("DELETE FROM `" . DB_PREFIX . "loyal` WHERE loyal_id = '" . (int)$loyal_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "loyal_description WHERE loyal_id = '" . (int)$loyal_id . "'");	
		$this->db->query("DELETE FROM " . DB_PREFIX . "loyal_value WHERE loyal_id = '" . (int)$loyal_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "loyal_value_description WHERE loyal_id = '" . (int)$loyal_id . "'");
	}
	
	public function getloyal($loyal_id) {
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "loyal` o LEFT JOIN " . DB_PREFIX . "loyal_description od ON (o.loyal_id = od.loyal_id) WHERE o.loyal_id = '" . (int)$loyal_id . "' AND od.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row;
	}
		
	public function getloyals($data = array()) {
		$sql = "SELECT * FROM `" . DB_PREFIX . "loyal` o LEFT JOIN " . DB_PREFIX . "loyal_description od ON (o.loyal_id = od.loyal_id) WHERE od.language_id = '" . (int)$this->config->get('config_language_id') . "'";
		
		if (isset($data['filter_name']) && !is_null($data['filter_name'])) {
			$sql .= " AND LCASE(od.name) LIKE '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "%'";
		}

		$sort_data = array(
			'od.name',
			'o.type',
			'o.sort_order'
		);	
		
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY od.name";	
		}
		
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}					

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		
		$query = $this->db->query($sql);

		return $query->rows;
	}
	
	public function getloyalDescriptions($loyal_id) {
		$loyal_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "loyal_description WHERE loyal_id = '" . (int)$loyal_id . "'");
				
		foreach ($query->rows as $result) {
			$loyal_data[$result['language_id']] = array('name' => $result['name']);
		}
		
		return $loyal_data;
	}
	
	public function getloyalValues($loyal_id) {
		$loyal_value_data = array();
		
		$loyal_value_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "loyal_value ov LEFT JOIN " . DB_PREFIX . "loyal_value_description ovd ON (ov.loyal_value_id = ovd.loyal_value_id) WHERE ov.loyal_id = '" . (int)$loyal_id . "' AND ovd.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY ov.sort_order ASC");
				
		foreach ($loyal_value_query->rows as $loyal_value) {
			$loyal_value_data[] = array(
				'loyal_value_id' => $loyal_value['loyal_value_id'],
				'name'            => $loyal_value['name'],
				'image'           => $loyal_value['image'],
				'sort_order'      => $loyal_value['sort_order']
			);
		}
		
		return $loyal_value_data;
	}
	
	public function getloyalValueDescriptions($loyal_id) {
		$loyal_value_data = array();
		
		$loyal_value_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "loyal_value WHERE loyal_id = '" . (int)$loyal_id . "'");
				
		foreach ($loyal_value_query->rows as $loyal_value) {
			$loyal_value_description_data = array();
			
			$loyal_value_description_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "loyal_value_description WHERE loyal_value_id = '" . (int)$loyal_value['loyal_value_id'] . "'");			
			
			foreach ($loyal_value_description_query->rows as $loyal_value_description) {
				$loyal_value_description_data[$loyal_value_description['language_id']] = array('name' => $loyal_value_description['name']);
			}
			
			$loyal_value_data[] = array(
				'loyal_value_id'          => $loyal_value['loyal_value_id'],
				'loyal_value_description' => $loyal_value_description_data,
				'image'                    => $loyal_value['image'],
				'sort_order'               => $loyal_value['sort_order']
			);
		}
		
		return $loyal_value_data;
	}

	public function getTotalloyals() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "loyal`"); 
		
		return $query->row['total'];
	}		
}
?>