<?php
class ControllerAffiliateAffiliatepayment extends Controller {
	private $error = array();

  	public function index()
  	{
        $this->load->language('affiliate/affiliatepayment');
        $this->document->setTitle($this->language->get('heading_title'));
    		$this->load->model('affiliate/affiliate');
       	$this->getList();
  	}

  	public function generatefile() {
	$this->load->language('affiliate/affiliatepayment');
	$this->data['token'] = $this->session->data['token'];

    	$this->document->setTitle($this->language->get('heading_title'));

  		$this->load->model('affiliate/affiliate');


    	if (isset($this->request->post['selected']) )
    	{
			   $Date=date("mdY_His");
         $filename = 'MassPaymentFiles\Paypal_Mass_Payment_File_'.$Date.'.txt';
         $Aff_Currency =  $this->config->get('config_currency');
         $Delimiter="\t";
         $Aff_Name = $this->config->get('config_name'). " - Affiliate Payment";
         $count=0;
         foreach ($this->request->post['selected'] as $affiliate_id_count ){
         	  $count+=1;
         }
         $content   = "test";
         if($count != 0)
         {
            if($handle = fopen($filename, 'a'))
            {
               if(is_writable($filename))
               {
                   if(fwrite($handle, $content) === FALSE)
                   {
                      $this->session->data['success']= "Cannot write to file $filename";
                      exit;
                   }
                   foreach ($this->request->post['selected'] as $affiliate_id)
                   {
                       if (isset($affiliate_id)){
      		          $affl_payment = $this->model_affiliate_affiliate->getAffiliatePayProcessSales($affiliate_id);
      		          $affl_info    = $this->model_affiliate_affiliate->getAffiliate($affiliate_id);
                       }
                       $Aff_Sale  = "";
                       $Aff_Mail  = "";
                       $Aff_PayID = "";
                       $Content   = "";
                       if (isset($affl_payment)) 
                       {
                       	   If (isset($affl_payment['affaccount_id'])){
                       	   	$Aff_PayID =  "PAY000".$affl_payment['affaccount_id'] ;
                       	   }else{
                       	   	$Aff_PayID =  "PAY000";
                       	   }                       	 
                       	   If (isset($affl_payment['Sale_Total'])){
				$Aff_Sale  =  $affl_payment['Sale_Total'] ;
			   }
		        }
                       if (isset($affl_info)) {
						$Aff_Mail =  $affl_info['email'] ;
			          }
                   	  $Content = $Aff_Mail . $Delimiter . $Aff_Sale . $Delimiter . $Aff_Currency . $Delimiter . $Aff_PayID . $Delimiter . $Aff_Name . "\r\n";
                   	  If (isset($affl_payment['Sale_Total'])){
                   	     if($affl_payment['Payment_Status'] == "2") {
                   	         fwrite($handle, $Content);
                   	     }
                   	  }
					         }
					         fclose($handle);
                   $this->session->data['success']= "PayPal Mass Payment File " . getcwd() . "\\" . "$filename was created successfully";
               }else
               {
                   $this->error['warning']= "The file $filename, could not written to!";
                   exit;
               }
            }else
            {
                 $this->session->data['success']= "The file $filename, could not be created!";
                 exit;
            }

         }
			   $url = '';

			   if (isset($this->request->get['filter_name'])) {
			   	$url .= '&filter_name=' . $this->request->get['filter_name'];
			   }

			   if (isset($this->request->get['filter_email'])) {
			   	$url .= '&filter_email=' . $this->request->get['filter_email'];
			   }

			   if (isset($this->request->get['filter_affiliate_group_id'])) {
			   	$url .= '&filter_affiliate_group_id=' . $this->request->get['filter_affiliate_group_id'];
			   }

			   if (isset($this->request->get['filter_status'])) {
			   	$url .= '&filter_status=' . $this->request->get['filter_status'];
			   }

			   if (isset($this->request->get['filter_approved'])) {
			   	$url .= '&filter_approved=' . $this->request->get['filter_approved'];
			   }

			   if (isset($this->request->get['filter_date_added'])) {
			   	$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
			   }

			   if (isset($this->request->get['page'])) {
			   	$url .= '&page=' . $this->request->get['page'];
			   }

			   if (isset($this->request->get['sort'])) {
			   	$url .= '&sort=' . $this->request->get['sort'];
			   }

			   if (isset($this->request->get['order'])) {
			   	$url .= '&order=' . $this->request->get['order'];
			   }

			   $this->redirect(HTTPS_SERVER . 'index.php?route=affiliate/affiliatepayment&token=' . $this->session->data['token'] . $url);
    	}

    	$this->getList();
  	}

  	public function updatepaid() {
		$this->load->language('affiliate/affiliatepayment');
		$this->data['token'] = $this->session->data['token'];

    	$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('affiliate/affiliate');

    	if (isset($this->request->post['selected']) )
    	{
			   foreach ($this->request->post['selected'] as $affiliate_id)
			   {
			   	$this->model_affiliate_affiliate->UpdateAffiliatePaidStatus($affiliate_id);
			   }

			   $this->session->data['success'] = $this->language->get('text_success');

			   $url = '';

			   if (isset($this->request->get['filter_name'])) {
			   	$url .= '&filter_name=' . $this->request->get['filter_name'];
			   }

			   if (isset($this->request->get['filter_email'])) {
			   	$url .= '&filter_email=' . $this->request->get['filter_email'];
			   }

			   if (isset($this->request->get['filter_affiliate_group_id'])) {
			   	$url .= '&filter_affiliate_group_id=' . $this->request->get['filter_affiliate_group_id'];
			   }

			   if (isset($this->request->get['filter_status'])) {
			   	$url .= '&filter_status=' . $this->request->get['filter_status'];
			   }

			   if (isset($this->request->get['filter_approved'])) {
			   	$url .= '&filter_approved=' . $this->request->get['filter_approved'];
			   }

			   if (isset($this->request->get['filter_date_added'])) {
			   	$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
			   }

			   if (isset($this->request->get['page'])) {
			   	$url .= '&page=' . $this->request->get['page'];
			   }

			   if (isset($this->request->get['sort'])) {
			   	$url .= '&sort=' . $this->request->get['sort'];
			   }

			   if (isset($this->request->get['order'])) {
			   	$url .= '&order=' . $this->request->get['order'];
			   }

			   $this->redirect(HTTPS_SERVER . 'index.php?route=affiliate/affiliatepayment&token=' . $this->session->data['token'] . $url);
    	}

    	$this->getList();
  	}

  	public function delete() {
		$this->load->language('affiliate/affiliatepayment');
$this->data['token'] = $this->session->data['token'];

    	$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('affiliate/affiliate');

    	if (isset($this->request->post['selected']) )
    	{
			   foreach ($this->request->post['selected'] as $affiliate_id)
			   {
			   	$this->model_affiliate_affiliate->UpdateAffiliatePayStatus($affiliate_id);
			   }

			   $this->session->data['success'] = $this->language->get('text_success');

			   $url = '';

			   if (isset($this->request->get['filter_name'])) {
			   	$url .= '&filter_name=' . $this->request->get['filter_name'];
			   }

			   if (isset($this->request->get['filter_email'])) {
			   	$url .= '&filter_email=' . $this->request->get['filter_email'];
			   }

			   if (isset($this->request->get['filter_affiliate_group_id'])) {
			   	$url .= '&filter_affiliate_group_id=' . $this->request->get['filter_affiliate_group_id'];
			   }

			   if (isset($this->request->get['filter_status'])) {
			   	$url .= '&filter_status=' . $this->request->get['filter_status'];
			   }

			   if (isset($this->request->get['filter_approved'])) {
			   	$url .= '&filter_approved=' . $this->request->get['filter_approved'];
			   }

			   if (isset($this->request->get['filter_date_added'])) {
			   	$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
			   }

			   if (isset($this->request->get['page'])) {
			   	$url .= '&page=' . $this->request->get['page'];
			   }

			   if (isset($this->request->get['sort'])) {
			   	$url .= '&sort=' . $this->request->get['sort'];
			   }

			   if (isset($this->request->get['order'])) {
			   	$url .= '&order=' . $this->request->get['order'];
			   }

			   $this->redirect(HTTPS_SERVER . 'index.php?route=affiliate/affiliatepayment&token=' . $this->session->data['token'] . $url);
    	}

    	$this->getList();
  	}

  	private function getList() {
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		$this->data['token'] = $this->session->data['token'];

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['filter_name'])) {
			$filter_name = $this->request->get['filter_name'];
		} else {
			$filter_name = NULL;
		}

		if (isset($this->request->get['filter_email'])) {
			$filter_email = $this->request->get['filter_email'];
		} else {
			$filter_email = NULL;
		}

		if (isset($this->request->get['filter_affiliate_group_id'])) {
			$filter_affiliate_group_id = $this->request->get['filter_affiliate_group_id'];
		} else {
			$filter_affiliate_group_id = NULL;
		}

		if (isset($this->request->get['filter_paidstatus'])) {
			$filter_paidstatus = $this->request->get['filter_paidstatus'];
		} else {
			$filter_paidstatus = NULL;
		}

		if (isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
		} else {
			$filter_status = NULL;
		}

		if (isset($this->request->get['filter_approved'])) {
			$filter_approved = $this->request->get['filter_approved'];
		} else {
			$filter_approved = NULL;
		}

		if (isset($this->request->get['filter_payment'])) {
			$filter_payment = $this->request->get['filter_payment'];
		} else {
			$filter_payment = NULL;
		}

		if (isset($this->request->get['filter_date_added'])) {
			$filter_date_added = $this->request->get['filter_date_added'];
		} else {
			$filter_date_added = NULL;
		}

		$url = '';
	//	if($this->config->get('affiliate') != $_SERVER["SERVER_NAME"])exit;
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}

		if (isset($this->request->get['filter_email'])) {
			$url .= '&filter_email=' . $this->request->get['filter_email'];
		}

		if (isset($this->request->get['filter_affiliate_group_id'])) {
			$url .= '&filter_affiliate_group_id=' . $this->request->get['filter_affiliate_group_id'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['filter_paidstatus'])) {
			$url .= '&filter_paidstatus=' . $this->request->get['filter_paidstatus'];
		}

		if (isset($this->request->get['filter_approved'])) {
			$url .= '&filter_approved=' . $this->request->get['filter_approved'];
		}

		if (isset($this->request->get['filter_payment'])) {
			$url .= '&filter_payment=' . $this->request->get['filter_payment'];
		}

		if (isset($this->request->get['filter_date_added'])) {
			$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

  		$this->document->breadcrumbs = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=affiliate/home&token=' . $this->session->data['token'],
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=affiliate/affiliatepayment&token=' . $this->session->data['token'] . $url,
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);

//		$this->data['approve'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliatepayment/delete&token=' . $this->session->data['token'] . $url;
//		$this->data['updatepaid']  = HTTPS_SERVER . 'index.php?route=affiliate/affiliatepayment/updatepaid&token=' . $this->session->data['token'] . $url;
//		$this->data['generatefile']  = HTTPS_SERVER . 'index.php?route=affiliate/affiliatepayment/generatefile&token=' . $this->session->data['token'] . $url;

		$this->data['affiliates'] = array();

		$data = array(
			'filter_name'               => $filter_name,
			'filter_email'              => $filter_email,
			'filter_affiliate_group_id' => $filter_affiliate_group_id,
			'filter_status'             => $filter_status,
			'filter_approved'           => $filter_approved,
			'filter_payment'            => $filter_payment,
			'filter_date_added'         => $filter_date_added,
			'sort'                      => $sort,
			'order'                     => $order,
			'start'                     => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'                     => $this->config->get('config_admin_limit')
		);

		$affiliate_total = $this->model_affiliate_affiliate->getTotalAffiliates($data);

		$results = $this->model_affiliate_affiliate->getAffiliatesPayments($data);

    	foreach ($results as $result) {
			$action = array();

			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => HTTPS_SERVER . 'index.php?route=sale/affiliate/update&token=' . $this->session->data['token'] . '&affiliate_id=' . $result['affiliate_id']
			);

			$this->data['affiliates'][] = array(
				'affiliate_id'    => $result['affiliate_id'],
				'name'            => $result['name'],
				'email'           => $result['email'],
				'affiliate_group' => $result['affiliate_group'],
				'status'          => ($result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled')),
				'payment_status'  => $result['Payment_Status'],
				'Sale_Total'      => $result['Sale_Total'],
				'approved'        => ($result['approved'] ? $this->language->get('text_yes') : $this->language->get('text_no')),
				'date_added'      => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
				'selected'        => isset($this->request->post['selected']) && in_array($result['affiliate_id'], $this->request->post['selected']),
				'action'          => $action
			);
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_UpdatePayment_InP'] = $this->language->get('text_UpdatePayment_InP');
		$this->data['text_UpdatePayment_CMP'] = $this->language->get('text_UpdatePayment_CMP');
		$this->data['text_GenMasPayFile'] = $this->language->get('text_GenMasPayFile');
		$this->data['text_Payment_Status'] = $this->language->get('text_Payment_Status');
		$this->data['text_Payment_Details'] = $this->language->get('text_Payment_Details');
		$this->data['text_Paid'] = $this->language->get('text_Paid');
		$this->data['text_NotPaid'] = $this->language->get('text_NotPaid');
		$this->data['text_InProcess'] = $this->language->get('text_InProcess');


		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_email'] = $this->language->get('column_email');
		$this->data['column_affiliate_group'] = $this->language->get('column_affiliate_group');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_paidstatus'] = $this->language->get('column_paidstatus');
		$this->data['column_approved'] = $this->language->get('column_approved');
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['button_approve'] = $this->language->get('button_approve');
		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
		$this->data['button_filter'] = $this->language->get('button_filter');

		if (isset($this->session->data['error'])) {
			$this->data['error_warning'] = $this->session->data['error'];

			unset($this->session->data['error']);
		} elseif (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}

		if (isset($this->request->get['filter_email'])) {
			$url .= '&filter_email=' . $this->request->get['filter_email'];
		}

		if (isset($this->request->get['filter_affiliate_group_id'])) {
			$url .= '&filter_affiliate_group_id=' . $this->request->get['filter_affiliate_group_id'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['filter_approved'])) {
			$url .= '&filter_approved=' . $this->request->get['filter_approved'];
		}

		if (isset($this->request->get['filter_payment'])) {
			$url .= '&filter_payment=' . $this->request->get['filter_payment'];
		}

		if (isset($this->request->get['filter_date_added'])) {
			$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
		}

		if ($order == 'ASC') {
			$url .= '&order=' .  'DESC';
		} else {
			$url .= '&order=' .  'ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['sort_name'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliatepayment&token=' . $this->session->data['token'] .'&sort=name' . $url;
		$this->data['sort_email'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliatepayment&token=' . $this->session->data['token'] . '&sort=c.email' . $url;
		$this->data['sort_affiliate_group'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliatepayment&token=' . $this->session->data['token'] .'&sort=affiliate_group' . $url;
		$this->data['sort_status'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliatepayment&token=' . $this->session->data['token'] .'&sort=c.status' . $url;
		$this->data['sort_paidstatus'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliatepayment&token=' . $this->session->data['token'] .'&sort=aa.Payment_Status' . $url;
		$this->data['sort_approved'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliatepayment&token=' . $this->session->data['token'] .'&sort=aa.Sale_Total' . $url;
		$this->data['sort_date_added'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliatepayment&token=' . $this->session->data['token'] .'&sort=c.date_added' . $url;

		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}

		if (isset($this->request->get['filter_email'])) {
			$url .= '&filter_email=' . $this->request->get['filter_email'];
		}

		if (isset($this->request->get['filter_affiliate_group_id'])) {
			$url .= '&filter_affiliate_group_id=' . $this->request->get['filter_affiliate_group_id'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['filter_approved'])) {
			$url .= '&filter_approved=' . $this->request->get['filter_approved'];
		}

		if (isset($this->request->get['filter_payment'])) {
			$url .= '&filter_payment=' . $this->request->get['filter_payment'];
		}

		if (isset($this->request->get['filter_date_added'])) {
			$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $affiliate_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = HTTPS_SERVER . 'index.php?route=affiliate/affiliatepayment&token=' . $this->session->data['token'] . $url . '&page={page}';

		$this->data['pagination'] = $pagination->render();

		$this->data['filter_name'] = $filter_name;
		$this->data['filter_email'] = $filter_email;
		$this->data['filter_affiliate_group_id'] = $filter_affiliate_group_id;
		$this->data['filter_status'] = $filter_status;
		$this->data['filter_approved'] = $filter_approved;
		$this->data['filter_payment'] = $filter_payment;
		$this->data['filter_date_added'] = $filter_date_added;

		$this->load->model('affiliate/affiliate_group');

    	$this->data['affiliate_groups'] = $this->model_affiliate_affiliate_group->getAffiliateGroups();

		$this->data['sort'] = $sort;
		$this->data['order'] = $order;

		$this->template = 'affiliate/affiliate_payment_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
  	}

  	private function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');
$this->data['token'] = $this->session->data['token'];

    	$this->data['text_enabled'] = $this->language->get('text_enabled');
    	$this->data['text_disabled'] = $this->language->get('text_disabled');

    	$this->data['entry_firstname'] = $this->language->get('entry_firstname');
    	$this->data['entry_lastname'] = $this->language->get('entry_lastname');
    	$this->data['entry_email'] = $this->language->get('entry_email');
    	$this->data['entry_telephone'] = $this->language->get('entry_telephone');
    	$this->data['entry_fax'] = $this->language->get('entry_fax');
    	$this->data['entry_password'] = $this->language->get('entry_password');
    	$this->data['entry_confirm'] = $this->language->get('entry_confirm');
		  $this->data['entry_newsletter'] = $this->language->get('entry_newsletter');
    	$this->data['entry_customer_group'] = $this->language->get('entry_affiliate_group');
		  $this->data['entry_status'] = $this->language->get('entry_status');
		  $this->data['entry_UrlCount'] = $this->language->get('entry_UrlCount');
		  $this->data['entry_Sale_Click'] = $this->language->get('entry_Sale_Click');
		  $this->data['entry_sale_salescount'] = $this->language->get('entry_sale_salescount');
		  $this->data['entry_Sale_CustomerCount'] = $this->language->get('entry_Sale_CustomerCount');
		  $this->data['entry_Total_Customers'] = $this->language->get('entry_Total_Customers');
		  $this->data['entry_Sale_Commission'] = $this->language->get('entry_Sale_Commission');
		  $this->data['entry_Sale_Flat_Rate'] = $this->language->get('entry_Sale_Flat_Rate');
		  $this->data['entry_Last_Processed_Date'] = $this->language->get('entry_Last_Processed_Date');
		  $this->data['entry_Sale_Total'] = $this->language->get('entry_Sale_Total');

      $this->data['config_flatratesale_enable'] = $this->config->get('config_flatratesale_enable');
      $this->data['config_paypersale_enable'] = $this->config->get('config_paypersale_enable');
      $this->data['config_paypercust_enable'] = $this->config->get('config_paypercust_enable');
      $this->data['config_paypersalecount_enable'] = $this->config->get('config_paypersalecount_enable');
      $this->data['config_payclickcount_enable'] = $this->config->get('config_payclickcount_enable');



		$this->data['button_save'] = $this->language->get('button_save');
    $this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['firstname'])) {
			$this->data['error_firstname'] = $this->error['firstname'];
		} else {
			$this->data['error_firstname'] = '';
		}

 		if (isset($this->error['lastname'])) {
			$this->data['error_lastname'] = $this->error['lastname'];
		} else {
			$this->data['error_lastname'] = '';
		}

 		if (isset($this->error['email'])) {
			$this->data['error_email'] = $this->error['email'];
		} else {
			$this->data['error_email'] = '';
		}

 		if (isset($this->error['telephone'])) {
			$this->data['error_telephone'] = $this->error['telephone'];
		} else {
			$this->data['error_telephone'] = '';
		}

 		if (isset($this->error['password'])) {
			$this->data['error_password'] = $this->error['password'];
		} else {
			$this->data['error_password'] = '';
		}

 		if (isset($this->error['confirm'])) {
			$this->data['error_confirm'] = $this->error['confirm'];
		} else {
			$this->data['error_confirm'] = '';
		}

		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}

		if (isset($this->request->get['filter_email'])) {
			$url .= '&filter_email=' . $this->request->get['filter_email'];
		}

		if (isset($this->request->get['filter_affiliate_group_id'])) {
			$url .= '&filter_affiliate_group_id=' . $this->request->get['filter_affiliate_group_id'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['filter_approved'])) {
			$url .= '&filter_approved=' . $this->request->get['filter_approved'];
		}

		if (isset($this->request->get['filter_payment'])) {
			$url .= '&filter_payment=' . $this->request->get['filter_payment'];
		}


		if (isset($this->request->get['filter_date_added'])) {
			$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

  		$this->document->breadcrumbs = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=common/home&token=' . $this->session->data['token'],
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=affiliate/affiliate&token=' . $this->session->data['token'] . $url,
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);

		if (!isset($this->request->get['affiliate_id'])) {
			$this->data['action'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliate/insert&token=' . $this->session->data['token'] . $url;
		} else {
			$this->data['action'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliate/update&token=' . $this->session->data['token'] . '&affiliate_id=' . $this->request->get['affiliate_id'] . $url;
		}

    	$this->data['cancel'] = HTTPS_SERVER . 'index.php?route=affiliate/affiliate&token=' . $this->session->data['token'] . $url;

    	if (isset($this->request->get['affiliate_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$affiliate_info = $this->model_affiliate_affiliate->getAffiliate($this->request->get['affiliate_id']);
    	}

    	if (isset($this->request->post['firstname'])) {
      		$this->data['firstname'] = $this->request->post['firstname'];
		} elseif (isset($affiliate_info)) {
			$this->data['firstname'] = $affiliate_info['firstname'];
		} else {
      		$this->data['firstname'] = '';
    	}

    	if (isset($this->request->post['lastname'])) {
      		$this->data['lastname'] = $this->request->post['lastname'];
    	} elseif (isset($affiliate_info)) {
			$this->data['lastname'] = $affiliate_info['lastname'];
		} else {
      		$this->data['lastname'] = '';
    	}

    	if (isset($this->request->post['email'])) {
      		$this->data['email'] = $this->request->post['email'];
    	} elseif (isset($affiliate_info)) {
			$this->data['email'] = $affiliate_info['email'];
		} else {
      		$this->data['email'] = '';
    	}

    	if (isset($this->request->post['telephone'])) {
      		$this->data['telephone'] = $this->request->post['telephone'];
    	} elseif (isset($affiliate_info)) {
			$this->data['telephone'] = $affiliate_info['telephone'];
		} else {
      		$this->data['telephone'] = '';
    	}

    	if (isset($this->request->post['fax'])) {
      		$this->data['fax'] = $this->request->post['fax'];
    	} elseif (isset($affiliate_info)) {
			$this->data['fax'] = $affiliate_info['fax'];
		} else {
      		$this->data['fax'] = '';
    	}

    	if (isset($this->request->post['newsletter'])) {
      		$this->data['newsletter'] = $this->request->post['newsletter'];
    	} elseif (isset($affiliate_info)) {
			$this->data['newsletter'] = $affiliate_info['newsletter'];
		} else {
      		$this->data['newsletter'] = '';
    	}

		$this->load->model('affiliate/affiliate_group');

		$this->data['affiliate_groups'] = $this->model_affiliate_affiliate_group->getAffiliateGroups();

    	if (isset($this->request->post['affiliate_group_id'])) {
      		$this->data['affiliate_group_id'] = $this->request->post['affiliate_group_id'];
    	} elseif (isset($affiliate_info)) {
			$this->data['affiliate_group_id'] = $affiliate_info['affiliate_group_id'];
		} else {
      		$this->data['affiliate_group_id'] = $this->config->get('config_affiliate_group_id');
    	}

    	if (isset($this->request->post['status'])) {
      		$this->data['status'] = $this->request->post['status'];
    	} elseif (isset($affiliate_info)) {
			$this->data['status'] = $affiliate_info['status'];
		} else {
      		$this->data['status'] = 1;
    	}

    	if (isset($this->request->post['password'])) {
			$this->data['password'] = $this->request->post['password'];
		} else {
			$this->data['password'] = '';
		}

		if (isset($this->request->post['confirm'])) {
    		$this->data['confirm'] = $this->request->post['confirm'];
		} else {
			$this->data['confirm'] = '';
		}

   	if (isset($this->request->get['affiliate_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$affiliate_balanceinfo = $this->model_affiliate_affiliate->getAffiliateSales($this->request->get['affiliate_id']);
    }

    if (isset($this->request->post['UrlCount'])) {
      		$this->data['UrlCount'] = $this->request->post['UrlCount'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['UrlCount'] =  $affiliate_balanceinfo['UrlCount'] ;
		} else {
      		$this->data['UrlCount'] = 0;
    }

    if (isset($this->request->post['Sale_Click'])) {
      		$this->data['Sale_Click'] = $this->request->post['Sale_Click'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['Sale_Click'] =  $affiliate_balanceinfo['Sale_Click'] ;
		} else {
      		$this->data['Sale_Click'] = 0;
    }

    if (isset($this->request->post['Sale_CustomerCount'])) {
      		$this->data['Sale_CustomerCount'] = $this->request->post['Sale_CustomerCount'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['Sale_CustomerCount'] =  $affiliate_balanceinfo['Sale_CustomerCount'] ;
		} else {
      		$this->data['Sale_CustomerCount'] = 0;
    }
    if (isset($this->request->post['sale_salescount'])) {
      		$this->data['sale_salescount'] = $this->request->post['sale_salescount'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['sale_salescount'] =  $affiliate_balanceinfo['sale_salescount'] ;
		} else {
      		$this->data['sale_salescount'] = 0;
    }

    if (isset($this->request->post['Total_Customers'])) {
      		$this->data['Total_Customers'] = $this->request->post['Total_Customers'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['Total_Customers'] =  $affiliate_balanceinfo['Total_Customers'] ;
		} else {
      		$this->data['Total_Customers'] = 0;
    }

    if (isset($this->request->post['Sale_Commission'])) {
      		$this->data['Sale_Commission'] = $this->request->post['Sale_Commission'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['Sale_Commission'] =  $affiliate_balanceinfo['Sale_Commission'] ;
		} else {
      		$this->data['Sale_Commission'] = 0;
    }

    if (isset($this->request->post['Sale_Flat_Rate'])) {
      		$this->data['Sale_Flat_Rate'] = $this->request->post['Sale_Flat_Rate'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['Sale_Flat_Rate'] =  $affiliate_balanceinfo['Sale_Flat_Rate'] ;
		} else {
      		$this->data['Sale_Flat_Rate'] = 0;
    }
    if (isset($this->request->post['Sale_Total'])) {
      		$this->data['Sale_Total'] = $this->request->post['Sale_Total'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['Sale_Total'] =  $affiliate_balanceinfo['Sale_Total'] ;
		} else {
      		$this->data['Sale_Total'] = 0;
    }

    if (isset($this->request->post['Last_Processed_Date'])) {
      		$this->data['Last_Processed_Date'] = $this->request->post['Last_Processed_Date'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['Last_Processed_Date'] =  $affiliate_balanceinfo['Last_Processed_Date'] ;
		} else {
      		$this->data['Last_Processed_Date'] = 0;
    }

    if (isset($this->request->post['Payment_Status'])) {
      		$this->data['Payment_Status'] = $this->request->post['Payment_Status'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['Payment_Status'] =  $affiliate_balanceinfo['Payment_Status'] ;
		} else {
      		$this->data['Payment_Status'] = 0;
    }


   	if (isset($this->request->get['affiliate_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$affiliate_balanceinfo = $this->model_affiliate_affiliate->getAffiliateSalesPayinProgress($this->request->get['affiliate_id']);
    }

    if (isset($this->request->post['INP_UrlCount'])) {
      		$this->data['INP_UrlCount'] = $this->request->post['INP_UrlCount'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['INP_UrlCount'] =  $affiliate_balanceinfo['UrlCount'] ;
		} else {
      		$this->data['INP_UrlCount'] = 0;
    }

    if (isset($this->request->post['INP_Sale_Click'])) {
      		$this->data['INP_Sale_Click'] = $this->request->post['INP_Sale_Click'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['INP_Sale_Click'] =  $affiliate_balanceinfo['Sale_Click'] ;
		} else {
      		$this->data['INP_Sale_Click'] = 0;
    }

    if (isset($this->request->post['INP_Sale_CustomerCount'])) {
      		$this->data['INP_Sale_CustomerCount'] = $this->request->post['INP_Sale_CustomerCount'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['INP_Sale_CustomerCount'] =  $affiliate_balanceinfo['Sale_CustomerCount'] ;
		} else {
      		$this->data['INP_Sale_CustomerCount'] = 0;
    }
    if (isset($this->request->post['INP_sale_salescount'])) {
      		$this->data['INP_sale_salescount'] = $this->request->post['INP_sale_salescount'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['INP_sale_salescount'] =  $affiliate_balanceinfo['sale_salescount'] ;
		} else {
      		$this->data['INP_sale_salescount'] = 0;
    }

    if (isset($this->request->post['INP_Total_Customers'])) {
      		$this->data['INP_Total_Customers'] = $this->request->post['INP_Total_Customers'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['INP_Total_Customers'] =  $affiliate_balanceinfo['Total_Customers'] ;
		} else {
      		$this->data['INP_Total_Customers'] = 0;
    }

    if (isset($this->request->post['INP_Sale_Commission'])) {
      		$this->data['INP_Sale_Commission'] = $this->request->post['INP_Sale_Commission'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['INP_Sale_Commission'] =  $affiliate_balanceinfo['Sale_Commission'] ;
		} else {
      		$this->data['INP_Sale_Commission'] = 0;
    }

    if (isset($this->request->post['INP_Sale_Flat_Rate'])) {
      		$this->data['INP_Sale_Flat_Rate'] = $this->request->post['INP_Sale_Flat_Rate'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['INP_Sale_Flat_Rate'] =  $affiliate_balanceinfo['Sale_Flat_Rate'] ;
		} else {
      		$this->data['INP_Sale_Flat_Rate'] = 0;
    }
    if (isset($this->request->post['INP_Sale_Total'])) {
      		$this->data['INP_Sale_Total'] = $this->request->post['INP_Sale_Total'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['INP_Sale_Total'] =  $affiliate_balanceinfo['Sale_Total'] ;
		} else {
      		$this->data['INP_Sale_Total'] = 0;
    }

    if (isset($this->request->post['INP_Last_Processed_Date'])) {
      		$this->data['INP_Last_Processed_Date'] = $this->request->post['INP_Last_Processed_Date'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['INP_Last_Processed_Date'] =  $affiliate_balanceinfo['Last_Processed_Date'] ;
		} else {
      		$this->data['INP_Last_Processed_Date'] = 0;
    }

    if (isset($this->request->post['INP_Payment_Status'])) {
      		$this->data['INP_Payment_Status'] = $this->request->post['INP_Payment_Status'];
		} elseif (isset($affiliate_balanceinfo)) {
			$this->data['INP_Payment_Status'] =  $affiliate_balanceinfo['Payment_Status'] ;
		} else {
      		$this->data['INP_Payment_Status'] = 0;
    }



    $this->data['paidsales'] = array();
		$affsales = $this->model_affiliate_affiliate->getAffiliatePaidSales($this->request->get['affiliate_id']);

    	foreach ($affsales as $sale) {
			   $this->data['paidsales'][] = array(
         		'Sale_Flat_Rate'      => $sale['Sale_Flat_Rate'],
        		'Sale_Commission'     => $sale['Sale_Commission'],
        		'Total_Customers'     => $sale['Total_Customers'],
        		'Sale_CustomerCount'  => $sale['Sale_CustomerCount'],
        		'sale_salescount'     => $sale['sale_salescount'],
        		'UrlCount'            => $sale['UrlCount'],
        		'Sale_Click'          => $sale['Sale_Click'],
        		'Sale_Total'          => $sale['Sale_Total'],
        		'Payment_Status'      => $sale['Payment_Status'],
        		'Last_Processed_Date' => $sale['Last_Processed_Date']
       	);
      }

		$this->template = 'affiliate/affiliate_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
	}

	public function approve() {
		$this->load->language('affiliate/affiliate');
		$this->load->language('mail/affiliate');
$this->data['token'] = $this->session->data['token'];

		if (!$this->user->hasPermission('modify', 'affiliate/affiliate')) {
			$this->session->data['error'] = $this->language->get('error_permission');
		} else {
			if (isset($this->request->post['selected'])) {
				$this->load->model('affiliate/affiliate');

				foreach ($this->request->post['selected'] as $affiliate_id) {
					$affiliate_info = $this->model_affiliate_affiliate->getAffiliate($affiliate_id);

					if ($affiliate_info && !$affiliate_info['approved']) {
						$this->model_affiliate_affiliate->approve($affiliate_id);

						$this->load->model('setting/store');

						$store_info = $this->model_setting_store->getStore($affiliate_info['store_id']);

						if ($store_info) {
							$store_name = $store_info['name'];
							$store_url = $store_info['url'] . 'index.php?route=account/login';
						} else {
							$store_name = $this->config->get('config_name');
							$store_url = $this->config->get('config_url') . 'index.php?route=account/login';
						}

						$message  = sprintf($this->language->get('text_welcome'), $store_name) . "\n\n";;
						$message .= $this->language->get('text_login') . "\n";
						$message .= $store_url . "\n\n";
						$message .= $this->language->get('text_services') . "\n\n";
						$message .= $this->language->get('text_thanks') . "\n";
						$message .= $store_name;

						$mail = new Mail();
						$mail->protocol = $this->config->get('config_mail_protocol');
						$mail->hostname = $this->config->get('config_smtp_host');
						$mail->username = $this->config->get('config_smtp_username');
						$mail->password = $this->config->get('config_smtp_password');
						$mail->port = $this->config->get('config_smtp_port');
						$mail->timeout = $this->config->get('config_smtp_timeout');
						$mail->setTo($affiliate_info['email']);
						$mail->setFrom($this->config->get('config_email'));
						$mail->setSender($store_name);
						$mail->setSubject(sprintf($this->language->get('text_subject'), $store_name));
						$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
						$mail->send();

						$this->session->data['success'] = sprintf($this->language->get('text_approved'), $affiliate_info['firstname'] . ' ' . $affiliate_info['lastname']);
					}
				}
			}
		}

		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}

		if (isset($this->request->get['filter_email'])) {
			$url .= '&filter_email=' . $this->request->get['filter_email'];
		}

		if (isset($this->request->get['filter_affiliate_group_id'])) {
			$url .= '&filter_affiliate_group_id=' . $this->request->get['filter_affiliate_group_id'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['filter_approved'])) {
			$url .= '&filter_approved=' . $this->request->get['filter_approved'];
		}

		if (isset($this->request->get['filter_payment'])) {
			$url .= '&filter_payment=' . $this->request->get['filter_payment'];
		}


		if (isset($this->request->get['filter_date_added'])) {
			$url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$this->redirect(HTTPS_SERVER . 'index.php?route=affiliate/affiliate&token=' . $this->session->data['token'] . $url);
	}

  	private function validateForm() {
    	if (!$this->user->hasPermission('modify', 'affiliate/affiliate')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
$this->data['token'] = $this->session->data['token'];

    	if ((strlen(utf8_decode($this->request->post['firstname'])) < 1) || (strlen(utf8_decode($this->request->post['firstname'])) > 32)) {
      		$this->error['firstname'] = $this->language->get('error_firstname');
    	}

    	if ((strlen(utf8_decode($this->request->post['lastname'])) < 1) || (strlen(utf8_decode($this->request->post['lastname'])) > 32)) {
      		$this->error['lastname'] = $this->language->get('error_lastname');
    	}

		$pattern = '/^[A-Z0-9._%-]+@[A-Z0-9][A-Z0-9.-]{0,61}[A-Z0-9]\.[A-Z]{2,6}$/i';

		if ((strlen(utf8_decode($this->request->post['email'])) > 96) || (!preg_match($pattern, $this->request->post['email']))) {
      		$this->error['email'] = $this->language->get('error_email');
    	}

    	if ((strlen(utf8_decode($this->request->post['telephone'])) < 3) || (strlen(utf8_decode($this->request->post['telephone'])) > 32)) {
      		$this->error['telephone'] = $this->language->get('error_telephone');
    	}

    	if (($this->request->post['password']) || (!isset($this->request->get['affiliate_id']))) {
      		if ((strlen(utf8_decode($this->request->post['password'])) < 4) || (strlen(utf8_decode($this->request->post['password'])) > 20)) {
        		$this->error['password'] = $this->language->get('error_password');
      		}

	  		if ($this->request->post['password'] != $this->request->post['confirm']) {
	    		$this->error['confirm'] = $this->language->get('error_confirm');
	  		}
    	}

		if (!$this->error) {
	  		return TRUE;
		} else {
	  		return FALSE;
		}
  	}

  	private function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'affiliate/affiliatepayment')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}
$this->data['token'] = $this->session->data['token'];

		if (!$this->error) {
	  		return TRUE;
		} else {
	  		return FALSE;
		}
  	}
}
?>
