<?php
namespace Cart;
class Cart {
	private $data = array();

	public function __construct($registry) {
		$this->config = $registry->get('config');
		$this->customer = $registry->get('customer');
		$this->session = $registry->get('session');
		$this->db = $registry->get('db');
		$this->tax = $registry->get('tax');
		$this->weight = $registry->get('weight');
		$this->currency = $registry->get('currency');

		// Remove all the expired carts with no customer ID
		//$this->db->query("DELETE FROM " . DB_PREFIX . "cart WHERE (api_id > '0' OR customer_id = '0') AND date_added < DATE_SUB(NOW(), INTERVAL 1 HOUR)");

		if ($this->customer->getId()) {
			// We want to change the session ID on all the old items in the customers cart
			$this->db->query("UPDATE " . DB_PREFIX . "cart SET session_id = '" . $this->db->escape($this->session->getId()) . "' WHERE api_id = '0' AND customer_id = '" . (int)$this->customer->getId() . "'");

			// Once the customer is logged in we want to update the customers cart
			$cart_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "cart WHERE api_id = '0' AND customer_id = '0' AND session_id = '" . $this->db->escape($this->session->getId()) . "'");

			foreach ($cart_query->rows as $cart) {
				$this->db->query("DELETE FROM " . DB_PREFIX . "cart WHERE cart_id = '" . (int)$cart['cart_id'] . "'");

				// The advantage of using $this->add is that it will check if the products already exist and increaser the quantity if necessary.
				$this->add($cart['product_id'], $cart['quantity'], json_decode($cart['option']), $cart['recurring_id']);
			}
		}
	}

	public function getProducts() {
		$product_data = array();

		$cart_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "cart WHERE api_id = '" . (isset($this->session->data['api_id']) ? (int)$this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int)$this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "'");
		//echo "SELECT * FROM " . DB_PREFIX . "cart WHERE api_id = '" . (isset($this->session->data['api_id']) ? (int)$this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int)$this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "'";
		foreach ($cart_query->rows as $cart) {
			$key = (int)$cart['product_id'];
      		//$product = explode(':', $key);
      		//$product_id = $product[0];
			$stock = true;

			$product_query = $this->db->query("SELECT *,pd.optionname as optionnamefinal FROM " . DB_PREFIX . "product_to_store_vw p2s LEFT JOIN " . DB_PREFIX . "product_vw p ON (p2s.product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description_vw pd ON (p.product_id = pd.product_id) WHERE p2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND p2s.product_id = '" . (int)$cart['product_id'] . "' AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND p.date_available <= NOW() AND p.status = '1'");
			//echo "SELECT *,pd.optionname as optionnamefinal FROM " . DB_PREFIX . "product_to_store p2s LEFT JOIN " . DB_PREFIX . "product_vw p ON (p2s.product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description_vw pd ON (p.product_id = pd.product_id) WHERE p2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND p2s.product_id = '" . (int)$cart['product_id'] . "' AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND p.date_available <= NOW() AND p.status = '1'";
			if ($product_query->num_rows && ($cart['quantity'] > 0)) {
				$option_price = 0;
				$option_points = 0;
				$option_weight = 0;
				$product_type = $product_query->row['type'];
				/*
				if( $product_query->row['type'] == 0 ){
						$product_type = 0;		// 0 - Customizable Product
				}else{
						$product_type = $product_query->row['type'];		// 0 - Customizable Product / 1 - Non Customizable Product / 2 - Non Customizable Bracelet
				}
				*/

				//echo "<br>The time is " . date("h:i:sa");
				$option_data = array();
				foreach (json_decode($cart['option']) as $product_option_id => $value) {
					$option_query = $this->db->query("SELECT po.product_option_id, po.option_id, od.name, o.type FROM " . DB_PREFIX . "product_option po LEFT JOIN `" . DB_PREFIX . "option` o ON (po.option_id = o.option_id) LEFT JOIN " . DB_PREFIX . "option_description od ON (o.option_id = od.option_id) WHERE po.product_option_id = '" . (int)$product_option_id . "' AND po.product_id = '" . (int)$cart['product_id'] . "' AND od.language_id = '" . (int)$this->config->get('config_language_id') . "'");

					if ($option_query->num_rows) {
						if ($option_query->row['type'] == 'select' || $option_query->row['type'] == 'radio') {
							//echo "<br>--- 1 The time is " . date("h:i:sa");

							$option_value_query = $this->db->query("SELECT pov.option_value_id, ovd.name, pov.quantity, pov.subtract, pov.price, pov.price_prefix, pov.points, pov.points_prefix, pov.weight, pov.weight_prefix FROM " . DB_PREFIX . "product_option_value pov LEFT JOIN " . DB_PREFIX . "option_value ov ON (pov.option_value_id = ov.option_value_id) LEFT JOIN " . DB_PREFIX . "option_value_description ovd ON (ov.option_value_id = ovd.option_value_id) WHERE pov.product_option_value_id = '" . (int)$value . "' AND pov.product_option_id = '" . (int)$product_option_id . "' AND ovd.language_id = '" . (int)$this->config->get('config_language_id') . "'");

							if ($option_value_query->num_rows) {
								if ($option_value_query->row['price_prefix'] == '+') {
									$option_price += $option_value_query->row['price'];
								} elseif ($option_value_query->row['price_prefix'] == '-') {
									$option_price -= $option_value_query->row['price'];
								}

								if ($option_value_query->row['points_prefix'] == '+') {
									$option_points += $option_value_query->row['points'];
								} elseif ($option_value_query->row['points_prefix'] == '-') {
									$option_points -= $option_value_query->row['points'];
								}

								if ($option_value_query->row['weight_prefix'] == '+') {
									$option_weight += $option_value_query->row['weight'];
								} elseif ($option_value_query->row['weight_prefix'] == '-') {
									$option_weight -= $option_value_query->row['weight'];
								}

								if ($option_value_query->row['subtract'] && (!$option_value_query->row['quantity'] || ($option_value_query->row['quantity'] < $cart['quantity']))) {
									$stock = false;
								}

								$option_data[] = array(
									'product_option_id'       => $product_option_id,
									'product_option_value_id' => $value,
									'option_id'               => $option_query->row['option_id'],
									'option_value_id'         => $option_value_query->row['option_value_id'],
									'name'                    => $option_query->row['name'],
									'value'                   => $option_value_query->row['name'],
									'type'                    => $option_query->row['type'],
									'quantity'                => $option_value_query->row['quantity'],
									'subtract'                => $option_value_query->row['subtract'],
									'price'                   => $option_value_query->row['price'],
									'price_prefix'            => $option_value_query->row['price_prefix'],
									'points'                  => $option_value_query->row['points'],
									'points_prefix'           => $option_value_query->row['points_prefix'],
									'weight'                  => $option_value_query->row['weight'],
									'weight_prefix'           => $option_value_query->row['weight_prefix']
								);
							}
						} elseif ($option_query->row['type'] == 'checkbox' && is_array($value)) {
							foreach ($value as $product_option_value_id) {
								//echo "<br>--- 2 The time is " . date("h:i:sa");
								$option_value_query = $this->db->query("SELECT pov.option_value_id, pov.quantity, pov.subtract, pov.price, pov.price_prefix, pov.points, pov.points_prefix, pov.weight, pov.weight_prefix, ovd.name FROM " . DB_PREFIX . "product_option_value pov LEFT JOIN " . DB_PREFIX . "option_value_description ovd ON (pov.option_value_id = ovd.option_value_id) WHERE pov.product_option_value_id = '" . (int)$product_option_value_id . "' AND pov.product_option_id = '" . (int)$product_option_id . "' AND ovd.language_id = '" . (int)$this->config->get('config_language_id') . "'");

								if ($option_value_query->num_rows) {
									if ($option_value_query->row['price_prefix'] == '+') {
										$option_price += $option_value_query->row['price'];
									} elseif ($option_value_query->row['price_prefix'] == '-') {
										$option_price -= $option_value_query->row['price'];
									}

									if ($option_value_query->row['points_prefix'] == '+') {
										$option_points += $option_value_query->row['points'];
									} elseif ($option_value_query->row['points_prefix'] == '-') {
										$option_points -= $option_value_query->row['points'];
									}

									if ($option_value_query->row['weight_prefix'] == '+') {
										$option_weight += $option_value_query->row['weight'];
									} elseif ($option_value_query->row['weight_prefix'] == '-') {
										$option_weight -= $option_value_query->row['weight'];
									}

									if ($option_value_query->row['subtract'] && (!$option_value_query->row['quantity'] || ($option_value_query->row['quantity'] < $cart['quantity']))) {
										$stock = false;
									}

									$option_data[] = array(
										'product_option_id'       => $product_option_id,
										'product_option_value_id' => $product_option_value_id,
										'option_id'               => $option_query->row['option_id'],
										'option_value_id'         => $option_value_query->row['option_value_id'],
										'name'                    => $option_query->row['name'],
										'value'                   => $option_value_query->row['name'],
										'type'                    => $option_query->row['type'],
										'quantity'                => $option_value_query->row['quantity'],
										'subtract'                => $option_value_query->row['subtract'],
										'price'                   => $option_value_query->row['price'],
										'price_prefix'            => $option_value_query->row['price_prefix'],
										'points'                  => $option_value_query->row['points'],
										'points_prefix'           => $option_value_query->row['points_prefix'],
										'weight'                  => $option_value_query->row['weight'],
										'weight_prefix'           => $option_value_query->row['weight_prefix']
									);
								}
							}
						} elseif ($option_query->row['type'] == 'text' || $option_query->row['type'] == 'textarea' || $option_query->row['type'] == 'file' || $option_query->row['type'] == 'date' || $option_query->row['type'] == 'datetime' || $option_query->row['type'] == 'time') {

							if( $cart['product_id'] == 795 ){
								//echo "<br>--- 3 The time is " . date("h:i:sa");
								$rapnet_query = $this->db->query("select * from diamond_tbl where rapnet_lot_no = '" . $value	 . "'");
								$product_query->row['rapnet_lot_no'] =  $value;
								$diamondDtl = round($rapnet_query->row['weight'],2) . ' CT '. $rapnet_query->row['shape'] . ' Diamond | '. $rapnet_query->row['color'] .' Colour | ' . $rapnet_query->row['clarity'] . ' Clarity | ' . $rapnet_query->row['rapnet_lot_no'] . ' | GIA ' . $rapnet_query->row['cert_no'];
								$product_query->row['name'] = round($rapnet_query->row['weight'],2) . ' CT '. $rapnet_query->row['shape'] . ' Diamond' ;
								$product_query->row['optionname'] = $diamondDtl;
								$product_query->row['image'] = $rapnet_query->row['diamond_image_url'];
								// $product_query->row['parent_product_id'] = $rapnet_query->row['diamond_image_url'];
								$product_type = 4;	// 4 - Diamond Product

								// $this->load->model('catalog/product');
								//echo "<br>--- 4 The time is " . date("h:i:sa");
								$costData = explode(";", $this->costCalculateDiamond($rapnet_query->row['rapnet_final_price']));
								$row1['cost1'] = $costData[0];
								$row1['cost2'] = $costData[1];
								$row1['cost1format'] = $this->currency->format(round($costData[0]));
								$row1['cost2format'] = $this->currency->format(round($costData[1]));
								$option_price = $row1['cost1'];
								// echo $costData . ' - '  . $option_price;

								$option_data[] = array(
									'product_option_id'       => $product_option_id,
									'product_option_value_id' => '',
									'option_id'               => $rapnet_query->row['color'],
									'option_value_id'         => '',
									'name'                    => $diamondDtl, // $rapnet_query->row['color'],
									'value'                   => $diamondDtl,
									'type'                    => $rapnet_query->row['shape'],
									'quantity'                => '',
									'subtract'                => '',
									'price'                   => '',
									'price_prefix'            => '',
									'points'                  => '',
									'points_prefix'           => '',
									'weight'                  => '',
									'weight_prefix'           => ''
								);

							}else{

								$option_data[] = array(
									'product_option_id'       => $product_option_id,
									'product_option_value_id' => '',
									'option_id'               => $option_query->row['option_id'],
									'option_value_id'         => '',
									'name'                    => $option_query->row['name'],
									'value'                   => $value,
									'type'                    => $option_query->row['type'],
									'quantity'                => '',
									'subtract'                => '',
									'price'                   => '',
									'price_prefix'            => '',
									'points'                  => '',
									'points_prefix'           => '',
									'weight'                  => '',
									'weight_prefix'           => ''
								);

							}
						}
					}
				}

				if ($this->customer->isLogged()) {
					$customer_group_id = $this->customer->getCustomerGroupId();
				} else {
					$customer_group_id = $this->config->get('config_customer_group_id');
				}

				$price = $product_query->row['price'];

				// Product Discounts
				$discount_quantity = 0;

				foreach ($cart_query->rows as $cart_2) {
					if ($cart_2['product_id'] == $cart['product_id']) {
						$discount_quantity += $cart_2['quantity'];
					}
				}


				$reward = 0;

				/*
				$product_discount_query = $this->db->query("SELECT price FROM " . DB_PREFIX . "product_discount WHERE product_id = '" . (int)$cart['product_id'] . "' AND customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND quantity <= '" . (int)$discount_quantity . "' AND ((date_start = '0000-00-00' OR date_start < NOW()) AND (date_end = '0000-00-00' OR date_end > NOW())) ORDER BY quantity DESC, priority ASC, price ASC LIMIT 1");

				if ($product_discount_query->num_rows) {
					$price = $product_discount_query->row['price'];
				}

				// Product Specials
				$product_special_query = $this->db->query("SELECT price FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int)$cart['product_id'] . "' AND customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "' AND ((date_start = '0000-00-00' OR date_start < NOW()) AND (date_end = '0000-00-00' OR date_end > NOW())) ORDER BY priority ASC, price ASC LIMIT 1");

				if ($product_special_query->num_rows) {
					$price = $product_special_query->row['price'];
				}

				// Reward Points
				$product_reward_query = $this->db->query("SELECT points FROM " . DB_PREFIX . "product_reward WHERE product_id = '" . (int)$cart['product_id'] . "' AND customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "'");

				if ($product_reward_query->num_rows) {
					$reward = $product_reward_query->row['points'];
				} else {

				}
				*/

				// Downloads
				$download_data = array();

				/*
				$download_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_download p2d LEFT JOIN " . DB_PREFIX . "download d ON (p2d.download_id = d.download_id) LEFT JOIN " . DB_PREFIX . "download_description dd ON (d.download_id = dd.download_id) WHERE p2d.product_id = '" . (int)$cart['product_id'] . "' AND dd.language_id = '" . (int)$this->config->get('config_language_id') . "'");

				foreach ($download_query->rows as $download) {
					$download_data[] = array(
						'download_id' => $download['download_id'],
						'name'        => $download['name'],
						'filename'    => $download['filename'],
						'mask'        => $download['mask'],
						'remaining'   => $download['remaining']
					);
				}
				*/

				// Stock
				if (!$product_query->row['quantity'] || ($product_query->row['quantity'] < $cart['quantity'])) {
					$stock = false;
				}



				//New Codes Starts Here
				/*
				$prdprice=0;
				$metal_weight = 0;
				$product_metal_weight = $this->db->query("SELECT sum(weight) as weight FROM " . DB_PREFIX . "product_metalcontent_vw WHERE product_id = '" . (int)$product_id . "' ");
				if ($product_metal_weight->num_rows) {
					$metal_weight = $product_metal_weight->row['weight'];
				}

				$gem_weight = 0;
				$laboursettingcost = 0;
				$product_gem_weight = $this->db->query("SELECT sum(a.weight * a.count) as weight, sum(b.cost * a.count) as laboursettingcost,a.* FROM " . DB_PREFIX . "product_gemcontent_vw a,laboursettingcost b WHERE a.setting_id=b.setting_id and product_id = '" . (int)$product_id . "' ");
				if ($product_gem_weight->num_rows) {
					$gem_weight = $product_gem_weight->row['weight'];
					$laboursettingcost = $product_gem_weight->row['laboursettingcost'];
				}

				$product_weight = $metal_weight + $gem_weight;

				$labour_weight_cost = 0;
				$product_weight_cost = $this->db->query("SELECT cost FROM " . DB_PREFIX . "labour_weight_based_costs WHERE low_weight >= ". $product_weight  ."	and high_weight < " . $product_weight );
				if ($product_weight_cost->num_rows) {
					$labour_weight_cost = $product_weight_cost->row['cost'] * $product_weight;
				}

				if(isset($product_query->row['overriding_mark_up_ubsolute']) && $product_query->row['overriding_mark_up_ubsolute'] !=0 ){

					$prdprice=$product_query->row['overriding_mark_up_ubsolute'];

				}else{

					$prdprice=0;
					$prdprice += $laboursettingcost;
					$prdprice += $labour_weight_cost;
					$prdprice += $prdprice * $product_query->row['product_id'];
					$prdprice += $prdprice * $product_query->row['overriding_markup_percentage'];
					$prdprice += 20 ; // Shipping Cost
					$prdprice += 30 ; // Packaging Cost

				}
				//New Codes Ends Here
				$comments = '<br>     - Labour Setting Cost '. $laboursettingcost;
				$comments .= '<br>     - Labour Weight Cost '. $labour_weight_cost;
				$comments .= '<br>     - Labour Setting Cost'. $laboursettingcost;
				$comments .= '<br>     - Shipping Cost 20$' ;
				$comments .= '<br>     - Packaging Cost 30$';
				*/

				if(isset($this->session->data[$key.'_country'])){
					$country=$this->session->data[$key.'_country'];
				}else{
					$this->session->data[$key.'_country'] = 'AUS';
					$country='AUS';
				}
				if(isset($this->session->data[$key.'_ringsize'])){
					$ringsize=$this->session->data[$key.'_ringsize'];
				}else{
					$this->session->data[$key.'_ringsize'] = 'bbbb';
					$ringsize='bbbb';
				}

				if(isset($this->session->data[$key.'_engravetxt'])){
					$engravetxt=$this->session->data[$key.'_engravetxt'];
				}else{
					$this->session->data[$key.'_engravetxt'] = '';
					$engravetxt='';
				}
				if(isset($this->session->data[$key.'_engravefont'])){
					$engravefont=$this->session->data[$key.'_engravefont'];
				}else{
					$this->session->data[$key.'_engravefont'] = '';
					$engravefont='';
				}
				$gem_query = "";
				$gemsArray = "";

				//echo "<br>--- 5 The time is " . date("h:i:sa");
				$gem_query = $this->db->query("select * FROM product_gemavail pga WHERE pga.rapnet = 1 and pga.product_id = '" . $product_query->row['parent_product_id'] . "'");
				if ($gem_query->num_rows) {
					$x=$gem_query->num_rows;
					foreach ($gem_query->rows as $gem_row)
					{
					if(isset($this->session->data[ 'LotNo-' . $product_query->row['parent_product_id'] . '-' . $gem_row['product_gemavail_id'] ])){
							$pos = strpos($product_query->row['image'], $gem_row['product_gemavail_id'] );
							if ($pos === false) {	} else {
//								$this->log->write(" In Shopping Cart - LotNo " . $gem_row['product_id'] . ' = ' . $gem_row['product_gemavail_id'] . " For " . $this->session->data[ 'LotNo-' . $gem_row['product_id'] . '-' . $gem_row['product_gemavail_id']]);
//								echo " Let No " . $gem_row['product_id'] . ' = ' . $gem_row['product_gemavail_id'] . " For " . $this->session->data[ 'LotNo-' . $product_query->row['parent_product_id'] . '-' . $gem_row['product_gemavail_id']];
								$gemsArray .= $gem_row['gem'] . ":" . $gem_row['product_gemavail_id'] . ":" . $this->session->data[ 'LotNo-' . $product_query->row['parent_product_id'] . '-' . $gem_row['product_gemavail_id']] . ";";
							}
						}
					}
				}
				//echo "<br>--- 6 The time is " . date("h:i:sa");

				$recurring_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "recurring r LEFT JOIN " . DB_PREFIX . "product_recurring pr ON (r.recurring_id = pr.recurring_id) LEFT JOIN " . DB_PREFIX . "recurring_description rd ON (r.recurring_id = rd.recurring_id) WHERE r.recurring_id = '" . (int)$cart['recurring_id'] . "' AND pr.product_id = '" . (int)$cart['product_id'] . "' AND rd.language_id = " . (int)$this->config->get('config_language_id') . " AND r.status = 1 AND pr.customer_group_id = '" . (int)$this->config->get('config_customer_group_id') . "'");

				if ($recurring_query->num_rows) {
					$recurring = array(
						'recurring_id'    => $cart['recurring_id'],
						'name'            => $recurring_query->row['name'],
						'frequency'       => $recurring_query->row['frequency'],
						'price'           => $recurring_query->row['price'],
						'cycle'           => $recurring_query->row['cycle'],
						'duration'        => $recurring_query->row['duration'],
						'trial'           => $recurring_query->row['trial_status'],
						'trial_frequency' => $recurring_query->row['trial_frequency'],
						'trial_price'     => $recurring_query->row['trial_price'],
						'trial_cycle'     => $recurring_query->row['trial_cycle'],
						'trial_duration'  => $recurring_query->row['trial_duration']
					);
				} else {
					$recurring = false;
				}

				$diamondDetails = '';
				if( trim($product_query->row['rapnet_lot_no'],0) != '' && $cart['product_id'] != 795 ) {
						$rapnet_customproduct_query = $this->db->query("select weight,shape,color,clarity,rapnet_lot_no,cert_no from diamond_tbl where rapnet_lot_no = '" . $product_query->row['rapnet_lot_no']	 . "'");
						$diamondDetails = round($rapnet_customproduct_query->row['weight'],2) . ' CT '. $rapnet_customproduct_query->row['shape'] . ' Diamond | '. $rapnet_customproduct_query->row['color'] .' Colour | ' . $rapnet_customproduct_query->row['clarity'] . ' Clarity | ' . $rapnet_customproduct_query->row['rapnet_lot_no'] . ' | GIA ' . $rapnet_customproduct_query->row['cert_no'];

						$settingname  =  substr($product_query->row['optionname'], 19) ;
						$position = strpos($settingname, 'Center');
						$settingname = substr($settingname, 0, $position) . ' | ' . $product_query->row['name'];
						$product_query->row['optionname'] = $settingname;

				}

				if($product_query->row['optionname'] == '') $product_query->row['optionname'] = $product_query->row['name'];
				$product_data[] = array(
					'cart_id'         => $cart['cart_id'],
					'product_id'      => $product_query->row['product_id'],
        	'parent_product_id' => $product_query->row['parent_product_id'],
        	//'image'      	  	=> $product_query->row['parent_product_id'],
					'name'            => $product_query->row['name'],
					'model'           => $product_query->row['model'],
					'shipping'        => $product_query->row['shipping'],
					'image'           => $product_query->row['image'],
					'option'          => $option_data,
					'download'        => $download_data,
					'quantity'        => $cart['quantity'],
					'minimum'         => $product_query->row['minimum'],
					'subtract'        => $product_query->row['subtract'],
					'stock'           => $stock,
					'price'           => ($price + $option_price),
					'total'           => ($price + $option_price) * $cart['quantity'],
					'reward'          => $reward * $cart['quantity'],
					'points'          => ($product_query->row['points'] ? ($product_query->row['points'] + $option_points) * $cart['quantity'] : 0),
					'tax_class_id'    => $product_query->row['tax_class_id'],
					'weight'          => ($product_query->row['weight'] + $option_weight) * $cart['quantity'],
					'weight_class_id' => $product_query->row['weight_class_id'],
					'length'          => $product_query->row['length'],
					'width'           => $product_query->row['width'],
					'height'          => $product_query->row['height'],
					'length_class_id' => $product_query->row['length_class_id'],
					'recurring'       => $recurring,
					'settingcost'     => $product_query->row['setting_cost'],

					'rapnet_lot_no'   => $product_query->row['rapnet_lot_no'],
					'diamondDetails'   => $diamondDetails,

					'product_type'    => $product_type,		// 0 - Customizable Product / 1 - Non Customizable Product / 2 - Non Customizable Bracelet / 4 - Diamond
																								// 1 - Diamond 2 - Ring, 3 - Other Products - 4 - Diamond Product

					// Custom Fields
					'key'         	  => $key,
        	'parent_product_id'  => $product_query->row['parent_product_id'],
        	//'image'      	  	=> $product_query->row['parent_product_id'],
        	'type'            => $product_query->row['type'],
        	'optionname'      => $product_query->row['optionname'],
					'gemsArray'       => $gemsArray,
					// 'thumb'	       		=> $product_query->row['image'],
        	//'country'         => $country,
        	//'ringsize'        => $ringsize,
					'country'         => $cart['country'],
					'ringsize'        => $cart['ringsize'],
        	'engrave'         => $product_query->row['engrave'],
        	'engravetxt'      => $engravetxt,
        	'engravefont'     => $engravefont,
        	'svgContents'     => $product_query->row['svgContents'],
					'engravePrd'      => $product_query->row['engravePrd'],
	     		'total'           => ($price + $option_price) * $cart['quantity'] ,
					'reward'          => $reward * $cart['quantity'],
					'points'          => ($product_query->row['price'] + $option_points) * $cart['quantity']

				);
			} else {
				$this->remove($cart['cart_id']);
			}
		}

		return $product_data;
	}

	public function add($product_id, $quantity = 1, $option = array(), $recurring_id = 0) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "cart WHERE api_id = '" . (isset($this->session->data['api_id']) ? (int)$this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int)$this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "' AND product_id = '" . (int)$product_id . "' AND recurring_id = '" . (int)$recurring_id . "' AND `option` = '" . $this->db->escape(json_encode($option)) . "'");

		/*
    	if (!$options) {
      		$key = (int)$product_id;
    	} else {
      		$key = (int)$product_id . ':' . base64_encode(serialize($options));
    	}
		if (!isset($this->session->data['size'][$key])) {
      		$this->session->data['size'][$key] = (int)$size;
    	}
		if ((int)$quantity && ((int)$quantity > 0)) {
    		if (!isset($this->session->data['cart'][$key])) {
      			$this->session->data['cart'][$key] = (int)$quantity;
    		} else {
      			$this->session->data['cart'][$key] += (int)$quantity;
    		}
		}
		*/

		if (!$query->row['total']) {
			$sql = "INSERT INTO astral_portobello." . DB_PREFIX . "cart SET api_id = '" . (isset($this->session->data['api_id']) ? (int)$this->session->data['api_id'] : 0) . "', customer_id = '" . (int)$this->customer->getId() . "', session_id = '" . $this->db->escape($this->session->getId()) . "', product_id = '" . (int)$product_id . "', recurring_id = '" . (int)$recurring_id . "', `option` = '" . $this->db->escape(json_encode($option)) . "', quantity = '" . (int)$quantity . "', date_added = NOW(), country = '', ringsize=''";
			$query = $this->db->query($sql);
					//echo $sql;
		} else {
			//echo "UPDATE " . DB_PREFIX . "cart SET quantity = (quantity + " . (int)$quantity . ") WHERE api_id = '" . (isset($this->session->data['api_id']) ? (int)$this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int)$this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "' AND product_id = '" . (int)$product_id . "' AND recurring_id = '" . (int)$recurring_id . "' AND `option` = '" . $this->db->escape(json_encode($option)) . "'";
			$query = $this->db->query("UPDATE " . DB_PREFIX . "cart SET quantity = (quantity + " . (int)$quantity . ") WHERE api_id = '" . (isset($this->session->data['api_id']) ? (int)$this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int)$this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "' AND product_id = '" . (int)$product_id . "' AND recurring_id = '" . (int)$recurring_id . "' AND `option` = '" . $this->db->escape(json_encode($option)) . "'");
		}
	}

	public function update($cart_id, $quantity) {
		$this->db->query("UPDATE " . DB_PREFIX . "cart SET quantity = '" . (int)$quantity . "' WHERE cart_id = '" . (int)$cart_id . "' AND api_id = '" . (isset($this->session->data['api_id']) ? (int)$this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int)$this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "'");
    	if ((int)$quantity && ((int)$quantity > 0)) {
      		$this->session->data['cart'][$cart_id] = (int)$quantity;
    	} else {
	  		$this->remove($cart_id);
		}
	}

  public function updateCountry($cart_id, $country) {
		$this->db->query("UPDATE " . DB_PREFIX . "cart SET country = '" . $country . "' WHERE cart_id = '" . (int)$cart_id . "' AND api_id = '" . (isset($this->session->data['api_id']) ? (int)$this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int)$this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "'");
  	//$this->session->data['cart'][$cart_id]['country'] = $country;
  }

  public function updateRingSize($cart_id, $size) {
		$this->db->query("UPDATE " . DB_PREFIX . "cart SET ringsize = '" . $size . "' WHERE cart_id = '" . (int)$cart_id . "' AND api_id = '" . (isset($this->session->data['api_id']) ? (int)$this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int)$this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "'");
  	//$this->session->data['cart'][$cart_id]['ringsize'] = $size;
  }


	public function remove($cart_id) {
		// echo 'delete data from cart remove';
		// echo "DELETE FROM " . DB_PREFIX . "cart WHERE cart_id = '" . (int)$cart_id . "' AND api_id = '" . (isset($this->session->data['api_id']) ? (int)$this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int)$this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "'";
		$this->db->query("DELETE FROM " . DB_PREFIX . "cart WHERE cart_id = '" . (int)$cart_id . "' AND api_id = '" . (isset($this->session->data['api_id']) ? (int)$this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int)$this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "'");
		if (isset($this->session->data['cart'][$cart_id])) {
     		unset($this->session->data['cart'][$cart_id]);
  	}
	}

	public function clear() {
		// echo 'delete data from cart clear';
		$this->db->query("DELETE FROM " . DB_PREFIX . "cart WHERE api_id = '" . (isset($this->session->data['api_id']) ? (int)$this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int)$this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "'");
		$this->session->data['cart'] = array();
	}

	public function getRecurringProducts() {
		$product_data = array();
		/*	Modified to increase the speed of the shopping cart page
		// echo "Calling from getRecurringProducts <br>";
		foreach ($this->getProducts() as $value) {
			if ($value['recurring']) {
				$product_data[] = $value;
			}
		}
		*/
		return $product_data;
	}

	public function getWeight() {
		$weight = 0;
		// echo "Calling from getWeight <br>";
		/*	Modified to increase the speed of the shopping cart page
		foreach ($this->getProducts() as $product) {
			if ($product['shipping']) {
				$weight += $this->weight->convert($product['weight'], $product['weight_class_id'], $this->config->get('config_weight_class_id'));
			}
		}
		*/
		return $weight;
	}

	public function getSubTotal() {
		$total = 0;
		// echo "Calling from getSubTotal <br>";
		foreach ($this->getProducts() as $product) {
			$total += $product['total'];
		}

		return $total;
	}


	public function getTaxes() {
		$tax_data = array();
		// echo "Calling from getTaxes <br>";

		foreach ($this->getProducts() as $product) {
			if ($product['tax_class_id']) {
				//$tax_rates = $this->tax->getRates($product['price'], $product['tax_class_id']);
				$tax_rates = $this->tax->getRates($product['total'], $product['tax_class_id']);

				foreach ($tax_rates as $tax_rate) {
					if (!isset($tax_data[$tax_rate['tax_rate_id']])) {
						//$tax_data[$tax_rate['tax_rate_id']] = ($tax_rate['amount'] * $product['quantity']);
						$tax_data[$tax_rate['tax_rate_id']] = $tax_rate['amount'];
					} else {
						//$tax_data[$tax_rate['tax_rate_id']] += ($tax_rate['amount'] * $product['quantity']);
						$tax_data[$tax_rate['tax_rate_id']] += $tax_rate['amount'];
					}
				}
			}
		}

		return $tax_data;
	}

	public function getTaxesTotal() {
		$tax_data = array();
		$tax_total = 0;
		// echo "Calling from getTaxesTotal <br>";

		foreach ($this->getProducts() as $product) {
			if ($product['tax_class_id']) {
				$tax_rates = $this->tax->getRates($product['total'], $product['tax_class_id']);

				foreach ($tax_rates as $tax_rate) {
					if (!isset($tax_data[$tax_rate['tax_rate_id']])) {
						$tax_data[$tax_rate['tax_rate_id']] = $tax_rate['amount'];
					} else {
						$tax_data[$tax_rate['tax_rate_id']] += $tax_rate['amount'];
					}
					$tax_total += $tax_rate['amount'];
				}
			}
		}

		return $tax_total;
  }

	public function getTotal() {
		$total = 0;
		// echo "Calling from getTotal <br>";

		foreach ($this->getProducts() as $product) {
			$total += $this->tax->calculate($product['price'], $product['tax_class_id'], $this->config->get('config_tax')) * $product['quantity'];
		}

		return $total;
	}

	public function getTotalRewardPoints() {
		$total = 0;
		// echo "Calling from getTotalRewardPoints <br>";

		foreach ($this->getProducts() as $product) {
			$total += $product['reward'];
		}

		return $total;
  	}

	public function countProducts() {
		$product_total = 0;
		// echo "Calling from countProducts <br>";

		/*	Modified to increase the speed of the shopping cart page
		$products = $this->getProducts();
		foreach ($products as $product) {
			$product_total += $product['quantity'];
		}
		return $product_total;
		*/

		$cart_query = $this->db->query("SELECT count(*) FROM " . DB_PREFIX . "cart WHERE api_id = '" . (isset($this->session->data['api_id']) ? (int)$this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int)$this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "'");
		return $cart_query->num_rows;

	}

	public function hasProducts() {
		// echo "Calling from hasProducts <br>";
		// return count($this->getProducts());
		/*	Modified to increase the speed of the shopping cart page */
		$cart_query = $this->db->query("SELECT count(*) FROM " . DB_PREFIX . "cart WHERE api_id = '" . (isset($this->session->data['api_id']) ? (int)$this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int)$this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "'");
		return $cart_query->num_rows;
	}

	public function hasRecurringProducts() {
		return count($this->getRecurringProducts());
	}

	public function hasStock() {
		// echo "Calling from hasStock <br>";
		/*	Disabled to increase the speed of the shopping cart page.
		foreach ($this->getProducts() as $product) {
			if (!$product['stock']) {
				return false;
			}
		}
		*/
		return true;
	}

	public function hasShipping() {
		// echo "Calling from hasShipping <br>";
		/*
		foreach ($this->getProducts() as $product) {
			if ($product['shipping']) {
				return true;
			}
		}

		return false;
		*/
		/*	Modified to increase the speed of the shopping cart page */
		return true;
	}

	public function hasDownload() {

		// echo "Calling from hasDownload <br>";
		/* 	Modified to increase the speed of the shopping cart page
		foreach ($this->getProducts() as $product) {
			if ($product['download']) {
				return true;
			}
		}
		*/
		return false;
	}


	public function costCalculateDiamond($diamondCost) {
		$dCost = 0;
		$dWholeCost = 0;
			//	this->log->write( ' Diamond Price Before Margin:  ' . $diamondCost );
		if( (int)$this->config->get('pricelimit_13') <= $diamondCost ){
			//	$this->log->write( ' Diamond Price Calculation: diamondCost: ' . $diamondCost .  '  , additionalcost_14:' .  $this->config->get('additionalcost_14')  .  '  , additionalcostpercent_14:' . $this->config->get('additionalcostpercent_14')  .  '  , wholeoverriding_14:' . $this->config->get('wholeoverriding_14') );
			$dCost = $diamondCost + (int)$this->config->get('additionalcost_14') + ( (int)$this->config->get('additionalcostpercent_14') * $diamondCost/ 100 ) + ((int)$this->config->get('wholeoverriding_14') * $diamondCost / 100);
			$dWholeCost = $diamondCost + (int)$this->config->get('additionalcost_14')  + ((int)$this->config->get('additionalcostpercent_14') * $diamondCost / 100) + ((int)$this->config->get('overriding_14') * $diamondCost / 100);
		}else if( (int)$this->config->get('pricelimit_12') <= $diamondCost ){
			$dCost = $diamondCost + (int)$this->config->get('additionalcost_13')  + ((int)$this->config->get('additionalcostpercent_13') * $diamondCost / 100) + ((int)$this->config->get('wholeoverriding_13') * $diamondCost / 100);
			$dWholeCost = $diamondCost + (int)$this->config->get('additionalcost_13')  + ((int)$this->config->get('additionalcostpercent_13') * $diamondCost / 100) + ((int)$this->config->get('overriding_13') * $diamondCost / 100);
		}else if( (int)$this->config->get('pricelimit_11') <= $diamondCost ){
			$dCost = $diamondCost + (int)$this->config->get('additionalcost_12')  + ((int)$this->config->get('additionalcostpercent_12') * $diamondCost / 100) + ((int)$this->config->get('wholeoverriding_12') * $diamondCost / 100);
			$dWholeCost = $diamondCost + (int)$this->config->get('additionalcost_12')  + ((int)$this->config->get('additionalcostpercent_12') * $diamondCost / 100) + ((int)$this->config->get('overriding_12') * $diamondCost / 100);
		}else if( (int)$this->config->get('pricelimit_10') <= $diamondCost ){
			$dCost = $diamondCost + (int)$this->config->get('additionalcost_11')  + ((int)$this->config->get('additionalcostpercent_11') * $diamondCost / 100) + ((int)$this->config->get('wholeoverriding_11') * $diamondCost / 100);
			$dWholeCost = $diamondCost + (int)$this->config->get('additionalcost_11')  + ((int)$this->config->get('additionalcostpercent_11') * $diamondCost / 100) + ((int)$this->config->get('overriding_11') * $diamondCost / 100);
		}else if( (int)$this->config->get('pricelimit_9') <= $diamondCost ){
			$dCost = $diamondCost + (int)$this->config->get('additionalcost_10')  + ((int)$this->config->get('additionalcostpercent_10') * $diamondCost / 100) + ((int)$this->config->get('wholeoverriding_10') * $diamondCost / 100);
			$dWholeCost = $diamondCost + (int)$this->config->get('additionalcost_10')  + ((int)$this->config->get('additionalcostpercent_10') * $diamondCost / 100) + ((int)$this->config->get('overriding_10') * $diamondCost / 100);
		}else if( (int)$this->config->get('pricelimit_8') <= $diamondCost ){
			$dCost = $diamondCost + (int)$this->config->get('additionalcost_9')  + ((int)$this->config->get('additionalcostpercent_9') * $diamondCost / 100) + ((int)$this->config->get('wholeoverriding_9') * $diamondCost / 100);
			$dWholeCost = $diamondCost + (int)$this->config->get('additionalcost_9')  + ((int)$this->config->get('additionalcostpercent_9') * $diamondCost / 100) + ((int)$this->config->get('overriding_9') * $diamondCost / 100);
		}else if( (int)$this->config->get('pricelimit_7') <= $diamondCost ){
			$dCost = $diamondCost + (int)$this->config->get('additionalcost_8')  + ((int)$this->config->get('additionalcostpercent_8') * $diamondCost / 100) + ((int)$this->config->get('wholeoverriding_8') * $diamondCost / 100);
			$dWholeCost = $diamondCost + (int)$this->config->get('additionalcost_8')  + ((int)$this->config->get('additionalcostpercent_8') * $diamondCost / 100) + ((int)$this->config->get('overriding_8') * $diamondCost / 100);
		}else if( (int)$this->config->get('pricelimit_6') <= $diamondCost ){
			$dCost = $diamondCost + (int)$this->config->get('additionalcost_7')  + ((int)$this->config->get('additionalcostpercent_7') * $diamondCost / 100) + ((int)$this->config->get('wholeoverriding_7') * $diamondCost / 100);
			$dWholeCost = $diamondCost + (int)$this->config->get('additionalcost_7')  + ((int)$this->config->get('additionalcostpercent_7') * $diamondCost / 100) + ((int)$this->config->get('overriding_7') * $diamondCost / 100);
		}else if( (int)$this->config->get('pricelimit_5') <= $diamondCost ){
			$dCost = $diamondCost + (int)$this->config->get('additionalcost_6')  + ((int)$this->config->get('additionalcostpercent_6') * $diamondCost / 100) + ((int)$this->config->get('wholeoverriding_6') * $diamondCost / 100);
			$dWholeCost = $diamondCost + (int)$this->config->get('additionalcost_6')  + ((int)$this->config->get('additionalcostpercent_6') * $diamondCost / 100) + ((int)$this->config->get('overriding_6') * $diamondCost / 100);
		}else if( (int)$this->config->get('pricelimit_4') <= $diamondCost ){
			$dCost = $diamondCost + (int)$this->config->get('additionalcost_5')  + ((int)$this->config->get('additionalcostpercent_5') * $diamondCost / 100) + ((int)$this->config->get('wholeoverriding_5') * $diamondCost / 100);
			$dWholeCost = $diamondCost + (int)$this->config->get('additionalcost_5')  + ((int)$this->config->get('additionalcostpercent_5') * $diamondCost / 100) + ((int)$this->config->get('overriding_5') * $diamondCost / 100);
		}else if( (int)$this->config->get('pricelimit_3') <= $diamondCost ){
			$dCost = $diamondCost + (int)$this->config->get('additionalcost_4')  + ((int)$this->config->get('additionalcostpercent_4') * $diamondCost / 100) + ((int)$this->config->get('wholeoverriding_4') * $diamondCost / 100);
			$dWholeCost = $diamondCost + (int)$this->config->get('additionalcost_4')  + ((int)$this->config->get('additionalcostpercent_4') * $diamondCost / 100) + ((int)$this->config->get('overriding_4') * $diamondCost / 100);
		}else if( (int)$this->config->get('pricelimit_2') <= $diamondCost ){
			$dCost = $diamondCost + (int)$this->config->get('additionalcost_3')  + ((int)$this->config->get('additionalcostpercent_3') * $diamondCost / 100) + ((int)$this->config->get('wholeoverriding_3') * $diamondCost / 100);
			$dWholeCost = $diamondCost + (int)$this->config->get('additionalcost_3')  + ((int)$this->config->get('additionalcostpercent_3') * $diamondCost / 100) + ((int)$this->config->get('overriding_3') * $diamondCost / 100);
		}else if( (int)$this->config->get('pricelimit_1') <= $diamondCost ){
			$dCost = $diamondCost + (int)$this->config->get('additionalcost_2')  + ((int)$this->config->get('additionalcostpercent_2') * $diamondCost / 100) + ((int)$this->config->get('wholeoverriding_2') * $diamondCost / 100);
			$dWholeCost = $diamondCost + (int)$this->config->get('additionalcost_2')  + ((int)$this->config->get('additionalcostpercent_2') * $diamondCost / 100) + ((int)$this->config->get('overriding_2') * $diamondCost / 100);

		}else{
			$dCost = $diamondCost + (int)$this->config->get('additionalcost_1')  + ((int)$this->config->get('additionalcostpercent_1') * $diamondCost / 100) + ((int)$this->config->get('wholeoverriding_1') * $diamondCost / 100);
			$dWholeCost = $diamondCost + (int)$this->config->get('additionalcost_1')  + ((int)$this->config->get('additionalcostpercent_1') * $diamondCost / 100) + ((int)$this->config->get('overriding_1') * $diamondCost / 100);
		}
		// $this->log->write( ' Diamond Price After Margin: ' . $dCost . '  wholesale: ' . $dWholeCost );
		// echo  $dCost . ' -- ' .  'USD' . ' -- ' .  $this->currency->getCode() ;
		$dCost = round($this->currency->convert($dCost,'USD', $this->currency->getCode()),0, PHP_ROUND_HALF_UP);
		$dWholeCost = round($this->currency->convert($dWholeCost,'USD', $this->currency->getCode()),0, PHP_ROUND_HALF_UP);
		// $this->log->write( ' Diamond Price After Margin: ' . $dCost . '  wholesale: ' . $dWholeCost );
	  // echo  '<br>' . $dCost . ';' . $dWholeCost;
		return $dCost . ';' . $dWholeCost;
	}
}
