<?php
class ControllerProductDiamond extends Controller {
	public function index() {
		$this->load->language('product/search');

		$this->load->model('catalog/category');

		$this->load->model('catalog/product');

		$this->load->model('tool/image');

		if (isset($this->request->get['search'])) {
			$search = $this->request->get['search'];
		} else {
			$search = '';
		}

		if (isset($this->request->get['tag'])) {
			$tag = $this->request->get['tag'];
		} elseif (isset($this->request->get['search'])) {
			$tag = $this->request->get['search'];
		} else {
			$tag = '';
		}

		if (isset($this->request->get['description'])) {
			$description = $this->request->get['description'];
		} else {
			$description = '';
		}

		if (isset($this->request->get['category_id'])) {
			$category_id = $this->request->get['category_id'];
		} else {
			$category_id = 0;
		}

		if (isset($this->request->get['sub_category'])) {
			$sub_category = $this->request->get['sub_category'];
		} else {
			$sub_category = '';
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'p.sort_order';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['limit'])) {
			$limit = (int)$this->request->get['limit'];
		} else {
			$limit = $this->config->get('theme_' . $this->config->get('config_theme') . '_product_limit');
		}

		if (isset($this->request->get['search'])) {
			$this->document->setTitle($this->language->get('heading_title') .  ' - ' . $this->request->get['search']);
		} elseif (isset($this->request->get['tag'])) {
			$this->document->setTitle($this->language->get('heading_title') .  ' - ' . $this->language->get('heading_tag') . $this->request->get['tag']);
		} else {
			$this->document->setTitle($this->language->get('heading_title'));
		}

		$data['customer_id'] =  $this->customer->getId() ;
		if ($this->customer->isLogged()) {
				$data['customer_group_id'] = $this->customer->getCustomerGroupId();
		} else {
				$data['customer_group_id'] = $this->config->get('config_customer_group_id');
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$url = '';

		if (isset($this->request->get['search'])) {
			$url .= '&search=' . urlencode(html_entity_decode($this->request->get['search'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['tag'])) {
			$url .= '&tag=' . urlencode(html_entity_decode($this->request->get['tag'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['description'])) {
			$url .= '&description=' . $this->request->get['description'];
		}

		if (isset($this->request->get['category_id'])) {
			$url .= '&category_id=' . $this->request->get['category_id'];
		}

		if (isset($this->request->get['sub_category'])) {
			$url .= '&sub_category=' . $this->request->get['sub_category'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['limit'])) {
			$url .= '&limit=' . $this->request->get['limit'];
		}

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('product/search', $url)
		);

		if (isset($this->request->get['search'])) {
			$data['heading_title'] = $this->language->get('heading_title') .  ' - ' . $this->request->get['search'];
		} else {
			$data['heading_title'] = $this->language->get('heading_title');
		}

		$data['text_compare'] = sprintf($this->language->get('text_compare'), (isset($this->session->data['compare']) ? count($this->session->data['compare']) : 0));

		$data['compare'] = $this->url->link('product/compare');

		$this->load->model('catalog/category');

		// 3 Level Category Search
		$data['categories'] = array();

		$categories_1 = $this->model_catalog_category->getCategories(0);

		foreach ($categories_1 as $category_1) {
			$level_2_data = array();

			$categories_2 = $this->model_catalog_category->getCategories($category_1['category_id']);

			foreach ($categories_2 as $category_2) {
				$level_3_data = array();

				$categories_3 = $this->model_catalog_category->getCategories($category_2['category_id']);

				foreach ($categories_3 as $category_3) {
					$level_3_data[] = array(
						'category_id' => $category_3['category_id'],
						'name'        => $category_3['name'],
					);
				}

				$level_2_data[] = array(
					'category_id' => $category_2['category_id'],
					'name'        => $category_2['name'],
					'children'    => $level_3_data
				);
			}

			$data['categories'][] = array(
				'category_id' => $category_1['category_id'],
				'name'        => $category_1['name'],
				'children'    => $level_2_data
			);
		}

		$data['products'] = array();


		$gemWeight = 1;
		$gemstoneCount = 1;
		$gemstoneShape = 'Round';

		$data['default_shape_id'] = 14 ;		// Round

		$data['caratvalue'] = 0; //3;
		$data['caratminvalue'] = 0;
		$data['caratmaxvalue'] = 4;

		$data['currencyLeftSymbol'] = $this->currency->getSymbolLeft('AUD');

		$gemWeightDia = $gemWeight / $gemstoneCount ;
		$gemWeightmin = $gemWeightDia - $gemWeightDia * 0.5;
		$gemWeight1 = $gemWeightDia - $gemWeightDia * 0.25;
		$gemWeight2 = $gemWeightDia + $gemWeightDia * 0.25;
		$gemWeightmax = $gemWeightDia + $gemWeightDia * 0.5;
		$data['caratvalues'] =  array(    $gemWeightmax, $gemWeight2, $gemWeightDia, $gemWeight1, $gemWeightmin);
		$this->log->write( " Getting Diamond Table of Data for shape : " . $gemstoneShape . " with weight " .  $gemWeightDia );
		$data['diamondData'] = $this->model_catalog_product->getDiamondData( $gemstoneShape ,  $gemWeightmin , $gemWeightmax, $gemWeightDia  );

		$data['diamondDetails'] = $data['diamondData'][0];


		//$data['comparediamondData'] = $this->model_catalog_product->getDiamondCompareData();
		//$data['recentvieweddiamondData'] = $this->model_catalog_product->getDiamondRecentViewedData();


		if(isset($this->request->get['errorlog']))$this->log->write( " == gemstone shape : " . $gemstoneShape . "   ; Weight: " . $gemWeightmin . " - " . $gemWeightmax );

		$gemRapnetMinMaxData =  $this->model_catalog_product->getMaxColorClarityValues( $gemstoneShape ,  $gemWeightmin , $gemWeightmax  );

		$data['colormaxvalue'] = $gemRapnetMinMaxData[0]['maxcolour'];
		$data['claritymaxvalue'] = $gemRapnetMinMaxData[0]['maxclarity'];

  	if(isset($this->request->get['errorlog']))$this->log->write("GemWeights : " . $gemWeightmin . " == " . $gemWeight1. " == " .  $gemWeightDia. " == " . $gemWeight2. " == " . $gemWeightmax);


		$shapes_info = $this->getShapesImages();
		foreach ($shapes_info as $shape_info) {
			if ($shape_info) {
				if ($shape_info['image']) {
					$image = $this->model_tool_image->resize($shape_info['image'], 52, 72);
				} else {
					$image = false;
				}
				//$linkurl=$this->url->link('product/newurllogic','newurl='.$category_id.'-'.$gemstone_id .'-'.$metal_id.'-'.$shape_info['shape_id'].'-'.$low_price.'-'.$high_price);

				$data['shapes'][] = array(
					'thumb'    => HTTP_IMAGE . $shape_info['image'],
					'name'   	 => $shape_info['shape'],
					'shape_id' => $shape_info['shape_id']
//					'href'  => $linkurl
				);
			}
		}

		//$data['colorvalues'] = $this->model_catalog_product->getColorValues();
		// $data['cutvalues'] = $this->model_catalog_product->getCutValues();
		$data['cutvalues'] = array( array( 'cutrankdescr' => 'Good') , array('cutrankdescr' =>  'Very Good') , array('cutrankdescr' =>  'Perfect'), array('cutrankdescr' =>  'Ideal') );
		$data['colorvalues'] = $this->model_catalog_product->getColorLimitedValues();
		$data['clarityvalues'] = $this->model_catalog_product->getClarityValuesDiamond();


//			if($gemstone['gem']==1){
		$data['DiamondShape'] = ucfirst(strtolower( $gemstoneShape ));
//				$data['CenterGemstone'] = $gemNameHeader;
//				$data['CenterGemSetting'] = $gemSetting;
//			}


/*
		if (isset($this->request->get['search']) || isset($this->request->get['tag'])) {
			$filter_data = array(
				'filter_name'         => $search,
				'filter_tag'          => $tag,
				'filter_description'  => $description,
				'filter_category_id'  => $category_id,
				'filter_sub_category' => $sub_category,
				'sort'                => $sort,
				'order'               => $order,
				'start'               => ($page - 1) * $limit,
				'limit'               => $limit
			);

			$product_total = $this->model_catalog_product->getTotalProducts($filter_data);

			$results = $this->model_catalog_product->getProducts($filter_data);

			foreach ($results as $result) {
				if ($result['image']) {
					$image = $this->model_tool_image->resize($result['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height'));
				} else {
					$image = $this->model_tool_image->resize('placeholder.png', $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height'));
				}

				if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$price = false;
				}

				if ((float)$result['special']) {
					$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$special = false;
				}

				if ($this->config->get('config_tax')) {
					$tax = $this->currency->format((float)$result['special'] ? $result['special'] : $result['price'], $this->session->data['currency']);
				} else {
					$tax = false;
				}

				if ($this->config->get('config_review_status')) {
					$rating = (int)$result['rating'];
				} else {
					$rating = false;
				}

				$data['products'][] = array(
					'product_id'  => $result['product_id'],
					'thumb'       => $image,
					'name'        => $result['name'],
					'description' => utf8_substr(trim(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8'))), 0, $this->config->get('theme_' . $this->config->get('config_theme') . '_product_description_length')) . '..',
					'price'       => $price,
					'special'     => $special,
					'tax'         => $tax,
					'minimum'     => $result['minimum'] > 0 ? $result['minimum'] : 1,
					'rating'      => $result['rating'],
					'href'        => $this->url->link('product/product', 'product_id=' . $result['product_id'] . $url)
				);
			}

			$url = '';

			if (isset($this->request->get['search'])) {
				$url .= '&search=' . urlencode(html_entity_decode($this->request->get['search'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['tag'])) {
				$url .= '&tag=' . urlencode(html_entity_decode($this->request->get['tag'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['description'])) {
				$url .= '&description=' . $this->request->get['description'];
			}

			if (isset($this->request->get['category_id'])) {
				$url .= '&category_id=' . $this->request->get['category_id'];
			}

			if (isset($this->request->get['sub_category'])) {
				$url .= '&sub_category=' . $this->request->get['sub_category'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['sorts'] = array();

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_default'),
				'value' => 'p.sort_order-ASC',
				'href'  => $this->url->link('product/search', 'sort=p.sort_order&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_name_asc'),
				'value' => 'pd.name-ASC',
				'href'  => $this->url->link('product/search', 'sort=pd.name&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_name_desc'),
				'value' => 'pd.name-DESC',
				'href'  => $this->url->link('product/search', 'sort=pd.name&order=DESC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_price_asc'),
				'value' => 'p.price-ASC',
				'href'  => $this->url->link('product/search', 'sort=p.price&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_price_desc'),
				'value' => 'p.price-DESC',
				'href'  => $this->url->link('product/search', 'sort=p.price&order=DESC' . $url)
			);

			if ($this->config->get('config_review_status')) {
				$data['sorts'][] = array(
					'text'  => $this->language->get('text_rating_desc'),
					'value' => 'rating-DESC',
					'href'  => $this->url->link('product/search', 'sort=rating&order=DESC' . $url)
				);

				$data['sorts'][] = array(
					'text'  => $this->language->get('text_rating_asc'),
					'value' => 'rating-ASC',
					'href'  => $this->url->link('product/search', 'sort=rating&order=ASC' . $url)
				);
			}

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_model_asc'),
				'value' => 'p.model-ASC',
				'href'  => $this->url->link('product/search', 'sort=p.model&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_model_desc'),
				'value' => 'p.model-DESC',
				'href'  => $this->url->link('product/search', 'sort=p.model&order=DESC' . $url)
			);

			$url = '';

			if (isset($this->request->get['search'])) {
				$url .= '&search=' . urlencode(html_entity_decode($this->request->get['search'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['tag'])) {
				$url .= '&tag=' . urlencode(html_entity_decode($this->request->get['tag'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['description'])) {
				$url .= '&description=' . $this->request->get['description'];
			}

			if (isset($this->request->get['category_id'])) {
				$url .= '&category_id=' . $this->request->get['category_id'];
			}

			if (isset($this->request->get['sub_category'])) {
				$url .= '&sub_category=' . $this->request->get['sub_category'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			$data['limits'] = array();

			$limits = array_unique(array($this->config->get('theme_' . $this->config->get('config_theme') . '_product_limit'), 25, 50, 75, 100));

			sort($limits);

			foreach($limits as $value) {
				$data['limits'][] = array(
					'text'  => $value,
					'value' => $value,
					'href'  => $this->url->link('product/search', $url . '&limit=' . $value)
				);
			}

			$url = '';

			if (isset($this->request->get['search'])) {
				$url .= '&search=' . urlencode(html_entity_decode($this->request->get['search'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['tag'])) {
				$url .= '&tag=' . urlencode(html_entity_decode($this->request->get['tag'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['description'])) {
				$url .= '&description=' . $this->request->get['description'];
			}

			if (isset($this->request->get['category_id'])) {
				$url .= '&category_id=' . $this->request->get['category_id'];
			}

			if (isset($this->request->get['sub_category'])) {
				$url .= '&sub_category=' . $this->request->get['sub_category'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$pagination = new Pagination();
			$pagination->total = $product_total;
			$pagination->page = $page;
			$pagination->limit = $limit;
			$pagination->url = $this->url->link('product/search', $url . '&page={page}');

			$data['pagination'] = $pagination->render();

			$data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $limit) + 1 : 0, ((($page - 1) * $limit) > ($product_total - $limit)) ? $product_total : ((($page - 1) * $limit) + $limit), $product_total, ceil($product_total / $limit));

			if (isset($this->request->get['search']) && $this->config->get('config_customer_search')) {
				$this->load->model('account/search');

				if ($this->customer->isLogged()) {
					$customer_id = $this->customer->getId();
				} else {
					$customer_id = 0;
				}

				if (isset($this->request->server['REMOTE_ADDR'])) {
					$ip = $this->request->server['REMOTE_ADDR'];
				} else {
					$ip = '';
				}

				$search_data = array(
					'keyword'       => $search,
					'category_id'   => $category_id,
					'sub_category'  => $sub_category,
					'description'   => $description,
					'products'      => $product_total,
					'customer_id'   => $customer_id,
					'ip'            => $ip
				);

				$this->model_account_search->addSearch($search_data);
			}
		}
		*/

		$data['search'] = $search;
		$data['description'] = $description;
		$data['category_id'] = $category_id;
		$data['sub_category'] = $sub_category;

		$data['sort'] = $sort;
		$data['order'] = $order;
		$data['limit'] = $limit;

		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');

		if( isset($this->session->data['Ring_Diamond_RNO']) ) {
			unset($this->session->data['Ring_Diamond_RNO']);
		}
		if( isset($this->session->data['Earrings_Diamond_RNO']) ) {
			unset($this->session->data['Earrings_Diamond_RNO']);
		}

		$data['customer_id'] =  $this->customer->getId() ;
		if ($this->customer->isLogged()) {
				$data['customer_group_id'] = $this->customer->getCustomerGroupId();
		} else {
				$data['customer_group_id'] = $this->config->get('config_customer_group_id');
		}

		$diamondArray1['diamonds'] = $data['diamondData'];
		$diamondArray1['rowcount'] = 1;
		$data['diamondTableData1'] = $this->load->controller('product/diamonddetail', $diamondArray1 );


		$diamondArray2['diamonds'] = $this->model_catalog_product->getDiamondRecentViewedData();
		$diamondArray2['rowcount'] = 10000;
		$data['diamondTableData2'] = $this->load->controller('product/diamonddetail', $diamondArray2 );

		$diamondArray3['diamonds'] = $this->model_catalog_product->getDiamondCompareData();
		$diamondArray3['rowcount'] = 20000;
		$data['diamondTableData3'] = $this->load->controller('product/diamonddetail', $diamondArray3 );

		//$data['diamondTableData'] = $this->getDiamondData();
		$this->response->setOutput($this->load->view('product/diamond', $data));
	}

	public function navigate() {
		if (isset($this->request->get['selectedItem'])) {
			if ($this->request->get['selectedItem'] == 'Ring') {
				$this->session->data['Ring_Diamond_RNO'] = $this->request->get['rapnetNo'] ;
				$url = "wolf-and-stone-engagement-collection?gemstone_id=9&shape_id=" . $this->request->get['shape_id']  . "&t=" . date('YmdHis') . "&rno=" . $this->request->get['rapnetNo'] ;
			}else{
				$this->session->data['Earrings_Diamond_RNO'] = $this->request->get['rapnetNo'] ;
				$url = "necklace?gemstone_id=9&shape_id=" . $this->request->get['shape_id']  . "&t=" . date('YmdHis') . "&rno=" . $this->request->get['rapnetNo'] ;

			}
			$this->response->redirect( $url );
			// header("Location: " . $url, true, ($permanent === true) ? 301 : 302);

 			//	window.location.replace("https://www.portobellojewellery.com.au/production/collections/wolf-and-stone-engagement-collection?gemstone_id=9" + "&shape_id=" + shape_id  + "&t=" + ddd + "&rno=" + rapnetNo );

			//$this->response->setOutput($this->load->view('product/diamond', $data));
		}
	}

	public function addsetting() {
		$data = array();

		if ( isset($this->request->post['selectedItem']) ) {
			if ($this->request->post['selectedItem'] == 'Ring') {
				$this->session->data['Ring_Setting_pid'] = $this->request->post['product_id'] ;
			}else{
				$this->session->data['Earrings_Setting_pid'] = $this->request->post['product_id'] ;
			}
			//$this->response->setOutput($this->load->view('product/diamond', $data));
		}
		/* */
		$data['Selection123'] = $this->load->controller('product/selection123' , $data);
		$this->response->setOutput( $data['Selection123'] );
	}

	public function recentlyViewed() {
			$this->load->model('catalog/product');

			$diamondArray2['diamonds'] = $this->model_catalog_product->getDiamondRecentViewedData();
			$diamondArray2['rowcount'] = 10000;
			$data['diamondTableData2'] = $this->load->controller('product/diamonddetail', $diamondArray2 );

			$this->response->setOutput( $data['diamondTableData2'] );
	}

	public function diamondComparison() {
			$this->load->model('catalog/product');
			if($this->request->post['val']) {
				unset($this->session->data['compareDiamond']);
			}

			$diamondArray3['diamonds'] = $this->model_catalog_product->getDiamondCompareData();
			$diamondArray3['rowcount'] = 20000;
			$data['diamondTableData3'] = $this->load->controller('product/diamonddetail', $diamondArray3 );

			$this->response->setOutput( $data['diamondTableData3'] );

	}

	public function filter() {

		$this->load->model('catalog/product');

		$filterdata = '';

		if (isset($this->request->post['diamondShape'])) {
			$diamondShapeArray = explode("/", $this->request->post['diamondShape'] );
			$diamondShape = strtolower( $diamondShapeArray[0] );
			$filterdata .=  " and lower(a.shape) like '%" . $diamondShape . "%' " ;
		}
		if ( isset($this->request->post['diamondCaratMinValue']) &&  isset($this->request->post['diamondCaratMaxValue']) ) {
				$filterdata .=  " and a.weight between " . $this->request->post['diamondCaratMinValue'] . " and " . $this->request->post['diamondCaratMaxValue'] ;
		}
		if ( isset($this->request->post['diamondPriceMinValue']) &&  isset($this->request->post['diamondPriceMaxValue']) ) {
				$filterdata .=  " and b.rapnet_user_price between " . $this->request->post['diamondPriceMinValue'] . " and " . $this->request->post['diamondPriceMaxValue'] ;
		}

//		$data['colorvalues'] = $this->model_catalog_product->getColorLimitedValues();
//		$data['clarityvalues'] = $this->model_catalog_product->getClarityValues();

		if ( isset($this->request->post['diamondShape']) && strtolower($this->request->post['diamondShape']) == 'round'  ) {
			// echo '<br>Cut' . $this->request->post['diamondCutMinValue'] . ' - ' . $this->request->post['diamondCutMaxValue'];
			// if ( isset($this->request->post['diamondCutMinValue']) && isset($this->request->get['diamondCutMaxValue']) ) {
			if ( 1 ) {
				// echo '<br>Cut' . $this->request->post['diamondCutMinValue'] . ' - ' . $this->request->post['diamondCutMaxValue'];
				$minValue = (int)$this->request->post['diamondCutMinValue'] ;
				$minValue = $minValue / 25 + 3;
				$maxValue = (int)$this->request->post['diamondCutMaxValue'] ;
				$maxValue = $maxValue / 25 + 2;

				$cutvalues = $this->model_catalog_product->getCutFilterValuesNew( $minValue , $maxValue);
				$cut = "";
				foreach ($cutvalues as $cutvalue) {
					$cut .=	"'" . $cutvalue['desc'] . "'," ;
				}
				$cut .=	"'DUMMY'" ;
				$filterdata .=  " and a.cut_grade in ( ". $cut ." )" ;
			}
		 	// echo $filterdata;
		}

		// Colour Code
		//if ( isset($this->request->post['diamondColourMinValue']) &&  isset($this->request->get['diamondColourMaxValue']) ) {
		if (1){
						$minValue = (int)$this->request->post['diamondColourMinValue'] ;
						$minValue = $minValue / 10 + 14;
						$maxValue = (int)$this->request->post['diamondColourMaxValue'] ;
						$maxValue = $maxValue / 10 + 13;

						$cutvalues = $this->model_catalog_product->getColorLimitedValuesNew( $minValue , $maxValue);
						$colourCode = "";
						foreach ($cutvalues as $cutvalue) {
							$colourCode .=	"'" . $cutvalue['colour_code'] . "'," ;
						}
						$colourCode .=	"'DUMMY'" ;
						$filterdata .=  " and a.color in ( ". $colourCode ." )" ;
						//echo '<br>Cut' . $minValue . ' - ' . $maxValue;
		}

		// Clarity Code
		// if ( isset($this->request->post['diamondClarityMinValue']) &&  isset($this->request->get['diamondClarityMaxValue']) ) {
		if (1){
						$minValue = (int)$this->request->post['diamondClarityMinValue'] ;
						$minValue = $minValue / 10 + 3;
						$maxValue = (int)$this->request->post['diamondClarityMaxValue'] ;
						$maxValue = $maxValue / 10 + 2;
						// echo '<br>Cut' . $minValue . ' - ' . $maxValue;
						$clartiyvalues = $this->model_catalog_product->getClarityValuesDiamondNew( $minValue , $maxValue );
						$clarity_code = "";
						foreach ($clartiyvalues as $clartiyvalue) {
								$clarity_code .=	"'" . $clartiyvalue['clarity_code'] . "'," ;
						}
						$clarity_code .=	"'DUMMY'" ;
						$filterdata .=  " and a.clarity in ( ". $clarity_code ." )" ;
						// echo '<br>Cut' . $minValue . ' - ' . $maxValue;
		}

		// SELECT * FROM " . DB_PREFIX . "rapnet_cut_equivalent order by cutrank desc
		$filterdata .=  " and (diamond_image_url != '' or diamond_video_url != '') ";
		$filterdata .=  " order by rapnet_final_price ";
		$filterdata .=  " LIMIT 10 ";

		// echo $filterdata ;
		// $diamondArray['diamonds'] = $this->model_catalog_product->getRapnetDiamond('LD19106645');
		// echo $filterdata;

		$diamondArray['diamonds'] = $this->model_catalog_product->getFilteredDiamonds($filterdata);
		$diamondArray['rowcount'] = 1;

		$data['diamondTableData'] = $this->load->controller('product/diamonddetail', $diamondArray );
		$this->response->setOutput( $data['diamondTableData'] );
	}

	public function filterRapnetNumber($rapnet_lot_no) {
		$this->load->model('catalog/product');
		$diamondArray['diamonds'] = $this->model_catalog_product->getRapnetDiamond($rapnet_lot_no);
		$diamondArray['rowcount'] = 1;

		$data['diamondTableData'] = $this->load->controller('product/diamonddetail', $diamondArray );
		$this->response->setOutput( $data['diamondTableData'] );
	}

	public function getShapesImages() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "shape where enable=1");

		return $query->rows;
	}
//Email Script Started
		public function SendCompareMail() {

			$this->load->model('catalog/product');

			$diamondArray4['diamonds'] = $this->model_catalog_product->getDiamondCompareData();
			$diamondArray4['rowcount'] = 20000;
			$data['diamondTableData3'] = $this->load->controller('product/diamonddetailmail', $diamondArray4 );

			$mail = new Mail();
			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
			$mail->smtp_username = $this->config->get('config_mail_smtp_username');
			$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
			$mail->smtp_port = $this->config->get('config_mail_smtp_port');
			$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

			$mail->setTo($this->customer->getEmail());
			$mail->setReplyTo($this->config->get('config_email'));
			//$mail->setBcc($this->config->get('config_email'));
			$mail->setFrom($this->config->get('config_email'));
			$mail->setSender(html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8'));
			$mail->setSubject(html_entity_decode('Your Diamond selection', ENT_QUOTES, 'UTF-8'));
			//$mail->setHtml($this->load->view('mail/diamond', $data['diamondTableData3']));
			$mail->setHtml($data['diamondTableData3']);
			//$mail->setText($text);
			$mail->send();
      /* ADMIN MAIL*/

			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
			$mail->smtp_username = $this->config->get('config_mail_smtp_username');
			$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
			$mail->smtp_port = $this->config->get('config_mail_smtp_port');
			$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

			$mail->setTo($this->config->get('config_email'));
			$mail->setReplyTo($this->customer->getEmail());
			//$mail->setBcc($this->config->get('config_email'));
			$mail->setFrom($this->config->get('config_email'));
			$mail->setSender(html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8'));
			$mail->setSubject(html_entity_decode('Your Diamond selection', ENT_QUOTES, 'UTF-8'));
			//$mail->setHtml($this->load->view('mail/diamond', $data['diamondTableData3']));
			$mail->setHtml($data['diamondTableData3']);
			//$mail->setText($text);
			$mail->send();
			$this->response->setOutput( 'Successfully sent to your mail' );
		}
		//Email Script Closed
}
