<?php
class ControllerSaleSize extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('sale/size');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/size');

		$this->getList();
	}

	public function add() {
		$this->load->language('sale/size');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/size');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_size->addsize($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/size', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('sale/size');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/size');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_size->editsize($this->request->get['size_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/size', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('sale/size');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/size');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $size_id) {
				$this->model_sale_size->deletesize($size_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/size', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'size_code';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] =   array();

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('heading_title'),
			'href' =>  $this->url->link('sale/size', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('sale/size/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('sale/size/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['size'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$size_total = $this->model_sale_size->getTotalsizes();

		$results = $this->model_sale_size->getsizes($filter_data);

		foreach ($results as $result) {
			$data['size'][] =   array(
				'size_id' 			=> $result['size_id'],
				'size_code'        		=> $result['size_code'], 
				'measlength'        		=> $result['measlength'], 
				'measwidth'        		=> $result['measwidth'], 
				'edit'        		=> $this->url->link('sale/size/edit', 'user_token=' . $this->session->data['user_token'] . '&size_id=' . $result['size_id'] . $url, true)
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_size_code'] = $this->url->link('sale/size', 'user_token=' . $this->session->data['user_token'] . '&sort=size_code' . $url, true); 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $size_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/size', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($size_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($size_total - $this->config->get('config_limit_admin'))) ? $size_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $size_total, ceil($size_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/size_list', $data));
	}

	protected function getForm() {
		$data['text_form'] = !isset($this->request->get['size_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['size_code'])) {
			$data['error_size_code'] = $this->error['size_code'];
		} else {
			$data['error_size_code'] = '';
		}
		

		if (isset($this->error['measlength'])) {
			$data['error_measlength'] = $this->error['measlength'];
		} else {
			$data['error_measlength'] = '';
		}
		if (isset($this->error['measwidth'])) {
			$data['error_measwidth'] = $this->error['measwidth'];
		} else {
			$data['error_measwidth'] = '';
		}
		

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/size', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['size_id'])) {
			$data['action'] = $this->url->link('sale/size/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/size/edit', 'user_token=' . $this->session->data['user_token'] .  '&size_id=' . $this->request->get['size_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('sale/size', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['size_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$size_info = $this->model_sale_size->getsize($this->request->get['size_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('setting/store');

		if (isset($this->request->post['size_code'])) {
			$data['size_code'] = $this->request->post['size_code'];
		} elseif (!empty($size_info)) {
			$data['size_code'] = $size_info['size_code'];
		} else {
			$data['size_code'] =   '';
		} 
		if (isset($this->request->post['measlength'])) {
			$data['measlength'] = $this->request->post['measlength'];
		} elseif (!empty($size_info)) {
			$data['measlength'] = $size_info['measlength'];
		} else {
			$data['measlength'] =   '';
		} 
		if (isset($this->request->post['measwidth'])) {
			$data['measwidth'] = $this->request->post['measwidth'];
		} elseif (!empty($size_info)) {
			$data['measwidth'] = $size_info['measwidth'];
		} else {
			$data['measwidth'] =   '';
		} 

		if (isset($this->request->post['size_id'])) {
			$data['size_id'] = $this->request->post['size_id'];
		} elseif (!empty($size_info)) {
			$data['size_id'] = $size_info['size_id'];
		} else {
			$data['size_id'] = '';
		} 
		
		$this->load->model('localisation/currency');

		$data['currencies'] = $this->model_localisation_currency->getCurrencies();
  
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/size_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/size')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['size_code']) < 1) || (utf8_strlen($this->request->post['size_code']) > 32)) {
			$this->error['size_code'] = $this->language->get('error_size_code');
		}  
 
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/size')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}