<?php
class ControllerSaleGemweight extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('sale/gemweight');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemweight');

		$this->getList();
	}

	public function add() {
		$this->load->language('sale/gemweight');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemweight');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemweight->addgemweight($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/gemweight', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('sale/gemweight');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemweight');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_gemweight->editgemweight($this->request->get['gemstoneweight_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/gemweight', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('sale/gemweight');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/gemweight');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $gemstoneweight_id) {
				$this->model_sale_gemweight->deletegemweight($gemstoneweight_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/gemweight', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'gemstoneweight_id';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] =   array();

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('heading_title'),
			'href' =>  $this->url->link('sale/gemweight', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('sale/gemweight/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('sale/gemweight/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['gemweight'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$gemweight_total = $this->model_sale_gemweight->getTotalgemweights();

		$results = $this->model_sale_gemweight->getgemweights($filter_data);

		foreach ($results as $result) {
			$data['gemweight'][] =   array(
				'gemstoneweight_id' 			=> $result['gemstoneweight_id'],
				'size_code'        		=> $result['size_code'], 
				'gemstone_id'        		=> $result['gemstone_id'], 
				'gemname'        		=> $result['gemname'], 
				'weight'     					=> $result['weight'], 
				'edit'        		=> $this->url->link('sale/gemweight/edit', 'user_token=' . $this->session->data['user_token'] . '&gemstoneweight_id=' . $result['gemstoneweight_id'] . $url, true)
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_size_code'] = $this->url->link('sale/gemweight', 'user_token=' . $this->session->data['user_token'] . '&sort=size_code' . $url, true);
		$data['sort_gemname'] = $this->url->link('sale/gemweight', 'user_token=' . $this->session->data['user_token'] . '&sort=gemname' . $url, true);
		$data['sort_weight'] = $this->url->link('sale/gemweight', 'user_token=' . $this->session->data['user_token'] . '&sort=weight' . $url, true); 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $gemweight_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/gemweight', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($gemweight_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($gemweight_total - $this->config->get('config_limit_admin'))) ? $gemweight_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $gemweight_total, ceil($gemweight_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/gemweight_list', $data));
	}

	protected function getForm() {
		$data['text_form'] = !isset($this->request->get['gemstoneweight_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['size_code'])) {
			$data['error_size_code'] = $this->error['size_code'];
		} else {
			$data['error_size_code'] = '';
		}

		if (isset($this->error['weight'])) {
			$data['error_weight'] = $this->error['weight'];
		} else {
			$data['error_weight'] = '';
		} 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/gemweight', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['gemstoneweight_id'])) {
			$data['action'] = $this->url->link('sale/gemweight/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/gemweight/edit', 'user_token=' . $this->session->data['user_token'] .  '&gemstoneweight_id=' . $this->request->get['gemstoneweight_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('sale/gemweight', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['gemstoneweight_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$gemweight_info = $this->model_sale_gemweight->getgemweight($this->request->get['gemstoneweight_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('setting/store');
 
		if (isset($this->request->post['size_code'])) {
			$data['size_code'] = $this->request->post['size_code'];
		} elseif (!empty($gemweight_info)) {
			$data['size_code'] = $gemweight_info['size_code'];
		} else {
			$data['size_code'] =   '';
		}
		
		if (isset($this->request->post['shape'])) {
			$data['shape'] = $this->request->post['shape'];
		} elseif (!empty($gemweight_info)) {
			$data['shape'] = $gemweight_info['shape'];
		} else {
			$data['shape'] = '';
		}
		if (isset($this->request->post['weight'])) {
			$data['weight'] = $this->request->post['weight'];
		} elseif (!empty($gemweight_info)) {
			$data['weight'] = $gemweight_info['weight'];
		} else {
			$data['weight'] = '';
		} 

		if (isset($this->request->post['gemstone_id'])) {
			$data['gemstone_id'] = $this->request->post['gemstone_id'];
		} elseif (!empty($gemweight_info)) {
			$data['gemstone_id'] = $gemweight_info['gemstone_id'];
		} else {
			$data['gemstone_id'] = '';
		} 
		 
		$this->load->model('sale/gemshape'); 
		$data['shapes'] = $this->model_sale_gemshape->getgemshapes();
		$this->load->model('sale/size');
		$data['sizes'] = $this->model_sale_size->getsizes();
		$this->load->model('sale/gemstone');
		$data['gemstones'] = $this->model_sale_gemstone->getgemstones();
  
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/gemweight_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/gemweight')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['size_code']) < 1) || (utf8_strlen($this->request->post['size_code']) > 32)) {
			$this->error['size_code'] = $this->language->get('error_size_code');
		} 

		
		if ((utf8_strlen($this->request->post['weight']) < 1) || (utf8_strlen($this->request->post['weight']) > 128)) {
			$this->error['weight'] = $this->language->get('error_weight');
		}
 
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/gemweight')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}