<?php
class ControllerSaleContestsm extends Controller {
	private $error = array();

	public function index() {
		
		$this->load->language('sale/contestsm');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/contestsm');

		$this->getList(); 
	}

	public function add() {
		$this->load->language('sale/contestsm');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/contestsm');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_contestsm->addcontestsm($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/contestsm', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('sale/contestsm');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/contestsm');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_contestsm->editcontestsm($this->request->get['contest_status_master_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/contestsm', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('sale/contestsm');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/contestsm');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $contest_status_master_id) {
				$this->model_sale_contestsm->deletecontestsm($contest_status_master_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/contestsm', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'description';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] =   array();

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('heading_title'),
			'href' =>  $this->url->link('sale/contestsm', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('sale/contestsm/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('sale/contestsm/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['contestsm'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$contestsm_total = $this->model_sale_contestsm->getTotalcontestsms();

		$results = $this->model_sale_contestsm->getcontestsms($filter_data);

		foreach ($results as $result) {
			$data['contestsm'][] =   array(
				'contest_status_master_id' 			=> $result['contest_status_master_id'],
				'description'        		=> $result['description'], 
				'edit'        		=> $this->url->link('sale/contestsm/edit', 'user_token=' . $this->session->data['user_token'] . '&contest_status_master_id=' . $result['contest_status_master_id'] . $url, true)
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_description'] = $this->url->link('sale/contestsm', 'user_token=' . $this->session->data['user_token'] . '&sort=description' . $url, true); 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $contestsm_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/contestsm', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($contestsm_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($contestsm_total - $this->config->get('config_limit_admin'))) ? $contestsm_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $contestsm_total, ceil($contestsm_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/contestsm_list', $data));
	}

	protected function getForm() {
		$data['text_form'] = !isset($this->request->get['contest_status_master_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['description'])) {
			$data['error_description'] = $this->error['description'];
		} else {
			$data['error_description'] = '';
		}
		

		if (isset($this->error['duration'])) {
			$data['error_duration'] = $this->error['duration'];
		} else {
			$data['error_duration'] = '';
		}
		

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/contestsm', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['contest_status_master_id'])) {
			$data['action'] = $this->url->link('sale/contestsm/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/contestsm/edit', 'user_token=' . $this->session->data['user_token'] .  '&contest_status_master_id=' . $this->request->get['contest_status_master_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('sale/contestsm', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['contest_status_master_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$contestsm_info = $this->model_sale_contestsm->getcontestsm($this->request->get['contest_status_master_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('setting/store');

		if (isset($this->request->post['description'])) {
			$data['description'] = $this->request->post['description'];
		} elseif (!empty($contestsm_info)) {
			$data['description'] = $contestsm_info['description'];
		} else {
			$data['description'] =   '';
		} 
		if (isset($this->request->post['duration'])) {
			$data['duration'] = $this->request->post['duration'];
		} elseif (!empty($contestsm_info)) {
			$data['duration'] = $contestsm_info['duration'];
		} else {
			$data['duration'] =   '';
		} 

		if (isset($this->request->post['contest_status_master_id'])) {
			$data['contest_status_master_id'] = $this->request->post['contest_status_master_id'];
		} elseif (!empty($contestsm_info)) {
			$data['contest_status_master_id'] = $contestsm_info['contest_status_master_id'];
		} else {
			$data['contest_status_master_id'] = '';
		} 
		
		$this->load->model('localisation/currency');

		$data['currencies'] = $this->model_localisation_currency->getCurrencies();
  
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/contestsm_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/contestsm')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['description']) < 1) || (utf8_strlen($this->request->post['description']) > 32)) {
			$this->error['description'] = $this->language->get('error_description');
		} 
 
		if ((utf8_strlen($this->request->post['duration']) < 1) || (utf8_strlen($this->request->post['duration']) > 32)) {
			$this->error['duration'] = $this->language->get('error_duration');
		} 
 
 
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/contestsm')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}