<?php
class ControllerSaleclaritycode extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('sale/claritycode');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/claritycode');

		$this->getList();
	}

	public function add() {
		$this->load->language('sale/claritycode');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/claritycode');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_claritycode->addclaritycode($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/claritycode', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function edit() {
		$this->load->language('sale/claritycode');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/claritycode');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_claritycode->editclaritycode($this->request->get['clarity_id'], $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/claritycode', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getForm();
	}

	public function delete() {
		$this->load->language('sale/claritycode');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/claritycode');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $clarity_id) {
				$this->model_sale_claritycode->deleteclaritycode($clarity_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('sale/claritycode', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'clarity_code';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] =   array();

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] =   array(
			'text' =>  $this->language->get('heading_title'),
			'href' =>  $this->url->link('sale/claritycode', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['add'] = $this->url->link('sale/claritycode/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['delete'] = $this->url->link('sale/claritycode/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['claritycode'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);

		$claritycode_total = $this->model_sale_claritycode->getTotalclaritycodes();

		$results = $this->model_sale_claritycode->getclaritycodes($filter_data);

		foreach ($results as $result) {
			$data['claritycode'][] =   array(
				'clarity_id' 			=> $result['clarity_id'],
				'clarity_code'        		=> $result['clarity_code'], 
				'edit'        		=> $this->url->link('sale/claritycode/edit', 'user_token=' . $this->session->data['user_token'] . '&clarity_id=' . $result['clarity_id'] . $url, true)
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_clarity_code'] = $this->url->link('sale/claritycode', 'user_token=' . $this->session->data['user_token'] . '&sort=clarity_code' . $url, true); 

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $claritycode_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/claritycode', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($claritycode_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($claritycode_total - $this->config->get('config_limit_admin'))) ? $claritycode_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $claritycode_total, ceil($claritycode_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/claritycode_list', $data));
	}

	protected function getForm() {
		$data['text_form'] = !isset($this->request->get['clarity_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['clarity_code'])) {
			$data['error_clarity_code'] = $this->error['clarity_code'];
		} else {
			$data['error_clarity_code'] = '';
		}
		

		if (isset($this->error['clarity_descr'])) {
			$data['error_clarity_descr'] = $this->error['clarity_descr'];
		} else {
			$data['error_clarity_descr'] = '';
		}
		

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/claritycode', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		if (!isset($this->request->get['clarity_id'])) {
			$data['action'] = $this->url->link('sale/claritycode/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
		} else {
			$data['action'] = $this->url->link('sale/claritycode/edit', 'user_token=' . $this->session->data['user_token'] .  '&clarity_id=' . $this->request->get['clarity_id'] . $url, true);
		}

		$data['cancel'] = $this->url->link('sale/claritycode', 'user_token=' . $this->session->data['user_token'] . $url, true);

		if (isset($this->request->get['clarity_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$claritycode_info = $this->model_sale_claritycode->getclaritycode($this->request->get['clarity_id']);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('setting/store');

		if (isset($this->request->post['clarity_code'])) {
			$data['clarity_code'] = $this->request->post['clarity_code'];
		} elseif (!empty($claritycode_info)) {
			$data['clarity_code'] = $claritycode_info['clarity_code'];
		} else {
			$data['clarity_code'] =   '';
		} 
		if (isset($this->request->post['clarity_descr'])) {
			$data['clarity_descr'] = $this->request->post['clarity_descr'];
		} elseif (!empty($claritycode_info)) {
			$data['clarity_descr'] = $claritycode_info['clarity_descr'];
		} else {
			$data['clarity_descr'] =   '';
		} 

		if (isset($this->request->post['clarity_id'])) {
			$data['clarity_id'] = $this->request->post['clarity_id'];
		} elseif (!empty($claritycode_info)) {
			$data['clarity_id'] = $claritycode_info['clarity_id'];
		} else {
			$data['clarity_id'] = '';
		} 
		
		$this->load->model('localisation/currency');

		$data['currencies'] = $this->model_localisation_currency->getCurrencies();
  
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/claritycode_form', $data));
	}

	protected function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/claritycode')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['clarity_code']) < 1) || (utf8_strlen($this->request->post['clarity_code']) > 32)) {
			$this->error['clarity_code'] = $this->language->get('error_clarity_code');
		} 
 
		if ((utf8_strlen($this->request->post['clarity_descr']) < 1) || (utf8_strlen($this->request->post['clarity_descr']) > 32)) {
			$this->error['clarity_descr'] = $this->language->get('error_clarity_descr');
		} 
 
 
		return !$this->error;
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/claritycode')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}