<?php
class ControllerExtensionModuleGemstone extends Controller {
	public function index($setting) { 
		$this->load->language('extension/module/gemstone'); 

  	$data['heading_title'] = $this->language->get('heading_title');
		
		$data['button_cart'] = $this->language->get('button_cart');
		
		$this->load->model('catalog/product'); 
		
		$this->load->model('tool/image');

		$data['gemstones'] = array();

		if (isset($this->request->get['path'])) 
		{
			$path = '';
		
			$parts = explode('_', (string)$this->request->get['path']);
		
			foreach ($parts as $path_id) {
				if (!$path) {
					$path = $path_id;
				} else {
					$path .= '_' . $path_id;
				}
									
				$category_info = $this->model_catalog_category->getCategory($path_id);
				
				if ($category_info) {
	       			$data['breadcrumbs'][] = array(
   	    				'text'      => $category_info['name'],
						'href'      => $this->url->link('product/category', 'path=' . $path),
        				'separator' => $this->language->get('text_separator')
        			);
				}
			}	
			$category_id = array_pop($parts);
		} else {
			$category_id = 0;
		}
		$data['gemname']='';
		$data['metalname']='';
		$data['shapename']='';
		
		
		
		if (isset($this->request->get['metal_id'])) { 
			$metal_id = $this->request->get['metal_id'];
		} elseif (isset($category_info['metal_id'])) {
			$metal_id = $category_info['metal_id'];
		} else {
			$metal_id = 0;
		}
							
		if (isset($this->request->get['gemstone_id'])) {
			$gemstone_id = $this->request->get['gemstone_id'];
		} elseif (isset($category_info['gemstone_id'])){
			$gemstone_id = $category_info['gemstone_id'];
		}else {
			$gemstone_id = 0;
		}				
		if (isset($this->request->get['shape_id'])) {
			$shape_id = $this->request->get['shape_id'];
		} elseif (isset($category_info['shape_id'])) {
			$shape_id = $category_info['shape_id']; 
		} else {
			$shape_id = 0 ; 
		}				
		if (isset($this->request->get['lp'])) {
			$low_price = $this->request->get['lp'];
		} else {
			$low_price = 0 ; 
		}				
		if (isset($this->request->get['hp'])) {
			$high_price = $this->request->get['hp'];
		} else {
			$high_price = 10000000 ; 
		}
		if( isset($this->request->get['metal_id']) <> 0 || isset($this->request->get['gemstone_id']) <> 0 || isset($this->request->get['shape_id']) <> 0 || isset($this->request->get['lp']) <> 0 || isset($this->request->get['hp']) <> 0   ){
			$data['filterMinimize']= $metal_id +  $gemstone_id+  $shape_id + $lp + $hp ;
		}else{
			$data['filterMinimize']= 0;		
		}
		$data['low_price']= $low_price;
		$data['high_price']= $high_price;
		if($low_price==0 && $high_price==10000000){
			$data['pricerange']= '';
		}else{
			$data['pricerange']=  $this->currency->format($low_price) . ' to ' . $this->currency->format($high_price);
		}
		$data['priceemptyurl']=$this->url->link('product/newurl','newurl='.$category_id.'-'.$gemstone_id.'-'.$metal_id.'-'.$shape_id.'-0-10000000');

		$data['gemname']=$this->model_catalog_product->getGemName($gemstone_id);
		$data['metalname']=$this->model_catalog_product->getMetalName($metal_id);
		$data['shapename']=$this->model_catalog_product->getShapeName($shape_id);
		$data['emptyurl']=$this->url->link('product/newurl', 'newurl='.$category_id.'-0-0-0-0-10000000');
		$data['gememptyurl']=$this->url->link('product/newurl', 'newurl='.$category_id.'-0-'.$metal_id.'-'.$shape_id.'-'.$low_price.'-'.$high_price);
		$data['metalemptyurl']=$this->url->link('product/newurl','newurl='.$category_id.'-'.$gemstone_id.'-0-'.$shape_id.'-'.$low_price.'-'.$high_price);
		$data['shapeemptyurl']=$this->url->link('product/newurl','newurl='.$category_id.'-'.$gemstone_id.'-'.$metal_id.'-0'.'-'.$low_price.'-'.$high_price);
		$data['rangehref']=$this->url->link('product/newurl','newurl='.$category_id.'-'.$gemstone_id.'-'.$metal_id.'-'.$shape_id.'-'.$low_price.'-'.$high_price);
		$data['rangehref1']=$this->url->link('product/newurl','newurl='.$category_id.'-'.$gemstone_id.'-'.$metal_id.'-'.$shape_id);
		
		$data['linkurl']=$this->url->link('product/newurl','newurl='.$category_id.'-'.$gemstone_id.'-'.$metal_id.'-'.$shape_id.'-'.$low_price.'-'.$high_price);

		$product_info = $this->getGemstoneImages();
		foreach ($product_info as $product_info) {
			if ($product_info) {
				if ($product_info['image1']) {
					//$image = $this->model_tool_image->resize($product_info['image1'], $setting['image_width'], $setting['image_height']);
					$image = 'image/' . $product_info['image1']; 
				} else {
					$image = false;
				}
				$linkurl=$this->url->link('product/newurllogic','newurl='.$category_id.'-'.$product_info['gemstone_id'].'-'.$metal_id.'-'.$shape_id.'-'.$low_price.'-'.$high_price);
				$data['gemstones'][] = array(
					'thumb'   => $image,
					'name'   	=> $product_info['gemname'],
					'linkurl'   	=> $linkurl,
					
				);
			}
		}

		$data['metals'] = array();
	
		$metal_info = $this->getMetalsImages();
		foreach ($metal_info as $metal_info) {
			if ($metal_info) {
				if ($metal_info['image']) {
					//$image = $this->model_tool_image->resize($metal_info['image'], $setting['image_width'], $setting['image_height']);
					$image = 'https://www.chameleon.rocks/image/'.$metal_info['image'];
				} else {
					$image = false;
				}
				$linkurl=$this->url->link('product/newurllogic','newurl='.$category_id.'-'.$gemstone_id .'-'.$metal_info['metal_id'].'-'.$shape_id.'-'.$low_price.'-'.$high_price);
			
				$data['metals'][] = array(
					'thumb'   	 => $image,
					'name'   	 => $metal_info['metalname'],
					'metal_id'   	 => $metal_info['metal_id'],
					'metal_code'   	 => $metal_info['metal_code'],
					//'href'  => $this->getMetalSeoKeyWord($metal_info['metal_code'])
					'href'  => $linkurl
				);
			}
		}

		$data['shapes'] = array();
	
		$shapes_info = $this->getShapesImages();
		foreach ($shapes_info as $shape_info) {
			if ($shape_info) {
				if ($shape_info['image']) {
					$image = $this->model_tool_image->resize($shape_info['image'], 52, 72);
				} else {
					$image = false;
				}
				$linkurl=$this->url->link('product/newurllogic','newurl='.$category_id.'-'.$gemstone_id .'-'.$metal_id.'-'.$shape_info['shape_id'].'-'.$low_price.'-'.$high_price);
			
				$data['shapes'][] = array(
					//'thumb'   	 => HTTP_IMAGE.$shape_info['image'],
					'thumb'   	 => DIR_IMAGE.$shape_info['image'],
					'name'   	 => $shape_info['shape'],
					'metal_id'   	 => $shape_info['shape_id'],
					//'href'  => $this->getMetalSeoKeyWord($metal_info['metal_code'])
					'href'  => $linkurl
				);
			}
		} 

		return $this->load->view('extension/module/gemstone',$data);
		


		/*if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/gemstone.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/gemstone.tpl';
		} else {
			$this->template = 'default/template/module/gemstone.tpl';
		}

		$this->render();*/
	}
	 public function getMetalsImages() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "metal ORDER BY sort_order ASC");

		return $query->rows;
	}
	public function getMetalSeoKeyWord($metalname) {
		$query = $this->db->query("SELECT b.keyword as keyword FROM " . DB_PREFIX . "category_description a,url_alias b where a.language_id=1 and a.name='". $metalname ."' and b.query=concat('category_id=',a.category_id)  ");

		return $query->row['keyword'];
	}
	
	
	public function getShapesImages() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "shape where enable=1");

		return $query->rows;
	}
	
	public function getGemstoneImages() {
		$query = $this->db->query("SELECT gemstone_id,image1,gemname FROM " . DB_PREFIX . "gemstone where category_display=0 ORDER BY sort_order ASC");

		return $query->rows;
	} 
}
?>