<?php  
class ControllerModuleBlogCategory extends Controller {
	protected function index() {
		$this->language->load('module/blog_category');
		
    	$this->data['heading_title'] = $this->language->get('heading_title');
		
		if (isset($this->request->get['blogpath'])) {
			$parts = explode('_', (string)$this->request->get['blogpath']);
		} else {
			$parts = array();
		}
		
		if (isset($parts[0])) {
			$this->data['blog_category_id'] = $parts[0];
		} else {
			$this->data['blog_category_id'] = 0;
		}
		
		if (isset($parts[1])) {
			$this->data['child_id'] = $parts[1];
		} else {
			$this->data['child_id'] = 0;
		}
							
		$this->load->model('extras/blog_category');
		$this->load->model('extras/blog');
		
		$this->data['blog_categories'] = array();
					
		$blog_categories = $this->model_extras_blog_category->getBlogCategories(0);
		
		foreach ($blog_categories as $blog_category) {
			$children_data = array();
			
			$children = $this->model_extras_blog_category->getBlogCategories($blog_category['blog_category_id']);
			
			foreach ($children as $child) {
				$data = array(
					'filter_blog_category_id'  => $child['blog_category_id'],
					'filter_sub_blog_category' => true
				);		
					
				$blog_total = $this->model_extras_blog->getTotalBlogsPerCategory($data);
							
				$children_data[] = array(
					'blog_category_id' => $child['blog_category_id'],
					'name'        => $child['name'] . ' (' . $blog_total . ')',
					'href'        => $this->url->link('extras/blog/getblogcategory', 'blogpath=' . $blog_category['blog_category_id'] . '_' . $child['blog_category_id'])	
				);					
			}
			
			$data = array(
				'filter_blog_category_id'  => $blog_category['blog_category_id'],
				'filter_sub_blog_category' => true	
			);		
				
			$blog_total = $this->model_extras_blog->getTotalBlogsPerCategory($data);
						
			$this->data['blog_categories'][] = array(
				'blog_category_id' => $blog_category['blog_category_id'],
				'name'        => $blog_category['name'] . ' (' . $blog_total . ')',
				'children'    => $children_data,
				'href'        => $this->url->link('extras/blog/getblogcategory', 'blogpath=' . $blog_category['blog_category_id'])
			);
		}
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/blog_category.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/blog_category.tpl';
		} else {
			$this->template = 'default/template/module/blog_category.tpl';
		}
		
		$this->render();
  	}
}
?>