<?php
class ControllerAffiliateCustomer extends Controller {
	private $error = array();
	     
  	public function index() {	
    	if (!$this->affiliate->isLogged()) {
      		$this->session->data['redirect'] = $this->url->link('affiliate/customer', '', 'SSL');

      		$this->redirect($this->url->link('affiliate/login', '', 'SSL'));
    	}		

		$this->language->load('affiliate/customer');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('affiliate/affiliate');

    	if (($this->request->server['REQUEST_METHOD'] == 'POST') ) {
			if(isset($this->request->post['customer_email']) && $this->validate() ){
				$this->model_affiliate_affiliate->updateCustomer($this->affiliate->isLogged(),$this->request->post['customer_email']);	
				$this->session->data['success'] = $this->language->get('text_success');	  
				$this->redirect($this->url->link('affiliate/account', '', 'SSL'));
			}else{
				if(isset($this->request->post['amount']) &&  (int)$this->request->post['amount'] <> 0 ){	

					$balance = $this->model_affiliate_affiliate->getAffiliateBalance($this->affiliate->isLogged());
					if($balance >= $this->request->post['amount'] )
					{
						if($this->config->get('config_rewards_price'))
						{
							$amount = $this->config->get('config_rewards_price') ;
							$points =  $this->config->get('config_rewards_points') ;
						}else{
							$amount = $this->language->get('amount');	
							$points = $this->language->get('points');
						}
						$applied_points= ($points / $amount ) * $this->request->post['amount'] ;
					
						$this->model_affiliate_affiliate->transferPoints($this->affiliate->isLogged(),$this->request->post['amount'], $this->language->get('entry_transferred_points'),$applied_points,$this->request->post['amount']);
						$this->session->data['success'] = $this->language->get('text_success');	  
						$this->redirect($this->url->link('affiliate/account', '', 'SSL'));
					}else{
						$this->error['error_balance'] = $this->language->get('error_balance');	  
					}
				}
			}
		}
		if(isset($this->request->get['val'])  && $this->validateget() ){
				$this->model_affiliate_affiliate->createCustomer($this->affiliate->isLogged());
				$this->log->write('created');
				$this->redirect($this->url->link('affiliate/account', '', 'SSL'));
		}

      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),       	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('affiliate/account', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);
		
      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('affiliate/customer', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);
			
    	$this->data['heading_title'] = $this->language->get('heading_title');

    	$this->data['text_customer'] = $this->language->get('text_customer');
		$this->data['entry_email'] = $this->language->get('entry_email');
		$this->data['entry_create'] = $this->language->get('entry_create');
		$this->data['entry_or'] = $this->language->get('entry_or');
		$this->data['entry_new'] = $this->language->get('entry_new');
    	$this->data['entry_customer'] = $this->language->get('entry_customer');
    	$this->data['entry_customername'] = $this->language->get('entry_customername');
    	$this->data['entry_confirm'] = $this->language->get('entry_confirm');
    	$this->data['button_continue'] = $this->language->get('button_continue');
    	$this->data['button_create'] = $this->language->get('button_create');
    	$this->data['button_back'] = $this->language->get('button_back');
    	$this->data['entry_transfer_payments'] = $this->language->get('entry_transfer_payments');
		$this->data['entry_amount'] = $this->language->get('entry_amount');

		if (isset($this->error['customer_email'])) { 
			$this->data['error_customer_email'] = $this->error['customer_email'];
		} else {
			$this->data['error_customer_email'] = '';
		}
		
		if (isset($this->error['customer_email_exist'])) { 
			$this->data['error_customer_email_exist'] = $this->error['customer_email_exist'];
		} else {
			$this->data['error_customer_email_exist'] = '';
		}
		if (isset($this->error['error_balance'])) { 
			$this->data['error_balance'] = $this->language->get('error_balance');	  
		} else {
			$this->data['error_balance'] = '';
		}					

 		
		
    	$this->data['action'] = $this->url->link('affiliate/customer', '', 'SSL');	
		
		$this->data['customername'] = $this->model_affiliate_affiliate->getCustomerDetails($this->affiliate->isLogged());
		
		if (isset($this->request->post['customer_email'])) {
    		$this->data['customer_email'] = $this->request->post['customer_email'];
		} else {
			$this->data['customer_email'] = '';
		}

		if (isset($this->request->post['amount'])) {
    		$this->data['amount'] = $this->request->post['amount'];
		} else {
			$this->data['amount'] = '';
		}

		if (isset($this->request->post['confirm'])) {
    		$this->data['confirm'] = $this->request->post['confirm'];
		} else {
			$this->data['confirm'] = '';
		}

    	$this->data['back'] = $this->url->link('affiliate/account', '', 'SSL');
		
		$this->data['customercreate'] = $this->url->link('affiliate/customer&val=create', '', 'SSL');

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/affiliate/customer.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/affiliate/customer.tpl';
		} else {
			$this->template = 'default/template/affiliate/customer.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
								
		$this->response->setOutput($this->render());				
  	}
  
  	private function validate() {

		if (utf8_strlen($this->request->post['customer_email']) < 4)
		{
			$this->error['customer_email'] = $this->language->get('error_customer');
		}
		$query = $this->db->query("SELECT a.* FROM " . DB_PREFIX . "customer a WHERE a.email = '" .  $this->request->post['customer_email'] . "'");
		if(! $query->num_rows){
			$this->error['customer_email'] = $this->language->get('error_customer');
		}

		
    	
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}
  	private function validateget() {

		$query = $this->db->query("SELECT a.* FROM " . DB_PREFIX . "customer a WHERE a.email = '" .  $this->affiliate->getEmail() . "'");
		if( $query->num_rows){
			$this->error['customer_email_exist'] = $this->language->get('error_customer_exist');
		}
    	
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}
}
?>
