<?php
@session_start(); //Start our session.
header("Cache-Control: no-store, no-cache"); //Tell the browser to not cache this page (don't store it in the internet temp folder).
header("Content-type: text/javascript"); //Let the browser think that this is a Javascript page.
if ($_SESSION["RunUpdatePx"] == true) {
?>
var delimiter = '<?php echo $_SESSION["delimiter"]; ?>';
var decimal_point = '<?php echo $_SESSION["decimal_point"]; ?>';
var decimal_place = '<?php echo $_SESSION["decimal_place"]; ?>';
var symbol_left = '<?php echo $_SESSION["symbol_left"]; ?>';
var symbol_right = '<?php echo $_SESSION["symbol_right"]; ?>';

	$(document).ready(function () {
		
		// use common decimal point for all languages
		product_px = $('#price').text().replace(/[,]/g,'.'); 

		// For currencies that use comma as decimal, 
		// we only want the last decimal and only if there is a decimal place
		// Otherwise, remove all decimals as they are not used.
		if (decimal_place > 0) {
			newpx = '';
			tmpprice = product_px.split('.');
			for (i=0; i<tmpprice.length-1; i++) {
				newpx += tmpprice[i];
			}
			product_px = newpx + '.' + tmpprice[tmpprice.length-1];
		} else {
			product_px = product_px.replace(/[.]/g,''); 
		}
		
		// Remove all additional non-price characters like symbol
		product_px = product_px.replace(/[^0-9.]/g,''); 

		updatePx();
		$('#product select').change(function(){
			updatePx();
		}); 
	});

	function updatePx() {

		// Check for Options. If there are none, return.
		if ($('#product select').length == 0) { return; }
		
		// Go through all options and get the price of each
		var px = product_px * 1;
		$('#product select :selected').each(function(i, selected){
			option_px = $(selected).text(); // get the contents of each selected option
			
			// If using custom delimiter, split. Otherwise split on +/- symbol.
			if (delimiter != '' && option_px.search(delimiter) > -1) {
				tmp = option_px.split(delimiter, 2); // split the price from the text
				if (tmp[tmp.length-1].lastIndexOf('-') > 0) { option_op = '-' } else { option_op = '+' }
			} else {
				if (option_px.lastIndexOf('-'+symbol_left) > 0) { option_op = '-' } else { option_op = '+' }
				option_px = option_px.replace(/[\+-]/g,'#'); // create a common split reference
				tmp = option_px.split('#'); // split the price from the text
			}

			if (tmp.length > 1) {
		
				// use common decimal point for all languages
				option_px = tmp[tmp.length-1].replace(/[,]/g,'.'); 
				
				// For currencies that use comma as decimal, 
				// we only want the last decimal and only if there is a decimal place
				// Otherwise, remove all decimals as they are not used.
				if (decimal_place > 0) {
					newpx = '';
					tmpprice = option_px.split('.');
					for (i=0; i<tmpprice.length-1; i++) {
						newpx += tmpprice[i];
					}
					option_px = newpx + '.' + tmpprice[tmpprice.length-1];
				} else {
					option_px = option_px.replace(/[.]/g,''); 
				}

				option_px = option_px.replace(/[^0-9.]/g,''); // remove all non-price characters from the LAST split (incase +,-,# are used in the name)
				if (option_px != '.') { //verify there is at least more than just a decimal
					option_px * 1;
					if (option_op == '-') {
						px -= (option_px * 1);
					} else {
						px += (option_px * 1);
					}
				}
			}
		});
		
		// Update the main price with the new price.
		$('#price').fadeOut('normal', function() {
			px = px.toFixed(decimal_place);			
			px = px.replace(/[.]/g, decimal_point); //restore language decimal point
			$('#price').html(symbol_left+px+symbol_right); 
		});
		$('#price').fadeIn('normal');
		
	}
<?php } 
$_SESSION["RunUpdatePx"] = false;
?>