<?php
class ControllerModuleFbconnect extends Controller {
	private $error = array(); 
	 
	public function index() {   
		$this->load->language('module/fbconnect');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
				
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			
			if(!empty($this->request->post['fb_req_ext_per'])){
				if(is_array($this->request->post['fb_req_ext_per'])){
				
					$this->request->post['fb_req_ext_per'] = implode(',',$this->request->post['fb_req_ext_per']); 
				
				}
			}
			
			$this->model_setting_setting->editSetting('fbconnect', $this->request->post);		
			
			$this->session->data['success'] = $this->language->get('text_success');
						
			$this->redirect(HTTPS_SERVER . 'index.php?route=extension/module&token=' . $this->session->data['token']);
		}
				
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['api_id_lang'] = $this->language->get('api_id_lang');
		$this->data['api_secret_lang'] = $this->language->get('api_secret_lang');
		$this->data['fb_req_ext_per_lang'] = $this->language->get('fb_req_ext_per_lang');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
	
		
		
		
		$this->data['token'] = $this->session->data['token'];

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => HTTPS_SERVER . 'index.php?route=common/home&token=' . $this->session->data['token'],
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_module'),
			'href'      => HTTPS_SERVER . 'index.php?route=extension/module&token=' . $this->session->data['token'],
      		'separator' => ' :: '
   		);
		

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => HTTPS_SERVER . 'index.php?route=module/fbconnect&token=' . $this->session->data['token'],
      		'separator' => ' :: '
   		);
		
		$this->data['action'] = HTTPS_SERVER . 'index.php?route=module/fbconnect&token=' . $this->session->data['token'];
		
		$this->data['cancel'] = HTTPS_SERVER . 'index.php?route=extension/module&token=' . $this->session->data['token'];

		
		
		
		
			
		if (isset($this->request->post['fb_api_id'])) {
					$this->data['val_fb_api_id'] = $this->request->post['fb_api_id'];
			} else {
					$this->data['val_fb_api_id'] = $this->config->get('fb_api_id');
			}

		if (isset($this->request->post['fb_api_secret'])) {
					$this->data['val_fb_api_secret'] = $this->request->post['fb_api_secret'];
			} else {
					$this->data['val_fb_api_secret'] = $this->config->get('fb_api_secret');
			}
		
		if(isset($this->request->post['fb_req_ext_per'])){
			$this->data['fb_req_ext_per'] = is_array($this->request->post['fb_req_ext_per']) ? implode(',',$this->request->post['fb_req_ext_per']) : $this->request->post['fb_req_ext_per'];
			}else{
				$this->data['fb_req_ext_per'] = $this->config->get('fb_req_ext_per');
				}
						
		

		$this->template = 'module/fbconnect.tpl';
		$this->children = array(
			'common/header',
			'common/footer',
		);
				
		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
	}
	
	private function validate() {
		if (!$this->user->hasPermission('modify', 'module/fbconnect')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
	
	public function install (){
		
		//Config
		$this->db->query("INSERT INTO " . DB_PREFIX . "setting SET `group`= 'fbconnect',`key` = 'fb_api_id'");
		$this->db->query("INSERT INTO " . DB_PREFIX . "setting SET `group`= 'fbconnect',`key` = 'fb_api_secret'");
		$this->db->query("INSERT INTO " . DB_PREFIX . "setting SET `group`= 'fbconnect',`key` = 'fb_req_ext_per'");
		//Customer Data
		
		
		$this->db->query("ALTER TABLE " . DB_DATABASE .".`". DB_PREFIX . "customer` 
							ADD COLUMN `customer_type` enum('R','F') 
							NULL DEFAULT 'R' AFTER `customer_id`");
		
		$this->db->query("ALTER TABLE " . DB_DATABASE .".`". DB_PREFIX . "customer` 
							ADD COLUMN `fb_user_id` varchar(255) NULL DEFAULT NULL AFTER `customer_type`");
		
		$this->db->query("ALTER TABLE " . DB_DATABASE .".`". DB_PREFIX . "customer` 
							ADD COLUMN `fb_token` varchar(255) NULL DEFAULT NULL AFTER `fb_user_id`");
		
		
	}
	
	public function uninstall (){
		
		
		$this->db->query("DELETE FROM  " . DB_PREFIX . "setting  WHERE `group`= 'fbconnect' AND `key` = 'fb_api_id'");
		$this->db->query("DELETE FROM  " . DB_PREFIX . "setting  WHERE `group`= 'fbconnect' AND `key` = 'fb_api_secret'");
		$this->db->query("DELETE FROM  " . DB_PREFIX . "setting  WHERE `group`= 'fbconnect' AND `key` = 'fb_req_ext_per'");
		
		$this->db->query("ALTER TABLE " . DB_DATABASE .".`". DB_PREFIX . "customer` 
							DROP COLUMN `customer_type`");
		
		$this->db->query("ALTER TABLE " . DB_DATABASE .".`". DB_PREFIX . "customer` 
							DROP COLUMN `fb_user_id`");
		
		$this->db->query("ALTER TABLE " . DB_DATABASE .".`". DB_PREFIX . "customer` 
							DROP COLUMN `fb_token`");
									
		
		}
}
?>