<?php
class ModelExtrasBlogSearch extends Model {
	public function getBlog($blog_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "blog i LEFT JOIN " . DB_PREFIX . "blog_description id ON (i.blog_id = id.blog_id) LEFT JOIN " . DB_PREFIX . "blog_to_store i2s ON (i.blog_id = i2s.blog_id) WHERE i.blog_id = '" . (int)$blog_id . "' AND id.language_id = '" . (int)$this->config->get('config_language_id') . "' AND i2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND i.status = '1'");
	
		return $query->row;
	}
	
	public function getBlogs($start = 0, $limit = 40, $data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "blog i LEFT JOIN " . DB_PREFIX . "blog_description id ON (i.blog_id = id.blog_id) LEFT JOIN " . DB_PREFIX . "blog_to_store i2s ON (i.blog_id = i2s.blog_id) WHERE id.language_id = '" . (int)$this->config->get('config_language_id') . "' AND i2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND i.status = '1' AND i.sort_order <> '-1'"; 
		
		if (!empty($data['filter_keyword'])) {
		
			if (empty($data['filter_blog_title']) && empty($data['filter_blog_description'])) {
				$sql .= " AND (LCASE(id.title) LIKE '%" . $this->db->escape(strtolower($data['filter_keyword'])) . "%' OR LCASE(id.description) LIKE '%" . $this->db->escape(strtolower($data['filter_keyword'])) . "%' ) ";
			}
			
			if ($data['filter_blog_title'] == "true" && empty($data['filter_blog_description'])) {
				$sql .= " AND (LCASE(id.title) LIKE '%" . $this->db->escape(strtolower($data['filter_keyword'])) . "%') ";
			}
			
			if ($data['filter_blog_description'] == "true" && empty($data['filter_blog_title'])) {
				$sql .= " AND (LCASE(id.description) LIKE '%" . $this->db->escape(strtolower($data['filter_keyword'])) . "%') ";
			}
			
			if ($data['filter_blog_title'] == "true" && $data['filter_blog_description'] == "true") {
				$sql .= " AND (LCASE(id.title) LIKE '%" . $this->db->escape(strtolower($data['filter_keyword'])) . "%' OR LCASE(id.description) LIKE '%" . $this->db->escape(strtolower($data['filter_keyword'])) . "%' ) ";
			}
			
		}
		
		$sql .= "ORDER BY i.sort_order, i.blog_id DESC LIMIT " . (int)$start . "," . (int)$limit;
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getTotalBlogs($data = array()) {
		$sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "blog i LEFT JOIN " . DB_PREFIX . "blog_description id ON (i.blog_id = id.blog_id) LEFT JOIN " . DB_PREFIX . "blog_to_store i2s ON (i.blog_id = i2s.blog_id) WHERE id.language_id = '" . (int)$this->config->get('config_language_id') . "' AND i2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND i.status = '1' AND i.sort_order <> '-1'"; 
		
		if (!empty($data['filter_keyword'])) {
		
			if (empty($data['filter_blog_title']) && empty($data['filter_blog_description'])) {
				$sql .= " AND (LCASE(id.title) LIKE '%" . $this->db->escape(strtolower($data['filter_keyword'])) . "%' OR LCASE(id.description) LIKE '%" . $this->db->escape(strtolower($data['filter_keyword'])) . "%' ) ";
			}
			
			if ($data['filter_blog_title'] == "true" && empty($data['filter_blog_description'])) {
				$sql .= " AND (LCASE(id.title) LIKE '%" . $this->db->escape(strtolower($data['filter_keyword'])) . "%') ";
			}
			
			if ($data['filter_blog_description'] == "true" && empty($data['filter_blog_title'])) {
				$sql .= " AND (LCASE(id.description) LIKE '%" . $this->db->escape(strtolower($data['filter_keyword'])) . "%') ";
			}
			
			if ($data['filter_blog_title'] == "true" && $data['filter_blog_description'] == "true") {
				$sql .= " AND (LCASE(id.title) LIKE '%" . $this->db->escape(strtolower($data['filter_keyword'])) . "%' OR LCASE(id.description) LIKE '%" . $this->db->escape(strtolower($data['filter_keyword'])) . "%' ) ";
			}
			
		}
		
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
		
	public function getLatestBlogs($data = array()) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "blog i LEFT JOIN " . DB_PREFIX . "blog_description id ON (i.blog_id = id.blog_id) LEFT JOIN " . DB_PREFIX . "blog_to_store i2s ON (i.blog_id = i2s.blog_id) WHERE id.language_id = '" . (int)$this->config->get('config_language_id') . "' AND i2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND i.status = '1' AND i.sort_order <> '-1' ORDER BY i.sort_order, i.blog_id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'] . "");
		
		return $query->rows;
	}
	
	public function getBlogsByBlogCategoryId($blog_category_id, $start = 0, $limit = 40) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "blog n LEFT JOIN " . DB_PREFIX . "blog_description nd ON (n.blog_id = nd.blog_id) LEFT JOIN " . DB_PREFIX . "blog_to_store n2s ON (n.blog_id = n2s.blog_id) LEFT JOIN " . DB_PREFIX . "blog_to_category n2c ON (n.blog_id = n2c.blog_id) WHERE nd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND n2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND n2c.blog_category_id = '" . (int)$blog_category_id . "' AND n.status = '1' AND n.sort_order <> '-1' ORDER BY n.sort_order, n.blog_id DESC LIMIT " . (int)$start . "," . (int)$limit);
		
		return $query->rows;
	}
	
	public function getTotalBlogsByBlogCategoryId($blog_category_id = 0) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "blog WHERE status = '1'");
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "blog_to_category n2c LEFT JOIN " . DB_PREFIX . "blog n ON (n2c.blog_id = n.blog_id) LEFT JOIN " . DB_PREFIX . "blog_to_store n2s ON (n.blog_id = n2s.blog_id) WHERE n.status = '1' AND n2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND n2c.blog_category_id = '" . (int)$blog_category_id . "'");
		
		return $query->row['total'];
	}
	
	public function getTotalBlogsPerCategory($data = array()) {
		$sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX ."blog n LEFT JOIN " . DB_PREFIX . "blog_to_store n2s ON (n.blog_id = n2s.blog_id) WHERE n.status = '1' AND n2s.store_id = '" . (int)$this->config->get('config_store_id') . "'";
		
		if (isset($data['filter_blog_category_id']) && $data['filter_blog_category_id']) {
			if (isset($data['filter_sub_blog_category']) && $data['filter_sub_blog_category']) {
				$implode_data = array();
				
				$this->load->model('extras/blog_category');
				
				$blog_categories = $this->model_extras_blog_category->getBlogCategoriesByParentId($data['filter_blog_category_id']);
				
				foreach ($blog_categories as $blog_category_id) {
					$implode_data[] = "n2c.blog_category_id = '" . (int)$blog_category_id . "'";
				}
				
				$sql .= " AND n.blog_id IN (SELECT n2c.blog_id FROM " . DB_PREFIX . "blog_to_category n2c WHERE " . implode(' OR ', $implode_data) . ")";			
			} else {
				$sql .= " AND n.blog_id IN (SELECT n2c.blog_id FROM " . DB_PREFIX . "blog_to_category n2c WHERE n2c.blog_category_id = '" . (int)$data['filter_blog_category_id'] . "')";
			}
		}
				
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
	public function updateBlogReadCounter($blog_id, $new_read_counter_value) {
	$this->db->query("UPDATE " . DB_PREFIX . "blog SET count_read = '" . (int)$new_read_counter_value . "' WHERE blog_id = '" . (int)$blog_id . "'");
   }
	
	public function getRelatedBlog($blog_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "blog n LEFT JOIN " . DB_PREFIX . "blog_description nd ON (n.blog_id = nd.blog_id) LEFT JOIN " . DB_PREFIX . "blog_to_store n2s ON (n.blog_id = n2s.blog_id) LEFT JOIN " . DB_PREFIX . "blog_related nr ON (n.blog_id = nr.child_blog_id) WHERE nd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND n2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND n.status = '1' AND n.sort_order <> '-1' AND nr.parent_blog_id = '" . (int)$blog_id. "' ORDER BY n.sort_order, n.blog_id DESC");
		
		return $query->rows;
	}
	
	public function addComment($blog_id, $name, $email, $comment, $comment_status) {
		$today_date = date("F j, Y, g:i a");
		
		$this->db->query("INSERT INTO " . DB_PREFIX . "blog_comment SET blog_id = '" . (int)$blog_id . "', name = '" . $this->db->escape($name) . "', email = '" . $this->db->escape($email) . "', comment = '" . $this->db->escape(strip_tags($comment)) . "', status = '" . (int)$comment_status . "',  date_added = NOW()");
	}
	
	public function getCommentsByBlogId($blog_id, $start = 0, $limit = 40) {
		$query = $this->db->query("SELECT nc.blog_id, nc.name, nc.email, nc.comment, n.blog_id, nd.title, n.image, nc.date_added FROM " . DB_PREFIX . "blog_comment nc LEFT JOIN " . DB_PREFIX . "blog n ON (nc.blog_id = n.blog_id) LEFT JOIN " . DB_PREFIX . "blog_description nd ON (n.blog_id = nd.blog_id) WHERE n.blog_id = '" . (int)$blog_id . "' AND n.status = '1' AND nc.status = '0' AND nd.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY nc.date_added DESC LIMIT " . (int)$start . "," . (int)$limit);
		
		return $query->rows;
	}
	
	public function getTotalCommentsByBlogId($blog_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "blog_comment nc LEFT JOIN " . DB_PREFIX . "blog n ON (nc.blog_id = n.blog_id) LEFT JOIN " . DB_PREFIX . "blog_description nd ON (n.blog_id = nd.blog_id) WHERE n.blog_id = '" . (int)$blog_id . "' AND n.status = '1' AND nc.status = '0' AND nd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row['total'];
	}
}
?>