<?php
class ControllerDesaccountOverall extends Controller {
	private $error = array();

	public function index() {
	if (!$this->designer->isLogged()) {
			$this->session->data['redirect'] = $this->url->link('desaccount/edit', '', 'SSL');

			$this->redirect($this->url->link('desaccount/login', '', 'SSL'));
		}
	
		$this->load->model('desaccount/designer');
		if(isset($_GET['cid'])) 
		{
		$this->data['hname'] = $this->model_desaccount_designer->GetHname($_GET['cid']).'(Contest # ' .$_GET['cid']  .')';
		} else {
		$this->data['hname'] = '';
		}

		$this->language->load('desaccount/overall');
		
		$this->document->setTitle($this->language->get('heading_title'));
		 
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
			$this->model_desaccount_designer->editCustomer($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->link('desaccount/desaccount', '', 'SSL'));
		}

      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),     	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_desaccount'),
			'href'      => $this->url->link('desaccount/desaccount', '', 'SSL'),        	
        	'separator' => $this->language->get('text_separator')
      	);

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_edit'),
			'href'      => $this->url->link('desaccount/overall', '', 'SSL'),       	
        	'separator' => $this->language->get('text_separator')
      	);
		
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_your_details'] = $this->language->get('text_your_details');

		$this->data['entry_firstname'] = $this->language->get('entry_firstname');
		$this->data['entry_lastname'] = $this->language->get('entry_lastname');
		$this->data['entry_email'] = $this->language->get('entry_email');
		$this->data['entry_fax'] = $this->language->get('entry_fax');
		$this->data['entry_password'] = $this->language->get('entry_password');
    	$this->data['entry_confirm'] = $this->language->get('entry_confirm');
    	$this->data['entry_dispname'] = $this->language->get('entry_dispname');
    	$this->data['entry_profpic'] = $this->language->get('entry_profpic');
		$this->data['text_browse'] = $this->language->get('text_browse');
		$this->data['text_clear'] = $this->language->get('text_clear');	
		$this->data['entry_gender'] = $this->language->get('entry_gender');	
		$this->data['text_male'] = $this->language->get('text_male');	
		$this->data['text_female'] = $this->language->get('text_female');	
		$this->data['text_english'] = $this->language->get('text_english');	
		$this->data['text_french'] = $this->language->get('text_french');	
		$this->data['text_italin'] = $this->language->get('text_italin');	
		$this->data['entry_yourself'] = $this->language->get('entry_yourself');	
		$this->data['entry_langknown'] = $this->language->get('entry_langknown');	
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
		$this->data['text_cheque'] = $this->language->get('text_cheque');
		$this->data['text_paypal'] = $this->language->get('text_paypal');
		$this->data['text_money'] = $this->language->get('text_money');
		$this->data['text_bank'] = $this->language->get('text_bank');
		$this->data['entry_paypalemail'] = $this->language->get('entry_paypalemail');

		$this->data['button_continue'] = $this->language->get('button_continue');
		$this->data['button_back'] = $this->language->get('button_back');

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['firstname'])) {
			$this->data['error_firstname'] = $this->error['firstname'];
		} else {
			$this->data['error_firstname'] = '';
		}

		if (isset($this->error['lastname'])) {
			$this->data['error_lastname'] = $this->error['lastname'];
		} else {
			$this->data['error_lastname'] = '';
		}
		
		if (isset($this->error['email'])) {
			$this->data['error_email'] = $this->error['email'];
		} else {
			$this->data['error_email'] = '';
		}	
	
		
		if (isset($this->error['password'])) { 
			$this->data['error_password'] = $this->error['password'];
		} else {
			$this->data['error_password'] = '';
		}

		if (isset($this->error['confirm'])) { 
			$this->data['error_confirm'] = $this->error['confirm'];
		} else {
			$this->data['error_confirm'] = '';
		}

		$this->data['action'] = $this->url->link('desaccount/overall', '', 'SSL');
		
		// Overall Entries Tab - Starts
		
		$this->data['sketch_masters'] = array();
		 
		$this->load->model('tool/image');
		
		$this->data['con_id'] = $_GET['cid'];
		
		$this->data['con_name'] =	$this->model_desaccount_designer->get_contest_name($this->data['con_id']);
		
		$results = $this->model_desaccount_designer->getsketchesmaster($this->data['con_id']);
		
		foreach ($results as $result) {
		
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], 175, 175);
			} else {
				$image = false;
			}
			
			$this->data['sketch_masters'][] = array(
					'contest_id'  => $result['contest_id'],
					'sketch_id'  => $result['sketch_id'],
					'rating'  => $result['rating'],
					'winner'  => $result['winner'],
					'eliminated'  => $result['eliminated'],
					'withdrawn'  => $result['withdrawn'],
					'reported'  => $result['reported'],
					'sketch_assignment_id'  => $result['sketch_assignment_id'],
					'designer_id'  => $this->model_desaccount_designer->getdesignername($result['designer_id']),
					'design_id'  => $result['designer_id'],
					'thumb'       => $image
				);
		} 
		
		// Overall Entries Tab - Ends
		
		// $this->data['attribute_groups'] = $this->model_desaccount_designer->get_designer_prof_pics();
		// Overall Designers Tab - Starts
		
		$this->data['profile_pics'] = array();
		
		$results = $this->model_desaccount_designer->get_designer_prof_pics();
		
		foreach ($results as $result) {
			if ($result['profileimg']) {
				$profileimg = $this->model_tool_image->resize($result['profileimg'], 140, 140);
			} else {
				$profileimg = false;
			}
			
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], 175, 175);
			} else {
				$image = false;
			}
				
		$this->data['profile_pics'][] = array(
					'thumb'       => $image,
					'designer_id'  => $result['designer_id'],
					'thumb_prof'       => $profileimg
				);
		}
		
		
		
		$this->data['customers'] = array();
		
		$results = $this->model_desaccount_designer->getCusdetails($this->data['con_id']);
		
		foreach ($results as $result) {
		
				$this->data['customers'][] = array(
					'customer_id'  			=> $result['customer_id'],
					'special_ocassion' 	 	=> $result['special_ocassion'],
					'prize_amount'  		=> $result['prize_amount'],
					'masculine_feminine'  	=> $result['masculine_feminine'],
					'youthful_mature'  		=> $result['youthful_mature'],
					'funky_graceful' 	 	=> $result['funky_graceful'],
					'bold_subtle'  			=> $result['bold_subtle'],
					'simple_intricate'  	=> $result['simple_intricate'],
					'classic_contemporary'  => $result['classic_contemporary'],
					'name'  			    => $result['firstname'].' '.$result['lastname'],
					'description'			=> $result['description'],
					'born'  				=> $result['born'],
					'email'  				=> $result['email']
				);
		}	
		
		$this->data['customers_uploads_img'] = $this->model_desaccount_designer->getCusdetails2($this->data['con_id']);		
		$this->data['customers_uploads_result'] = $this->model_tool_image->resize($this->data['customers_uploads_img'], 175, 175);
		if (! file_exists(DIR_NEWIMAGE .   $this->data['customers_uploads_img'] ) || $this->data['customers_uploads_img']=='') {
			$this->data['customers_uploads_img'] = 'no_img_avl.png';
		}
	
		
		// Overall Designers Tab - Ends
		
		
		// sketch id retriving from db - ends

		$this->data['sketch_ids'] = array();
		
		$results = $this->model_desaccount_designer->getsketchid($this->data['con_id']);	
		
		foreach ($results as $result) {
				$this->data['sketch_ids'][] = array(
					'sketch_id'  => $result['sketch_id'],
					'designer_id'  => $result['designer_id'],
					'rating'  => $result['rating'],
					'winner'  => $result['winner'],
					'eliminated'  => $result['eliminated'],
					'withdrawn'  => $result['withdrawn'],
					'sketch_assignment_id'  => $result['sketch_assignment_id'],
					'designer_name'  => $this->model_desaccount_designer->getdesignername($result['designer_id']),
					'designerimage'  => $this->model_tool_image->resize($result['designerimage'], 100, 100),
					'sketchimage'  => $this->model_tool_image->resize($result['sketchimage'], 170, 170)
				);
		}	
		$this->data['notdesigner_ids'] = array();
		$this->data['reporter'] = $this->model_desaccount_designer->getdesignername($this->designer->isLogged());
		$this->data['reporter_id'] = $this->designer->isLogged();

		$results = $this->model_desaccount_designer->getsketchidnot($this->data['con_id']);	
		
		foreach ($results as $result) {
				$this->data['notdesigner_ids'][] = array(
					'sketch_id'  => $result['sketch_id'],
					'designer_id'  => $result['designer_id'],
					'rating'  => $result['rating'],
					'winner'  => $result['winner'],
					'eliminated'  => $result['eliminated'],
					'withdrawn'  => $result['withdrawn'],
					'reported'  => $result['reported'],
					'sketch_assignment_id'  => $result['sketch_assignment_id'],
					'designer_name'  => $this->model_desaccount_designer->getdesignername($result['designer_id']),
					'designerimage'  => $this->model_tool_image->resize($result['designerimage'], 100, 100),
					'sketchimage'  => $this->model_tool_image->resize($result['sketchimage'], 170, 170)
				);
		}	


		$this->data['multi_images'] = array();
		
		$results = $this->model_desaccount_designer->getting_multi_imgs($this->data['con_id']);
		
		foreach ($results as $result) {
		
		/* if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], 175, 175);
			} else {
				$image = false;
		} */
			
		$this->data['multi_images'][] = array(
					'selectedimage'  => $this->model_tool_image->resize($result['image'], 170, 170)
		);
		
		}
		// sketch id retriving from db - ends
		
		$this->data['cus_comments'] = array();
		$results = $this->model_desaccount_designer->get_all_cus_comments($this->data['con_id']);
			
		foreach ($results as $result) {
			
		$this->data['cus_comments'][] = array(
					'comment'  => $result['comment'],
					'contest_id'  => $result['contest_id'],
					'customername'  => $this->model_desaccount_designer->get_cusid_cusname($result['customer_designer_id']),
					'creation_date_time'  => $result['creation_date_time']
					
		);
		
		}
		 
		if (isset($this->request->post['newsletter'])) {
			$this->data['newsletter'] = $this->request->post['newsletter'];
		} else {
			$this->data['newsletter'] = '';
		}
		
		if (isset($this->request->post['password'])) {
    		$this->data['password'] = $this->request->post['password'];
		} else {
			$this->data['password'] = '';
		}

		if (isset($this->request->post['confirm'])) {
    		$this->data['confirm'] = $this->request->post['confirm'];
		} else {
			$this->data['confirm'] = '';
		}
		
		// address Starts
		
		$this->data['button_edit'] = $this->language->get('button_edit');
		$this->data['entry_newsletter'] = $this->language->get('entry_newsletter');
    	$this->data['button_delete'] = $this->language->get('button_delete');
		
		$this->data['addresses'] = array();
		$this->load->model('desaccount/address');
		$results = $this->model_desaccount_address->getAddresses();

    	foreach ($results as $result) {
			if ($result['address_format']) {
      			$format = $result['address_format'];
    		} else {
				$format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
			}
		
    		$find = array(
	  			'{firstname}',
	  			'{lastname}',
	  			'{company}',
      			'{address_1}',
      			'{address_2}',
     			'{city}',
      			'{postcode}',
      			'{zone}',
				'{zone_code}',
      			'{country}'
			);
	
			$replace = array(
	  			'firstname' => $result['firstname'],
	  			'lastname'  => $result['lastname'],
	  			'company'   => $result['company'],
      			'address_1' => $result['address_1'],
      			'address_2' => $result['address_2'],
      			'city'      => $result['city'],
      			'postcode'  => $result['postcode'],
      			'zone'      => $result['zone'],
				'zone_code' => $result['zone_code'],
      			'country'   => $result['country']  
			);

      		$this->data['addresses'][] = array(
        		'address_id' => $result['address_id'],
        		'address'    => str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format)))),
        		'update'     => $this->url->link('desaccount/address/update', 'address_id=' . $result['address_id'], 'SSL'),
				'delete'     => $this->url->link('desaccount/address/delete', 'address_id=' . $result['address_id'], 'SSL')
      		);
    	}
		
		$this->data['newsletter'] = $this->customer->getNewsletter();
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		
		// address Ends

		$this->data['back'] = $this->url->link('desaccount/desaccount', '', 'SSL');

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/desaccount/overall.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/desaccount/overall.tpl';
		} else {
			$this->template = 'default/template/desaccount/overall.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());	
	}
	public function rating() {
		$this->db->query("UPDATE " . DB_PREFIX . "contest_sketch_assignment SET rating = '" . $this->request->get['rate'] . "' WHERE sketch_id = '" . $this->request->post['sketch_id'] . "'");
		  
	}
	public function item() {
		$this->db->query("UPDATE " . DB_PREFIX . "contest_sketch_assignment SET " . $this->request->get['title'] . " = 'y'  WHERE sketch_id = '" . $this->request->post['sketch_id'] . "'");
		  
	}

	private function validate() {
		if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen($this->request->post['firstname']) > 32)) {
			$this->error['firstname'] = $this->language->get('error_firstname');
		}

		if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen($this->request->post['lastname']) > 32)) {
			$this->error['lastname'] = $this->language->get('error_lastname');
		}

		if ((utf8_strlen($this->request->post['email']) > 96) || !preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $this->request->post['email'])) {
			$this->error['email'] = $this->language->get('error_email');
		}
		
		if (($this->customer->getEmail() != $this->request->post['email']) && $this->model_desaccount_designer->getTotalCustomersByEmail($this->request->post['email'])) {
			$this->error['warning'] = $this->language->get('error_exists');
		}


		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>