<?php 
class ControllerDesaccountAccount extends Controller { 
	public function index() {
		if (!$this->designer->isLogged()) {
	  		$this->session->data['redirect'] = $this->url->link('desaccount/edit', '', 'SSL');
	  
	  		$this->redirect($this->url->link('desaccount/login', '', 'SSL'));
    	} 
	
		$this->language->load('desaccount/account');

		$this->document->setTitle($this->language->get('heading_title'));

      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(       	
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('desaccount/account', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);
		
		if (isset($this->session->data['success'])) {
    		$this->data['success'] = $this->session->data['success'];
			
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
    	$this->data['heading_title'] = $this->language->get('heading_title');

    	$this->data['text_my_account'] = $this->language->get('text_my_account');
		$this->data['text_my_orders'] = $this->language->get('text_my_orders');
		$this->data['text_my_newsletter'] = $this->language->get('text_my_newsletter');
    	$this->data['text_edit'] = $this->language->get('text_edit');
    	$this->data['text_password'] = $this->language->get('text_password');
    	$this->data['text_address'] = $this->language->get('text_address');
		$this->data['text_wishlist'] = $this->language->get('text_wishlist');
    	$this->data['text_order'] = $this->language->get('text_order');
    	$this->data['text_download'] = $this->language->get('text_download');
		$this->data['text_reward'] = $this->language->get('text_reward');
		$this->data['text_return'] = $this->language->get('text_return');
		$this->data['text_transaction'] = $this->language->get('text_transaction');
		$this->data['text_newsletter'] = $this->language->get('text_newsletter');

    	$this->data['edit'] = $this->url->link('desaccount/edit', '', 'SSL');
    	$this->data['message'] = $this->url->link('desaccount/message', '', 'SSL');
    	$this->data['password'] = $this->url->link('desaccount/password', '', 'SSL');
		$this->data['address'] = $this->url->link('desaccount/address', '', 'SSL');
		$this->data['wishlist'] = $this->url->link('desaccount/wishlist');
    	$this->data['order'] = $this->url->link('desaccount/order', '', 'SSL');
    	$this->data['download'] = $this->url->link('desaccount/download', '', 'SSL');
		$this->data['reward'] = $this->url->link('desaccount/reward', '', 'SSL');
		$this->data['return'] = $this->url->link('desaccount/return', '', 'SSL');
		$this->data['transaction'] = $this->url->link('desaccount/transaction', '', 'SSL');
		$this->data['newsletter'] = $this->url->link('desaccount/newsletter', '', 'SSL');
		$this->data['deslogout'] = $this->url->link('desaccount/logout', '', 'SSL');
				
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/desaccount/account.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/desaccount/account.tpl';
		} else {
			$this->template = 'default/template/desaccount/account.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'		
		);
				
		$this->response->setOutput($this->render());
  	}
}
?>