<?php echo $header; ?>
<div id="content">
  <ul class="breadcrumb">
    <?php foreach ($breadcrumbs as $breadcrumb) { ?>
	    <li><?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
    <?php } ?>
  </ul>
  <?php echo $content_top; ?>
  
  <?php if ($thumb || $description) { ?>
  <div class="category-info">
    <?php if ($thumb) { //Category Image ?>
    	<div class="image"><img src="<?php echo $thumb; ?>" alt="<?php echo $heading_title; ?>" /></div>
    <?php } ?>
    <h1><?php echo $heading_title; //Category Title ?></h1>
    <?php if ($description) { ?>
        <div class="cat-desc">
            <?php echo $description; //Category Description ?>
        </div>
    <?php } ?>
    <div class="clear"></div>
  </div>
  <?php }else{ ?>
  	<h1><?php echo $heading_title; //Category Title ?></h1>  
  <?php } ?>
  <?php if ($categories) { ?>
  
  <div class="category-list">
  <h2><?php echo $text_refine; ?></h2>
    <?php if (count($categories) <= 5) { ?>
    <ul>
      <?php foreach ($categories as $category) { ?>
      <li><a href="<?php echo $category['href']; ?>"><?php echo $category['name']; ?></a></li>
      <?php } ?>
    </ul>
    <?php } else { ?>
    <?php for ($i = 0; $i < count($categories);) { ?>
    <ul>
      <?php $j = $i + ceil(count($categories) / 4); ?>
      <?php for (; $i < $j; $i++) { ?>
      <?php if (isset($categories[$i])) { ?>
      <li><a href="<?php echo $categories[$i]['href']; ?>"><?php echo $categories[$i]['name']; ?></a></li>
      <?php } ?>
      <?php } ?>
    </ul>
    <?php } ?>
    <?php } ?>
  </div>
  <?php } ?>
  <?php if ($products) { ?>
 	<?php include("includes/filter.tpl"); //Product Filters ?>
 
  <div id="cat-products" class="prod-grid">
  <ul>
    <?php $i=0; foreach ($products as $product) : $i++; ?>
    <li  <?php 
	  		if($i%4==0){ 
	  			echo 'class="last"';
			}elseif($i%2==0){
				echo 'class="second"';
			} 
		  ?>>
      <?php if ($product['thumb']): //Get product thumnails ?>
            <div class="image">
                <a href="<?php echo $product['href']; ?>"><img src="<?php echo $product['thumb']; ?>" title="<?php echo $product['name']; ?>" alt="<?php echo $product['name']; ?>" /></a>
                <?php if($product['special']) :?>
                	<span class="promo">promo</span>
            	<?php endif; ?>
            </div>
      <?php endif; ?>
       <div class="prodInfo">
          <div class="name">
                <h2><a href="<?php echo $product['href']; ?>"><?php echo $product['name']; //Get Product Name ?></a></h2>
          </div>
          <div class="description">
                <?php echo $product['description']; //Get Product Description ?>
          </div>
      <?php if ($product['price']) : //Get product price ?>
          <div class="price">
            <?php if (!$product['special']): ?>
               <p><?php echo $product['price']; ?></p>
            <?php else: ?>
                <p><span class="price-old"><?php echo $product['price']; ?></span> <span class="price-new"><?php echo $product['special']; ?></span></p>
            <?php endif; ?>
          </div>
      <?php endif; ?>
      <?php if ($product['rating']) { ?>
     		 <div class="rating"><img src="catalog/view/theme/teez/image/stars-<?php echo $product['rating']; ?>.png" alt="<?php echo $product['reviews']; ?>" /></div>
      <?php } ?>
      <div class="addTo">
      	 <div class="cart"><a onclick="addToCart('<?php echo $product['product_id']; ?>');" class="button"><span><?php echo $button_cart; ?></span></a></div>
     	 <div class="wishlist"><a onclick="addToWishList('<?php echo $product['product_id']; ?>');"><?php echo $button_wishlist; ?></a></div>
      	 <div class="compare"><a onclick="addToCompare('<?php echo $product['product_id']; ?>');" data-reveal-id="notification"><?php echo $button_compare; ?></a></div>
         <div class="clear"></div>
      </div>
      </div>
      <div class="clear"></div>
    </li>
    <?php endforeach; ?>
    </ul>
    <div class="clear"></div>
  </div>
  <div class="pagination"><?php echo $pagination; ?></div>
  <?php } ?>
  <?php if (!$categories && !$products) { ?>
  <div class="content"><?php echo $text_empty; ?></div>
  <div class="buttons">
    <div class="right"><a href="<?php echo $continue; ?>" class="button"><span><?php echo $button_continue; ?></span></a></div>
  </div>
  <?php } ?>
</div>

<?php echo $footer; ?>