<?php
class ControllerSettingSetting extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('setting/setting');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

			$this->model_setting_setting->editSetting('config', $this->request->post);

			if ($this->config->get('config_currency_auto')) {
				$this->load->model('localisation/currency');

				$this->model_localisation_currency->updateCurrencies();
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->link('setting/store', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_none'] = $this->language->get('text_none');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
 		$this->data['text_browse'] = $this->language->get('text_browse');
		$this->data['text_clear'] = $this->language->get('text_clear');
		$this->data['text_shipping'] = $this->language->get('text_shipping');
		$this->data['text_payment'] = $this->language->get('text_payment');
		$this->data['text_mail'] = $this->language->get('text_mail');
		$this->data['text_smtp'] = $this->language->get('text_smtp');
		   $this->data['entry_additionalCosts'] = $this->language->get('entry_additionalCosts');
		    $this->data['entry_OverridingMarkUpAbsolute'] = $this->language->get('entry_OverridingMarkUpAbsolute');
	    	$this->data['entry_OverridingMarkupPercentage'] = $this->language->get('entry_OverridingMarkupPercentage');
		$this->data['entry_name'] = $this->language->get('entry_name');
		$this->data['entry_owner'] = $this->language->get('entry_owner');
		$this->data['entry_address'] = $this->language->get('entry_address');
		$this->data['entry_email'] = $this->language->get('entry_email');
		$this->data['entry_telephone'] = $this->language->get('entry_telephone');
		$this->data['entry_fax'] = $this->language->get('entry_fax');
		$this->data['entry_title'] = $this->language->get('entry_title');
		$this->data['entry_meta_description'] = $this->language->get('entry_meta_description');
		$this->data['entry_layout'] = $this->language->get('entry_layout');
		$this->data['entry_template'] = $this->language->get('entry_template');
		$this->data['entry_country'] = $this->language->get('entry_country');
		$this->data['entry_zone'] = $this->language->get('entry_zone');
		$this->data['entry_language'] = $this->language->get('entry_language');
		$this->data['entry_admin_language'] = $this->language->get('entry_admin_language');
		$this->data['entry_currency'] = $this->language->get('entry_currency');
		$this->data['entry_currency_auto'] = $this->language->get('entry_currency_auto');
		$this->data['entry_length_class'] = $this->language->get('entry_length_class');
		$this->data['entry_weight_class'] = $this->language->get('entry_weight_class');
		$this->data['entry_catalog_limit'] = $this->language->get('entry_catalog_limit');
		$this->data['entry_admin_limit'] = $this->language->get('entry_admin_limit');
		$this->data['entry_tax'] = $this->language->get('entry_tax');
		$this->data['entry_tax_default'] = $this->language->get('entry_tax_default');
		$this->data['entry_tax_customer'] = $this->language->get('entry_tax_customer');
		$this->data['entry_invoice_prefix'] = $this->language->get('entry_invoice_prefix');
		$this->data['entry_customer_group'] = $this->language->get('entry_customer_group');
		$this->data['entry_customer_price'] = $this->language->get('entry_customer_price');
		$this->data['entry_customer_approval'] = $this->language->get('entry_customer_approval');
		$this->data['entry_guest_checkout'] = $this->language->get('entry_guest_checkout');
		$this->data['entry_account'] = $this->language->get('entry_account');
		$this->data['entry_checkout'] = $this->language->get('entry_checkout');
		$this->data['entry_affiliate'] = $this->language->get('entry_affiliate');
		$this->data['entry_commission'] = $this->language->get('entry_commission');
		$this->data['entry_stock_display'] = $this->language->get('entry_stock_display');
		$this->data['entry_stock_warning'] = $this->language->get('entry_stock_warning');
		$this->data['entry_stock_checkout'] = $this->language->get('entry_stock_checkout');
		$this->data['entry_order_status'] = $this->language->get('entry_order_status');
		$this->data['entry_complete_status'] = $this->language->get('entry_complete_status');
		$this->data['entry_return_status'] = $this->language->get('entry_return_status');
		$this->data['entry_stock_status'] = $this->language->get('entry_stock_status');
		$this->data['entry_review'] = $this->language->get('entry_review');
		$this->data['entry_download'] = $this->language->get('entry_download');
		$this->data['entry_upload_allowed'] = $this->language->get('entry_upload_allowed');
		$this->data['entry_cart_weight'] = $this->language->get('entry_cart_weight');
		$this->data['entry_logo'] = $this->language->get('entry_logo');
		$this->data['entry_icon'] = $this->language->get('entry_icon');
		$this->data['entry_image_category'] = $this->language->get('entry_image_category');
		$this->data['entry_image_thumb'] = $this->language->get('entry_image_thumb');
		$this->data['entry_image_popup'] = $this->language->get('entry_image_popup');
		$this->data['entry_image_product'] = $this->language->get('entry_image_product');
		$this->data['entry_image_additional'] = $this->language->get('entry_image_additional');
		$this->data['entry_image_related'] = $this->language->get('entry_image_related');
		$this->data['entry_image_compare'] = $this->language->get('entry_image_compare');
		$this->data['entry_image_wishlist'] = $this->language->get('entry_image_wishlist');
		$this->data['entry_image_cart'] = $this->language->get('entry_image_cart');
		$this->data['entry_mail_protocol'] = $this->language->get('entry_mail_protocol');
		$this->data['entry_mail_parameter'] = $this->language->get('entry_mail_parameter');
		$this->data['entry_smtp_host'] = $this->language->get('entry_smtp_host');
		$this->data['entry_smtp_username'] = $this->language->get('entry_smtp_username');
		$this->data['entry_smtp_password'] = $this->language->get('entry_smtp_password');
		$this->data['entry_smtp_port'] = $this->language->get('entry_smtp_port');
		$this->data['entry_smtp_timeout'] = $this->language->get('entry_smtp_timeout');
		$this->data['entry_alert_mail'] = $this->language->get('entry_alert_mail');
		$this->data['entry_account_mail'] = $this->language->get('entry_account_mail');
		$this->data['entry_alert_emails'] = $this->language->get('entry_alert_emails');
		$this->data['entry_use_ssl'] = $this->language->get('entry_use_ssl');
		$this->data['entry_maintenance'] = $this->language->get('entry_maintenance');
		$this->data['entry_encryption'] = $this->language->get('entry_encryption');
		$this->data['entry_seo_url'] = $this->language->get('entry_seo_url');
		$this->data['entry_compression'] = $this->language->get('entry_compression');
		$this->data['entry_error_display'] = $this->language->get('entry_error_display');
		$this->data['entry_error_log'] = $this->language->get('entry_error_log');
		$this->data['entry_error_filename'] = $this->language->get('entry_error_filename');
		$this->data['entry_google_analytics'] = $this->language->get('entry_google_analytics');

		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');
		$this->data['tab_store'] = $this->language->get('tab_store');
		$this->data['tab_local'] = $this->language->get('tab_local');
		$this->data['tab_option'] = $this->language->get('tab_option');
		$this->data['tab_image'] = $this->language->get('tab_image');
		$this->data['tab_mail'] = $this->language->get('tab_mail');
		$this->data['tab_server'] = $this->language->get('tab_server');

		$this->data['token'] = $this->session->data['token'];

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['name'])) {
			$this->data['error_name'] = $this->error['name'];
		} else {
			$this->data['error_name'] = '';
		}

 		if (isset($this->error['owner'])) {
			$this->data['error_owner'] = $this->error['owner'];
		} else {
			$this->data['error_owner'] = '';
		}

 		if (isset($this->error['address'])) {
			$this->data['error_address'] = $this->error['address'];
		} else {
			$this->data['error_address'] = '';
		}

 		if (isset($this->error['email'])) {
			$this->data['error_email'] = $this->error['email'];
		} else {
			$this->data['error_email'] = '';
		}

		if (isset($this->error['telephone'])) {
			$this->data['error_telephone'] = $this->error['telephone'];
		} else {
			$this->data['error_telephone'] = '';
		}

  		if (isset($this->error['title'])) {
			$this->data['error_title'] = $this->error['title'];
		} else {
			$this->data['error_title'] = '';
		}

 		if (isset($this->error['image_category'])) {
			$this->data['error_image_category'] = $this->error['image_category'];
		} else {
			$this->data['error_image_category'] = '';
		}

 		if (isset($this->error['image_thumb'])) {
			$this->data['error_image_thumb'] = $this->error['image_thumb'];
		} else {
			$this->data['error_image_thumb'] = '';
		}

 		if (isset($this->error['image_popup'])) {
			$this->data['error_image_popup'] = $this->error['image_popup'];
		} else {
			$this->data['error_image_popup'] = '';
		}

 		if (isset($this->error['image_product'])) {
			$this->data['error_image_product'] = $this->error['image_product'];
		} else {
			$this->data['error_image_product'] = '';
		}

 		if (isset($this->error['image_additional'])) {
			$this->data['error_image_additional'] = $this->error['image_additional'];
		} else {
			$this->data['error_image_additional'] = '';
		}

 		if (isset($this->error['image_related'])) {
			$this->data['error_image_related'] = $this->error['image_related'];
		} else {
			$this->data['error_image_related'] = '';
		}

 		if (isset($this->error['image_compare'])) {
			$this->data['error_image_compare'] = $this->error['image_compare'];
		} else {
			$this->data['error_image_compare'] = '';
		}

  		if (isset($this->error['image_wishlist'])) {
			$this->data['error_image_wishlist'] = $this->error['image_wishlist'];
		} else {
			$this->data['error_image_wishlist'] = '';
		}

		if (isset($this->error['image_cart'])) {
			$this->data['error_image_cart'] = $this->error['image_cart'];
		} else {
			$this->data['error_image_cart'] = '';
		}

		if (isset($this->error['error_filename'])) {
			$this->data['error_error_filename'] = $this->error['error_filename'];
		} else {
			$this->data['error_error_filename'] = '';
		}

		if (isset($this->error['catalog_limit'])) {
			$this->data['error_catalog_limit'] = $this->error['catalog_limit'];
		} else {
			$this->data['error_catalog_limit'] = '';
		}

		if (isset($this->error['admin_limit'])) {
			$this->data['error_admin_limit'] = $this->error['admin_limit'];
		} else {
			$this->data['error_admin_limit'] = '';
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('setting/setting', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		$this->data['action'] = $this->url->link('setting/setting', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['cancel'] = $this->url->link('setting/store', 'token=' . $this->session->data['token'], 'SSL');
		
		if (isset($this->request->post['config_name'])) {
			$this->data['config_name'] = $this->request->post['config_name'];
		} else {
			$this->data['config_name'] = $this->config->get('config_name');
		}

		if (isset($this->request->post['config_owner'])) {
			$this->data['config_owner'] = $this->request->post['config_owner'];
		} else {
			$this->data['config_owner'] = $this->config->get('config_owner');
		}

		if (isset($this->request->post['config_address'])) {
			$this->data['config_address'] = $this->request->post['config_address'];
		} else {
			$this->data['config_address'] = $this->config->get('config_address');
		}

		if (isset($this->request->post['config_email'])) {
			$this->data['config_email'] = $this->request->post['config_email'];
		} else {
			$this->data['config_email'] = $this->config->get('config_email');
		}

		if (isset($this->request->post['config_telephone'])) {
			$this->data['config_telephone'] = $this->request->post['config_telephone'];
		} else {
			$this->data['config_telephone'] = $this->config->get('config_telephone');
		}

		if (isset($this->request->post['config_fax'])) {
			$this->data['config_fax'] = $this->request->post['config_fax'];
		} else {
			$this->data['config_fax'] = $this->config->get('config_fax');
		}

		if (isset($this->request->post['config_title'])) {
			$this->data['config_title'] = $this->request->post['config_title'];
		} else {
			$this->data['config_title'] = $this->config->get('config_title');
		}

		if (isset($this->request->post['config_meta_description'])) {
			$this->data['config_meta_description'] = $this->request->post['config_meta_description'];
		} else {
			$this->data['config_meta_description'] = $this->config->get('config_meta_description');
		}

		if (isset($this->request->post['config_layout_id'])) {
			$this->data['config_layout_id'] = $this->request->post['config_layout_id'];
		} else {
			$this->data['config_layout_id'] = $this->config->get('config_layout_id');
		}

		$this->load->model('design/layout');

		$this->data['layouts'] = $this->model_design_layout->getLayouts();

		if (isset($this->request->post['config_template'])) {
			$this->data['config_template'] = $this->request->post['config_template'];
		} else {
			$this->data['config_template'] = $this->config->get('config_template');
		}

		$this->data['templates'] = array();

		$directories = glob(DIR_CATALOG . 'view/theme/*', GLOB_ONLYDIR);

		foreach ($directories as $directory) {
			$this->data['templates'][] = basename($directory);
		}

		if (isset($this->request->post['config_country_id'])) {
			$this->data['config_country_id'] = $this->request->post['config_country_id'];
		} else {
			$this->data['config_country_id'] = $this->config->get('config_country_id');
		}

		$this->load->model('localisation/country');

		$this->data['countries'] = $this->model_localisation_country->getCountries();

		if (isset($this->request->post['config_zone_id'])) {
			$this->data['config_zone_id'] = $this->request->post['config_zone_id'];
		} else {
			$this->data['config_zone_id'] = $this->config->get('config_zone_id');
		}

		if (isset($this->request->post['config_language'])) {
			$this->data['config_language'] = $this->request->post['config_language'];
		} else {
			$this->data['config_language'] = $this->config->get('config_language');
		}

		$this->load->model('localisation/language');

		$this->data['languages'] = $this->model_localisation_language->getLanguages();

		if (isset($this->request->post['config_admin_language'])) {
			$this->data['config_admin_language'] = $this->request->post['config_admin_language'];
		} else {
			$this->data['config_admin_language'] = $this->config->get('config_admin_language');
		}

		if (isset($this->request->post['config_currency'])) {
			$this->data['config_currency'] = $this->request->post['config_currency'];
		} else {
			$this->data['config_currency'] = $this->config->get('config_currency');
		}

		if (isset($this->request->post['config_currency_auto'])) {
			$this->data['config_currency_auto'] = $this->request->post['config_currency_auto'];
		} else {
			$this->data['config_currency_auto'] = $this->config->get('config_currency_auto');
		}

		$this->load->model('localisation/currency');

		$this->data['currencies'] = $this->model_localisation_currency->getCurrencies();

		if (isset($this->request->post['config_length_class_id'])) {
			$this->data['config_length_class_id'] = $this->request->post['config_length_class_id'];
		} else {
			$this->data['config_length_class_id'] = $this->config->get('config_length_class_id');
		}

		$this->load->model('localisation/length_class');

		$this->data['length_classes'] = $this->model_localisation_length_class->getLengthClasses();

		if (isset($this->request->post['config_weight_class_id'])) {
			$this->data['config_weight_class_id'] = $this->request->post['config_weight_class_id'];
		} else {
			$this->data['config_weight_class_id'] = $this->config->get('config_weight_class_id');
		}

		$this->load->model('localisation/weight_class');

		$this->data['weight_classes'] = $this->model_localisation_weight_class->getWeightClasses();

		if (isset($this->request->post['config_catalog_limit'])) {
			$this->data['config_catalog_limit'] = $this->request->post['config_catalog_limit'];
		} else {
			$this->data['config_catalog_limit'] = $this->config->get('config_catalog_limit');
		}

		if (isset($this->request->post['config_admin_limit'])) {
			$this->data['config_admin_limit'] = $this->request->post['config_admin_limit'];
		} else {
			$this->data['config_admin_limit'] = $this->config->get('config_admin_limit');
		}

		if (isset($this->request->post['config_tax'])) {
			$this->data['config_tax'] = $this->request->post['config_tax'];
		} else {
			$this->data['config_tax'] = $this->config->get('config_tax');
		}

		if (isset($this->request->post['config_tax_default'])) {
			$this->data['config_tax_default'] = $this->request->post['config_tax_default'];
		} else {
			$this->data['config_tax_default'] = $this->config->get('config_tax_default');
		}

		if (isset($this->request->post['config_tax_customer'])) {
			$this->data['config_tax_customer'] = $this->request->post['config_tax_customer'];
		} else {
			$this->data['config_tax_customer'] = $this->config->get('config_tax_customer');
		}

		if (isset($this->request->post['config_invoice_prefix'])) {
			$this->data['config_invoice_prefix'] = $this->request->post['config_invoice_prefix'];
		} elseif ($this->config->get('config_invoice_prefix')) {
			$this->data['config_invoice_prefix'] = $this->config->get('config_invoice_prefix');
		} else {
			$this->data['config_invoice_prefix'] = 'INV-' . date('Y') . '-00';
		}

		$this->load->model('sale/customer_group');

		$this->data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();

		if (isset($this->request->post['config_customer_group_id'])) {
			$this->data['config_customer_group_id'] = $this->request->post['config_customer_group_id'];
		} else {
			$this->data['config_customer_group_id'] = $this->config->get('config_customer_group_id');
		}

		if (isset($this->request->post['config_customer_price'])) {
			$this->data['config_customer_price'] = $this->request->post['config_customer_price'];
		} else {
			$this->data['config_customer_price'] = $this->config->get('config_customer_price');
		}

		if (isset($this->request->post['config_customer_approval'])) {
			$this->data['config_customer_approval'] = $this->request->post['config_customer_approval'];
		} else {
			$this->data['config_customer_approval'] = $this->config->get('config_customer_approval');
		}

		if (isset($this->request->post['config_guest_checkout'])) {
			$this->data['config_guest_checkout'] = $this->request->post['config_guest_checkout'];
		} else {
			$this->data['config_guest_checkout'] = $this->config->get('config_guest_checkout');
		}

		if (isset($this->request->post['config_account_id'])) {
			$this->data['config_account_id'] = $this->request->post['config_account_id'];
		} else {
			$this->data['config_account_id'] = $this->config->get('config_account_id');
		}

		if (isset($this->request->post['config_checkout_id'])) {
			$this->data['config_checkout_id'] = $this->request->post['config_checkout_id'];
		} else {
			$this->data['config_checkout_id'] = $this->config->get('config_checkout_id');
		}

		if (isset($this->request->post['config_affiliate_id'])) {
			$this->data['config_affiliate_id'] = $this->request->post['config_affiliate_id'];
		} else {
			$this->data['config_affiliate_id'] = $this->config->get('config_affiliate_id');
		}

		if (isset($this->request->post['config_commission'])) {
			$this->data['config_commission'] = $this->request->post['config_commission'];
		} elseif ($this->config->has('config_commission')) {
			$this->data['config_commission'] = $this->config->get('config_commission');
		} else {
			$this->data['config_commission'] = '5.00';
		}

		$this->load->model('catalog/information');

		$this->data['informations'] = $this->model_catalog_information->getInformations();

		if (isset($this->request->post['config_stock_display'])) {
			$this->data['config_stock_display'] = $this->request->post['config_stock_display'];
		} else {
			$this->data['config_stock_display'] = $this->config->get('config_stock_display');
		}

		if (isset($this->request->post['config_stock_warning'])) {
			$this->data['config_stock_warning'] = $this->request->post['config_stock_warning'];
		} else {
			$this->data['config_stock_warning'] = $this->config->get('config_stock_warning');
		}

		if (isset($this->request->post['config_stock_checkout'])) {
			$this->data['config_stock_checkout'] = $this->request->post['config_stock_checkout'];
		} else {
			$this->data['config_stock_checkout'] = $this->config->get('config_stock_checkout');
		}

		if (isset($this->request->post['config_stock_status_id'])) {
			$this->data['config_stock_status_id'] = $this->request->post['config_stock_status_id'];
		} else {
			$this->data['config_stock_status_id'] = $this->config->get('config_stock_status_id');
		}

		$this->load->model('localisation/stock_status');

		$this->data['stock_statuses'] = $this->model_localisation_stock_status->getStockStatuses();

		if (isset($this->request->post['config_order_status_id'])) {
			$this->data['config_order_status_id'] = $this->request->post['config_order_status_id'];
		} else {
			$this->data['config_order_status_id'] = $this->config->get('config_order_status_id');
		}

		$this->load->model('localisation/order_status');

		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['config_complete_status_id'])) {
			$this->data['config_complete_status_id'] = $this->request->post['config_complete_status_id'];
		} else {
			$this->data['config_complete_status_id'] = $this->config->get('config_complete_status_id');
		}

		if (isset($this->request->post['config_return_status_id'])) {
			$this->data['config_return_status_id'] = $this->request->post['config_return_status_id'];
		} else {
			$this->data['config_return_status_id'] = $this->config->get('config_return_status_id');
		}

		$this->load->model('localisation/return_status');

		$this->data['return_statuses'] = $this->model_localisation_return_status->getReturnStatuses();

		if (isset($this->request->post['config_review_status'])) {
			$this->data['config_review_status'] = $this->request->post['config_review_status'];
		} else {
			$this->data['config_review_status'] = $this->config->get('config_review_status');
		}

		if (isset($this->request->post['config_download'])) {
			$this->data['config_download'] = $this->request->post['config_download'];
		} else {
			$this->data['config_download'] = $this->config->get('config_download');
		}

		if (isset($this->request->post['config_upload_allowed'])) {
			$this->data['config_upload_allowed'] = $this->request->post['config_upload_allowed'];
		} else {
			$this->data['config_upload_allowed'] = $this->config->get('config_upload_allowed');
		}

		if (isset($this->request->post['config_cart_weight'])) {
			$this->data['config_cart_weight'] = $this->request->post['config_cart_weight'];
		} else {
			$this->data['config_cart_weight'] = $this->config->get('config_cart_weight');
		}

		$this->load->model('tool/image');

		if (isset($this->request->post['config_logo'])) {
			$this->data['config_logo'] = $this->request->post['config_logo'];
		} else {
			$this->data['config_logo'] = $this->config->get('config_logo');
		}

		if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo')) && is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
			$this->data['logo'] = $this->model_tool_image->resize($this->config->get('config_logo'), 100, 100);
		} else {
			$this->data['logo'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		}

		if (isset($this->request->post['config_icon'])) {
			$this->data['config_icon'] = $this->request->post['config_icon'];
		} else {
			$this->data['config_icon'] = $this->config->get('config_icon');
		}

		if ($this->config->get('config_icon') && file_exists(DIR_IMAGE . $this->config->get('config_icon')) && is_file(DIR_IMAGE . $this->config->get('config_icon'))) {
			$this->data['icon'] = $this->model_tool_image->resize($this->config->get('config_icon'), 100, 100);
		} else {
			$this->data['icon'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		}

		$this->data['no_image'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);

		if (isset($this->request->post['config_image_category_width'])) {
			$this->data['config_image_category_width'] = $this->request->post['config_image_category_width'];
		} else {
			$this->data['config_image_category_width'] = $this->config->get('config_image_category_width');
		}

		if (isset($this->request->post['config_image_category_height'])) {
			$this->data['config_image_category_height'] = $this->request->post['config_image_category_height'];
		} else {
			$this->data['config_image_category_height'] = $this->config->get('config_image_category_height');
		}

		if (isset($this->request->post['config_image_thumb_width'])) {
			$this->data['config_image_thumb_width'] = $this->request->post['config_image_thumb_width'];
		} else {
			$this->data['config_image_thumb_width'] = $this->config->get('config_image_thumb_width');
		}

		if (isset($this->request->post['config_image_thumb_height'])) {
			$this->data['config_image_thumb_height'] = $this->request->post['config_image_thumb_height'];
		} else {
			$this->data['config_image_thumb_height'] = $this->config->get('config_image_thumb_height');
		}

		if (isset($this->request->post['config_image_popup_width'])) {
			$this->data['config_image_popup_width'] = $this->request->post['config_image_popup_width'];
		} else {
			$this->data['config_image_popup_width'] = $this->config->get('config_image_popup_width');
		}

		if (isset($this->request->post['config_image_popup_height'])) {
			$this->data['config_image_popup_height'] = $this->request->post['config_image_popup_height'];
		} else {
			$this->data['config_image_popup_height'] = $this->config->get('config_image_popup_height');
		}

		if (isset($this->request->post['config_image_product_width'])) {
			$this->data['config_image_product_width'] = $this->request->post['config_image_product_width'];
		} else {
			$this->data['config_image_product_width'] = $this->config->get('config_image_product_width');
		}

		if (isset($this->request->post['config_image_product_height'])) {
			$this->data['config_image_product_height'] = $this->request->post['config_image_product_height'];
		} else {
			$this->data['config_image_product_height'] = $this->config->get('config_image_product_height');
		}

		if (isset($this->request->post['config_image_additional_width'])) {
			$this->data['config_image_additional_width'] = $this->request->post['config_image_additional_width'];
		} else {
			$this->data['config_image_additional_width'] = $this->config->get('config_image_additional_width');
		}

		if (isset($this->request->post['config_image_additional_height'])) {
			$this->data['config_image_additional_height'] = $this->request->post['config_image_additional_height'];
		} else {
			$this->data['config_image_additional_height'] = $this->config->get('config_image_additional_height');
		}

		if (isset($this->request->post['config_image_related_width'])) {
			$this->data['config_image_related_width'] = $this->request->post['config_image_related_width'];
		} else {
			$this->data['config_image_related_width'] = $this->config->get('config_image_related_width');
		}

		if (isset($this->request->post['config_image_related_height'])) {
			$this->data['config_image_related_height'] = $this->request->post['config_image_related_height'];
		} else {
			$this->data['config_image_related_height'] = $this->config->get('config_image_related_height');
		}

		if (isset($this->request->post['config_image_compare_width'])) {
			$this->data['config_image_compare_width'] = $this->request->post['config_image_compare_width'];
		} else {
			$this->data['config_image_compare_width'] = $this->config->get('config_image_compare_width');
		}

		if (isset($this->request->post['config_image_compare_height'])) {
			$this->data['config_image_compare_height'] = $this->request->post['config_image_compare_height'];
		} else {
			$this->data['config_image_compare_height'] = $this->config->get('config_image_compare_height');
		}

		if (isset($this->request->post['config_image_wishlist_width'])) {
			$this->data['config_image_wishlist_width'] = $this->request->post['config_image_wishlist_width'];
		} else {
			$this->data['config_image_wishlist_width'] = $this->config->get('config_image_wishlist_width');
		}

		if (isset($this->request->post['config_image_wishlist_height'])) {
			$this->data['config_image_wishlist_height'] = $this->request->post['config_image_wishlist_height'];
		} else {
			$this->data['config_image_wishlist_height'] = $this->config->get('config_image_wishlist_height');
		}

		if (isset($this->request->post['config_image_cart_width'])) {
			$this->data['config_image_cart_width'] = $this->request->post['config_image_cart_width'];
		} else {
			$this->data['config_image_cart_width'] = $this->config->get('config_image_cart_width');
		}

		if (isset($this->request->post['config_image_cart_height'])) {
			$this->data['config_image_cart_height'] = $this->request->post['config_image_cart_height'];
		} else {
			$this->data['config_image_cart_height'] = $this->config->get('config_image_cart_height');
		}

		if (isset($this->request->post['config_mail_protocol'])) {
			$this->data['config_mail_protocol'] = $this->request->post['config_mail_protocol'];
		} else {
			$this->data['config_mail_protocol'] = $this->config->get('config_mail_protocol');
		}

		if (isset($this->request->post['config_mail_parameter'])) {
			$this->data['config_mail_parameter'] = $this->request->post['config_mail_parameter'];
		} else {
			$this->data['config_mail_parameter'] = $this->config->get('config_mail_parameter');
		}

		if (isset($this->request->post['config_smtp_host'])) {
			$this->data['config_smtp_host'] = $this->request->post['config_smtp_host'];
		} else {
			$this->data['config_smtp_host'] = $this->config->get('config_smtp_host');
		}

		if (isset($this->request->post['pricelimit_one'])) {
			$this->data['pricelimit_one'] = $this->request->post['pricelimit_one'];
		} else {
			$this->data['pricelimit_one'] = $this->config->get('pricelimit_one');
		}

		if (isset($this->request->post['pricelimit_two'])) {
			$this->data['pricelimit_two'] = $this->request->post['pricelimit_two'];
		} else {
			$this->data['pricelimit_two'] = $this->config->get('pricelimit_two');
		}

		if (isset($this->request->post['pricelimit_three'])) {
			$this->data['pricelimit_three'] = $this->request->post['pricelimit_three'];
		} else {
			$this->data['pricelimit_three'] = $this->config->get('pricelimit_three');
		}

		if (isset($this->request->post['pricelimit_four'])) {
			$this->data['pricelimit_four'] = $this->request->post['pricelimit_four'];
		} else {
			$this->data['pricelimit_four'] = $this->config->get('pricelimit_four');
		}

		if (isset($this->request->post['pricelimit_five'])) {
			$this->data['pricelimit_five'] = $this->request->post['pricelimit_five'];
		} else {
			$this->data['pricelimit_five'] = $this->config->get('pricelimit_five');
		}

		if (isset($this->request->post['additionalcost_one'])) {
			$this->data['additionalcost_one'] = $this->request->post['additionalcost_one'];
		} else {
			$this->data['additionalcost_one'] = $this->config->get('additionalcost_one');
		}

		if (isset($this->request->post['additionalcost_two'])) {
			$this->data['additionalcost_two'] = $this->request->post['additionalcost_two'];
		} else {
			$this->data['additionalcost_two'] = $this->config->get('additionalcost_two');
		}

		if (isset($this->request->post['additionalcost_three'])) {
			$this->data['additionalcost_three'] = $this->request->post['additionalcost_three'];
		} else {
			$this->data['additionalcost_three'] = $this->config->get('additionalcost_three');
		}

		if (isset($this->request->post['additionalcost_four'])) {
			$this->data['additionalcost_four'] = $this->request->post['additionalcost_four'];
		} else {
			$this->data['additionalcost_four'] = $this->config->get('additionalcost_four');
		}

		if (isset($this->request->post['additionalcost_five'])) {
			$this->data['additionalcost_five'] = $this->request->post['additionalcost_five'];
		} else {
			$this->data['additionalcost_five'] = $this->config->get('additionalcost_five');
		}

		if (isset($this->request->post['overriding_one'])) {
			$this->data['overriding_one'] = $this->request->post['overriding_one'];
		} else {
			$this->data['overriding_one'] = $this->config->get('overriding_one');
		}

		if (isset($this->request->post['overriding_two'])) {
			$this->data['overriding_two'] = $this->request->post['overriding_two'];
		} else {
			$this->data['overriding_two'] = $this->config->get('overriding_two');
		}

		if (isset($this->request->post['overriding_three'])) {
			$this->data['overriding_three'] = $this->request->post['overriding_three'];
		} else {
			$this->data['overriding_three'] = $this->config->get('overriding_three');
		}

		if (isset($this->request->post['overriding_four'])) {
			$this->data['overriding_four'] = $this->request->post['overriding_four'];
		} else {
			$this->data['overriding_four'] = $this->config->get('overriding_four');
		}

		if (isset($this->request->post['overriding_five'])) {
			$this->data['overriding_five'] = $this->request->post['overriding_five'];
		} else {
			$this->data['overriding_five'] = $this->config->get('overriding_five');
		}


		if (isset($this->request->post['wholeoverriding_one'])) {
			$this->data['wholeoverriding_one'] = $this->request->post['wholeoverriding_one'];
		} else {
			$this->data['wholeoverriding_one'] = $this->config->get('wholeoverriding_one');
		}

		if (isset($this->request->post['wholeoverriding_two'])) {
			$this->data['wholeoverriding_two'] = $this->request->post['wholeoverriding_two'];
		} else {
			$this->data['wholeoverriding_two'] = $this->config->get('wholeoverriding_two');
		}

		if (isset($this->request->post['wholeoverriding_three'])) {
			$this->data['wholeoverriding_three'] = $this->request->post['wholeoverriding_three'];
		} else {
			$this->data['wholeoverriding_three'] = $this->config->get('wholeoverriding_three');
		}

		if (isset($this->request->post['wholeoverriding_four'])) {
			$this->data['wholeoverriding_four'] = $this->request->post['wholeoverriding_four'];
		} else {
			$this->data['wholeoverriding_four'] = $this->config->get('wholeoverriding_four');
		}

		if (isset($this->request->post['wholeoverriding_five'])) {
			$this->data['wholeoverriding_five'] = $this->request->post['wholeoverriding_five'];
		} else {
			$this->data['wholeoverriding_five'] = $this->config->get('wholeoverriding_five');
		}


		if (isset($this->request->post['wholemarkup_one'])) {
			$this->data['wholemarkup_one'] = $this->request->post['wholemarkup_one'];
		} else {
			$this->data['wholemarkup_one'] = $this->config->get('wholemarkup_one');
		}

		if (isset($this->request->post['wholemarkup_two'])) {
			$this->data['wholemarkup_two'] = $this->request->post['wholemarkup_two'];
		} else {
			$this->data['wholemarkup_two'] = $this->config->get('wholemarkup_two');
		}

		if (isset($this->request->post['wholemarkup_three'])) {
			$this->data['wholemarkup_three'] = $this->request->post['wholemarkup_three'];
		} else {
			$this->data['wholemarkup_three'] = $this->config->get('wholemarkup_three');
		}

		if (isset($this->request->post['wholemarkup_four'])) {
			$this->data['wholemarkup_four'] = $this->request->post['wholemarkup_four'];
		} else {
			$this->data['wholemarkup_four'] = $this->config->get('wholemarkup_four');
		}

		if (isset($this->request->post['wholemarkup_five'])) {
			$this->data['wholemarkup_five'] = $this->request->post['wholemarkup_five'];
		} else {
			$this->data['wholemarkup_five'] = $this->config->get('wholemarkup_five');
		}

		if (isset($this->request->post['additionalCosts'])) {
			$this->data['additionalCosts'] = $this->request->post['additionalCosts'];
		} else {
			$this->data['additionalCosts'] = $this->config->get('additionalCosts');
		}
		// Diamond New Fields
		if (isset($this->request->post['overriding_markup_diamond_percentage'])) {
			$this->data['overriding_markup_diamond_percentage'] = $this->request->post['overriding_markup_diamond_percentage'];
		} else {
			$this->data['overriding_markup_diamond_percentage'] = $this->config->get('overriding_markup_diamond_percentage');
		}
		if (isset($this->request->post['additionalDiamondCosts'])) {
			$this->data['additionalDiamondCosts'] = $this->request->post['additionalDiamondCosts'];
		} else {
			$this->data['additionalDiamondCosts'] = $this->config->get('additionalDiamondCosts');
		}

		if (isset($this->request->post['pricelimit_1'])) {
			$this->data['pricelimit_1'] = $this->request->post['pricelimit_1'];
		} else {
			$this->data['pricelimit_1'] = $this->config->get('pricelimit_1');
		}

		if (isset($this->request->post['pricelimit_2'])) {
			$this->data['pricelimit_2'] = $this->request->post['pricelimit_2'];
		} else {
			$this->data['pricelimit_2'] = $this->config->get('pricelimit_2');
		}

		if (isset($this->request->post['pricelimit_3'])) {
			$this->data['pricelimit_3'] = $this->request->post['pricelimit_3'];
		} else {
			$this->data['pricelimit_3'] = $this->config->get('pricelimit_3');
		}

		if (isset($this->request->post['pricelimit_4'])) {
			$this->data['pricelimit_4'] = $this->request->post['pricelimit_4'];
		} else {
			$this->data['pricelimit_4'] = $this->config->get('pricelimit_4');
		}

		if (isset($this->request->post['pricelimit_5'])) {
			$this->data['pricelimit_5'] = $this->request->post['pricelimit_5'];
		} else {
			$this->data['pricelimit_5'] = $this->config->get('pricelimit_5');
		}
		if (isset($this->request->post['pricelimit_6'])) {
			$this->data['pricelimit_6'] = $this->request->post['pricelimit_6'];
		} else {
			$this->data['pricelimit_6'] = $this->config->get('pricelimit_6');
		}

		if (isset($this->request->post['pricelimit_7'])) {
			$this->data['pricelimit_7'] = $this->request->post['pricelimit_7'];
		} else {
			$this->data['pricelimit_7'] = $this->config->get('pricelimit_7');
		}

		if (isset($this->request->post['pricelimit_8'])) {
			$this->data['pricelimit_8'] = $this->request->post['pricelimit_8'];
		} else {
			$this->data['pricelimit_8'] = $this->config->get('pricelimit_8');
		}

		if (isset($this->request->post['pricelimit_9'])) {
			$this->data['pricelimit_9'] = $this->request->post['pricelimit_9'];
		} else {
			$this->data['pricelimit_9'] = $this->config->get('pricelimit_9');
		}

		if (isset($this->request->post['pricelimit_10'])) {
			$this->data['pricelimit_10'] = $this->request->post['pricelimit_10'];
		} else {
			$this->data['pricelimit_10'] = $this->config->get('pricelimit_10');
		}


		if (isset($this->request->post['additionalcost_1'])) {
			$this->data['additionalcost_1'] = $this->request->post['additionalcost_1'];
		} else {
			$this->data['additionalcost_1'] = $this->config->get('additionalcost_1');
		}

		if (isset($this->request->post['additionalcost_2'])) {
			$this->data['additionalcost_2'] = $this->request->post['additionalcost_2'];
		} else {
			$this->data['additionalcost_2'] = $this->config->get('additionalcost_2');
		}

		if (isset($this->request->post['additionalcost_3'])) {
			$this->data['additionalcost_3'] = $this->request->post['additionalcost_3'];
		} else {
			$this->data['additionalcost_3'] = $this->config->get('additionalcost_3');
		}

		if (isset($this->request->post['additionalcost_4'])) {
			$this->data['additionalcost_4'] = $this->request->post['additionalcost_4'];
		} else {
			$this->data['additionalcost_4'] = $this->config->get('additionalcost_4');
		}

		if (isset($this->request->post['additionalcost_5'])) {
			$this->data['additionalcost_5'] = $this->request->post['additionalcost_5'];
		} else {
			$this->data['additionalcost_5'] = $this->config->get('additionalcost_5');
		}
		if (isset($this->request->post['additionalcost_6'])) {
			$this->data['additionalcost_6'] = $this->request->post['additionalcost_6'];
		} else {
			$this->data['additionalcost_6'] = $this->config->get('additionalcost_6');
		}

		if (isset($this->request->post['additionalcost_7'])) {
			$this->data['additionalcost_7'] = $this->request->post['additionalcost_7'];
		} else {
			$this->data['additionalcost_7'] = $this->config->get('additionalcost_7');
		}

		if (isset($this->request->post['additionalcost_8'])) {
			$this->data['additionalcost_8'] = $this->request->post['additionalcost_8'];
		} else {
			$this->data['additionalcost_8'] = $this->config->get('additionalcost_8');
		}

		if (isset($this->request->post['additionalcost_9'])) {
			$this->data['additionalcost_9'] = $this->request->post['additionalcost_9'];
		} else {
			$this->data['additionalcost_9'] = $this->config->get('additionalcost_9');
		}

		if (isset($this->request->post['additionalcost_10'])) {
			$this->data['additionalcost_10'] = $this->request->post['additionalcost_10'];
		} else {
			$this->data['additionalcost_10'] = $this->config->get('additionalcost_10');
		}



		if (isset($this->request->post['additionalcostpercent_1'])) {
			$this->data['additionalcostpercent_1'] = $this->request->post['additionalcostpercent_1'];
		} else {
			$this->data['additionalcostpercent_1'] = $this->config->get('additionalcostpercent_1');
		}

		if (isset($this->request->post['additionalcostpercent_2'])) {
			$this->data['additionalcostpercent_2'] = $this->request->post['additionalcostpercent_2'];
		} else {
			$this->data['additionalcostpercent_2'] = $this->config->get('additionalcostpercent_2');
		}

		if (isset($this->request->post['additionalcostpercent_3'])) {
			$this->data['additionalcostpercent_3'] = $this->request->post['additionalcostpercent_3'];
		} else {
			$this->data['additionalcostpercent_3'] = $this->config->get('additionalcostpercent_3');
		}

		if (isset($this->request->post['additionalcostpercent_4'])) {
			$this->data['additionalcostpercent_4'] = $this->request->post['additionalcostpercent_4'];
		} else {
			$this->data['additionalcostpercent_4'] = $this->config->get('additionalcostpercent_4');
		}

		if (isset($this->request->post['additionalcostpercent_5'])) {
			$this->data['additionalcostpercent_5'] = $this->request->post['additionalcostpercent_5'];
		} else {
			$this->data['additionalcostpercent_5'] = $this->config->get('additionalcostpercent_5');
		}
		if (isset($this->request->post['additionalcostpercent_6'])) {
			$this->data['additionalcostpercent_6'] = $this->request->post['additionalcostpercent_6'];
		} else {
			$this->data['additionalcostpercent_6'] = $this->config->get('additionalcostpercent_6');
		}

		if (isset($this->request->post['additionalcostpercent_7'])) {
			$this->data['additionalcostpercent_7'] = $this->request->post['additionalcostpercent_7'];
		} else {
			$this->data['additionalcostpercent_7'] = $this->config->get('additionalcostpercent_7');
		}

		if (isset($this->request->post['additionalcostpercent_8'])) {
			$this->data['additionalcostpercent_8'] = $this->request->post['additionalcostpercent_8'];
		} else {
			$this->data['additionalcostpercent_8'] = $this->config->get('additionalcostpercent_8');
		}

		if (isset($this->request->post['additionalcostpercent_9'])) {
			$this->data['additionalcostpercent_9'] = $this->request->post['additionalcostpercent_9'];
		} else {
			$this->data['additionalcostpercent_9'] = $this->config->get('additionalcostpercent_9');
		}

		if (isset($this->request->post['additionalcostpercent_10'])) {
			$this->data['additionalcostpercent_10'] = $this->request->post['additionalcostpercent_10'];
		} else {
			$this->data['additionalcostpercent_10'] = $this->config->get('additionalcostpercent_10');
		}


		if (isset($this->request->post['overriding_1'])) {
			$this->data['overriding_1'] = $this->request->post['overriding_1'];
		} else {
			$this->data['overriding_1'] = $this->config->get('overriding_1');
		}

		if (isset($this->request->post['overriding_2'])) {
			$this->data['overriding_2'] = $this->request->post['overriding_2'];
		} else {
			$this->data['overriding_2'] = $this->config->get('overriding_2');
		}

		if (isset($this->request->post['overriding_3'])) {
			$this->data['overriding_3'] = $this->request->post['overriding_3'];
		} else {
			$this->data['overriding_3'] = $this->config->get('overriding_3');
		}

		if (isset($this->request->post['overriding_4'])) {
			$this->data['overriding_4'] = $this->request->post['overriding_4'];
		} else {
			$this->data['overriding_4'] = $this->config->get('overriding_4');
		}

		if (isset($this->request->post['overriding_5'])) {
			$this->data['overriding_5'] = $this->request->post['overriding_5'];
		} else {
			$this->data['overriding_5'] = $this->config->get('overriding_5');
		}
		if (isset($this->request->post['overriding_6'])) {
			$this->data['overriding_6'] = $this->request->post['overriding_6'];
		} else {
			$this->data['overriding_6'] = $this->config->get('overriding_6');
		}

		if (isset($this->request->post['overriding_7'])) {
			$this->data['overriding_7'] = $this->request->post['overriding_7'];
		} else {
			$this->data['overriding_7'] = $this->config->get('overriding_7');
		}

		if (isset($this->request->post['overriding_8'])) {
			$this->data['overriding_8'] = $this->request->post['overriding_8'];
		} else {
			$this->data['overriding_8'] = $this->config->get('overriding_8');
		}

		if (isset($this->request->post['overriding_9'])) {
			$this->data['overriding_9'] = $this->request->post['overriding_9'];
		} else {
			$this->data['overriding_9'] = $this->config->get('overriding_9');
		}

		if (isset($this->request->post['overriding_10'])) {
			$this->data['overriding_10'] = $this->request->post['overriding_10'];
		} else {
			$this->data['overriding_10'] = $this->config->get('overriding_10');
		}


		if (isset($this->request->post['wholeoverriding_1'])) {
			$this->data['wholeoverriding_1'] = $this->request->post['wholeoverriding_1'];
		} else {
			$this->data['wholeoverriding_1'] = $this->config->get('wholeoverriding_1');
		}

		if (isset($this->request->post['wholewholeoverriding_2'])) {
			$this->data['wholeoverriding_2'] = $this->request->post['wholeoverriding_2'];
		} else {
			$this->data['wholeoverriding_2'] = $this->config->get('wholeoverriding_2');
		}

		if (isset($this->request->post['wholeoverriding_3'])) {
			$this->data['wholeoverriding_3'] = $this->request->post['wholeoverriding_3'];
		} else {
			$this->data['wholeoverriding_3'] = $this->config->get('wholeoverriding_3');
		}

		if (isset($this->request->post['wholeoverriding_4'])) {
			$this->data['wholeoverriding_4'] = $this->request->post['wholeoverriding_4'];
		} else {
			$this->data['wholeoverriding_4'] = $this->config->get('wholeoverriding_4');
		}

		if (isset($this->request->post['wholeoverriding_5'])) {
			$this->data['wholeoverriding_5'] = $this->request->post['wholeoverriding_5'];
		} else {
			$this->data['wholeoverriding_5'] = $this->config->get('wholeoverriding_5');
		}
		if (isset($this->request->post['wholeoverriding_6'])) {
			$this->data['wholeoverriding_6'] = $this->request->post['wholeoverriding_6'];
		} else {
			$this->data['wholeoverriding_6'] = $this->config->get('wholeoverriding_6');
		}

		if (isset($this->request->post['wholeoverriding_7'])) {
			$this->data['wholeoverriding_7'] = $this->request->post['wholeoverriding_7'];
		} else {
			$this->data['wholeoverriding_7'] = $this->config->get('wholeoverriding_7');
		}

		if (isset($this->request->post['wholeoverriding_8'])) {
			$this->data['wholeoverriding_8'] = $this->request->post['wholeoverriding_8'];
		} else {
			$this->data['wholeoverriding_8'] = $this->config->get('wholeoverriding_8');
		}

		if (isset($this->request->post['wholeoverriding_9'])) {
			$this->data['wholeoverriding_9'] = $this->request->post['wholeoverriding_9'];
		} else {
			$this->data['wholeoverriding_9'] = $this->config->get('wholeoverriding_9');
		}

		if (isset($this->request->post['wholeoverriding_10'])) {
			$this->data['wholeoverriding_10'] = $this->request->post['wholeoverriding_10'];
		} else {
			$this->data['wholeoverriding_10'] = $this->config->get('wholeoverriding_10');
		}


		if (isset($this->request->post['pricelimit_11'])) {
			$this->data['pricelimit_11'] = $this->request->post['pricelimit_11'];
		} else {
			$this->data['pricelimit_11'] = $this->config->get('pricelimit_11');
		}

		if (isset($this->request->post['pricelimit_12'])) {
			$this->data['pricelimit_12'] = $this->request->post['pricelimit_12'];
		} else {
			$this->data['pricelimit_12'] = $this->config->get('pricelimit_12');
		}

		if (isset($this->request->post['pricelimit_13'])) {
			$this->data['pricelimit_13'] = $this->request->post['pricelimit_13'];
		} else {
			$this->data['pricelimit_13'] = $this->config->get('pricelimit_13');
		}

		if (isset($this->request->post['pricelimit_14'])) {
			$this->data['pricelimit_14'] = $this->request->post['pricelimit_14'];
		} else {
			$this->data['pricelimit_14'] = $this->config->get('pricelimit_14');
		}

		if (isset($this->request->post['additionalcost_11'])) {
			$this->data['additionalcost_11'] = $this->request->post['additionalcost_11'];
		} else {
			$this->data['additionalcost_11'] = $this->config->get('additionalcost_11');
		}

		if (isset($this->request->post['additionalcost_12'])) {
			$this->data['additionalcost_12'] = $this->request->post['additionalcost_12'];
		} else {
			$this->data['additionalcost_12'] = $this->config->get('additionalcost_12');
		}

		if (isset($this->request->post['additionalcost_13'])) {
			$this->data['additionalcost_13'] = $this->request->post['additionalcost_13'];
		} else {
			$this->data['additionalcost_13'] = $this->config->get('additionalcost_13');
		}

		if (isset($this->request->post['additionalcost_14'])) {
			$this->data['additionalcost_14'] = $this->request->post['additionalcost_14'];
		} else {
			$this->data['additionalcost_14'] = $this->config->get('additionalcost_14');
		}

		if (isset($this->request->post['additionalcostpercent_11'])) {
			$this->data['additionalcostpercent_11'] = $this->request->post['additionalcostpercent_11'];
		} else {
			$this->data['additionalcostpercent_11'] = $this->config->get('additionalcostpercent_11');
		}

		if (isset($this->request->post['additionalcostpercent_12'])) {
			$this->data['additionalcostpercent_12'] = $this->request->post['additionalcostpercent_12'];
		} else {
			$this->data['additionalcostpercent_12'] = $this->config->get('additionalcostpercent_12');
		}

		if (isset($this->request->post['additionalcostpercent_13'])) {
			$this->data['additionalcostpercent_13'] = $this->request->post['additionalcostpercent_13'];
		} else {
			$this->data['additionalcostpercent_13'] = $this->config->get('additionalcostpercent_13');
		}

		if (isset($this->request->post['additionalcostpercent_14'])) {
			$this->data['additionalcostpercent_14'] = $this->request->post['additionalcostpercent_14'];
		} else {
			$this->data['additionalcostpercent_14'] = $this->config->get('additionalcostpercent_14');
		}


		if (isset($this->request->post['overriding_11'])) {
			$this->data['overriding_11'] = $this->request->post['overriding_11'];
		} else {
			$this->data['overriding_11'] = $this->config->get('overriding_11');
		}

		if (isset($this->request->post['overriding_12'])) {
			$this->data['overriding_12'] = $this->request->post['overriding_12'];
		} else {
			$this->data['overriding_12'] = $this->config->get('overriding_12');
		}

		if (isset($this->request->post['overriding_13'])) {
			$this->data['overriding_13'] = $this->request->post['overriding_13'];
		} else {
			$this->data['overriding_13'] = $this->config->get('overriding_13');
		}

		if (isset($this->request->post['overriding_14'])) {
			$this->data['overriding_14'] = $this->request->post['overriding_14'];
		} else {
			$this->data['overriding_14'] = $this->config->get('overriding_14');
		}


		if (isset($this->request->post['wholeoverriding_11'])) {
			$this->data['wholeoverriding_11'] = $this->request->post['wholeoverriding_11'];
		} else {
			$this->data['wholeoverriding_11'] = $this->config->get('wholeoverriding_11');
		}

		if (isset($this->request->post['wholeoverriding_12'])) {
			$this->data['wholeoverriding_12'] = $this->request->post['wholeoverriding_12'];
		} else {
			$this->data['wholeoverriding_12'] = $this->config->get('wholeoverriding_12');
		}

		if (isset($this->request->post['wholeoverriding_13'])) {
			$this->data['wholeoverriding_13'] = $this->request->post['wholeoverriding_13'];
		} else {
			$this->data['wholeoverriding_13'] = $this->config->get('wholeoverriding_13');
		}

		if (isset($this->request->post['wholeoverriding_14'])) {
			$this->data['wholeoverriding_14'] = $this->request->post['wholeoverriding_14'];
		} else {
			$this->data['wholeoverriding_14'] = $this->config->get('wholeoverriding_14');
		}



if (isset($this->request->post['rapneturl'])) {
			$this->data['rapneturl'] = $this->request->post['rapneturl'];
		} else {
			$this->data['rapneturl'] = $this->config->get('rapneturl');
		}
if (isset($this->request->post['designer_reward_sale_based'])) {
			$this->data['designer_reward_sale_based'] = $this->request->post['designer_reward_sale_based'];
		} else {
			$this->data['designer_reward_sale_based'] = $this->config->get('designer_reward_sale_based');
		}
if (isset($this->request->post['customer_reward_sale_based'])) {
			$this->data['customer_reward_sale_based'] = $this->request->post['customer_reward_sale_based'];
		} else {
			$this->data['customer_reward_sale_based'] = $this->config->get('customer_reward_sale_based');
		}
if (isset($this->request->post['group_reward_sale_based'])) {
			$this->data['group_reward_sale_based'] = $this->request->post['group_reward_sale_based'];
		} else {
			$this->data['group_reward_sale_based'] = $this->config->get('group_reward_sale_based');
		}

if (isset($this->request->post['overriding_mark_up_ubsolute'])) {
			$this->data['overriding_mark_up_ubsolute'] = $this->request->post['overriding_mark_up_ubsolute'];
		} else {
			$this->data['overriding_mark_up_ubsolute'] = $this->config->get('overriding_mark_up_ubsolute');
		}

if (isset($this->request->post['overriding_markup_percentage'])) {
			$this->data['overriding_markup_percentage'] = $this->request->post['overriding_markup_percentage'];
		} else {
			$this->data['overriding_markup_percentage'] = $this->config->get('overriding_markup_percentage');
		}

		if (isset($this->request->post['config_smtp_username'])) {
			$this->data['config_smtp_username'] = $this->request->post['config_smtp_username'];
		} else {
			$this->data['config_smtp_username'] = $this->config->get('config_smtp_username');
		}

		if (isset($this->request->post['config_smtp_password'])) {
			$this->data['config_smtp_password'] = $this->request->post['config_smtp_password'];
		} else {
			$this->data['config_smtp_password'] = $this->config->get('config_smtp_password');
		}

		if (isset($this->request->post['config_smtp_port'])) {
			$this->data['config_smtp_port'] = $this->request->post['config_smtp_port'];
		} elseif ($this->config->get('config_smtp_port')) {
			$this->data['config_smtp_port'] = $this->config->get('config_smtp_port');
		} else {
			$this->data['config_smtp_port'] = 25;
		}

		if (isset($this->request->post['config_smtp_timeout'])) {
			$this->data['config_smtp_timeout'] = $this->request->post['config_smtp_timeout'];
		} elseif ($this->config->get('config_smtp_timeout')) {
			$this->data['config_smtp_timeout'] = $this->config->get('config_smtp_timeout');
		} else {
			$this->data['config_smtp_timeout'] = 5;
		}

		if (isset($this->request->post['config_alert_mail'])) {
			$this->data['config_alert_mail'] = $this->request->post['config_alert_mail'];
		} else {
			$this->data['config_alert_mail'] = $this->config->get('config_alert_mail');
		}

		if (isset($this->request->post['config_account_mail'])) {
			$this->data['config_account_mail'] = $this->request->post['config_account_mail'];
		} else {
			$this->data['config_account_mail'] = $this->config->get('config_account_mail');
		}

		if (isset($this->request->post['config_alert_emails'])) {
			$this->data['config_alert_emails'] = $this->request->post['config_alert_emails'];
		} else {
			$this->data['config_alert_emails'] = $this->config->get('config_alert_emails');
		}

		if (isset($this->request->post['config_use_ssl'])) {
			$this->data['config_use_ssl'] = $this->request->post['config_use_ssl'];
		} else {
			$this->data['config_use_ssl'] = $this->config->get('config_use_ssl');
		}

		if (isset($this->request->post['config_seo_url'])) {
			$this->data['config_seo_url'] = $this->request->post['config_seo_url'];
		} else {
			$this->data['config_seo_url'] = $this->config->get('config_seo_url');
		}

		if (isset($this->request->post['config_maintenance'])) {
			$this->data['config_maintenance'] = $this->request->post['config_maintenance'];
		} else {
			$this->data['config_maintenance'] = $this->config->get('config_maintenance');
		}

		if (isset($this->request->post['config_encryption'])) {
			$this->data['config_encryption'] = $this->request->post['config_encryption'];
		} else {
			$this->data['config_encryption'] = $this->config->get('config_encryption');
		}

		if (isset($this->request->post['config_compression'])) {
			$this->data['config_compression'] = $this->request->post['config_compression'];
		} else {
			$this->data['config_compression'] = $this->config->get('config_compression');
		}

		if (isset($this->request->post['config_error_display'])) {
			$this->data['config_error_display'] = $this->request->post['config_error_display'];
		} else {
			$this->data['config_error_display'] = $this->config->get('config_error_display');
		}

		if (isset($this->request->post['config_error_log'])) {
			$this->data['config_error_log'] = $this->request->post['config_error_log'];
		} else {
			$this->data['config_error_log'] = $this->config->get('config_error_log');
		}

		if (isset($this->request->post['config_error_filename'])) {
			$this->data['config_error_filename'] = $this->request->post['config_error_filename'];
		} else {
			$this->data['config_error_filename'] = $this->config->get('config_error_filename');
		}

		if (isset($this->request->post['config_google_analytics'])) {
			$this->data['config_google_analytics'] = $this->request->post['config_google_analytics'];
		} else {
			$this->data['config_google_analytics'] = $this->config->get('config_google_analytics');
		}

		$this->template = 'setting/setting.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render());
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'setting/setting')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['config_name']) {
			$this->error['name'] = $this->language->get('error_name');
		}

		if ((utf8_strlen($this->request->post['config_owner']) < 3) || (utf8_strlen($this->request->post['config_owner']) > 64)) {
			$this->error['owner'] = $this->language->get('error_owner');
		}

		if ((utf8_strlen($this->request->post['config_address']) < 3) || (utf8_strlen($this->request->post['config_address']) > 256)) {
			$this->error['address'] = $this->language->get('error_address');
		}

    	if ((utf8_strlen($this->request->post['config_email']) > 96) || !preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $this->request->post['config_email'])) {
      		$this->error['email'] = $this->language->get('error_email');
    	}

    	if ((utf8_strlen($this->request->post['config_telephone']) < 3) || (utf8_strlen($this->request->post['config_telephone']) > 32)) {
      		$this->error['telephone'] = $this->language->get('error_telephone');
    	}

		if (!$this->request->post['config_title']) {
			$this->error['title'] = $this->language->get('error_title');
		}

		if (!$this->request->post['config_image_category_width'] || !$this->request->post['config_image_category_height']) {
			$this->error['image_category'] = $this->language->get('error_image_category');
		}

		if (!$this->request->post['config_image_thumb_width'] || !$this->request->post['config_image_thumb_height']) {
			$this->error['image_thumb'] = $this->language->get('error_image_thumb');
		}

		if (!$this->request->post['config_image_popup_width'] || !$this->request->post['config_image_popup_height']) {
			$this->error['image_popup'] = $this->language->get('error_image_popup');
		}

		if (!$this->request->post['config_image_product_width'] || !$this->request->post['config_image_product_height']) {
			$this->error['image_product'] = $this->language->get('error_image_product');
		}

		if (!$this->request->post['config_image_additional_width'] || !$this->request->post['config_image_additional_height']) {
			$this->error['image_additional'] = $this->language->get('error_image_additional');
		}

		if (!$this->request->post['config_image_related_width'] || !$this->request->post['config_image_related_height']) {
			$this->error['image_related'] = $this->language->get('error_image_related');
		}

		if (!$this->request->post['config_image_compare_width'] || !$this->request->post['config_image_compare_height']) {
			$this->error['image_compare'] = $this->language->get('error_image_compare');
		}

		if (!$this->request->post['config_image_wishlist_width'] || !$this->request->post['config_image_wishlist_height']) {
			$this->error['image_wishlist'] = $this->language->get('error_image_wishlist');
		}

		if (!$this->request->post['config_image_cart_width'] || !$this->request->post['config_image_cart_height']) {
			$this->error['image_cart'] = $this->language->get('error_image_cart');
		}

		if (!$this->request->post['config_error_filename']) {
			$this->error['error_filename'] = $this->language->get('error_error_filename');
		}

		if (!$this->request->post['config_admin_limit']) {
			$this->error['admin_limit'] = $this->language->get('error_limit');
		}

		if (!$this->request->post['config_catalog_limit']) {
			$this->error['catalog_limit'] = $this->language->get('error_limit');
		}

		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

	public function template() {
		$template = basename($this->request->get['template']);

		if (file_exists(DIR_IMAGE . 'templates/' . $template . '.png')) {
			$image = HTTPS_IMAGE . 'templates/' . $template . '.png';
		} else {
			$image = HTTPS_IMAGE . 'no_image.jpg';
		}

		$this->response->setOutput('<img src="' . $image . '" alt="" title="" style="border: 1px solid #EEEEEE;" />');
	}

	public function zone() {
		$output = '';

		$this->load->model('localisation/zone');

		$results = $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']);

		foreach ($results as $result) {
			$output .= '<option value="' . $result['zone_id'] . '"';

			if (isset($this->request->get['zone_id']) && ($this->request->get['zone_id'] == $result['zone_id'])) {
				$output .= ' selected="selected"';
			}

			$output .= '>' . $result['name'] . '</option>';
		}

		if (!$results) {
			$output .= '<option value="0">' . $this->language->get('text_none') . '</option>';
		}

		$this->response->setOutput($output);
	}
}
?>
