<?php
class ControllerSalecolorclarity extends Controller {
	private $error = array();
  
	public function index() {
		$this->load->language('sale/colorclarity');
 
		$this->document->setTitle($this->language->get('heading_title'));
 		
		$this->load->model('sale/colorclarity');
		
		$this->getList();
	}

	public function insert() {
		$this->load->language('sale/colorclarity');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/colorclarity');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_colorclarity->addCustomerGroup($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/colorclarity', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function update() {
		$this->load->language('sale/colorclarity');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/colorclarity');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_sale_colorclarity->editCustomerGroup($this->request->get['colorclarity_id'], $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/colorclarity', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function delete() { 
		$this->load->language('sale/colorclarity');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('sale/colorclarity');
		
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
      		foreach ($this->request->post['selected'] as $colorclarity_id) {
				$this->model_sale_colorclarity->deleteCustomerGroup($colorclarity_id);	
			}
						
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('sale/colorclarity', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getList();
	}

	private function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'metal_code';
		}
		 
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}	
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
			
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/colorclarity', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
							
		$this->data['insert'] = $this->url->link('sale/colorclarity/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('sale/colorclarity/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');	
	
		$this->data['colorclaritys'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$colorclarity_total = $this->model_sale_colorclarity->getTotalCustomerGroups();
		
		$results = $this->model_sale_colorclarity->getCustomerGroups($data);

		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('sale/colorclarity/update', 'token=' . $this->session->data['token'] . '&colorclarity_id=' . $result['colorclarity_id'] . $url, 'SSL')
			);		
		
			$this->data['colorclaritys'][] = array(
				'colorclarity_id' => $result['colorclarity_id'],
				'gemstone_id' => $result['gemstone_id'],
				'gemname' => $result['gemname'],
				'clarity_id' => $result['clarity_id'],
				'colour_id' => $result['colour_id'],
				'selected'          => isset($this->request->post['selected']) && in_array($result['colorclarity_id'], $this->request->post['selected']),
				'action'            => $action
			);
		}	
	
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_pricebycart'] = $this->language->get('column_pricebycart');
		$this->data['column_gemstone'] = $this->language->get('column_gemstone');
		$this->data['column_action'] = $this->language->get('column_action');
		$this->data['column_clarity'] = $this->language->get('column_clarity');
		$this->data['column_color'] = $this->language->get('column_color');
		$this->data['column_claritycode'] = $this->language->get('column_claritycode');
		$this->data['column_colorcode'] = $this->language->get('column_colorcode');

		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
 
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['sort_metal_code'] = $this->url->link('sale/colorclarity', 'token=' . $this->session->data['token'] . '&sort=metal_code' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $colorclarity_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('sale/colorclarity', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		
		$this->data['pagination'] = $pagination->render();				

		$this->data['sort'] = $sort; 
		$this->data['order'] = $order;

		$this->template = 'sale/colorclarity_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
 	}

	private function getForm() {
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['entry_lowweight'] = $this->language->get('entry_lowweight');
		$this->data['entry_highweight'] = $this->language->get('entry_highweight');
		$this->data['entry_cost'] = $this->language->get('entry_cost');
		$this->data['entry_appilicablecost'] = $this->language->get('entry_appilicablecost');
		$this->data['entry_pricebycart'] = $this->language->get('entry_pricebycart');
		$this->data['entry_gemstone'] = $this->language->get('entry_gemstone');
		$this->data['entry_clarity'] = $this->language->get('entry_clarity');
		$this->data['entry_color'] = $this->language->get('entry_color');
		$this->data['entry_claritycode'] = $this->language->get('entry_claritycode');
		$this->data['entry_colorcode'] = $this->language->get('entry_colorcode');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

		$this->load->model('sale/clarity_master');
			
		$this->data['claritymasters'] = $this->model_sale_clarity_master->getCustomerGroups();
	
	
		$this->load->model('sale/colour_master');
			
		$this->data['colourmaster'] = $this->model_sale_colour_master->getCustomerGroups();
		
		$this->load->model('sale/gemstone');
			
		$this->data['gemshapes'] = $this->model_sale_gemstone->getCustomerGroups();

		$this->load->model('sale/gemstonelist');
			
		$this->data['gemstones'] = $this->model_sale_gemstonelist->getCustomerGroups();	
		
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['gemstone_id'])) {
			$this->data['error_gemstone'] = $this->error['gemstone_id'];
		} else {
			$this->data['error_gemstone'] = '';
		}
		
 		if (isset($this->error['clarity_id'])) {
			$this->data['error_clarity'] = $this->error['clarity_id'];
		} else {
			$this->data['error_clarity'] = '';
		}
		
 		if (isset($this->error['colour_id'])) {
			$this->data['error_color'] = $this->error['colour_id'];
		} else {
			$this->data['error_color'] = '';
		}
		
		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('sale/colorclarity', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
			
		if (!isset($this->request->get['colorclarity_id'])) {
			$this->data['action'] = $this->url->link('sale/colorclarity/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('sale/colorclarity/update', 'token=' . $this->session->data['token'] . '&colorclarity_id=' . $this->request->get['colorclarity_id'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('sale/colorclarity', 'token=' . $this->session->data['token'] . $url, 'SSL');

		if (isset($this->request->get['colorclarity_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$colorclarity_info = $this->model_sale_colorclarity->getCustomerGroup($this->request->get['colorclarity_id']);
		}


		if (isset($this->request->post['gemstone_id'])) {
			$this->data['gemstone_id'] = $this->request->post['gemstone_id'];
		} elseif (isset($colorclarity_info)) {
			$this->data['gemstone_id'] = $colorclarity_info['gemstone_id'];
		} else {
			$this->data['gemstone_id'] = '';
		}

		if (isset($this->request->post['clarity_id'])) {
			$this->data['clarity_id'] = $this->request->post['clarity_id'];
		} elseif (isset($colorclarity_info)) {
			$this->data['clarity_id'] = $colorclarity_info['clarity_id'];
		} else {
			$this->data['clarity_id'] = '';
		}

		if (isset($this->request->post['colour_id'])) {
			$this->data['colour_id'] = $this->request->post['colour_id'];
		} elseif (isset($colorclarity_info)) {
			$this->data['colour_id'] = $colorclarity_info['colour_id'];
		} else {
			$this->data['colour_id'] = '';
		}

	
		$this->template = 'sale/colorclarity_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render()); 
	}

	private function validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/colorclarity')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}


		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

	private function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/colorclarity')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		$this->load->model('setting/store');
		$this->load->model('sale/customer');
      	
		foreach ($this->request->post['selected'] as $colorclarity_id) {
    		if ($this->config->get('config_colorclarity_id') == $colorclarity_id) {
	  			$this->error['warning'] = $this->language->get('error_default');	
			}  
			
			$store_total = $this->model_setting_store->getTotalStoresByCustomerGroupId($colorclarity_id);

			if ($store_total) {
				$this->error['warning'] = sprintf($this->language->get('error_store'), $store_total);
			}
			
			$customer_total = $this->model_sale_customer->getTotalCustomersByCustomerGroupId($colorclarity_id);

			if ($customer_total) {
				$this->error['warning'] = sprintf($this->language->get('error_customer'), $customer_total);
			}
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>