<?php
///////////////////////////////////////////////////////////////////
//	Copyright: Mintegra.com
//	Product: Ebay Auction Lister 2.0
//	Distributors: www.mintegra.com
//	Support: http://www.mintgera.com/support
///////////////////////////////////////////////////////////////////
class ControllerModuleEbay extends Controller {
	private $error = array(); 
	
	function index() {
		$this->load->language('module/ebay');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->model_setting_setting->editSetting('ebay', $this->request->post);
			$this->session->data['success'] = $this->language->get('text_success');
			$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');
		$this->data['text_none'] = $this->language->get('text_none');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');

		$this->data['entry_site_id'] = $this->language->get('entry_site_id');
		$this->data['entry_app_mode'] = $this->language->get('entry_app_mode');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_paypal_email'] = $this->language->get('entry_paypal_email');
		$this->data['entry_product_zip'] = $this->language->get('entry_product_zip');
		$this->data['entry_dispatch_time'] = $this->language->get('entry_dispatch_time');
		$this->data['entry_template_status'] = $this->language->get('entry_template_status');
		$this->data['entry_template_header'] = $this->language->get('entry_template_header');
		$this->data['entry_template_images'] = $this->language->get('entry_template_images');
		$this->data['entry_template_shipping'] = $this->language->get('entry_template_shipping');
		$this->data['entry_template_returns'] = $this->language->get('entry_template_returns');
		$this->data['entry_template_terms'] = $this->language->get('entry_template_terms');		
		$this->data['entry_template_about'] = $this->language->get('entry_template_about');
		$this->data['entry_serial_key'] = $this->language->get('entry_serial_key');
		$this->data['entry_domain_name'] = $this->language->get('entry_domain_name');

		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_support'] = $this->language->get('button_support');
		$this->data['button_blog'] = $this->language->get('button_blog');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

	 	if (isset($this->error['serial'])) {
			$this->data['error_serial'] = $this->error['serial'];
		} else {
			$this->data['error_serial'] = '';
		}	

	 	if (isset($this->error['domain'])) {
			$this->data['error_domain'] = $this->error['domain'];
		} else {
			$this->data['error_domain'] = '';
		}	
		
	 	if (isset($this->error['paypal_email'])) {
			$this->data['error_paypal_email'] = $this->error['paypal_email'];
		} else {
			$this->data['error_paypal_email'] = '';
		}		

	 	if (isset($this->error['product_zip'])) {
			$this->data['error_product_zip'] = $this->error['product_zip'];
		} else {
			$this->data['error_product_zip'] = '';
		}			
				
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_module'),
			'href'      => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('module/ebay', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);

		$this->data['action'] = $this->url->link('module/ebay', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['ebay_time_url'] = $this->url->link('module/ebay/gettime', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['ebay_cat_url'] = $this->url->link('module/ebay/addcategories', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['ebay_api_url'] = $this->url->link('module/ebay/download_api', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['ebay_auth_url'] = $this->url->link('module/ebay/authorize', 'token=' . $this->session->data['token'], 'SSL');		
		$this->data['ebay_fetchtoken_url'] = $this->url->link('module/ebay/fetchtoken', 'token=' . $this->session->data['token'], 'SSL');		
		$this->data['support_url'] = 'http://www.mintegra.com/support';
		$this->data['register_url'] = 'http://www.mintegra.com/license/software';
		$this->data['blog_url'] = 'http://www.mintegra.com/blog';
		$this->data['token'] = $this->session->data['token'];

					
		if (isset($this->request->post['ebay_site_id'])) {
			$this->data['ebay_site_id'] = $this->request->post['ebay_site_id'];
		} else {
			$this->data['ebay_site_id'] = $this->config->get('ebay_site_id');
		}

		if (isset($this->request->post['ebay_app_mode'])) {
			$this->data['ebay_app_mode'] = $this->request->post['ebay_app_mode'];
		} else {
			$this->data['ebay_app_mode'] = $this->config->get('ebay_app_mode');
		}
		
		if (isset($this->request->post['ebay_domain_name'])) {
			$this->data['ebay_domain_name'] = $this->request->post['ebay_domain_name'];
		} else {
			$this->data['ebay_domain_name'] = $this->config->get('ebay_domain_name');
		}	
		
		if (isset($this->request->post['ebay_serial_key'])) {
			$this->data['ebay_serial_key'] = $this->request->post['ebay_serial_key'];
		} else {
			$this->data['ebay_serial_key'] = $this->config->get('ebay_serial_key');
		}

		if (isset($this->request->post['ebay_status'])) {
			$this->data['ebay_status'] = $this->request->post['ebay_status'];
		} else {
			$this->data['ebay_status'] = $this->config->get('ebay_status');
		}

		if (isset($this->request->post['ebay_paypal_email'])) {
			$this->data['ebay_paypal_email'] = $this->request->post['ebay_paypal_email'];
		} else {
			$this->data['ebay_paypal_email'] = $this->config->get('ebay_paypal_email');
		}

		if (isset($this->request->post['ebay_product_zip'])) {
			$this->data['ebay_product_zip'] = $this->request->post['ebay_product_zip'];
		} else {
			$this->data['ebay_product_zip'] = $this->config->get('ebay_product_zip');
		}

		if (isset($this->request->post['ebay_template_header'])) {
			$this->data['ebay_template_header'] = $this->request->post['ebay_template_header'];
		} else {
			$this->data['ebay_template_header'] = $this->config->get('ebay_template_header');
		}

		if (isset($this->request->post['ebay_template_status'])) {
			$this->data['ebay_template_status'] = $this->request->post['ebay_template_status'];
		} else {
			$this->data['ebay_template_status'] = $this->config->get('ebay_template_status');
		}

		if (isset($this->request->post['ebay_template_shipping'])) {
			$this->data['ebay_template_shipping'] = $this->request->post['ebay_template_shipping'];
		} else {
			$this->data['ebay_template_shipping'] = $this->config->get('ebay_template_shipping');
		}

		if (isset($this->request->post['ebay_template_returns'])) {
			$this->data['ebay_template_returns'] = $this->request->post['ebay_template_returns'];
		} else {
			$this->data['ebay_template_returns'] = $this->config->get('ebay_template_returns');
		}

		if (isset($this->request->post['ebay_template_about'])) {
			$this->data['ebay_template_about'] = $this->request->post['ebay_template_about'];
		} else {
			$this->data['ebay_template_about'] = $this->config->get('ebay_template_about');
		}
		
		if (isset($this->request->post['ebay_template_images'])) {
			$this->data['ebay_template_images'] = $this->request->post['ebay_template_images'];
		} else {
			$this->data['ebay_template_images'] = $this->config->get('ebay_template_images');
		}
		
		if (isset($this->request->post['ebay_template_terms'])) {
			$this->data['ebay_template_terms'] = $this->request->post['ebay_template_terms'];
		} else {
			$this->data['ebay_template_terms'] = $this->config->get('ebay_template_terms');
		}
				
		


		$this->template = 'module/ebay.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render());
	}

	
	//authorize()
	public function authorize()
	{
	//$mintegra_config_url = "http://www.mayoo.com/gc5/getmc.php";
	$mintegra_config_url = "http://www.mintegra.com/license/keymanager";
	$domain_name = $this->request->get['ebay_domain_name'];
	$serial_key = $this->request->get['ebay_serial_key'];
	$key_type = "production";
	$trade = 'https://api.ebay.com/ws/api.dll';
	$sigin_url = 'https://signin.ebay.com/ws/eBayISAPI.dll?SignIn';
	
	if ( $this->request->get['ebay_app_mode'] == 1 ){
		$key_type = "sandbox";
		$trade = 'https://api.sandbox.ebay.com/ws/api.dll';
		$sigin_url = 'https://signin.sandbox.ebay.com/ws/eBayISAPI.dll?SignIn';
	}else{
		$key_type = "production";
	}
		
	$mintegra_config_url .= "?&serial_key=" . $serial_key  . "&key_type=" . $key_type . "&domain_name=" . $domain_name;
	
	//Get config details from mintegra
	$config_details = @file_get_contents($mintegra_config_url);
	if($config_details == false){
		echo "Error: Unable to get information from Mintgera URL";
		return;
	}
	$str_xml = base64_decode($config_details);
	
	if ($str_xml == "UNAUTHORIZED"){
		echo "<h1>Product serial authetication Failed<h1>";
		return;
	}
	//echo $str_xml;
	$xml = simplexml_load_string($str_xml);
	
	$devid = (string) $xml->mintegra->devid;
	//echo "Dev Id ->" . $devid ;
	$appid = (string) $xml->mintegra->appid;
	//echo "App Id ->" . $appid ;
	$certid = (string) $xml->mintegra->certid;
	//echo "Cert Id ->" . $certid ;
	$RuName = (string) $xml->mintegra->RuName;
	
	$call = 'GetSessionID';
	$body = "\n  <RuName>" . $RuName. "</RuName>\n";
	$field = 'SessionID';


	
	 if (($response = @file_get_contents($trade, 'r', stream_context_create(array('http' => array(
	 'method' => 'POST',

	 'header' =>
	 "Content-Type: text/xml; charset=utf-8\r\n"
	 . "X-EBAY-API-SITEID: 0\r\n"
	 . "X-EBAY-API-COMPATIBILITY-LEVEL: 689\r\n"
	 . "X-EBAY-API-CALL-NAME: ". $call . "\r\n"

	 // these headers are only required for GetSessionID and FetchToken
	 . "X-EBAY-API-DEV-NAME: " . $devid . "\r\n"
	 . "X-EBAY-API-APP-NAME: " . $appid . "\r\n"
	 . "X-EBAY-API-CERT-NAME: " . $certid . "\r\n",

	 'content' => $request =
	 "<?xml version='1.0' encoding='utf-8'?>\n"
	 . "<{$call} xmlns='urn:ebay:apis:eBLBaseComponents'>{$body}</{$call}>"
	 ))))) === FALSE)
	 {
	 exit('No response from eBay server!');
	 }

	 // found open tag?
	 if (($begin = strpos($response, "<{$field}>")) !== FALSE)
	 {
	 // skip open tag
	 $begin += strlen($field) + 2;

	 // found close tag?
		 if (($end = strpos($response, "</{$field}>", $begin)) !== FALSE)
		 {
			$session_id =  substr($response, $begin, $end - $begin);
			//Store session id in settings table
			$data = array(
				'mintegra_session_id'  => $session_id
			);
			
			$this->load->model('setting/setting');
			$this->model_setting_setting->editSetting('mintegra', $data);
			
			//echo 'Session Id : ' . $session_id . '<br>';
			$url = $sigin_url . "&RuName=" . $RuName . "&SessID=" . $session_id;

			//echo "Redirecting Now to URL: " . $url ;
			$this->redirect($url);
		 }
	}
	 echo "<h1>Failed to retrieve Session Id from Ebay. Please retry later...</h1>";	
     //return "Field <b>{$field}</b> not found in eBay response!<p/>\n\n{$response}");
}
	
	
	//fetchEbayToken()
	public function fetchtoken()
	{
	$mintegra_config_url = "http://www.mintegra.com/license/keymanager";
	$domain_name = $this->request->get['ebay_domain_name'];
	$serial_key = $this->request->get['ebay_serial_key'];
	$key_type = "production";
	$trade = 'https://api.ebay.com/ws/api.dll';

	
	if ( $this->request->get['ebay_app_mode'] == 1 ){
		$key_type = "sandbox";
		$trade = 'https://api.sandbox.ebay.com/ws/api.dll';
	}else{
		$key_type = "production";
	}
	
	$mintegra_config_url .= "?&serial_key=" . $serial_key  . "&key_type=" . $key_type . "&domain_name=" . $domain_name;
	//Get config details from mintegra
	$config_details = @file_get_contents($mintegra_config_url);
	if($config_details == false){
		echo "Error: Unable to get information from Mintgera URL";
		return;
	}
	$str_xml = base64_decode($config_details);
	//echo $str_xml;
	$xml = simplexml_load_string($str_xml);
	
	$devid = (string) $xml->mintegra->devid;
	//echo "Dev Id ->" . $devid ;
	$appid = (string) $xml->mintegra->appid;
	//echo "App Id ->" . $appid ;
	$certid = (string) $xml->mintegra->certid;
	//echo "Cert Id ->" . $certid ;
	$session_id = $this->config->get('mintegra_session_id');
	if ( !isset($session_id)){
		echo "Please authorize application before fecthing token.";
		return;
	}
	
	$call = 'FetchToken';
	$body = "\n  <SessionID>" . $session_id . "</SessionID>\n";
	$field = 'eBayAuthToken';

	
	 if (($response = @file_get_contents($trade, 'r', stream_context_create(array('http' => array(
	 'method' => 'POST',

	 'header' =>
	 "Content-Type: text/xml; charset=utf-8\r\n"
	 . "X-EBAY-API-SITEID: 0\r\n"
	 . "X-EBAY-API-COMPATIBILITY-LEVEL: 689\r\n"
	 . "X-EBAY-API-CALL-NAME: ". $call . "\r\n"

	 // these headers are only required for GetSessionID and FetchToken
	 . "X-EBAY-API-DEV-NAME: " . $devid . "\r\n"
	 . "X-EBAY-API-APP-NAME: " . $appid . "\r\n"
	 . "X-EBAY-API-CERT-NAME: " . $certid . "\r\n",

	 'content' => $request =
	 "<?xml version='1.0' encoding='utf-8'?>\n"
	 . "<{$call} xmlns='urn:ebay:apis:eBLBaseComponents'>{$body}</{$call}>"
	 ))))) === FALSE)
	 {
	 exit('No response from eBay server!');
	 }

	 // found open tag?
	 if (($begin = strpos($response, "<{$field}>")) !== FALSE)
	 {
	 // skip open tag
	 $begin += strlen($field) + 2;

	 // found close tag?
		 if (($end = strpos($response, "</{$field}>", $begin)) !== FALSE)
		 {
			$ebayToken=  substr($response, $begin, $end - $begin);
			//Store session id in settings table
			$data = array(
				'mintegra_ebay_token'  => $ebayToken
			);
			
			$this->load->model('setting/setting');
			$this->model_setting_setting->editSetting('mintegra', $data);
			
			echo "Token retrieved successfully";
			return;
		 }
	}else{
		$this->log->write("Call Failed : " . $response);	
		echo "Failed to Fetch Token.Please re-authorize extension and try fetching token again.";
		return;
	}
}
	private function validate() {

		if (!$this->user->hasPermission('modify', 'module/ebay')) {

			$this->error['warning'] = $this->language->get('error_permission');

		}

		if ( (strlen($this->request->post['ebay_serial_key']) < 1) ) {
		
			$this->error['serial'] = $this->language->get('error_serial');
		}
		
		if ( (strlen($this->request->post['ebay_domain_name']) < 1) ) {
		
			$this->error['domain'] = $this->language->get('error_domain');
		}
		
		if ( (strlen($this->request->post['ebay_paypal_email']) < 1) ) {
		
			$this->error['paypal_email'] = $this->language->get('error_paypal_email');
		}		
		
		if ( (strlen($this->request->post['ebay_product_zip']) < 1) ) {
		
			$this->error['product_zip'] = $this->language->get('error_product_zip');
		}			
		
		if (!$this->error) {

			return true;

		} else {

			return false;

		}
	}

	private function https($route) {
		if (HTTPS_SERVER != '') {
			$link = HTTPS_SERVER . 'index.php?route=' . str_replace('&', '&amp;', $route.'&token=' . $this->session->data['token']);
		} else {
			$link = HTTP_SERVER . 'index.php?route=' . str_replace('&', '&amp;', $route.'&token=' . $this->session->data['token']);
		}

		return $link;
	}

	private function startsWith( $haystack, $needle ) {
		if (strlen( $haystack ) < strlen( $needle )) {
			return FALSE;
		}
		return (substr( $haystack, 0, strlen($needle) ) == $needle);
	}

	public function download_api(){
	
	
	if ( $this->config->get('config_error_display') > 0 || $this->config->get('config_error_log') > 0 ){

		echo "<b>Modify Display and Log Errors Server Settings:</b><br>Please navigate to system settings menu.<br> Click edit action for the store.<br> On Server tab set Display Errors and Log Errors to No";
		return;

	}
	
		$this->load->language('module/ebay');
		$dest_filename = 'ebatNs.zip';

		$url  = $this->language->get('url_download_api');
		mkdir(DIR_SYSTEM . 'library/'.'ebatNs', 0777,true);
		$path = DIR_SYSTEM . 'library/' . 'ebatNs/' . $dest_filename;
		$unzip_path = DIR_SYSTEM . 'library/'.'ebatNs/';

		if (!$fp = fopen($path, 'w')){
             echo "File not opened<br>";
			 return;
        }
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_FILE, $fp);

		$data = curl_exec($ch);
		curl_close($ch);
		fclose($fp);

		echo 'Download Complete....' . '<br>';

		$zip = zip_open($path);
		if (is_resource($zip)) {
		  while ($zip_entry = zip_read($zip)) {
			$fp = fopen( $unzip_path . zip_entry_name($zip_entry), "w");
			if (zip_entry_open($zip, $zip_entry, "r")) {
			  $buf = zip_entry_read($zip_entry, zip_entry_filesize($zip_entry));
			  fwrite($fp,"$buf");
			  zip_entry_close($zip_entry);
			  fclose($fp);
			}
		  }
		  zip_close($zip);
		}

		echo 'Api Installed...';
	}

	public function exists_ebatns(){
	$ebatns_file = DIR_SYSTEM . 'library/ebatNs/EbatNs_ServiceProxy.php';

	if ( file_exists( $ebatns_file ) ){
		return true;
	}else{
		return false;
		}
	}
	
	public function gettime(){

	if ( !$this->exists_ebatns() ) {
		echo "<b>ebatNs api is Missing.</b><br>Refer to documentation on installing ebatNs Api";
		return;
	}

	if ( $this->config->get('config_error_display') > 0 || $this->config->get('config_error_log') > 0 ){

		echo "<b>Modify Display and Log Errors Server Settings:</b><br>Please navigate to system settings menu.<br> Click edit action for the store.<br> On Server tab set Display Errors and Log Errors to No";
		return;

	}

		require_once(DIR_SYSTEM . 'library/ebatNs/EbatNs_ServiceProxy.php');
		require_once(DIR_SYSTEM . 'library/ebatNs/EbatNs_Logger.php');
		require_once(DIR_SYSTEM . 'library/ebatNs/GeteBayOfficialTimeRequestType.php');
		require_once(DIR_SYSTEM . 'library/ebatNs/GeteBayOfficialTimeResponseType.php');

		$returnString = "EBAY request failed";
		$pEbay_token = $this->config->get('mintegra_ebay_token');
		$pEbay_app_mode = $this->request->get['ebay_app_mode'];
		$pEbay_site_id = $this->request->get['ebay_site_id'];

		$token = $pEbay_token;
		$session = new EbatNs_Session();
		$session->setAppMode($pEbay_app_mode);
		$session->setSiteId($pEbay_site_id);
		$session->setTokenMode(true);
		$session->setRequestToken($token);

		$cs = new EbatNs_ServiceProxy($session);
		$req = new GeteBayOfficialTimeRequestType();
		$res = $cs-> GeteBayOfficialTime($req);
			if ($res->getAck() != $Facet_AckCodeType->Success)
			{
				$returnString = "EBAY Time request failed";
				//$returnString = $token ;
			}else{
				$returnString = "EBAY Time: " . $res->Timestamp;
			}
			echo $returnString;

	}



	public function getsubcategories(){

		$pEbay_catid = $this->request->get['ebay_catid'];
		$this->load->model('ebay/category');
		$ebaycategories = $this->model_ebay_category->getCategoryById($pEbay_catid);
		$returnstring = "";
		foreach ($ebaycategories as $ebaycategory) {
		 if ($ebaycategory['leafcategory'] == 1){
			$returnstring = $returnstring . '<option value="'. $ebaycategory['categoryid'] . '">' . $ebaycategory['categoryname'] . '</option>';
			}else{
			$returnstring = $returnstring . '<option value="'. $ebaycategory['categoryid'] . '">' . $ebaycategory['categoryname'] . '>' . '</option>';
			}
		}
        echo $returnstring;
	}


	function updateCatProgress($pct,$msg)
	 {
			ob_start();
			echo "<script>parent.downloadCatProgress(" .  $pct . ",'" . $msg . "');</script>";
			ob_end_flush();
	}
	public function addcategories(){
	if ( !$this->exists_ebatns() ) {
		$currentpct = 100;
		$returnString = "<b>ebatNs api is Missing.</b><br>Refer to documentation on installing ebatNs Api";
		$this->updateCatProgress($currentpct,$returnString);
		return;
	}

	if ( $this->config->get('config_error_display') > 0 || $this->config->get('config_error_log') > 0 ){
		$currentpct = 100;
		$returnString = "<b>Modify Display and Log Errors Server Settings:</b><br>Please navigate to system settings menu.<br> Click edit action for the store.<br> On Server tab set Display Errors and Log Errors to No";
		$this->updateCatProgress($currentpct,$returnString);
		return;

	}

	require_once(DIR_SYSTEM . 'library/ebatNs/EbatNs_ServiceProxy.php');
	require_once(DIR_SYSTEM . 'library/ebatNs/GetCategoriesRequestType.php');
	require_once(DIR_SYSTEM . 'library/ebatNs/GetCategoriesResponseType.php');
	require_once(DIR_SYSTEM . 'library/ebatNs/CategoryArrayType.php');
	require_once(DIR_SYSTEM . 'library/ebatNs/CategoryType.php');

	$this->load->model('ebay/category');
	$returnString = "EBAY request failed";

		$pEbay_token = $this->config->get('mintegra_ebay_token');
		$pEbay_app_mode = $this->request->get['ebay_app_mode'];
		$pEbay_site_id = $this->request->get['ebay_site_id'];

		$token = $pEbay_token;
		$session = new EbatNs_Session();
		$session->setAppMode($pEbay_app_mode);

		$session->setSiteId($pEbay_site_id);
		$session->setTokenMode(true);
		$session->setRequestToken($token);
		
	$cs = new EbatNs_ServiceProxy($session);
	$req = new GetCategoriesRequestType();
	$req->CategorySiteID = $pEbay_site_id;
	$req->LevelLimit = 1;
	$req->DetailLevel = 'ReturnAll';
	$res = $cs->getCategories($req);


	//Check if version already exists
	//Return Exists message if exists
	$this->load->model('ebay/categoryversion');
	$version_in_use = $this->model_ebay_categoryversion->getVersion();

	$returnString = "";
	if ( $version_in_use == $res->getCategoryVersion() ){
		//Categories are upto date message

		$returnString = "Ebay categories version " . $version_in_use . " in use is the latest verison";
		$this->updateCatProgress(100,$returnString);
		echo $returnString ;
	}else{


		$version = $res->getCategoryVersion();
		$updatetime = $res->getUpdateTime();
		$catPrimary = $res->getCategoryArray();

		$this->model_ebay_categoryversion->deleteVersion();
		$this->model_ebay_categoryversion->addVersion($version);

		$this->load->model('ebay/category');
		$this->model_ebay_category->deleteAll();

		$total_categories = count($catPrimary);

		for($i=0;$i<count($catPrimary);$i++){
			$cattype = $catPrimary[$i];

			$category['categoryid'] = $cattype->getCategoryID();
			$category['categorylevel'] = $cattype->getCategoryLevel();
			$category['categoryname'] = $cattype->getCategoryName();
			$category['categoryparentid'] = $cattype->getCategoryParentID();
			$category['leafcategory'] = $cattype->getLeafCategory();
			$this->model_ebay_category->addCategory($category);

				$req->CategorySiteID = $pEbay_site_id;
				$req->LevelLimit = 254;
				$req->DetailLevel = 'ReturnAll';
				$req->setCategoryParent($cattype->getCategoryID());

				$res = $cs->GetCategories($req);
				$catSecondary = $res->getCategoryArray();

				for($n=1;$n<count($catSecondary);$n++){
					$cattype2 = $catSecondary[$n];
					$parentid = $cattype2->getCategoryParentID();
					$category['categoryid'] = $cattype2->getCategoryID();
					$category['categorylevel'] = $cattype2->getCategoryLevel();
					$category['categoryname'] = $cattype2->getCategoryName();
					$category['categoryparentid'] = $parentid[0];
					$category['leafcategory'] = $cattype2->getLeafCategory();
					$this->model_ebay_category->addCategory($category);
				}
				//Update pct progress
				$currentpct = (int) (($i * 100)/ $total_categories);
				$returnString = "Percentage Complete ". $currentpct . "%" . "    Downloading " . $category['categoryname'] . " categories " ;
				$this->updateCatProgress($currentpct,$returnString);
			}

			$returnString = "Ebay Categories Version " . $version . " downloaded";
			$this->updateCatProgress(100,$returnString);
			echo $returnString;
	}

	}
	
	public function specificsauction() {
		$this->load->language('module/ebay');
		$this->document->setTitle($this->language->get('heading_auction_specifics'));
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

		
			$this->load->model('ebay/auction');
			$this->model_ebay_auction->addSpecifics($this->request->post,$this->request->get['auction_id']);
			
			$this->redirect(HTTPS_SERVER . 'index.php?route=module/ebay/auctiontemplates&token=' . $this->session->data['token']);
		}
		
		$this->getSpecificsForm();
	}

	private function getSpecificsForm() {
	
	require_once(DIR_SYSTEM . 'library/ebatNs/EbatNs_ServiceProxy.php');
	require_once(DIR_SYSTEM . 'library/ebatNs/EbatNs_Logger.php');
	require_once(DIR_SYSTEM . 'library/ebatNs/GetCategorySpecificsRequestType.php');
	require_once(DIR_SYSTEM . 'library/ebatNs/GetCategorySpecificsResponseType.php');
	
	$this->load->model('setting/setting');
	
	$returnString = "EBAY request failed";
	$pEbay_token = $this->config->get('mintegra_ebay_token');
	$pEbay_app_mode = $this->config->get('ebay_app_mode');
	$pEbay_site_id = $this->config->get('ebay_site_id');

	$session = new EbatNs_Session();
	$session->setAppMode($pEbay_app_mode);
	$session->setSiteId($pEbay_site_id);
	$session->setTokenMode(true);
	$session->setRequestToken($pEbay_token);

	$cs = new EbatNs_ServiceProxy($session);
	$req = new GetCategorySpecificsRequestType();
	
	$this->load->model('ebay/auction');
	if (isset($this->request->get['auction_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$auction_info = $this->model_ebay_auction->getAuction($this->request->get['auction_id']);
    }
	
	$auction_specifics = $this->model_ebay_auction->getSpecifics($this->request->get['auction_id']);
			
	$this->data['stored_specifics'] = array();
	
	//Load values from specifics in order
	foreach($auction_specifics as $sv){
				$this->data['stored_specifics'][] = $sv['spec_value'];
	}
	
	$req->CategoryID = $auction_info['category'];
	$res = $cs->GetCategorySpecifics($req);
	$rcms = $res->getRecommendations();

	
	$this->data['names'] = array();
	
	for($n=0;$n<count($rcms);$n++){
		$cur_rcms = $rcms[$n];
		$gnr = $cur_rcms->getNameRecommendation();
			for($j=0;$j <count($gnr);$j++){
				$cur_gnr = $gnr[$j];
				$name =  $cur_gnr->getName();
				$this->data['names'][] = $name;
				$this->data['specifics'][$j] = array();
				$gvr = $cur_gnr->getValueRecommendation();
					for($m=0;$m <count($gvr);$m++){
						$cur_gvr = $gvr[$m];
						$value =  $cur_gvr->getValue();
						$val_count = substr_count($value,'"');
						if ($val_count == 2){
							$value = str_replace('"','',$value);
						}elseif ($val_count == 1){
							$value = str_replace('"',' Inch',$value);
						}
						
						$this->data['specifics'][$j][] = $value;
						
					}
					
			}
	}
	
	
	
	if ($res->getAck() != $Facet_AckCodeType->Success)
	{
		$returnString = "Product Specifics request failed";
		//call form
	}else{		
				
			$this->data['breadcrumbs'] = array();

			$this->data['breadcrumbs'][] = array(
				'href'      => HTTPS_SERVER . 'index.php?route=common/home&token=' . $this->session->data['token'],
				'text'      => $this->language->get('text_home'),
				'separator' => FALSE
			);

			$this->data['breadcrumbs'][] = array(
				'href'      => HTTPS_SERVER . 'index.php?route=module/ebay/auctiontemplates&token=' . $this->session->data['token'] ,
				'text'      => $this->language->get('heading_auction_templates'),
				'separator' => ' :: '
			);
				
			if (isset($this->error['warning'])) {
				$this->data['error_warning'] = $this->error['warning'];
			} else {
				$this->data['error_warning'] = '';
			}
			
			$this->data['button_save'] = $this->language->get('button_save');
			$this->data['button_cancel'] = $this->language->get('button_cancel');
			
			$this->data['heading_auction_specifics'] = $this->language->get('heading_auction_specifics');
			
			$this->data['action'] = HTTPS_SERVER . 'index.php?route=module/ebay/specificsauction&token=' . $this->session->data['token'] . '&auction_id=' . $this->request->get['auction_id'] ;
			
			$this->data['cancel'] = HTTPS_SERVER . 'index.php?route=module/ebay/auctiontemplates&token=' . $this->session->data['token'] . '&auction_id=' . $this->request->get['auction_id'];

			$this->data['token'] = $this->session->data['token'];
			
			$this->template = 'module/ebay_specificsauction_form.tpl';
			
					$this->children = array(
						'common/header',	
						'common/footer'	
					);
		
			$this->response->setOutput($this->render());
		}
	}	

	public function verifyauction() {
	    $this->load->language('module/ebay');
    	//$this->document->title = $this->language->get('heading_auction_templates');
		$this->document->setTitle($this->language->get('heading_auction_templates'));
		$this->load->model('ebay/auction');
		$return_str = "";
		$auction_id = $this->request->get['auction_id'];
		$verify = true;
		//$return_str = $this->listOnEbay($auction_id,$verify);
		$itemarray = array($auction_id);
		$return_str = $this->listOnEbay2($itemarray,$verify);
		$this->session->data['success'] = $return_str;
		$url = '';

		if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . $this->request->get['filter_name'];
		}

		if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . $this->request->get['filter_model'];
		}

		if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}

		if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
		}

		$this->redirect(HTTPS_SERVER . 'index.php?route=module/ebay/auctiontemplates&token=' . $this->session->data['token'] . $url);
	}

	public function listauction() {
    	$this->load->language('module/ebay');

		$this->document->setTitle($this->language->get('heading_auction_templates'));
		$this->load->model('ebay/auction');
		$return_str = "";

		if (isset($this->request->post['selected']) && $this->validateDelete()) {

				$verify = false;
				//$return_str = $this->listOnEbay2($auction_id,$verify);

				$return_str = $this->listOnEbay2($this->request->post['selected'],$verify);
				$this->session->data['success'] = $return_str;

			$url = '';

			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . $this->request->get['filter_name'];
			}

			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . $this->request->get['filter_model'];
			}

			if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
			}

			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . $this->request->get['filter_status'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			$this->redirect(HTTPS_SERVER . 'index.php?route=module/ebay/auctiontemplates&token=' . $this->session->data['token'] . $url);
		}

    	$this->getAuctionTemplates();
  	}

	public function delete() {
    	$this->load->language('module/ebay');

		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('ebay/auction');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $auction_id) {
				$this->model_ebay_auction->deleteAuction($auction_id);
	  		}

			$this->session->data['success'] = $this->language->get('text_success_delete');

			$url = '';

			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . $this->request->get['filter_name'];
			}

			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . $this->request->get['filter_model'];
			}

			if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
			}

			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . $this->request->get['filter_status'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			$this->redirect(HTTPS_SERVER . 'index.php?route=module/ebay/auctiontemplates&token=' . $this->session->data['token'] . $url);
		}

    	$this->getAuctionTemplates();
  	}

	public function editauction() {
		$this->load->language('module/ebay');
    	//$this->load->language('catalog/product');

		$this->document->setTitle($this->language->get('heading_auction_templates'));
		$this->load->model('ebay/auction');

    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
    	//if (($this->request->server['REQUEST_METHOD'] == 'POST')) {

			$this->load->model('ebay/auction');
			$this->model_ebay_auction->editAuction($this->request->post,$this->request->get['auction_id']);

			$this->session->data['success'] = $this->language->get('text_success_edit');

			$url = '';

			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . $this->request->get['filter_name'];
			}

			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . $this->request->get['filter_model'];
			}

			if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
			}

			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . $this->request->get['filter_status'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			$this->redirect(HTTPS_SERVER . 'index.php?route=module/ebay/auctiontemplates&token=' . $this->session->data['token'] . $url);
		}

    	$this->getAuctionForm();
  	}

	public function auction() {
		$this->load->language('module/ebay');
    	//$this->load->language('catalog/product');

		$this->document->setTitle($this->language->get('heading_auction_products'));
		$this->load->model('catalog/product');

    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
    	//if (($this->request->server['REQUEST_METHOD'] == 'POST')) {

			$this->load->model('ebay/auction');
			$this->model_ebay_auction->addAuction($this->request->post);

			$this->session->data['success'] = $this->language->get('text_success_auction');

			$url = '';

			if (isset($this->request->get['filter_name'])) {
				$url .= '&filter_name=' . $this->request->get['filter_name'];
			}

			if (isset($this->request->get['filter_model'])) {
				$url .= '&filter_model=' . $this->request->get['filter_model'];
			}

			if (isset($this->request->get['filter_quantity'])) {
				$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
			}

			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . $this->request->get['filter_status'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			$this->redirect(HTTPS_SERVER . 'index.php?route=module/ebay/auctionproducts&token=' . $this->session->data['token'] . $url);
		}

    	$this->getForm();
  	}
	public function auctiontemplates(){
		$this->load->language('module/ebay');

		$this->document->setTitle($this->language->get('heading_auction_templates'));		
		$this->load->model('ebay/auction');

		$this->getAuctionTemplates();
	}
	public function auctionproducts(){
		$this->load->language('module/ebay');
		$this->load->language('catalog/product');

		$this->document->setTitle($this->language->get('heading_auction_products'));	
		
		$this->load->model('catalog/product');

		$this->getList();
	}
	private function getAuctionTemplates() {
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'title';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		$url = '';

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=common/home&token=' . $this->session->data['token'],
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->data['breadcrumbs'][] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=module/ebay/auctiontemplates&token=' . $this->session->data['token'] . $url,
       		'text'      => $this->language->get('heading_auction_templates'),
      		'separator' => ' :: '
   		);


		$this->data['delete'] = HTTPS_SERVER . 'index.php?route=module/ebay/delete&token=' . $this->session->data['token'] . $url;
		$this->data['list'] = HTTPS_SERVER . 'index.php?route=module/ebay/listauction&token=' . $this->session->data['token'] . $url;

    	$this->data['auctions'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);

		$auction_total = $this->model_ebay_auction->getTotalAuctions();

		$results = $this->model_ebay_auction->getAuctions($data);

		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_specifics'),
				'href' => HTTPS_SERVER . 'index.php?route=module/ebay/specificsauction&token=' . $this->session->data['token'] . '&auction_id=' . $result['auction_id'] . $url
			);			

			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => HTTPS_SERVER . 'index.php?route=module/ebay/editauction&token=' . $this->session->data['token'] . '&auction_id=' . $result['auction_id'] . $url
			);

			 $action[] = array(
				 'text' => $this->language->get('text_verify'),
				 'href' => HTTPS_SERVER . 'index.php?route=module/ebay/verifyauction&token=' . $this->session->data['token'] . '&auction_id=' . $result['auction_id'] . $url
			 );

      		$this->data['auctions'][] = array(
				'auction_id'    => $result['auction_id'],
				'title'    => $result['title'],
				'auctiontype'   => $result['auctiontype'],
				'category'     => $result['category'],
				'selected'   => isset($this->request->post['selected']) && in_array($result['auction_id'], $this->request->post['selected']),
				'action'     => $action
			);
		}

		//$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['heading_auction_templates'] = $this->language->get('heading_auction_templates');
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_title'] = $this->language->get('column_title');
		$this->data['column_auctiontype'] = $this->language->get('column_auctiontype');
		$this->data['column_category'] = $this->language->get('column_category');
		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['button_list'] = $this->language->get('button_list');
		$this->data['button_delete'] = $this->language->get('button_delete');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['sort_title'] = HTTPS_SERVER . 'index.php?route=module/ebay/auctiontemplates&token=' . $this->session->data['token'] . '&sort=title' . $url;
		$this->data['sort_auctiontype'] = HTTPS_SERVER . 'index.php?route=module/ebay/auctiontemplates&token=' . $this->session->data['token'] . '&sort=auctiontype' . $url;
		$this->data['sort_category'] = HTTPS_SERVER . 'index.php?route=module/ebay/auctiontemplates&token=' . $this->session->data['token'] . '&sort=category' . $url;

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $auction_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = HTTPS_SERVER . 'index.php?route=module/ebay/auctiontemplates&token=' . $this->session->data['token'] . $url . '&page={page}';

		$this->data['pagination'] = $pagination->render();

		$this->data['sort'] = $sort;
		$this->data['order'] = $order;

		$this->template = 'module/ebay_auction_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
  	}
	private function getList() {
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'pd.name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['filter_name'])) {
			$filter_name = $this->request->get['filter_name'];
		} else {
			$filter_name = NULL;
		}

		if (isset($this->request->get['filter_model'])) {
			$filter_model = $this->request->get['filter_model'];
		} else {
			$filter_model = NULL;
		}

		if (isset($this->request->get['filter_quantity'])) {
			$filter_quantity = $this->request->get['filter_quantity'];
		} else {
			$filter_quantity = NULL;
		}

		if (isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
		} else {
			$filter_status = NULL;
		}

		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}

		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . $this->request->get['filter_model'];
		}

		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=common/home&token=' . $this->session->data['token'],
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->data['breadcrumbs'][] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=module/ebay/auctionproducts&token=' . $this->session->data['token'] . $url,
       		'text'      => $this->language->get('heading_auction_products'),
      		'separator' => ' :: '
   		);

		$this->data['auction'] = HTTPS_SERVER . 'index.php?route=module/ebay/auction&token=' . $this->session->data['token'] . $url;

		$this->data['products'] = array();

		$data = array(
			'filter_name'	  => $filter_name,
			'filter_model'	  => $filter_model,
			'filter_quantity' => $filter_quantity,
			'filter_status'   => $filter_status,
			'sort'            => $sort,
			'order'           => $order,
			'start'           => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit'           => $this->config->get('config_admin_limit')
		);

		$this->load->model('tool/image');

		$product_total = $this->model_catalog_product->getTotalProducts($data);

		$results = $this->model_catalog_product->getProducts($data);

		foreach ($results as $result) {
			$action = array();

			$action[] = array(
				'text' => $this->language->get('text_auction'),
				'href' => HTTPS_SERVER . 'index.php?route=module/ebay/auction&token=' . $this->session->data['token'] . '&product_id=' . $result['product_id'] . $url
			);

			if ($result['image'] && file_exists(DIR_IMAGE . $result['image'])) {
				$image = $this->model_tool_image->resize($result['image'], 40, 40);
			} else {
				$image = $this->model_tool_image->resize('no_image.jpg', 40, 40);
			}

      		$this->data['products'][] = array(
				'product_id' => $result['product_id'],
				'name'       => $result['name'],
				'model'      => $result['model'],
				'image'      => $image,
				'quantity'   => $result['quantity'],
				'status'     => ($result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled')),
				'selected'   => isset($this->request->post['selected']) && in_array($result['product_id'], $this->request->post['selected']),
				'action'     => $action
			);
    	}

		$this->data['heading_title'] = $this->language->get('heading_auction_products');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_no_results'] = $this->language->get('text_no_results');
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');

		$this->data['column_image'] = $this->language->get('column_image');
		$this->data['column_name'] = $this->language->get('column_name');
    	$this->data['column_model'] = $this->language->get('column_model');
		$this->data['column_quantity'] = $this->language->get('column_quantity');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_action'] = $this->language->get('column_action');

		// $this->data['button_copy'] = $this->language->get('button_copy');
		// $this->data['button_insert'] = $this->language->get('button_insert');
		// $this->data['button_delete'] = $this->language->get('button_delete');
		$this->data['button_filter'] = $this->language->get('button_filter');

 		$this->data['token'] = $this->session->data['token'];

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}

		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . $this->request->get['filter_model'];
		}

		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['sort_name'] = HTTPS_SERVER . 'index.php?route=module/ebay/auctionproducts&token=' . $this->session->data['token'] . '&sort=pd.name' . $url;
		$this->data['sort_model'] = HTTPS_SERVER . 'index.php?route=module/ebay/auctionproducts&token=' . $this->session->data['token'] . '&sort=p.model' . $url;
		$this->data['sort_quantity'] = HTTPS_SERVER . 'index.php?route=module/ebay/auctionproducts&token=' . $this->session->data['token'] . '&sort=p.quantity' . $url;
		$this->data['sort_status'] = HTTPS_SERVER . 'index.php?route=module/ebay/auctionproducts&token=' . $this->session->data['token'] . '&sort=p.status' . $url;
		$this->data['sort_order'] = HTTPS_SERVER . 'index.php?route=module/ebay/auctionproducts&token=' . $this->session->data['token'] . '&sort=p.sort_order' . $url;

		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}

		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . $this->request->get['filter_model'];
		}

		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $product_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = HTTPS_SERVER . 'index.php?route=module/ebay/auctionproducts&token=' . $this->session->data['token'] . $url . '&page={page}';

		$this->data['pagination'] = $pagination->render();

		$this->data['filter_name'] = $filter_name;
		$this->data['filter_model'] = $filter_model;
		$this->data['filter_quantity'] = $filter_quantity;
		$this->data['filter_status'] = $filter_status;

		$this->data['sort'] = $sort;
		$this->data['order'] = $order;

		$this->template = 'module/ebay_product_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
  	}
	private function getForm() {

    	$this->data['heading_auction_products'] = $this->language->get('heading_auction_products');

    	$this->data['text_enabled'] = $this->language->get('text_enabled');
    	$this->data['text_disabled'] = $this->language->get('text_disabled');
    	$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_yes'] = $this->language->get('text_yes');
    	$this->data['text_no'] = $this->language->get('text_no');
		$this->data['text_plus'] = $this->language->get('text_plus');
		$this->data['text_minus'] = $this->language->get('text_minus');
		$this->data['text_default'] = $this->language->get('text_default');
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
		$this->data['text_option'] = $this->language->get('text_option');
		$this->data['text_option_value'] = $this->language->get('text_option_value');
		$this->data['text_select'] = $this->language->get('text_select');
		$this->data['text_none'] = $this->language->get('text_none');

		$this->data['text_oneday'] = $this->language->get('text_oneday');
		$this->data['text_twodays'] = $this->language->get('text_twodays');
		$this->data['text_threedays'] = $this->language->get('text_threedays');
		$this->data['text_fourdays'] = $this->language->get('text_fourdays');
		$this->data['text_fivedays'] = $this->language->get('text_fivedays');
		$this->data['text_sevendays'] = $this->language->get('text_sevendays');
		$this->data['text_tendays'] = $this->language->get('text_tendays');
		$this->data['text_fifteendays'] = $this->language->get('text_fifteendays');
		$this->data['text_twentydays'] = $this->language->get('text_twentydays');
		$this->data['text_thirtydays'] = $this->language->get('text_thirtydays');
		$this->data['text_gtc'] = $this->language->get('text_gtc');		
		$this->data['text_fixed'] = $this->language->get('text_fixed');
		$this->data['text_online'] = $this->language->get('text_online');
		$this->data['text_flat'] = $this->language->get('text_flat');
		$this->data['text_calculated'] = $this->language->get('text_calculated');
		$this->data['text_freight'] = $this->language->get('text_freight');
		$this->data['text_noshipping'] = $this->language->get('text_noshipping');
		$this->data['text_localpickup'] = $this->language->get('text_localpickup');
		$this->data['text_letter'] = $this->language->get('text_letter');
		$this->data['text_largeenvelope'] = $this->language->get('text_largeenvelope');
		$this->data['text_package'] = $this->language->get('text_package');
		$this->data['text_largepackage'] = $this->language->get('text_largepackage');

		$this->data['text_shipping_method0'] = $this->language->get('text_shipping_method0');
		$this->data['text_shipping_method1'] = $this->language->get('text_shipping_method1');
		$this->data['text_shipping_method2'] = $this->language->get('text_shipping_method2');
		$this->data['text_shipping_method3'] = $this->language->get('text_shipping_method3');
		$this->data['text_shipping_method4'] = $this->language->get('text_shipping_method4');
		$this->data['text_shipping_method5'] = $this->language->get('text_shipping_method5');
		$this->data['text_shipping_method6'] = $this->language->get('text_shipping_method6');
		$this->data['text_shipping_method7'] = $this->language->get('text_shipping_method7');
		$this->data['text_shipping_method8'] = $this->language->get('text_shipping_method8');
		$this->data['text_shipping_method9'] = $this->language->get('text_shipping_method9');
		$this->data['text_shipping_method10'] = $this->language->get('text_shipping_method10');
		$this->data['text_shipping_method11'] = $this->language->get('text_shipping_method11');
		$this->data['text_shipping_method12'] = $this->language->get('text_shipping_method12');
		$this->data['text_shipping_method13'] = $this->language->get('text_shipping_method13');
		$this->data['text_shipping_method14'] = $this->language->get('text_shipping_method14');
		$this->data['text_shipping_method15'] = $this->language->get('text_shipping_method15');
		$this->data['text_shipping_method16'] = $this->language->get('text_shipping_method16');
		$this->data['text_shipping_method17'] = $this->language->get('text_shipping_method17');
		$this->data['text_shipping_method18'] = $this->language->get('text_shipping_method18');
		$this->data['text_shipping_method19'] = $this->language->get('text_shipping_method19');
		$this->data['text_shipping_method20'] = $this->language->get('text_shipping_method20');
		$this->data['text_shipping_method21'] = $this->language->get('text_shipping_method21');
		$this->data['text_shipping_method22'] = $this->language->get('text_shipping_method22');

		$this->data['tab_condition'] = $this->language->get('tab_ebay_condition');
		$this->data['text_condition_new'] = $this->language->get('text_condition_new');
		$this->data['text_condition_newoth'] = $this->language->get('text_condition_newoth');
		$this->data['text_condition_mfgref'] = $this->language->get('text_condition_mfgref');
		$this->data['text_condition_selref'] = $this->language->get('text_condition_selref');
		$this->data['text_condition_used'] = $this->language->get('text_condition_used');
		$this->data['text_condition_parts'] = $this->language->get('text_condition_parts');

		$this->data['text_returns_accepted'] = $this->language->get('text_returns_accepted');
		$this->data['text_returns_notaccepted'] = $this->language->get('text_returns_notaccepted');

		$this->data['tab_shipping'] = $this->language->get('tab_ebay_shipping');
		$this->data['tab_links'] = $this->language->get('tab_links');

		$this->data['entry_auction_title'] = $this->language->get('entry_auction_title');
		$this->data['entry_auction_subtitle'] = $this->language->get('entry_auction_subtitle');
		$this->data['entry_auction_describe'] = $this->language->get('entry_auction_describe');
		$this->data['entry_auction_quantity'] = $this->language->get('entry_auction_quantity');
		$this->data['entry_auction_duration'] = $this->language->get('entry_auction_duration');
		$this->data['entry_auction_buyitnowprice'] = $this->language->get('entry_auction_buyitnowprice');
		$this->data['entry_auction_type'] = $this->language->get('entry_auction_type');
		$this->data['entry_auction_startprice'] = $this->language->get('entry_auction_startprice');
		$this->data['entry_auction_immediatepayment'] = $this->language->get('entry_auction_immediatepayment');
		$this->data['entry_auction_category'] = $this->language->get('entry_auction_category');
		$this->data['entry_auction_galleryplus'] = $this->language->get('entry_auction_galleryplus');
		$this->data['entry_auction_includesubtitle'] = $this->language->get('entry_auction_includesubtitle');
		$this->data['entry_auction_bold'] = $this->language->get('entry_auction_bold');
		$this->data['entry_auction_usshipping'] = $this->language->get('entry_auction_usshipping');
		$this->data['entry_auction_shippingcost'] = $this->language->get('entry_auction_shippingcost');
		$this->data['entry_auction_freeshipping'] = $this->language->get('entry_auction_freeshipping');
		$this->data['entry_auction_localpickup'] = $this->language->get('entry_auction_localpickup');
		$this->data['entry_auction_handlingtime'] = $this->language->get('entry_auction_handlingtime');
		$this->data['entry_auction_service'] = $this->language->get('entry_auction_service');
		$this->data['entry_auction_addservice'] = $this->language->get('entry_auction_addservice');
		$this->data['entry_auction_eachadditional'] = $this->language->get('entry_auction_eachadditional');
		$this->data['entry_auction_packagetype'] = $this->language->get('entry_auction_packagetype');
		$this->data['entry_auction_irregular'] = $this->language->get('entry_auction_irregular');
		$this->data['entry_auction_dimensions'] = $this->language->get('entry_auction_dimensions');
		$this->data['entry_auction_weight'] = $this->language->get('entry_auction_weight');
		$this->data['entry_auction_image'] = $this->language->get('entry_auction_image');
		$this->data['entry_auction_categorys'] = $this->language->get('entry_auction_categorys');
		$this->data['entry_auction_condition'] = $this->language->get('entry_auction_condition');
		$this->data['entry_auction_returns'] = $this->language->get('entry_auction_returns');

		$this->data['ebay_subcat_url'] = $this->https('module/ebay/getsubcategories');

		$this->data['entry_tags'] = $this->language->get('entry_tags');

    	$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_add_option'] = $this->language->get('button_add_option');
		$this->data['button_add_option_value'] = $this->language->get('button_add_option_value');
		$this->data['button_add_discount'] = $this->language->get('button_add_discount');
		$this->data['button_add_special'] = $this->language->get('button_add_special');
		$this->data['button_add_image'] = $this->language->get('button_add_image');
		$this->data['button_remove'] = $this->language->get('button_remove');

    	$this->data['tab_general'] = $this->language->get('tab_ebay_general');
    	$this->data['tab_categories'] = $this->language->get('tab_ebay_category');
		$this->data['tab_shipping'] = $this->language->get('tab_ebay_shipping');
		$this->data['tab_features'] = $this->language->get('tab_ebay_features');
    	$this->data['tab_image'] = $this->language->get('tab_ebay_image');


 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['name'])) {
			$this->data['error_name'] = $this->error['name'];
		} else {
			$this->data['error_name'] = '';
		}


   		if (isset($this->error['description'])) {
			$this->data['error_description'] = $this->error['description'];
		} else {
			$this->data['error_description'] = '';
		}

		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}

		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . $this->request->get['filter_model'];
		}

		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=common/home&token=' . $this->session->data['token'],
       		'text'      => $this->language->get('text_home'),
			'separator' => FALSE
   		);

   		$this->data['breadcrumbs'][] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=module/ebay/auctionproducts&token=' . $this->session->data['token'] . $url,
       		'text'      => $this->language->get('heading_auction_products'),
      		'separator' => ' :: '
   		);


		$this->data['action'] = HTTPS_SERVER . 'index.php?route=module/ebay/auction&token=' . $this->session->data['token'] . $url;

		$this->data['cancel'] = HTTPS_SERVER . 'index.php?route=module/ebay/auctionproducts&token=' . $this->session->data['token'] . $url;

		$this->data['token'] = $this->session->data['token'];

		if (isset($this->request->get['product_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$product_info = $this->model_catalog_product->getProduct($this->request->get['product_id']);
			$this->data['product_id'] = $this->request->get['product_id'];
    	}

		$this->load->model('localisation/language');

		$this->data['languages'] = $this->model_localisation_language->getLanguages();

		if (isset($this->request->post['product_description'])) {
			$this->data['product_description'] = $this->request->post['product_description'];
		} elseif (isset($product_info)) {
			$this->data['product_description'] = $this->model_catalog_product->getProductDescriptions($this->request->get['product_id']);
		} else {
			$this->data['product_description'] = array();
		}


		$this->load->model('setting/store');

		$this->data['stores'] = $this->model_setting_store->getStores();



		if (isset($this->request->post['image'])) {
			$this->data['image'] = $this->request->post['image'];
		} elseif (isset($product_info)) {
			$this->data['image'] = $product_info['image'];
		} else {
			$this->data['image'] = '';
		}

		$this->load->model('tool/image');

		if (isset($product_info) && $product_info['image'] && file_exists(DIR_IMAGE . $product_info['image'])) {
			$this->data['preview'] = $this->model_tool_image->resize($product_info['image'], 100, 100);
		} else {
			$this->data['preview'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		}



    	if (isset($this->request->post['quantity'])) {
      		$this->data['quantity'] = $this->request->post['quantity'];
    	} elseif (isset($product_info)) {
      		$this->data['quantity'] = $product_info['quantity'];
    	} else {
			$this->data['quantity'] = 1;
		}


    	if (isset($this->request->post['price'])) {
      		$this->data['price'] = $this->request->post['price'];
    	} else if (isset($product_info)) {
			$this->data['price'] = $product_info['price'];
		} else {
      		$this->data['price'] = '';
    	}



    	if (isset($this->request->post['weight'])) {
      		$this->data['weight'] = $this->request->post['weight'];
		} else if (isset($product_info)) {
			$this->data['weight'] = $product_info['weight'];
    	} else {
      		$this->data['weight'] = '';
    	}

		$this->load->model('localisation/weight_class');

		$this->data['weight_classes'] = $this->model_localisation_weight_class->getWeightClasses();

    	$weight_info = $this->model_localisation_weight_class->getWeightClassDescriptionByUnit($this->config->get('config_weight_class'));

		if (isset($this->request->post['weight_class_id'])) {
      		$this->data['weight_class_id'] = $this->request->post['weight_class_id'];
    	} elseif (isset($product_info)) {
      		$this->data['weight_class_id'] = $product_info['weight_class_id'];
    	} elseif (isset($weight_info)) {
      		$this->data['weight_class_id'] = $weight_info['weight_class_id'];
		} else {
      		$this->data['weight_class_id'] = '';
    	}

		if (isset($this->request->post['length'])) {
      		$this->data['length'] = $this->request->post['length'];
    	} elseif (isset($product_info)) {
			$this->data['length'] = $product_info['length'];
		} else {
      		$this->data['length'] = '';
    	}

		if (isset($this->request->post['width'])) {
      		$this->data['width'] = $this->request->post['width'];
		} elseif (isset($product_info)) {
			$this->data['width'] = $product_info['width'];
    	} else {
      		$this->data['width'] = '';
    	}

		if (isset($this->request->post['height'])) {
      		$this->data['height'] = $this->request->post['height'];
		} elseif (isset($product_info)) {
			$this->data['height'] = $product_info['height'];
    	} else {
      		$this->data['height'] = '';
    	}

		$this->load->model('localisation/length_class');

		$this->data['length_classes'] = $this->model_localisation_length_class->getLengthClasses();

    	$length_info = $this->model_localisation_length_class->getLengthClassDescriptionByUnit($this->config->get('config_length_class'));

		if (isset($this->request->post['length_class_id'])) {
      		$this->data['length_class_id'] = $this->request->post['length_class_id'];
    	} elseif (isset($product_info)) {
      		$this->data['length_class_id'] = $product_info['length_class_id'];
    	} elseif (isset($length_info)) {
      		$this->data['length_class_id'] = $length_info['length_class_id'];
    	} else {
    		$this->data['length_class_id'] = '';
		}

		$this->data['language_id'] = $this->config->get('config_language_id');

		$this->data['no_image'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);

		$this->data['product_images'] = array();

		if (isset($product_info)) {
			$results = $this->model_catalog_product->getProductImages($this->request->get['product_id']);

			foreach ($results as $result) {
				if ($result['image'] && file_exists(DIR_IMAGE . $result['image'])) {
					$this->data['product_images'][] = array(
						'preview' => $this->model_tool_image->resize($result['image'], 100, 100),
						'file'    => $result['image']
					);
				} else {
					$this->data['product_images'][] = array(
						'preview' => $this->model_tool_image->resize('no_image.jpg', 100, 100),
						'file'    => $result['image']
					);
				}
			}
		}



		//Load Ebay Primary Categories
		$this->load->model('ebay/category');
		$primaryCategory=0;
		$ebaycategories = $this->model_ebay_category->getCategoryById($primaryCategory);
		foreach ($ebaycategories as $ebaycategory) {
		$primcatname = $ebaycategory['categoryname'] ;
		if($ebaycategory['leafcategory'] == 0){
		  $primcatname = $ebaycategory['categoryname'] . '>';
		 }

		$this->data['ebaycats'][] = array(
				'cat_id'    => $ebaycategory['categoryid'],
				'cat_name'   => $primcatname
				);
		}
		$this->template = 'module/ebay_auction_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
  	}

	private function getAuctionForm() {

    	$this->data['heading_auction_templates'] = $this->language->get('heading_auction_templates');

    	$this->data['text_enabled'] = $this->language->get('text_enabled');
    	$this->data['text_disabled'] = $this->language->get('text_disabled');
    	$this->data['text_none'] = $this->language->get('text_none');
    	$this->data['text_yes'] = $this->language->get('text_yes');
    	$this->data['text_no'] = $this->language->get('text_no');
		$this->data['text_plus'] = $this->language->get('text_plus');
		$this->data['text_minus'] = $this->language->get('text_minus');
		$this->data['text_default'] = $this->language->get('text_default');
		$this->data['text_image_manager'] = $this->language->get('text_image_manager');
		$this->data['text_option'] = $this->language->get('text_option');
		$this->data['text_option_value'] = $this->language->get('text_option_value');
		$this->data['text_select'] = $this->language->get('text_select');
		$this->data['text_none'] = $this->language->get('text_none');

		$this->data['text_oneday'] = $this->language->get('text_oneday');
		$this->data['text_twodays'] = $this->language->get('text_twodays');
		$this->data['text_threedays'] = $this->language->get('text_threedays');
		$this->data['text_fourdays'] = $this->language->get('text_fourdays');
		$this->data['text_fivedays'] = $this->language->get('text_fivedays');
		$this->data['text_sevendays'] = $this->language->get('text_sevendays');
		$this->data['text_tendays'] = $this->language->get('text_tendays');
		$this->data['text_fifteendays'] = $this->language->get('text_fifteendays');
		$this->data['text_twentydays'] = $this->language->get('text_twentydays');
		$this->data['text_thirtydays'] = $this->language->get('text_thirtydays');
		$this->data['text_gtc'] = $this->language->get('text_gtc');		
		$this->data['text_fixed'] = $this->language->get('text_fixed');
		$this->data['text_online'] = $this->language->get('text_online');
		$this->data['text_flat'] = $this->language->get('text_flat');
		$this->data['text_calculated'] = $this->language->get('text_calculated');
		$this->data['text_freight'] = $this->language->get('text_freight');
		$this->data['text_noshipping'] = $this->language->get('text_noshipping');
		$this->data['text_localpickup'] = $this->language->get('text_localpickup');
		$this->data['text_letter'] = $this->language->get('text_letter');
		$this->data['text_largeenvelope'] = $this->language->get('text_largeenvelope');
		$this->data['text_package'] = $this->language->get('text_package');
		$this->data['text_largepackage'] = $this->language->get('text_largepackage');

		$this->data['text_shipping_method0'] = $this->language->get('text_shipping_method0');
		$this->data['text_shipping_method1'] = $this->language->get('text_shipping_method1');
		$this->data['text_shipping_method2'] = $this->language->get('text_shipping_method2');
		$this->data['text_shipping_method3'] = $this->language->get('text_shipping_method3');
		$this->data['text_shipping_method4'] = $this->language->get('text_shipping_method4');
		$this->data['text_shipping_method5'] = $this->language->get('text_shipping_method5');
		$this->data['text_shipping_method6'] = $this->language->get('text_shipping_method6');
		$this->data['text_shipping_method7'] = $this->language->get('text_shipping_method7');
		$this->data['text_shipping_method8'] = $this->language->get('text_shipping_method8');
		$this->data['text_shipping_method9'] = $this->language->get('text_shipping_method9');
		$this->data['text_shipping_method10'] = $this->language->get('text_shipping_method10');
		$this->data['text_shipping_method11'] = $this->language->get('text_shipping_method11');
		$this->data['text_shipping_method12'] = $this->language->get('text_shipping_method12');
		$this->data['text_shipping_method13'] = $this->language->get('text_shipping_method13');
		$this->data['text_shipping_method14'] = $this->language->get('text_shipping_method14');
		$this->data['text_shipping_method15'] = $this->language->get('text_shipping_method15');
		$this->data['text_shipping_method16'] = $this->language->get('text_shipping_method16');
		$this->data['text_shipping_method17'] = $this->language->get('text_shipping_method17');
		$this->data['text_shipping_method18'] = $this->language->get('text_shipping_method18');
		$this->data['text_shipping_method19'] = $this->language->get('text_shipping_method19');
		$this->data['text_shipping_method20'] = $this->language->get('text_shipping_method20');
		$this->data['text_shipping_method21'] = $this->language->get('text_shipping_method21');
		$this->data['text_shipping_method22'] = $this->language->get('text_shipping_method22');


		$this->data['tab_condition'] = $this->language->get('tab_ebay_condition');
		$this->data['text_condition_new'] = $this->language->get('text_condition_new');
		$this->data['text_condition_newoth'] = $this->language->get('text_condition_newoth');
		$this->data['text_condition_mfgref'] = $this->language->get('text_condition_mfgref');
		$this->data['text_condition_selref'] = $this->language->get('text_condition_selref');
		$this->data['text_condition_used'] = $this->language->get('text_condition_used');
		$this->data['text_condition_parts'] = $this->language->get('text_condition_parts');

		$this->data['text_returns_accepted'] = $this->language->get('text_returns_accepted');
		$this->data['text_returns_notaccepted'] = $this->language->get('text_returns_notaccepted');

		$this->data['tab_shipping'] = $this->language->get('tab_ebay_shipping');
		$this->data['tab_links'] = $this->language->get('tab_links');

		$this->data['entry_auction_title'] = $this->language->get('entry_auction_title');
		$this->data['entry_auction_subtitle'] = $this->language->get('entry_auction_subtitle');
		$this->data['entry_auction_describe'] = $this->language->get('entry_auction_describe');
		$this->data['entry_auction_quantity'] = $this->language->get('entry_auction_quantity');
		$this->data['entry_auction_duration'] = $this->language->get('entry_auction_duration');
		$this->data['entry_auction_buyitnowprice'] = $this->language->get('entry_auction_buyitnowprice');
		$this->data['entry_auction_type'] = $this->language->get('entry_auction_type');
		$this->data['entry_auction_startprice'] = $this->language->get('entry_auction_startprice');
		$this->data['entry_auction_immediatepayment'] = $this->language->get('entry_auction_immediatepayment');
		$this->data['entry_auction_category'] = $this->language->get('entry_auction_category');
		$this->data['entry_auction_galleryplus'] = $this->language->get('entry_auction_galleryplus');
		$this->data['entry_auction_includesubtitle'] = $this->language->get('entry_auction_includesubtitle');
		$this->data['entry_auction_bold'] = $this->language->get('entry_auction_bold');
		$this->data['entry_auction_usshipping'] = $this->language->get('entry_auction_usshipping');
		$this->data['entry_auction_shippingcost'] = $this->language->get('entry_auction_shippingcost');
		$this->data['entry_auction_freeshipping'] = $this->language->get('entry_auction_freeshipping');
		$this->data['entry_auction_localpickup'] = $this->language->get('entry_auction_localpickup');
		$this->data['entry_auction_handlingtime'] = $this->language->get('entry_auction_handlingtime');
		$this->data['entry_auction_service'] = $this->language->get('entry_auction_service');
		$this->data['entry_auction_addservice'] = $this->language->get('entry_auction_addservice');
		$this->data['entry_auction_eachadditional'] = $this->language->get('entry_auction_eachadditional');
		$this->data['entry_auction_packagetype'] = $this->language->get('entry_auction_packagetype');
		$this->data['entry_auction_irregular'] = $this->language->get('entry_auction_irregular');
		$this->data['entry_auction_dimensions'] = $this->language->get('entry_auction_dimensions');
		$this->data['entry_auction_weight'] = $this->language->get('entry_auction_weight');
		$this->data['entry_auction_image'] = $this->language->get('entry_auction_image');
		$this->data['entry_auction_categorys'] = $this->language->get('entry_auction_categorys');
		$this->data['entry_auction_condition'] = $this->language->get('entry_auction_condition');
		$this->data['entry_auction_returns'] = $this->language->get('entry_auction_returns');

		$this->data['ebay_subcat_url'] = $this->https('module/ebay/getsubcategories');

		$this->data['entry_tags'] = $this->language->get('entry_tags');

    	$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_add_option'] = $this->language->get('button_add_option');
		$this->data['button_add_option_value'] = $this->language->get('button_add_option_value');
		$this->data['button_add_discount'] = $this->language->get('button_add_discount');
		$this->data['button_add_special'] = $this->language->get('button_add_special');
		$this->data['button_add_image'] = $this->language->get('button_add_image');
		$this->data['button_remove'] = $this->language->get('button_remove');

    	$this->data['tab_general'] = $this->language->get('tab_ebay_general');
    	$this->data['tab_categories'] = $this->language->get('tab_ebay_category');
		$this->data['tab_shipping'] = $this->language->get('tab_ebay_shipping');
		$this->data['tab_features'] = $this->language->get('tab_ebay_features');
    	$this->data['tab_image'] = $this->language->get('tab_ebay_image');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['name'])) {
			$this->data['error_name'] = $this->error['name'];
		} else {
			$this->data['error_name'] = '';
		}


   		if (isset($this->error['description'])) {
			$this->data['error_description'] = $this->error['description'];
		} else {
			$this->data['error_description'] = '';
		}

		$url = '';

		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}

		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . $this->request->get['filter_model'];
		}

		if (isset($this->request->get['filter_quantity'])) {
			$url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=common/home&token=' . $this->session->data['token'],
       		'text'      => $this->language->get('text_home'),
			'separator' => FALSE
   		);

   		$this->data['breadcrumbs'][] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=module/ebay/auctiontemplates&token=' . $this->session->data['token'] . $url,
       		'text'      => $this->language->get('heading_auction_templates'),
      		'separator' => ' :: '
   		);


		$this->data['action'] = HTTPS_SERVER . 'index.php?route=module/ebay/editauction&token=' . $this->session->data['token'] . '&auction_id=' . $this->request->get['auction_id'] . $url;

		$this->data['cancel'] = HTTPS_SERVER . 'index.php?route=module/ebay/auctiontemplates&token=' . $this->session->data['token'] . '&auction_id=' . $this->request->get['auction_id']. $url;

		$this->data['token'] = $this->session->data['token'];

		if (isset($this->request->get['auction_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$auction_info = $this->model_ebay_auction->getAuction($this->request->get['auction_id']);
    	}

		if (isset($this->request->post['auction_title'])) {
			$this->data['title'] = $this->request->post['auction_title'];
		} elseif (isset($auction_info)) {
			$this->data['title'] =  $auction_info['title'];
		} else {
			$this->data['title'] = array();
		}

		if (isset($this->request->post['auction_subtitle'])) {
			$this->data['subtitle'] = $this->request->post['auction_subtitle'];
		} elseif (isset($auction_info)) {
			$this->data['subtitle'] =  $auction_info['subtitle'];
		} else {
			$this->data['subtitle'] = array();
		}

		if (isset($this->request->post['auction_description'])) {
			$this->data['description'] = $this->request->post['auction_description'];
		} elseif (isset($auction_info)) {
			$this->data['description'] =  $auction_info['description'];
		} else {
			$this->data['description'] = array();
		}

		if (isset($this->request->post['image'])) {
			$this->data['image'] = $this->request->post['image'];
		} elseif (isset($auction_info)) {
			$this->data['image'] = $auction_info['image'];
		} else {
			$this->data['image'] = '';
		}

		$this->load->model('tool/image');

		if (isset($auction_info) && $auction_info['image'] && file_exists(DIR_IMAGE . $auction_info['image'])) {
			$this->data['preview'] = $this->model_tool_image->resize($auction_info['image'], 100, 100);
		} else {
			$this->data['preview'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		}

    	if (isset($this->request->post['quantity'])) {
      		$this->data['quantity'] = $this->request->post['quantity'];
    	} elseif (isset($auction_info)) {
      		$this->data['quantity'] = $auction_info['quantity'];
    	} else {
			$this->data['quantity'] = 1;
		}

		if (isset($this->request->post['auction_duration'])) {
      		$this->data['auction_duration'] = $this->request->post['auction_duration'];
    	} elseif (isset($auction_info)) {
      		$this->data['auction_duration'] = $auction_info['duration'];
    	} else {
			$this->data['auction_duration'] = 1;
		}

    	if (isset($this->request->post['price'])) {
      		$this->data['price'] = $this->request->post['price'];
    	} else if (isset($auction_info)) {
			$this->data['price'] = $auction_info['buyitnowprice'];
		} else {
      		$this->data['price'] = '';
    	}

    	if (isset($this->request->post['weight'])) {
      		$this->data['weight'] = $this->request->post['weight'];
		} else if (isset($auction_info)) {
			$this->data['weight'] = $auction_info['weight'];
    	} else {
      		$this->data['weight'] = '';
    	}


		if (isset($this->request->post['length'])) {
      		$this->data['length'] = $this->request->post['length'];
    	} elseif (isset($auction_info)) {
			$this->data['length'] = $auction_info['length'];
		} else {
      		$this->data['length'] = '';
    	}

		if (isset($this->request->post['width'])) {
      		$this->data['width'] = $this->request->post['width'];
		} elseif (isset($auction_info)) {
			$this->data['width'] = $auction_info['width'];
    	} else {
      		$this->data['width'] = '';
    	}

		if (isset($this->request->post['height'])) {
      		$this->data['height'] = $this->request->post['height'];
		} elseif (isset($auction_info)) {
			$this->data['height'] = $auction_info['height'];
    	} else {
      		$this->data['height'] = '';
    	}

		if (isset($this->request->post['auction_type'])) {
      		$this->data['auction_type'] = $this->request->post['auction_type'];
		} elseif (isset($auction_info)) {
			$this->data['auction_type'] = $auction_info['auctiontype'];
    	} else {
      		$this->data['auction_type'] = '';
    	}

		if (isset($this->request->post['auction_startprice'])) {
			$this->data['auction_startprice'] = $this->request->post['auction_startprice'];
		} elseif (isset($auction_info)) {
			$this->data['auction_startprice'] =  $auction_info['startprice'];
		} else {
			$this->data['auction_statprice'] = '';
		}

		if (isset($this->request->post['auction_immediatepayment'])) {
			$this->data['auction_immediatepayment'] = $this->request->post['auction_immediatepayment'];
		} elseif (isset($auction_info)) {
			$this->data['auction_immediatepayment'] =  $auction_info['immediatepayment'];
		} else {
			$this->data['auction_immediatepayment'] = '';
		}

		if (isset($this->request->post['auction_category'])) {
			$this->data['auction_category'] = $this->request->post['auction_category'];
		} elseif (isset($auction_info)) {
			$this->data['auction_category'] =  $auction_info['category'];
		} else {
			$this->data['auction_category'] = '';
		}

		if (isset($this->request->post['auction_galleryplus'])) {
			$this->data['auction_galleryplus'] = $this->request->post['auction_galleryplus'];
		} elseif (isset($auction_info)) {
			$this->data['auction_galleryplus'] =  $auction_info['galleryplus'];
		} else {
			$this->data['auction_galleryplus'] = '';
		}

		if (isset($this->request->post['auction_boldtitle'])) {
			$this->data['auction_boldtitle'] = $this->request->post['auction_boldtitle'];
		} elseif (isset($auction_info)) {
			$this->data['auction_boldtitle'] =  $auction_info['boldtitle'];
		} else {
			$this->data['auction_boldtitle'] = '';
		}

		if (isset($this->request->post['auction_includesubtitle'])) {
			$this->data['auction_boldtitle'] = $this->request->post['auction_includesubtitle'];
		} elseif (isset($auction_info)) {
			$this->data['auction_includesubtitle'] =  $auction_info['includesubtitle'];
		} else {
			$this->data['auction_includesubtitle'] = '';
		}

	    if (isset($this->request->post['auction_shipping'])) {
			$this->data['auction_shipping'] = $this->request->post['auction_shipping'];
		} elseif (isset($auction_info)) {
			$this->data['auction_shipping'] =  $auction_info['shippingtype'];
		} else {
			$this->data['auction_shipping'] = '';
		}

		if (isset($this->request->post['auction_service1'])) {
			$this->data['auction_service1'] = $this->request->post['auction_service1'];
		} elseif (isset($auction_info)) {
			$this->data['auction_service1'] =  $auction_info['service1'];
		} else {
			$this->data['auction_service1'] = '';
		}

		if (isset($this->request->post['auction_service1cost'])) {
			$this->data['auction_service1cost'] = $this->request->post['auction_service1'];
		} elseif (isset($auction_info)) {
			$this->data['auction_service1cost'] =  $auction_info['cost1'];
		} else {
			$this->data['auction_service1cost'] = '';
		}

		if (isset($this->request->post['auction_service1addcost'])) {
			$this->data['auction_service1addcost'] = $this->request->post['auction_service1addcost'];
		} elseif (isset($auction_info)) {
			$this->data['auction_service1addcost'] =  $auction_info['additionalcost1'];
		} else {
			$this->data['auction_service1addcost'] = '';
		}

		if (isset($this->request->post['auction_service2'])) {
			$this->data['auction_service2'] = $this->request->post['auction_service2'];
		} elseif (isset($auction_info)) {
			$this->data['auction_service2'] =  $auction_info['service2'];
		} else {
			$this->data['auction_service2'] = '';
		}

		if (isset($this->request->post['auction_service2cost'])) {
			$this->data['auction_service2cost'] = $this->request->post['auction_service2'];
		} elseif (isset($auction_info)) {
			$this->data['auction_service2cost'] =  $auction_info['cost2'];
		} else {
			$this->data['auction_service2cost'] = '';
		}

		if (isset($this->request->post['auction_service2addcost'])) {
			$this->data['auction_service2addcost'] = $this->request->post['auction_service2addcost'];
		} elseif (isset($auction_info)) {
			$this->data['auction_service2addcost'] =  $auction_info['additionalcost2'];
		} else {
			$this->data['auction_service2addcost'] = '';
		}

		if (isset($this->request->post['auction_service3'])) {
			$this->data['auction_service3'] = $this->request->post['auction_service3'];
		} elseif (isset($auction_info)) {
			$this->data['auction_service3'] =  $auction_info['service3'];
		} else {
			$this->data['auction_service3'] = '';
		}

		if (isset($this->request->post['auction_service3cost'])) {
			$this->data['auction_service3cost'] = $this->request->post['auction_service3'];
		} elseif (isset($auction_info)) {
			$this->data['auction_service3cost'] =  $auction_info['cost3'];
		} else {
			$this->data['auction_service3cost'] = '';
		}

		if (isset($this->request->post['auction_service3addcost'])) {
			$this->data['auction_service3addcost'] = $this->request->post['auction_service3addcost'];
		} elseif (isset($auction_info)) {
			$this->data['auction_service3addcost'] =  $auction_info['additionalcost3'];
		} else {
			$this->data['auction_service3addcost'] = '';
		}

		if (isset($this->request->post['auction_packagetype'])) {
			$this->data['auction_packagetype'] = $this->request->post['auction_packagetype'];
		} elseif (isset($auction_info)) {
			$this->data['auction_packagetype'] =  $auction_info['packagetype'];
		} else {
			$this->data['auction_packagetype'] = '';
		}

		if (isset($this->request->post['auction_irregular'])) {
			$this->data['auction_irregular'] = $this->request->post['auction_irregular'];
		} elseif (isset($auction_info)) {
			$this->data['auction_irregular'] =  $auction_info['irregular'];
		} else {
			$this->data['auction_irregular'] = '';
		}

		if (isset($this->request->post['auction_freeshipping'])) {
			$this->data['auction_freeshipping'] = $this->request->post['auction_freeshipping'];
		} elseif (isset($auction_info)) {
			$this->data['auction_freeshipping'] =  $auction_info['freeshipping'];
		} else {
			$this->data['auction_freeshipping'] = '';
		}

		if (isset($this->request->post['auction_localpickup'])) {
			$this->data['auction_localpickup'] = $this->request->post['auction_localpickup'];
		} elseif (isset($auction_info)) {
			$this->data['auction_localpickup'] =  $auction_info['localpickup'];
		} else {
			$this->data['auction_localpickup'] = '';
		}

		if (isset($this->request->post['auction_handlingtime'])) {
			$this->data['auction_handlingtime'] = $this->request->post['auction_handlingtime'];
		} elseif (isset($auction_info)) {
			$this->data['auction_handlingtime'] =  $auction_info['handlingtime'];
		} else {
			$this->data['auction_handlingtime'] = '';
		}

		if (isset($this->request->post['auction_condition'])) {
			$this->data['auction_condition'] = $this->request->post['auction_condition'];
		} elseif (isset($auction_info)) {
			$this->data['auction_condition'] =  $auction_info['itemcondition'];
		} else {
			$this->data['auction_condition'] = '';
		}

		if (isset($this->request->post['auction_returns'])) {
			$this->data['auction_returns'] = $this->request->post['auction_returns'];
		} elseif (isset($auction_info)) {
			$this->data['auction_returns'] =  $auction_info['returns'];
		} else {
			$this->data['auction_returns'] = '';
		}

		$this->load->model('localisation/language');

		$this->data['languages'] = $this->model_localisation_language->getLanguages();

	    $this->data['language_id'] = $this->config->get('config_language_id');
		$this->data['no_image'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
		//Load Ebay Primary Categories
		$this->load->model('ebay/category');
		$primaryCategory=0;
		$ebaycategories = $this->model_ebay_category->getCategoryById($primaryCategory);
		foreach ($ebaycategories as $ebaycategory) {
		$primcatname = $ebaycategory['categoryname'] ;
		if($ebaycategory['leafcategory'] == 0){
		  $primcatname = $ebaycategory['categoryname'] . '>';
		 }

		$this->data['ebaycats'][] = array(
				'cat_id'    => $ebaycategory['categoryid'],
				'cat_name'   => $primcatname
				);
		}
		$this->template = 'module/ebay_editauction_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
  	}

	//Ebay Services
	private function listOnEbay2($selecteditems, boolean $verify){

	require_once(DIR_SYSTEM . 'library/ebatNs/EbatNs_ServiceProxy.php');
	require_once(DIR_SYSTEM . 'library/ebatNs/EbatNs_Logger.php');
	require_once(DIR_SYSTEM . 'library/ebatNs/VerifyAddItemRequestType.php');
	require_once(DIR_SYSTEM . 'library/ebatNs/VerifyAddItemResponseType.php');
	require_once(DIR_SYSTEM . 'library/ebatNs/ItemType.php');

	$this->load->model('setting/setting');
	$returnString = "EBAY request failed";

	$pEbay_token = $this->config->get('mintegra_ebay_token');
	$pEbay_app_mode = $this->config->get('ebay_app_mode');
	$pEbay_site_id = $this->config->get('ebay_site_id');
	$pEbay_template_status = $this->config->get('ebay_template_status');
	$pEbay_template_header = $this->config->get('ebay_template_header');
	$pEbay_template_shipping = $this->config->get('ebay_template_shipping');
	$pEbay_template_returns = $this->config->get('ebay_template_returns');
	$pEbay_template_about = $this->config->get('ebay_template_about');
	$pEbay_template_images = $this->config->get('ebay_template_images');
	$pEbay_template_terms = $this->config->get('ebay_template_terms');	

	$session = new EbatNs_Session();
	$session->setAppMode($pEbay_app_mode);
	$session->setSiteId($pEbay_site_id);
	$session->setTokenMode(true);
	$session->setRequestToken($pEbay_token);

	$cs = new EbatNs_ServiceProxy($session);

	foreach ( $selecteditems as $auction_id) {

	$req = new VerifyAddItemRequestType();
	$item = new ItemType();

	$this->load->model('ebay/auction');
	$auction_info = $this->model_ebay_auction->getAuction($auction_id);
	$specifics = $this->model_ebay_auction->getSpecifics($auction_id);
	
	if (count($specifics) > 0 ) {
		$nvlat = new NameValueListArrayType();

		foreach( $specifics as $specific){
			$nvlt = new NameValueListType();
			$nvlt->setName($specific['spec_name']);
			$nvlt->setValue(html_entity_decode($specific['spec_value']));
			$nvlat->addNameValueList($nvlt);
		}

		$item->setItemSpecifics($nvlat);
	}
	
	//Title
	if(!empty($auction_info['title'])){
		$item->Title = $auction_info['title'];
	}

	//SubTitle
	if(!empty($auction_info['subtitle']) && $auction_info['includesubtitle'] == 'Yes'){
		$item->SubTitle = $auction_info['subtitle'];
	}

	//Picture
	if(!empty($auction_info['image'])){
	$item->PictureDetails = new PictureDetailsType();
	$image_link = HTTP_CATALOG . "image/" .  str_replace(" ","%20",$auction_info['image']);

    $item->PictureDetails->PictureURL = $image_link;
		if(!empty($auction_info['galleryplus']) && $auction_info['galleryplus'] == 'Yes' ){
			$item->PictureDetails->GalleryType = 'Plus';
		}else{
			$item->PictureDetails->GalleryType = 'Gallery';
			}
	}

	//bold title
	if(!empty($auction_info['boldtitle']) && $auction_info['boldtitle'] == 'Yes'){
		$item->setListingEnhancement('BoldTitle');
	}

	$myDescription="";
	$myHeader="";
	$myShipping="";
	$myReturns="";
	$myAbout="";
	$myImages="";
	$myTerms="";
	$imageTable="";
	
	if(!empty($pEbay_template_header)){
			$myHeader =  htmlspecialchars_decode($pEbay_template_header);
	}

	if(!empty($pEbay_template_shipping)){
			$myShipping =  htmlspecialchars_decode($pEbay_template_shipping);
	}

	if(!empty($pEbay_template_returns)){
			$myReturns =  htmlspecialchars_decode($pEbay_template_returns);
	}

	if(!empty($pEbay_template_header)){
			$myAbout =  htmlspecialchars_decode($pEbay_template_about);
	}
	
	if(!empty($pEbay_template_images)){
			$myImages =  htmlspecialchars_decode($pEbay_template_images);
	}
	
	if(!empty($pEbay_template_terms)){
			$myTerms =  htmlspecialchars_decode($pEbay_template_terms);
	}


	if (isset($auction_info['product_id']) && !empty($pEbay_template_images)) {
		$this->load->model('catalog/product');
		$results = array();
		$results = $this->model_catalog_product->getProductImages($auction_info['product_id']);
		$this->load->model('tool/image');		
		$image_bar="";
		$img_ctr = 0;
		

				foreach ($results as $result) {

					if ($img_ctr > 5){
						$image_bar .= "</tr>";
						$img_ctr = 0;
					}
					if ($img_ctr == 0){
						$image_bar .= "<tr>";
					}
					if ($result['image'] && file_exists(DIR_IMAGE . $result['image'])) {
						$img_ctr = $img_ctr + 1;
						$image_bar .=  '<td><a href="' . HTTPS_IMAGE . $result['image'] . '"><img class="imgBox" src="' . $this->model_tool_image->resize($result['image'], 100, 100) . '"/></a></td>';
						} else {
						$image_bar .=  '<td><img src="' . $this->model_tool_image->resize('no_image.jpg', 100, 100) . '"/></td>';
						}
					}
					if($img_ctr < 5){
						$image_bar .= "</tr>";
					}
					//Finally build image table bar
					$imageTable = "<table>". $image_bar . "</table>";
			}	
			if($img_ctr == 0){
			$myImages="";
			$imageTable="";
			}
	
	
	if(!empty($auction_info['description']) && $pEbay_template_status == '1' ){
		$myDescription = htmlspecialchars_decode($auction_info['description']);
		
		$this->data['mint_logo'] = $myHeader;
		$this->data['mint_desc'] = $myDescription;
		$this->data['mint_shipping'] = $myShipping;		
		$this->data['mint_returns'] = $myReturns;
		$this->data['mint_about'] = $myAbout;
		$this->data['mint_images'] = $myImages ;
		$this->data['mint_imagetable'] = $imageTable;
		$this->data['mint_terms'] = $myTerms;		
		$this->data['mint_poweredby'] = HTTP_CATALOG . "image/data/poweredbymintegra.jpg";
		
		$this->template = 'module/ebay_design.tpl';
		$item->Description = $this->render();
		//$output = $this->render();
		//echo $output;
	} else {
		if(!empty($auction_info['description'])){
		$item->Description = htmlspecialchars_decode($auction_info['description']);
		}
	}

	if(!empty($auction_info['quantity']) && $auction_info['auctiontype'] == 'Fixed Price'){
		$item->Quantity = $auction_info['quantity'];
		$item->ListingType = 'FixedPriceItem';

		if(!empty($auction_info['buyitnowprice'])){
		$item->StartPrice = new AmountType();
		$item->StartPrice->setTypeValue($auction_info['buyitnowprice']);
		$item->StartPrice->setTypeAttribute('currencyID', 'USD');
		}

	}else{
		$item->Quantity = 1;
		if(!empty($auction_info['startprice'])){
		$item->StartPrice = new AmountType();
		$item->StartPrice->setTypeValue($auction_info['startprice']);
		$item->StartPrice->setTypeAttribute('currencyID', 'USD');
		}
		if(!empty($auction_info['buyitnowprice'])){
		$item->BuyItNowPrice = new AmountType();
		$item->BuyItNowPrice->setTypeValue($auction_info['buyitnowprice']);
		$item->BuyItNowPrice->setTypeAttribute('currencyID', 'USD');


		}
	}

    if(!empty($auction_info['immediatepayment']) && $auction_info['immediatepayment'] == 'Yes'){
				   $item->AutoPay = true;
	}

	if(!empty($auction_info['duration'])){
		if ( $auction_info['duration'] == "Good Till Canceled"){
			$item->ListingDuration = "GTC";
		} else {
			$item->ListingDuration = 'Days_' . rtrim(substr($auction_info['duration'],0,2));
		}
	}
	//Category
	if(!empty($auction_info['category'])){
		$item->PrimaryCategory = new CategoryType();
		$item->PrimaryCategory->CategoryID = $auction_info['category'];
	}
	//Condition
	if(!empty($auction_info['itemcondition'])){
		if($auction_info['itemcondition'] == 'New'){
			$item->ConditionID = 1000 ;
		}elseif($auction_info['itemcondition'] == 'New other (see details)'){
			$item->ConditionID = 1500 ;
		}elseif($auction_info['itemcondition'] == 'Manufacturer refurbished'){
			$item->ConditionID = 2000 ;
		}elseif($auction_info['itemcondition'] == 'Seller refurbished'){
			$item->ConditionID = 2500 ;
		}elseif($auction_info['itemcondition'] == 'Used'){
			$item->ConditionID = 3000 ;
		}elseif($auction_info['itemcondition'] == 'For parts or not working'){
			$item->ConditionID = 7000 ;
		}
	}

	// Set Local Info
	$item->Currency = 'USD';
	$item->Country = 'US';
	$item->Site = 'US';


 // Set Payment Methods
	$paymentMethods[] = 'PayPal';
	$item->setPaymentMethods($paymentMethods);
	$item->PayPalEmailAddress = $this->config->get('ebay_paypal_email');
	$global_disp_time = $this->config->get('ebay_dispatch_time');
	if ( global_disp_time > 0){
	$item->DispatchTimeMax = $global_disp_time ;
	}else
	{
	$item->DispatchTimeMax = rtrim(substr($auction_info['handlingtime'],0,2));
	}

    $returnPolicy = new ReturnPolicyType();
	if($auction_info['returns'] == 'Returns accepted'){
		$returnPolicy->setReturnsAcceptedOption('ReturnsAccepted');
	} else {
	$returnPolicy->setReturnsAcceptedOption('ReturnsNotAccepted');
	}
    $returnPolicy->setDescription('See Auction Listing for Details');
	$item->setReturnPolicy($returnPolicy);
	$item->PostalCode = $this->config->get('ebay_product_zip');
	$item->ShipToLocations[]="US";

	if(!empty($auction_info['freeshipping']) && $auction_info['freeshipping'] == 'Yes' ){

		$ShippingServiceOptions = new ShippingServiceOptionsType();
		$ShippingServiceOptions->setFreeShipping(true);
		$ShippingServiceOptions->setShippingService('ShippingMethodStandard');
		$ShippingServiceOptions->setShippingServiceCost(0);
	    $shippingObj = new ShippingDetailsType();
		$shippingObj->setShippingServiceOptions($ShippingServiceOptions, 0);
		$item->setShippingDetails($shippingObj,0);
	}  else if(!empty($auction_info['shippingtype']) && $auction_info['shippingtype'] == 'No shipping:Local pickup only'){
		$ShippingServiceOptions = new ShippingServiceOptionsType();
		$ShippingServiceOptions->setShippingService('LocalDelivery');
		$ShippingServiceOptions->setShippingServiceCost(0);
	    $shippingObj = new ShippingDetailsType();
		$shippingObj->setShippingServiceOptions($ShippingServiceOptions, 0);
		$item->setShippingDetails($shippingObj,0);

	} else if(!empty($auction_info['shippingtype']) && $auction_info['shippingtype'] == 'Freight:large items over 150lbs.'){
		$ShippingServiceOptions = new ShippingServiceOptionsType();
		$ShippingServiceOptions->setShippingService('FreightShipping');
		$ShippingServiceOptions->setShippingServiceCost(0);
	    $shippingObj = new ShippingDetailsType();
		$shippingObj->ShippingType='Freight';
		$shippingObj->setShippingServiceOptions($ShippingServiceOptions, 0);
		$item->setShippingDetails($shippingObj,0);

	}else {
		if( $auction_info['shippingtype'] == 'Flat:same cost to all buyers'){
			$ShippingServiceOptions = new ShippingServiceOptionsType();

			$ShippingServiceOptions->setShippingService($this->getShippingService($auction_info['service1']));
			if(number_format($auction_info['cost1'], 2, '.', '') > 0 ){
			$s1Cost = new AmountType();
			$s1Cost->setTypeValue($auction_info['cost1']);
			$s1Cost->setTypeAttribute('currencyID', 'USD');
			$ShippingServiceOptions->setShippingServiceCost($s1Cost);
			}

			if(number_format($auction_info['additionalcost1'], 2, '.', '') > 0 && $item->Quantity  > 1){
			$s1Costadd = new AmountType();
			$s1Costadd->setTypeValue($auction_info['additionalcost1']);
			$s1Costadd->setTypeAttribute('currencyID', 'USD');
			$ShippingServiceOptions->setShippingServiceAdditionalCost($s1Costadd);
			}

			$ShippingServiceOptions2 = new ShippingServiceOptionsType();
			$ShippingServiceOptions2->setShippingService($this->getShippingService($auction_info['service2']));
			if(number_format($auction_info['cost2'], 2, '.', '') > 0 ){
			$s2Cost = new AmountType();
			$s2Cost->setTypeValue($auction_info['cost2']);
			$s2Cost->setTypeAttribute('currencyID', 'USD');
			$ShippingServiceOptions2->setShippingServiceCost($s2Cost);
			}

			if(number_format($auction_info['additionalcost2'], 2, '.', '') > 0 && $item->Quantity  > 1){
			$s2Costadd = new AmountType();
			$s2Costadd->setTypeValue($auction_info['additionalcost2']);
			$s2Costadd->setTypeAttribute('currencyID', 'USD');
			$ShippingServiceOptions2->setShippingServiceAdditionalCost($s2Costadd);
			}

			$ShippingServiceOptions3 = new ShippingServiceOptionsType();
			$ShippingServiceOptions3->setShippingService($this->getShippingService($auction_info['service3']));
			if(number_format($auction_info['cost3'], 2, '.', '') > 0 ){
			$s3Cost = new AmountType();
			$s3Cost->setTypeValue($auction_info['cost3']);
			$s3Cost->setTypeAttribute('currencyID', 'USD');
			$ShippingServiceOptions3->setShippingServiceCost($s3Cost);
			}

			if(number_format($auction_info['additionalcost3'], 2, '.', '') > 0 && $item->Quantity  > 1){
			$s3Costadd = new AmountType();
			$s3Costadd->setTypeValue($auction_info['additionalcost3']);
			$s3Costadd->setTypeAttribute('currencyID', 'USD');
			$ShippingServiceOptions3->setShippingServiceAdditionalCost($s3Costadd);
			}

			$shippingObj = new ShippingDetailsType();
			$shippingObj->ShippingType='Flat';
			$shippingObj->setShippingServiceOptions($ShippingServiceOptions, 0);
			if ($auction_info['service2'] != 'None'){
			$shippingObj->setShippingServiceOptions($ShippingServiceOptions2, 1);
			}
			if ($auction_info['service3'] != 'None'){
			$shippingObj->setShippingServiceOptions($ShippingServiceOptions3, 2);
			}
			if(!empty($auction_info['localpickup']) && $auction_info['localpickup'] == 'Yes'){
			//Local Free pickup
			$ShippingServiceOptions4 = new ShippingServiceOptionsType();
			$ShippingServiceOptions4->setShippingService('Pickup');
			$ShippingServiceOptions4->setShippingServiceCost(0);
			$shippingObj->setShippingServiceOptions($ShippingServiceOptions4, 3);
			}
			$item->setShippingDetails($shippingObj,0);

		}else if( $auction_info['shippingtype'] == 'Calculated:cost varies by buyer location'){
			$calRate = new CalculatedShippingRateType();
			$calRate->setOriginatingPostalCode($item->PostalCode);

			if(!empty($auction_info['weight']) && $auction_info['weight'] > 0 && $auction_info['weight'] < 1){
			$wmt = new MeasureType();
			$wmt->setTypeAttribute('unit','oz');
			$minor_weight = number_format($auction_info['weight'],2,'.','') * 100;
			$wmt->setTypeValue($minor_weight);
			$calRate->setWeightminor($wmt);
			}else if(!empty($auction_info['weight']) && $auction_info['weight'] > 0){
			$wmt = new MeasureType();
			$wmt->setTypeAttribute('unit','lbs');
			$wmt->setTypeValue(number_format($auction_info['weight'],2,'.',''));
			$calRate->setWeightMajor($wmt);
			}

			if(!empty($auction_info['height']) && $auction_info['height'] > 0){
			$hmt = new MeasureType();
			$hmt->setTypeAttribute('unit','in');
			$hmt->setTypeValue(number_format($auction_info['height'],2,'.',''));
			$calRate->setPackageDepth($hmt);
			}
			if(!empty($auction_info['width']) && $auction_info['width'] > 0 ){
			$wdmt = new MeasureType();
			$wdmt->setTypeAttribute('unit','in');
			$wdmt->setTypeValue(number_format($auction_info['width'],2,'.',''));
			$calRate->setPackageWidth($wdmt);
			}
			if(!empty($auction_info['length']) && $auction_info['length'] > 0){
			$lmt = new MeasureType();
			$lmt->setTypeAttribute('unit','in');
			$lmt->setTypeValue(number_format($auction_info['length'],2,'.',''));
			$calRate->setPackageLength($lmt);
			}
			if(!empty($auction_info['irregular']) && $auction_info['irregular'] == 'Yes'){
			$calRate->setShippingIrregular(true);
			}


			$calRate->setShippingPackage($this->getPackageType($auction_info['packagetype']));
			$ShippingServiceOptions = new ShippingServiceOptionsType();
			$ShippingServiceOptions->setShippingService($this->getShippingService($auction_info['service1']));

			$shippingObj = new ShippingDetailsType();
			$shippingObj->ShippingType='Calculated';
			$shippingObj->setCalculatedShippingRate($calRate);
			$shippingObj->setShippingServiceOptions($ShippingServiceOptions, 0);

			if ( $auction_info['service2'] != 'None'){
			$ShippingServiceOptions2 = new ShippingServiceOptionsType();
			$ShippingServiceOptions2->setShippingService($this->getShippingService($auction_info['service2']));
			$shippingObj->setShippingServiceOptions($ShippingServiceOptions2, 1);
			}

			if ( $auction_info['service3'] != 'None'){
			$ShippingServiceOptions3 = new ShippingServiceOptionsType();
			$ShippingServiceOptions3->setShippingService($this->getShippingService($auction_info['service3']));
			$shippingObj->setShippingServiceOptions($ShippingServiceOptions3, 2);
			}

			$item->setShippingDetails($shippingObj,0);
		}

	}

	$req->Item = $item;

	if ($verify == true){
		$res = $cs->VerifyAddItem($req);
		$calltype = "Verify Auction <br>";
	}else{
		$res = $cs->AddItem($req);
		$calltype = "Add Auction <br>";
	}


	if ($res->getAck() != $Facet_AckCodeType->Success && $res->getAck() != $Facet_AckCodeType->Warning)
	{
		$returnString = "Auction Id:" . $auction_id . "<BR>" . " Request failed!<BR>";

		 foreach ($res->getErrors() as $error)
		{
			$returnString .=  "#" . $error->getErrorCode() . " " . htmlentities($error->getShortMessage()) . "/" . htmlentities($error->getLongMessage()) . "<br>";
			//print_r($req);
		}

		break;
	}else{
		//print_r($req);
		$fees = new FeesType();
		$fees = $res->GetFees();
		foreach ($fees->getFee() as $fee)
		{
			 if ( $fee->GetName() == 'ListingFee'){
			  $total_fees =  $fee->GetFee()->getTypeValue() . ' ' .$fee->GetFee()->getTypeAttribute('currencyID');
			}
		}

		$req = null;
		$res = null;
		$item = null;
		$shippingObj = null;
		$returnString = $calltype . "Listing Fees: " .  $total_fees  ;
	}
	} //end for
	return $returnString;
	}
	private function validateDelete() {
    	if (!$this->user->hasPermission('modify', 'module/ebay')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}

		if (!$this->error) {
	  		return TRUE;
		} else {
	  		return FALSE;
		}
  	}

	private function validateForm() {
    	if (!$this->user->hasPermission('modify', 'module/ebay')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}


    	if (!$this->error) {
			return TRUE;
    	} else {
			if (!isset($this->error['warning'])) {
				$this->error['warning'] = $this->language->get('error_required_data');
			}
      		return FALSE;
    	}
  	}


	 private function getPackageType($selectedPackageType) {
		if ( $selectedPackageType == 'Letter'){
		  return 'Letter';
		}else if ( $selectedPackageType == 'Large Envelope'){
		  return 'LargeEnvelope';
		}else if ( $selectedPackageType == 'Package (or thick envelope)'){
		  return 'PackageThickEnvelope';
		}else if ( $selectedPackageType == 'Large Package'){
		  return 'USPSLargePack';
		}
	   }

	 private function getShippingService($selectedService) {
		if ( $selectedService == 'Economy Shipping (1 to 10 business days)' || $selectedService == 'Standard Shipping (1 to 5 business days)' ){
			return 'ShippingMethodStandard';
		} else if ( $selectedService == 'USPS Parcel Post (2 to 9 business days)'){
			return 'USPSParcel';
		} else if ( $selectedService == 'USPS Media Mail (2 to 9 business days)'){
			return 'USPSMedia';
		} else if ( $selectedService == 'UPS Ground (1 to 5 business days)'){
			return 'UPSGround';
	    } else if ( $selectedService == 'Expedited Shipping (1 to 3 business days)'){
		  return 'ShippingMethodExpress';
		} else if ( $selectedService == 'USPS Priority Mail (2 to 3 business days)'){
		  return 'USPSPriority';
		} else if ( $selectedService == 'USPS Priority Mail Flat Rate Envelope (2 to 3 business days)'){
		  return 'USPSPriorityMailFlatRateEnvelope';
		} else if ( $selectedService == 'USPS Priority Mail Small Flat Rate Box (2 to 3 business days)'){
		  return 'USPSPriorityMailSmallFlatRateBox';
		} else if ( $selectedService == 'USPS Priority Mail Medium Flat Rate Box (2 to 3 business days)'){
		  return 'USPSPriorityMailFlatRateBox';
		} else if ( $selectedService == 'USPS Priority Mail Large Flat Rate Box (2 to 3 business days)'){
		  return 'USPSPriorityMailLargeFlatRateBox';
		} else if ( $selectedService == 'USPS First Class Mail (2 to 3 business days)'){
		  return 'USPSFirstClass';
	    } else if ( $selectedService == 'UPS 3 Day Select (3 business days)'){
		  return 'UPS3rdDay';
		} else if ( $selectedService == 'UPS 2nd Day Air (2 business days)'){
		  return 'UPS2ndDay';
	    } else if ( $selectedService == 'One-day Shipping (1 business day)'){
		  return 'ShippingMethodExpress';
		} else if ( $selectedService == 'USPS Express Mail (1 business day)'){
		  return 'USPSExpressMail';
		} else if ( $selectedService == 'USPS Express Mail Flat Rate Envelope (1 business day)'){
		  return 'USPSExpressMailFlatRateEnvelope';
		} else if ( $selectedService == 'UPS Next Day Air Saver (1 business day)'){
		  return 'UPSNextDay';
		} else if ( $selectedService == 'UPS Next Day Air (1 business day)'){
		  return 'UPSNextDayAir';
		} else if ( $selectedService == 'Economy Shipping from outside US ( 11 to 20 business days)'){
		  return 'StandardInternational';
		} else if ( $selectedService == 'Standard Shipping from outside US (5 to 10 business days)'){
		  return 'StandardInternational';
		}else if ( $selectedService == 'Expedited Shipping from outside US (1 to 4 business days)'){
		  return 'ExpeditedInternational';
		} else {
		  return 'None';
		}
	}
	
	


}
?>