<?php

/**
 * cardsave 3D Secure Redirection Page
 *
 * @author     Conor Kerr <cardsave@dev.ceon.net>
 * @copyright  Copyright 2008 Ceon
 * @link       http://dev.ceon.net/web/zen-cart/cardsave
 * @license    http://www.gnu.org/copyleft/gpl.html   GNU Public License V2.0
 * @version    $Id: header_php.php 734 2008-08-18 14:23:35Z conor $
 */

require(DIR_FS_CATALOG . DIR_WS_MODULES . 'require_languages.php');

if (!isset($_GET['ACSURL']) || !isset($_GET['PaReq']) || !isset($_GET['crossreference'])) {
	// Necessary config details missing! Redirect back to payment page and display error message
	$payment_error_return = 'payment_error=cardsave&error=' . urlencode(CHECKOUT_CARDSAVE_3D_SECURE_ERROR_GET_PARAMS);
	
	zen_redirect(zen_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
}

// Avoid hack attempts during the checkout procedure by checking the internal cartID
if ($_SESSION['cart']->cartID != $_SESSION['cartID']) {
	// User has attempted to access this page after its initial display and navigating to another
	// page. Can't continue in case they have modified their cart contents
	zen_redirect(zen_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
}

/**
 * Load language defines from main CardSave languages file... saves duplication of definitions!
 */
$cardsave_language_file_path = 'modules/payment/cardsave.php';
if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . $cardsave_language_file_path)) {
	require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . $cardsave_language_file_path);
} else {
	require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $cardsave_language_file_path);
}

$acs_url = $_GET['ACSURL'];
$pa_req = $_GET['PaReq'];
$crossreference = $_GET['crossreference'];

$breadcrumb->add(NAVBAR_TITLE_1, zen_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
$breadcrumb->add(NAVBAR_TITLE_2);

?>