/* 
Author: 			Dan Crack
Author URI: 		http://www.freethinkingdesign.co.uk/
*/

function addBookmark(title,url){
    if (window.sidebar) { // firefox
        window.sidebar.addPanel(title, url, "");
    } else if(window.opera && window.print) { // opera
        var elem = document.createElement('a');
        elem.setAttribute('href',url);
        elem.setAttribute('title',title);
        elem.setAttribute('rel','sidebar');
        elem.click();
    } else if(document.all) { // ie
        window.external.AddFavorite(url, title);
    }
}

// Race starts... jQuery
$(document).ready( function() {
    
    $('.bookmarkIt').each(function() {
        $(this).click(function() { addBookmark(document.title+" | "+$(this).attr('rel'),window.location); return false; });
    });
    
    // if big promobox is displayed, rotate its contents.
    if ( $('#promoBigCycle').length ) {
        $('#promoBigCycle').cycle({
            fx:     'fade',
            speed:   1400,
            timeout: 3800,
//            next:   '#promoBigCycle',
            pause:   3
        });
    }
    if ( $('#peRotator1').length ) {
        $('#peRotator1').cycle({
            fx:     'fade',
            speed:   1400,
            timeout: 4500,
            next:   '#peRotator1',
            pause:   3
        });
    }
    if ( $('#peRotator2') ) {
        $('#peRotator2').cycle({
            fx:     'fade',
            speed:   1400,
            timeout: 4000,
            next:   '#peRotator2',
            pause:   3
        });
    }

    // if product images are displayed, make lightbox available.
    if ( $('#productPanelImageWrap').length ) {
        $('#productPanelImageWrap a').lightBox(); // Select all links in object with gallery ID
    }
    if ( $('#emailForm').length ) {
        var setupSend = function(hash){
            $('#sendToFriend').click(function() {
                if ( $('#friends_email_address').val() == "" || $('#your_email_address').val() == "" || $('#your_name').val() == "" || $('#comment').val() == "") {
                    alert("You must complete all the fields");
                    return false;
                }
                
                $.post("/email-a-friend",
                    { id: $('#prodId').val(),
                      your_name: $('#your_name').val(),
                      your_email_address: $('#your_email_address').val(),
                      friends_email_address: $('#friends_email_address').val(),
                      comment: $('#comment').val(),
                      prodUrl: $('#prodUrl').val(),
                      checkIt: $('#checkIt').val()
                    });
                
                $('#emailForm').jqmHide();
                return true; 
            });
                 
            hash.w.css().show(); 
        }
        $('#emailForm').jqm({trigger: '#emailFriend', overlay:80, onShow:setupSend});
    }
        

    if ( $('#inspirationometer').length ) {
        // Sliders
        $('#slider1').slider({
            values: [0],
            slide: function(event, ui){
                themeId = parseInt(ui.value/themeCount);
                if ( themeId > 8 ) { themeId = 8; }
                $('#themeDesc').html(theme[themeId]);
                $('#inspired').attr('class','');
                $('#inspired').addClass('i'+themeId);
                $('#inspiredHire').attr('href','/hire/'+theme[themeId].toLowerCase().replace(/ /g,'-'));
                $('#inspiredBuy').attr('href','/shop/'+theme[themeId].toLowerCase().replace(/ /g,'-'));
            }
        });
        $('#themeDesc').html(theme[0]);
        $('#inspiredRandom').click(function(){
            hireShop = ['hire','shop'];
            rndDest = '/'+hireShop[Math.round(Math.random())]+'/'+theme[parseInt(10 * Math.random())].toLowerCase().replace(/ /g,'-')
            $(this).attr('href',rndDest);
            
        });
    }
});
