<!DOCTYPE html>
<html dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>">
<head>
<meta charset="UTF-8" /> 
<title><?php echo $title; ?></title>
<base href="<?php echo $base; ?>" />
<?php if ($description) { ?>
<meta name="description" content="<?php echo $description; ?>" />
<?php } ?>
<?php if ($keywords) { ?>
<meta name="keywords" content="<?php echo $keywords; ?>" />
<?php } ?>
<?php if ($icon) { ?>
<link href="<?php echo $icon; ?>" rel="icon" />
<?php } ?>
<?php foreach ($links as $link) { ?>
<link href="<?php echo $link['href']; ?>" rel="<?php echo $link['rel']; ?>" />
<?php } ?>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/default/stylesheet/stylesheet.css" />
<?php foreach ($styles as $style) { ?>
<link rel="<?php echo $style['rel']; ?>" type="text/css" href="<?php echo $style['href']; ?>" media="<?php echo $style['media']; ?>" />
<?php } ?>
<script type="text/javascript" src="catalog/view/javascript/jquery/jquery-1.7.1.min.js"></script>
<script type="text/javascript" src="catalog/view/javascript/jquery/ui/jquery-ui-1.8.16.custom.min.js"></script>
<link rel="stylesheet" type="text/css" href="catalog/view/javascript/jquery/ui/themes/ui-lightness/jquery-ui-1.8.16.custom.css" />
<script type="text/javascript" src="catalog/view/javascript/common.js"></script>
<?php foreach ($scripts as $script) { ?>
<script type="text/javascript" src="<?php echo $script; ?>"></script>

					<script type="text/javascript">
					   $(document).ready(function() {
						  $(".fancybox").fancybox();
					   });
					</script>

					<!-- Add mousewheel plugin (this is optional) -->
					<script type="text/javascript" src="catalog/view/javascript/jquery/fancybox/lib/jquery.mousewheel-3.0.6.pack.js"></script>
					<!-- Add fancyBox -->
					<link rel="stylesheet" href="catalog/view/javascript/jquery/fancybox/source/jquery.fancybox.css?v=2.0.6" type="text/css" media="screen" />
					<script type="text/javascript" src="catalog/view/javascript/jquery/fancybox/source/jquery.fancybox.pack.js?v=2.0.6"></script>
					
			
<?php } ?>
<!--[if IE 7]> 
<link rel="stylesheet" type="text/css" href="catalog/view/theme/default/stylesheet/ie7.css" />
<![endif]-->
<!--[if lt IE 7]>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/default/stylesheet/ie6.css" />
<script type="text/javascript" src="catalog/view/javascript/DD_belatedPNG_0.0.8a-min.js"></script>
<script type="text/javascript">
DD_belatedPNG.fix('#logo img');
</script>
<![endif]-->
<?php if ($stores) { ?>
<script type="text/javascript"><!--
$(document).ready(function() {
<?php foreach ($stores as $store) { ?>
$('body').prepend('<iframe src="<?php echo $store; ?>" style="display: none;"></iframe>');
<?php } ?>
});
//--></script>
<?php } ?>
<?php echo $google_analytics; ?>
</head>
<body>
<div id="container">
<div id="header">
  <?php if ($logo) { ?>
  <div id="logo"><a href="<?php echo $home; ?>"><img src="<?php echo $logo; ?>" title="<?php echo $name; ?>" alt="<?php echo $name; ?>" /></a></div>
  <?php } ?>
  
  <div class="links">
				<a href="<?php echo $home; ?>"><img src="catalog/view/theme/default/image/home1.jpg" /></a>
				<a href="<?php echo $aboutus; ?>" id="wishlist-total"><img src="catalog/view/theme/default/image/aboutus1.jpg" /></a>
				<?php if ($logged) { ?>
				<a href="<?php echo $catalogs; ?>"><img src="catalog/view/theme/default/image/catalog1.jpg" /></a>
				<?php } else { ?>
				<a href="<?php echo $notlogged; ?>"><img src="catalog/view/theme/default/image/catalog1.jpg" /></a>
				<?php } ?>
				<a href="<?php echo $tradefairs; ?>"><img src="catalog/view/theme/default/image/trade1.jpg" /></a>
				<a href="<?php echo $contactus; ?>"><img src="catalog/view/theme/default/image/contactus1.jpg" /></a>
  </div>

  </div>
<!--  
<?php if ($categories) { ?>
<div id="menu">
  <ul>
    <?php foreach ($categories as $category) { ?>
    <li><a href="<?php echo $category['href']; ?>"><?php echo $category['name']; ?></a>
      <?php if ($category['children']) { ?>
      <div>
        <?php for ($i = 0; $i < count($category['children']);) { ?>
        <ul>
          <?php $j = $i + ceil(count($category['children']) / $category['column']); ?>
          <?php for (; $i < $j; $i++) { ?>
          <?php if (isset($category['children'][$i])) { ?>
          <li><a href="<?php echo $category['children'][$i]['href']; ?>"><?php echo $category['children'][$i]['name']; ?></a></li>
          <?php } ?>
          <?php } ?>
        </ul>
        <?php } ?>
      </div>
      <?php } ?>
    </li>
    <?php } ?>
  </ul>
</div>
<?php } ?>
-->
<div id="notification"></div>
