<?php  
class ControllerModulePrice extends Controller {
	protected function index() {
		$this->language->load('module/price');
		
    	$this->data['heading_title'] = $this->language->get('heading_title');
    	
		$this->data['text_contact'] = $this->language->get('text_contact');
    	$this->data['text_sitemap'] = $this->language->get('text_sitemap');
		
		$this->load->model('catalog/information');
		$this->load->model('tool/seo_url');
		
		$this->data['prices'] = array();

		foreach ($this->model_catalog_information->getInformations() as $result) {
      		$this->data['prices'][] = array(
        		'title' => $result['title'],
	    		'href'  => $this->model_tool_seo_url->rewrite(HTTP_SERVER . 'index.php?route=price/price&information_id=' . $result['information_id'])
      		);
    	}

		$this->data['contact'] = HTTP_SERVER . 'index.php?route=information/contact';
    	$this->data['sitemap'] = HTTP_SERVER . 'index.php?route=information/sitemap';
		
		$this->id = 'price';

		if ($this->config->get('price_position') == 'home') {
			$this->data['heading_title'] .= (' ' . $this->language->get('text_products'));
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/price.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/module/price.tpl';
			} else {
				$this->template = 'mrsilver/template/module/price.tpl';
			}
		} else {
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/price.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/price.tpl';
		} else {
			$this->template = 'default/template/module/price.tpl';
		}
		
		$this->render();
	}
}
}
?>