<?php

/*

  $Id: create_account.php 1739 2007-12-20 00:52:16Z hpdl $



  osCommerce, Open Source E-Commerce Solutions

  http://www.oscommerce.com



  Copyright (c) 2003 osCommerce



  Released under the GNU General Public License

*/



  require('includes/application_top.php');



// needs to be included earlier to set the success message in the messageStack

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CREATE_ACCOUNT);



  $process = false;

  if (isset($HTTP_POST_VARS['action']) && ($HTTP_POST_VARS['action'] == 'process')) {

    $process = true;



    if (ACCOUNT_GENDER == 'true') {

      if (isset($HTTP_POST_VARS['gender'])) {

        $gender = tep_db_prepare_input($HTTP_POST_VARS['gender']);

      } else {

        $gender = false;

      }

    }

    $firstname = tep_db_prepare_input($HTTP_POST_VARS['firstname']);

	$title = tep_db_prepare_input($HTTP_POST_VARS['title']);

	

    $lastname = tep_db_prepare_input($HTTP_POST_VARS['lastname']);

    if (ACCOUNT_DOB == 'true') $dob = tep_db_prepare_input($HTTP_POST_VARS['dob']);

    $email_address = tep_db_prepare_input($HTTP_POST_VARS['email_address']);

	

// BOF Separate Pricing Per Customer, added: field for tax id number

    if (ACCOUNT_COMPANY == 'true') {

    $company = tep_db_prepare_input($_POST['company']);

    $company_tax_id = tep_db_prepare_input($_POST['company_tax_id']);

    }

// EOF Separate Pricing Per Customer, added: field for tax id number

	

    $street_address = tep_db_prepare_input($HTTP_POST_VARS['street_address']);

    if (ACCOUNT_SUBURB == 'true') $suburb = tep_db_prepare_input($HTTP_POST_VARS['suburb']);

    $postcode = tep_db_prepare_input($HTTP_POST_VARS['postcode']);

    $city = tep_db_prepare_input($HTTP_POST_VARS['city']);

    if (ACCOUNT_STATE == 'true') {

      $state = tep_db_prepare_input($HTTP_POST_VARS['state']);

      if (isset($HTTP_POST_VARS['zone_id'])) {

        $zone_id = tep_db_prepare_input($HTTP_POST_VARS['zone_id']);

      } else {

        $zone_id = false;

      }

    }

    $country = tep_db_prepare_input($HTTP_POST_VARS['country']);

    $telephone = tep_db_prepare_input($HTTP_POST_VARS['telephone']);

    $fax = tep_db_prepare_input($HTTP_POST_VARS['fax']);

    if (isset($HTTP_POST_VARS['newsletter'])) {

      $newsletter = tep_db_prepare_input($HTTP_POST_VARS['newsletter']);

    } else {

      $newsletter = false;

    }

    $password = tep_db_prepare_input($HTTP_POST_VARS['password']);

    $confirmation = tep_db_prepare_input($HTTP_POST_VARS['confirmation']);



    $error = false;



    if (ACCOUNT_GENDER == 'true') {

      if ( ($gender != 'm') && ($gender != 'f') ) {

        $error = true;



        $messageStack->add('create_account', ENTRY_GENDER_ERROR);

      }

    }



    if (strlen($firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {

      $error = true;



      $messageStack->add('create_account', ENTRY_FIRST_NAME_ERROR);

    }



    if (strlen($lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {

      $error = true;



      $messageStack->add('create_account', ENTRY_LAST_NAME_ERROR);

    }



    if (ACCOUNT_DOB == 'true') {

      if (checkdate(substr(tep_date_raw($dob), 4, 2), substr(tep_date_raw($dob), 6, 2), substr(tep_date_raw($dob), 0, 4)) == false) {

        $error = true;



        $messageStack->add('create_account', ENTRY_DATE_OF_BIRTH_ERROR);

      }

    }



    if (strlen($email_address) < ENTRY_EMAIL_ADDRESS_MIN_LENGTH) {

      $error = true;



      $messageStack->add('create_account', ENTRY_EMAIL_ADDRESS_ERROR);

    } elseif (tep_validate_email($email_address) == false) {

      $error = true;



      $messageStack->add('create_account', ENTRY_EMAIL_ADDRESS_CHECK_ERROR);

    } else {

      $check_email_query = tep_db_query("select count(*) as total from " . TABLE_CUSTOMERS . " where customers_email_address = '" . tep_db_input($email_address) . "'");

      $check_email = tep_db_fetch_array($check_email_query);

      if ($check_email['total'] > 0) {

        $error = true;



        $messageStack->add('create_account', ENTRY_EMAIL_ADDRESS_ERROR_EXISTS);

      }

    }



    if (strlen($street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {

      $error = true;



      $messageStack->add('create_account', ENTRY_STREET_ADDRESS_ERROR);

    }



    if (strlen($postcode) < ENTRY_POSTCODE_MIN_LENGTH) {

      $error = true;



      $messageStack->add('create_account', ENTRY_POST_CODE_ERROR);

    }



    if (strlen($city) < ENTRY_CITY_MIN_LENGTH) {

      $error = true;



      $messageStack->add('create_account', ENTRY_CITY_ERROR);

    }



    if (is_numeric($country) == false) {

      $error = true;



      $messageStack->add('create_account', ENTRY_COUNTRY_ERROR);

    }



    if (ACCOUNT_STATE == 'true') {

      $zone_id = 0;

      $check_query = tep_db_query("select count(*) as total from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "'");

      $check = tep_db_fetch_array($check_query);

      $entry_state_has_zones = ($check['total'] > 0);

      if ($entry_state_has_zones == true) {

        $zone_query = tep_db_query("select distinct zone_id from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "' and (zone_name = '" . tep_db_input($state) . "' or zone_code = '" . tep_db_input($state) . "')");

        if (tep_db_num_rows($zone_query) == 1) {

          $zone = tep_db_fetch_array($zone_query);

          $zone_id = $zone['zone_id'];

        } else {

          $error = true;



          $messageStack->add('create_account', ENTRY_STATE_ERROR_SELECT);

        }

      } else {

        if (strlen($state) < ENTRY_STATE_MIN_LENGTH) {

          $error = true;



          $messageStack->add('create_account', ENTRY_STATE_ERROR);

        }

      }

    }



 /*   if (strlen($telephone) < ENTRY_TELEPHONE_MIN_LENGTH) {

      $error = true;



      $messageStack->add('create_account', ENTRY_TELEPHONE_NUMBER_ERROR);

    }*/





    if (strlen($password) < ENTRY_PASSWORD_MIN_LENGTH) {

      $error = true;



      $messageStack->add('create_account', ENTRY_PASSWORD_ERROR);

    } elseif ($password != $confirmation) {

      $error = true;



      $messageStack->add('create_account', ENTRY_PASSWORD_ERROR_NOT_MATCHING);

    }



    if ($error == false) {

      $sql_data_array = array('customers_firstname' => $firstname,

                              'customers_lastname' => $lastname,

                              'customers_email_address' => $email_address,

                              'customers_telephone' => $telephone,

                              'customers_fax' => $fax,

							  'customers_password' => tep_encrypt_password($password),

                              'customers_newsletter' => $newsletter,

							  'customers_lastname' => $lastname,

                              'customers_title' => $title);



      if (ACCOUNT_GENDER == 'true') $sql_data_array['customers_gender'] = $gender;

      if (ACCOUNT_DOB == 'true') $sql_data_array['customers_dob'] = tep_date_raw($dob);



// BOF Separate Pricing Per Customer

   // if you would like to have an alert in the admin section when either a company name has been entered in

   // the appropriate field or a tax id number, or both then uncomment the next line and comment the default

   // setting: only alert when a tax_id number has been given

   //    if ( (ACCOUNT_COMPANY == 'true' && tep_not_null($company) ) || (ACCOUNT_COMPANY == 'true' && tep_not_null($company_tax_id) ) ) {

	  if ( ACCOUNT_COMPANY == 'true' && tep_not_null($company_tax_id)  ) {

      $sql_data_array['customers_group_ra'] = '1';

// entry_company_tax_id moved from table address_book to table customers in version 4.2.0

      $sql_data_array['entry_company_tax_id'] = $company_tax_id; 

    }

// EOF Separate Pricing Per Customer





      tep_db_perform(TABLE_CUSTOMERS, $sql_data_array);



      $customer_id = tep_db_insert_id();



      $sql_data_array = array('customers_id' => $customer_id,

                              'entry_firstname' => $firstname,

                              'entry_lastname' => $lastname,

                              'entry_street_address' => $street_address,

                              'entry_postcode' => $postcode,

                              'entry_city' => $city,

                              'entry_country_id' => $country);



      if (ACCOUNT_GENDER == 'true') $sql_data_array['entry_gender'] = $gender;

      if (ACCOUNT_COMPANY == 'true') $sql_data_array['entry_company'] = $company;

      if (ACCOUNT_SUBURB == 'true') $sql_data_array['entry_suburb'] = $suburb;

      if (ACCOUNT_STATE == 'true') {

        if ($zone_id > 0) {

          $sql_data_array['entry_zone_id'] = $zone_id;

          $sql_data_array['entry_state'] = '';

        } else {

          $sql_data_array['entry_zone_id'] = '0';

          $sql_data_array['entry_state'] = $state;

        }

      }



      tep_db_perform(TABLE_ADDRESS_BOOK, $sql_data_array);



      $address_id = tep_db_insert_id();



      tep_db_query("update " . TABLE_CUSTOMERS . " set customers_default_address_id = '" . (int)$address_id . "' where customers_id = '" . (int)$customer_id . "'");



      tep_db_query("insert into " . TABLE_CUSTOMERS_INFO . " (customers_info_id, customers_info_number_of_logons, customers_info_date_account_created) values ('" . (int)$customer_id . "', '0', now())");



      if (SESSION_RECREATE == 'True') {

        tep_session_recreate();

      }

// BOF Separate Pricing Per Customer

// register SPPC session variables for the new customer

// if there is code above that puts new customers directly into another customer group (default is retail)

// then the below code need not be changed, it uses the newly inserted customer group

      $check_customer_group_info = tep_db_query("select c.customers_group_id, cg.customers_group_show_tax, cg.customers_group_tax_exempt, cg.group_specific_taxes_exempt from " . TABLE_CUSTOMERS . " c left join " . TABLE_CUSTOMERS_GROUPS . " cg using(customers_group_id) where c.customers_id = '" . $customer_id . "'");

      $customer_group_info = tep_db_fetch_array($check_customer_group_info);

      $sppc_customer_group_id = $customer_group_info['customers_group_id'];

      $sppc_customer_group_show_tax = (int)$customer_group_info['customers_group_show_tax'];

      $sppc_customer_group_tax_exempt = (int)$customer_group_info['customers_group_tax_exempt'];

      $sppc_customer_specific_taxes_exempt = '';

      if (tep_not_null($customer_group_info['group_specific_taxes_exempt'])) {

        $sppc_customer_specific_taxes_exempt = $customer_group_info['group_specific_taxes_exempt'];

      }

// EOF Separate Pricing Per Customer

/*     $customer_first_name = $firstname;

      $customer_default_address_id = $address_id;

      $customer_country_id = $country;

      $customer_zone_id = $zone_id;

      tep_session_register('customer_id');

      tep_session_register('customer_first_name');

      tep_session_register('customer_default_address_id');

      tep_session_register('customer_country_id');

      tep_session_register('customer_zone_id');

	  

	  // BOF Separate Pricing Per Customer

      tep_session_register('sppc_customer_group_id');

      tep_session_register('sppc_customer_group_show_tax');

      tep_session_register('sppc_customer_group_tax_exempt');

      tep_session_register('sppc_customer_specific_taxes_exempt');*/

// EOF Separate Pricing Per Customer



// restore cart contents

      $cart->restore_contents();

	     $wishList->restore_wishlist();



// build the message content

      $name = $firstname . ' ' . $lastname;



      if (ACCOUNT_GENDER == 'true') {

         if ($gender == 'm') {

           $email_text = sprintf(EMAIL_GREET_MR, $lastname);

         } else {

           $email_text = sprintf(EMAIL_GREET_MS, $lastname);

         }

      } else {

        $email_text = sprintf(EMAIL_GREET_NONE, $firstname);

      }



      $email_text .= EMAIL_WELCOME . EMAIL_TEXT . EMAIL_CONTACT . EMAIL_WARNING;

	 
	$from = 'info@astraljewels.com.au';
	$emailtoadmin = "sundeep.maheshwari@gmail.com";
	$headers  = 'From: '.$from." \n";
	$headers .= 'MIME-Version: 1.0' ."\n";
	$headers .= 'Content-Type: text/HTML; charset=ISO-8859-1' ."\n";
	$body = <<<EOD
A new user created account his/her details as below:<br/>
Name:  $firstname $lastname<br/>
Email: $email_address<br/>
Phone: $telephone<br/>
Company: $company<br/>
ABN: $company_tax_id<br/>
Address: $street_address $city $postcode<br/>
EOD;
$subject = "A new account created on astral jewels";
	if(mail('payal@astraljewels.com.au',$subject,$body,$headers))
	{
		//echo "Thanks for contacting us. Someone will contact you soon.";	
	}
	
      //tep_mail($name, $email_address, EMAIL_SUBJECT, $email_text, STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);

      tep_redirect(tep_href_link(FILENAME_CREATE_ACCOUNT_SUCCESS, '', 'SSL'));

    }

  }



  $breadcrumb->add(NAVBAR_TITLE, tep_href_link(FILENAME_CREATE_ACCOUNT, '', 'SSL'));

?>

<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">

<html <?php echo HTML_PARAMS; ?>>

<head>

<link rel="shortcut icon" href="favicon.ico" />

<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">

<title><?php echo TITLE; ?></title>

<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>">

<link rel="stylesheet" type="text/css" href="stylesheet.css">

<?php require('includes/form_check.js.php'); ?>

</head>

<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0">

<!-- header //-->

<?php require(DIR_WS_INCLUDES . 'header.php'); ?>

<!-- header_eof //-->



<!-- body //-->

<table border="0" width="100%" cellspacing="3" cellpadding="3">

  <tr>

<!-- body_text //-->

    <td width="100%" valign="top"><div class="cmsbox"><div class="cmsboxinner"><?php echo tep_draw_form('create_account', tep_href_link(FILENAME_CREATE_ACCOUNT, '', 'SSL'), 'post', 'onSubmit="return check_form(create_account);"') . tep_draw_hidden_field('action', 'process'); ?><table border="0" width="100%" cellspacing="0" cellpadding="0">

      <tr>

        <td><table border="0" width="100%" cellspacing="0" cellpadding="0">

          <tr>

            <td class="pageHeading" valign="middle"><?php echo HEADING_TITLE; ?><div class="righttext"></div></td>            

          </tr>

        </table></td>

      </tr>

      <tr>

        <td><?php echo tep_draw_separator('pixel_trans.gif', '100%', '10'); ?></td>

      </tr>    

     

<?php

  if ($messageStack->size('create_account') > 0) {

?>

      <tr>

        <td><?php echo $messageStack->output('create_account'); ?></td>

      </tr>

      <tr>

        <td><?php echo tep_draw_separator('pixel_trans.gif', '100%', '10'); ?></td>

      </tr>

<?php

  }

?>

      <tr>

        <td>



		<table width="100%" border="0" cellpadding="0" cellspacing="0">

		 <tr>

<td colspan="2" class="main" ><strong>Login Details</strong></td>

</tr>

 <tr>

<td colspan="2" height="2" ></td>

</tr>

<?php

  if (ACCOUNT_GENDER == 'true') {

?>

              <tr>

                <td class="main_test" width="150"><?php echo ENTRY_GENDER .'<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>'; ?></td>

                <td class="main_test"><?php echo tep_draw_radio_field('gender', 'm') . '&nbsp;&nbsp;' . MALE . '&nbsp;&nbsp;' . tep_draw_radio_field('gender', 'f') . '&nbsp;&nbsp;' . FEMALE . '&nbsp;' . (tep_not_null(ENTRY_GENDER_TEXT) ? '': ''); ?></td>

              </tr>

			  <tr>

<td colspan="2" class="main" height="2" ></td>

</tr>

<?php

  }

?>

<tr>

                <td class="main">Title</td>

                <td class="main"><?php echo tep_get_title_list('title');  ?></td>

              </tr>

			  			  <tr>

<td colspan="2" class="main" height="2" ></td>

</tr>

<tr>

                <td class="main"><?php echo ENTRY_FIRST_NAME .'<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>'; ?></td>

                <td class="main"><?php echo tep_draw_input_field('firstname') . '&nbsp;' . (tep_not_null(ENTRY_FIRST_NAME_TEXT) ? '': ''); ?></td>

              </tr>

			  <tr>

<td colspan="2" class="main" height="2" ></td>

</tr>

              <tr>

                <td class="main"><?php echo ENTRY_LAST_NAME .'<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>'; ?></td>

                <td class="main"><?php echo tep_draw_input_field('lastname') . '&nbsp;' . (tep_not_null(ENTRY_LAST_NAME_TEXT) ? '': ''); ?></td>

              </tr>

			   

			  <tr>

<td colspan="2" class="main" height="2" ></td>

</tr>



<?php

  if (ACCOUNT_DOB == 'true') {

?>

              <tr>

                <td class="main"><?php echo ENTRY_DATE_OF_BIRTH .'<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>'; ?></td>

                <td class="main"><?php echo tep_draw_input_field('dob') . '&nbsp;' . (tep_not_null(ENTRY_DATE_OF_BIRTH_TEXT) ? '': ''); ?></td>

              </tr>

			  <tr>

<td colspan="2" class="main" height="2" ></td>

</tr>

<?php

  }

?>

              <tr>

                <td class="main"><?php echo ENTRY_EMAIL_ADDRESS .'<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>'; ?></td>

                <td class="main"><?php echo tep_draw_input_field('email_address') . '&nbsp;' . (tep_not_null(ENTRY_EMAIL_ADDRESS_TEXT) ? '': ''); ?></td>

              </tr>

			    <tr>

<td colspan="2" class="main" height="2" ></td>

</tr>

			    <tr>

                <td class="main"><?php echo ENTRY_PASSWORD .'<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>'; ?></td>

                <td class="main"><?php echo tep_draw_password_field('password') . '&nbsp;' . (tep_not_null(ENTRY_PASSWORD_TEXT) ? '': ''); ?></td>

              </tr>

			  <tr>

<td colspan="2" class="main" height="2" ></td>

</tr>

              <tr>

                <td class="main"><?php echo ENTRY_PASSWORD_CONFIRMATION .'<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>'; ?></td>

                <td class="main"><?php echo tep_draw_password_field('confirmation') . '&nbsp;' . (tep_not_null(ENTRY_PASSWORD_CONFIRMATION_TEXT) ? '': ''); ?></td>

              </tr>

			  

			  <tr>

<td colspan="2" class="main" height="10" ></td>

</tr>

		 <tr>

<td colspan="2" class="main" ><strong>Business Details</strong></td>

</tr>

 <tr>

<td colspan="2" height="2" ></td>

</tr>



   <tr>

                <td class="main">Business/Trading Name</td>

<!-- BOF Separate Pricing Per Customer: field for tax id number -->

<td class="main"><?php echo tep_draw_input_field('company') . '&nbsp;' . (tep_not_null(ENTRY_COMPANY_TEXT) ? '<span class="inputRequirement">' . ENTRY_COMPANY_TEXT . '</span>': ''); ?></td>

              </tr>

 <tr>

<td colspan="2" height="2" ></td>

</tr>

              <tr>

                <td class="main">ABN / ACN</td>

                <td class="main"><?php echo tep_draw_input_field('company_tax_id') . '&nbsp;' . (tep_not_null(ENTRY_COMPANY_TAX_ID_TEXT) ? '<span class="inputRequirement">' . ENTRY_COMPANY_TAX_ID_TEXT . '</span>': ''); ?></td>

              </tr>

<!-- EOF Separate Pricing Per Customer: field for tax id number -->

 <tr>

<td colspan="2" height="2" ></td>

</tr>

   <tr>

                <td class="main"><?php echo ENTRY_TELEPHONE_NUMBER.'<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>'; ?></td>

                <td class="main"><?php echo tep_draw_input_field('telephone') . '&nbsp;'  ?></td>

              </tr>

			 <tr>

<td colspan="2" height="2" ></td>

</tr>  

			  <tr>

                <td class="main"><?php echo ENTRY_STREET_ADDRESS .'<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>'; ?></td>

                <td class="main"><?php echo tep_draw_input_field('street_address') . '&nbsp;' . (tep_not_null(ENTRY_STREET_ADDRESS_TEXT) ? '': ''); ?></td>

              </tr>

			  <tr>

<td colspan="2" class="main" height="2" ></td>

</tr>

<?php

  if (ACCOUNT_SUBURB == 'true') {

?>

              <tr>

                <td class="main"><?php echo ENTRY_SUBURB .'<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>'; ?></td>

                <td class="main"><?php echo tep_draw_input_field('suburb') . '&nbsp;' . (tep_not_null(ENTRY_SUBURB_TEXT) ? '': ''); ?></td>

              </tr>

			  <tr>

<td colspan="2" class="main" height="2" ></td>

</tr>

<?php

  }

?>

              <tr>

                <td class="main"><?php echo ENTRY_POST_CODE .'<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>'; ?></td>

                <td class="main"><?php echo tep_draw_input_field('postcode') . '&nbsp;' . (tep_not_null(ENTRY_POST_CODE_TEXT) ? '': ''); ?></td>

              </tr>

			  <tr>

<td colspan="2" class="main" height="2" ></td>

</tr>

              <tr>

                <td class="main"><?php echo 'City/Suburb' .'<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>'; ?></td>

                <td class="main"><?php echo tep_draw_input_field('city') . '&nbsp;' . (tep_not_null(ENTRY_CITY_TEXT) ? '': ''); ?></td>

              </tr>

			  <tr>

<td colspan="2" class="main" height="2" ></td>

</tr>



<?php

  if (ACCOUNT_STATE == 'true') {

?>

              <tr>

                <td class="main"><?php echo ENTRY_STATE .''; ?></td>

                <td class="main">

<?php

    if ($process == true) {

      if ($entry_state_has_zones == true) {

        $zones_array = array();

        $zones_query = tep_db_query("select zone_name from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "' order by zone_name");

        while ($zones_values = tep_db_fetch_array($zones_query)) {

          $zones_array[] = array('id' => $zones_values['zone_name'], 'text' => $zones_values['zone_name']);

        }

        echo tep_draw_pull_down_menu('state', $zones_array);

      } else {

        echo tep_draw_input_field('state');

      }

    } else {

      echo tep_draw_input_field('state');

    }



   

?>

                </td>

              </tr>

			  <tr>

<td colspan="2" class="main" height="2" ></td>

</tr>

<?php

  }

?>

              <tr>

                <td class="main"><?php echo ENTRY_COUNTRY .'<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>'; ?></td>

                <td class="main"><?php echo tep_get_country_list('country') . '&nbsp;' . (tep_not_null(ENTRY_COUNTRY_TEXT) ? '': ''); ?></td>

              </tr>

			  <tr>

<td colspan="2" class="main" height="2" ></td>

</tr>

	

			  <tr>

<td colspan="2" class="main" height="2" ></td>

</tr>

			

			  <tr>

<td class="main" ></td>

<td class="main" ><?php echo tep_image_submit('continue.gif', IMAGE_BUTTON_CONTINUE); ?></td>

</tr>

</table>

		

		

			

		</td>

      </tr>

   



    </table></form></div></div></td>

<!-- body_text_eof //-->

    <td width="195" valign="top">

<!-- right_navigation //-->

<?php include(DIR_WS_INCLUDES . 'column_right.php'); ?>

<!-- right_navigation_eof //-->

   </td>

  </tr>

</table>

<!-- body_eof //-->



<!-- footer //-->

<?php include(DIR_WS_INCLUDES . 'footer.php'); ?>

<!-- footer_eof //-->

<br>

</body>

</html>

<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>

